/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.util;

import java.util.HashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Tuple;

public class IISoundAnimation {
    private final HashMap<Double, SoundEvent> sounds = new HashMap();
    private final HashMap<Integer, SoundEvent[]> compiledSounds = new HashMap();
    private final double animationDuration;

    public IISoundAnimation(double animationDuration) {
        this.animationDuration = animationDuration;
    }

    public void compile(int maxTime) {
        this.compiledSounds.clear();
        this.sounds.entrySet().stream().map(e -> new Tuple((Object)((int)((Double)e.getKey() * (double)maxTime)), e.getValue())).collect(Collectors.groupingBy(Tuple::func_76341_a)).forEach((time, sound) -> {
            SoundEvent[] sounds = (SoundEvent[])sound.stream().map(Tuple::func_76340_b).toArray(SoundEvent[]::new);
            this.compiledSounds.put((Integer)time, sounds);
        });
    }

    public IISoundAnimation withSound(double time, SoundEvent sound) {
        this.sounds.put(time / this.animationDuration, sound);
        return this;
    }

    @Nullable
    public SoundEvent[] getSounds(int time) {
        return this.compiledSounds.get(time);
    }
}

