/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.util;

import blusunrize.immersiveengineering.common.util.EnergyHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import pl.pabilo8.immersiveintelligence.common.items.armor.ItemIIUpgradeableArmor;

public class IIArmorItemStackHandler
extends ItemStackHandler
implements ICapabilityProvider {
    private boolean first = true;
    private ItemStack stack;
    EnergyHelper.ItemEnergyStorage energyStorage;
    @Nonnull
    private Runnable onChange = () -> {};

    public IIArmorItemStackHandler(ItemStack stack) {
        this.stack = stack;
        this.energyStorage = new EnergyHelper.ItemEnergyStorage(stack);
    }

    public void setTile(TileEntity tile) {
        this.onChange = tile != null ? () -> ((TileEntity)tile).func_70296_d() : () -> {};
    }

    public void setInventoryForUpdate(IInventory inv) {
        this.onChange = inv != null ? () -> ((IInventory)inv).func_70296_d() : () -> {};
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.onChange.run();
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.first) {
            int idealSize = ((ItemIIUpgradeableArmor)this.stack.func_77973_b()).getSlotCount();
            NonNullList newList = NonNullList.func_191197_a((int)idealSize, (Object)ItemStack.field_190927_a);
            for (int i = 0; i < Math.min(this.stacks.size(), idealSize); ++i) {
                newList.set(i, this.stacks.get(i));
            }
            this.stacks = newList;
            this.stack = ItemStack.field_190927_a;
            this.first = false;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.energyStorage;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this);
        }
        return null;
    }

    public NonNullList<ItemStack> getContainedItems() {
        return this.stacks;
    }
}

