/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import pl.pabilo8.immersiveintelligence.common.entity.EntityFieldHowitzer;
import pl.pabilo8.immersiveintelligence.common.entity.EntityMachinegun;
import pl.pabilo8.immersiveintelligence.common.entity.EntityMortar;
import pl.pabilo8.immersiveintelligence.common.entity.EntityMotorbike;
import pl.pabilo8.immersiveintelligence.common.entity.bullets.EntityBullet;

public class MessageEntityNBTSync
implements IMessage {
    int entityID;
    NBTTagCompound tag;

    public MessageEntityNBTSync(Entity entity, NBTTagCompound tag) {
        this.entityID = entity.func_145782_y();
        this.tag = tag;
    }

    public MessageEntityNBTSync() {
    }

    public void fromBytes(ByteBuf buf) {
        this.entityID = buf.readInt();
        this.tag = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityID);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
    }

    public static class HandlerServer
    implements IMessageHandler<MessageEntityNBTSync, IMessage> {
        public IMessage onMessage(MessageEntityNBTSync message, MessageContext ctx) {
            WorldServer world = ctx.getServerHandler().field_147369_b.func_71121_q();
            world.func_152344_a(() -> {
                Entity entity = world.func_73045_a(message.entityID);
                if (entity instanceof EntityMachinegun) {
                    ((EntityMachinegun)entity).func_70037_a(message.tag);
                } else if (entity instanceof EntityMotorbike) {
                    ((EntityMotorbike)entity).syncKeyPress(message.tag);
                } else if (entity instanceof EntityFieldHowitzer) {
                    ((EntityFieldHowitzer)entity).syncKeyPress(message.tag);
                } else if (entity instanceof EntityMortar) {
                    ((EntityMortar)entity).syncKeyPress(message.tag);
                }
            });
            return null;
        }
    }

    public static class HandlerClient
    implements IMessageHandler<MessageEntityNBTSync, IMessage> {
        public IMessage onMessage(MessageEntityNBTSync message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                World world = ImmersiveEngineering.proxy.getClientWorld();
                if (world != null) {
                    Entity entity = world.func_73045_a(message.entityID);
                    if (entity instanceof EntityBullet) {
                        ((EntityBullet)entity).func_70037_a(message.tag);
                    } else if (entity instanceof EntityMachinegun) {
                        ((EntityMachinegun)entity).func_70037_a(message.tag);
                    }
                }
            });
            return null;
        }
    }
}

