/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.items.weapons;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.tool.IUpgrade;
import blusunrize.immersiveengineering.api.tool.IUpgradeableTool;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import pl.pabilo8.immersiveintelligence.client.render.MachinegunRenderer;
import pl.pabilo8.immersiveintelligence.client.render.item.SubmachinegunItemStackRenderer;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.items.ItemIIBase;

public class ItemIIWeaponUpgrade
extends ItemIIBase
implements IUpgrade {
    public ItemIIWeaponUpgrade() {
        super("weapon_upgrade", 1, WeaponUpgrades.parse());
    }

    public static TextFormatting getFormattingForWeapon(String weapon) {
        switch (weapon) {
            case "MACHINEGUN": {
                return TextFormatting.YELLOW;
            }
            case "SUBMACHINEGUN": {
                return TextFormatting.GOLD;
            }
            case "RAILGUN": {
                return TextFormatting.DARK_GREEN;
            }
            case "REVOLVER": {
                return TextFormatting.BLUE;
            }
            case "AUTOREVOLVER": {
                return TextFormatting.DARK_BLUE;
            }
            case "ASSAULT_RIFLE": {
                return TextFormatting.RED;
            }
            case "SPIGOT_MORTAR": {
                return TextFormatting.DARK_PURPLE;
            }
        }
        return TextFormatting.RESET;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (stack.func_77952_i() < this.getSubNames().length) {
            for (String upgradeType : this.getUpgradeTypes(stack)) {
                list.add(ItemIIWeaponUpgrade.getFormattingForWeapon(upgradeType) + I18n.func_135052_a((String)("desc.immersiveintelligence.toolupgrade.item." + upgradeType.toLowerCase()), (Object[])new Object[0]));
            }
            String[] flavour = ImmersiveEngineering.proxy.splitStringOnWidth(I18n.func_135052_a((String)("desc.immersiveintelligence.toolupgrade." + this.getSubNames()[stack.func_77952_i()]), (Object[])new Object[0]), 200);
            Arrays.stream(flavour).map(s -> TextFormatting.ITALIC + s + TextFormatting.RESET).forEach(list::add);
        }
    }

    public int getItemStackLimit(ItemStack stack) {
        return WeaponUpgrades.get(stack.func_77960_j()).stackSize;
    }

    public Set<String> getUpgradeTypes(ItemStack upgrade) {
        return WeaponUpgrades.get(upgrade.func_77960_j()).toolset;
    }

    public boolean canApplyUpgrades(ItemStack target, ItemStack upgrade) {
        BiPredicate check = WeaponUpgrades.get(upgrade.func_77960_j()).applyCheck;
        if (check != null && target.func_77973_b() instanceof IUpgradeableTool) {
            return check.test(target, upgrade);
        }
        return true;
    }

    public void applyUpgrades(ItemStack target, ItemStack upgrade, NBTTagCompound modifications) {
        WeaponUpgrades.get(upgrade.func_77960_j()).function.accept(upgrade, modifications);
    }

    public static void addUpgradesToRender() {
        MachinegunRenderer.upgrades.put(stack -> IIContent.itemMachinegun.getUpgrades((ItemStack)stack).func_74767_n("water_cooling"), (stack, tmtNamedBoxGroups) -> {
            tmtNamedBoxGroups.remove(MachinegunRenderer.model.barrelBox);
            tmtNamedBoxGroups.add(MachinegunRenderer.model.waterCoolingBox);
        });
        MachinegunRenderer.upgrades.put(stack -> IIContent.itemMachinegun.getUpgrades((ItemStack)stack).func_74767_n("heavy_barrel"), (stack, tmtNamedBoxGroups) -> {
            tmtNamedBoxGroups.remove(MachinegunRenderer.model.barrelBox);
            tmtNamedBoxGroups.add(MachinegunRenderer.model.heavyBarrelBox);
        });
        MachinegunRenderer.upgrades.put(stack -> IIContent.itemMachinegun.getUpgrades((ItemStack)stack).func_74767_n("second_magazine"), (stack, tmtNamedBoxGroups) -> {
            tmtNamedBoxGroups.add(MachinegunRenderer.model.secondMagazineMainBox);
            tmtNamedBoxGroups.add(MachinegunRenderer.model.secondMagazineMagBox);
        });
        MachinegunRenderer.upgrades.put(stack -> IIContent.itemMachinegun.getUpgrades((ItemStack)stack).func_74767_n("belt_fed_loader"), (stack, tmtNamedBoxGroups) -> {
            tmtNamedBoxGroups.remove(MachinegunRenderer.model.ammoBox);
            tmtNamedBoxGroups.add(MachinegunRenderer.model.beltFedLoaderBox);
        });
        MachinegunRenderer.upgrades.put(stack -> IIContent.itemMachinegun.getUpgrades((ItemStack)stack).func_74767_n("scope"), (stack, tmtNamedBoxGroups) -> tmtNamedBoxGroups.add(MachinegunRenderer.model.scopeBox));
        MachinegunRenderer.upgrades.put(stack -> IIContent.itemMachinegun.getUpgrades((ItemStack)stack).func_74767_n("infrared_scope"), (stack, tmtNamedBoxGroups) -> tmtNamedBoxGroups.add(MachinegunRenderer.model.infraredScopeBox));
        MachinegunRenderer.upgrades.put(stack -> IIContent.itemMachinegun.getUpgrades((ItemStack)stack).func_74767_n("hasty_bipod"), (stack, tmtNamedBoxGroups) -> {
            tmtNamedBoxGroups.remove(MachinegunRenderer.model.bipodBox);
            tmtNamedBoxGroups.add(MachinegunRenderer.model.hastyBipodBox);
        });
        MachinegunRenderer.upgrades.put(stack -> IIContent.itemMachinegun.getUpgrades((ItemStack)stack).func_74767_n("precise_bipod"), (stack, tmtNamedBoxGroups) -> {
            tmtNamedBoxGroups.remove(MachinegunRenderer.model.bipodBox);
            tmtNamedBoxGroups.add(MachinegunRenderer.model.preciseBipodBox);
        });
        MachinegunRenderer.upgrades.put(stack -> IIContent.itemMachinegun.getUpgrades((ItemStack)stack).func_74767_n("tripod"), (stack, tmtNamedBoxGroups) -> {
            tmtNamedBoxGroups.remove(MachinegunRenderer.model.bipodBox);
            tmtNamedBoxGroups.add(MachinegunRenderer.model.tripodBox);
        });
        MachinegunRenderer.upgrades.put(stack -> IIContent.itemMachinegun.getUpgrades((ItemStack)stack).func_74767_n("shield"), (stack, tmtNamedBoxGroups) -> tmtNamedBoxGroups.add(MachinegunRenderer.model.shieldBox));
        SubmachinegunItemStackRenderer.upgrades.put(stack -> IIContent.itemSubmachinegun.getUpgrades((ItemStack)stack).func_74767_n("sturdy_barrel"), (stack, tmtNamedBoxGroups) -> {
            tmtNamedBoxGroups.remove(SubmachinegunItemStackRenderer.model.barrelBox);
            tmtNamedBoxGroups.add(SubmachinegunItemStackRenderer.model.sturdyBarrelBox);
        });
        SubmachinegunItemStackRenderer.upgrades.put(stack -> IIContent.itemSubmachinegun.getUpgrades((ItemStack)stack).func_74767_n("suppressor"), (stack, tmtNamedBoxGroups) -> tmtNamedBoxGroups.add(SubmachinegunItemStackRenderer.model.silencerBox));
        SubmachinegunItemStackRenderer.upgrades.put(stack -> IIContent.itemSubmachinegun.getUpgrades((ItemStack)stack).func_74767_n("bottom_loading"), (stack, tmtNamedBoxGroups) -> {
            tmtNamedBoxGroups.remove(SubmachinegunItemStackRenderer.model.ammoBox);
            tmtNamedBoxGroups.remove(SubmachinegunItemStackRenderer.model.gripBox);
            tmtNamedBoxGroups.remove(SubmachinegunItemStackRenderer.model.loaderBox);
            tmtNamedBoxGroups.add(SubmachinegunItemStackRenderer.model.bottomLoaderBox);
        });
        SubmachinegunItemStackRenderer.upgrades.put(stack -> IIContent.itemSubmachinegun.getUpgrades((ItemStack)stack).func_74767_n("folding_stock"), (stack, tmtNamedBoxGroups) -> {
            tmtNamedBoxGroups.remove(SubmachinegunItemStackRenderer.model.stockBox);
            tmtNamedBoxGroups.add(SubmachinegunItemStackRenderer.model.foldingStockHolderBox);
            tmtNamedBoxGroups.add(SubmachinegunItemStackRenderer.model.foldingStockBox);
        });
        SubmachinegunItemStackRenderer.upgrades.put(stack -> IIContent.itemSubmachinegun.getUpgrades((ItemStack)stack).func_74762_e("melee") > 0, (stack, tmtNamedBoxGroups) -> tmtNamedBoxGroups.add(SubmachinegunItemStackRenderer.model.bayonetBox));
    }

    public static enum WeaponUpgrades {
        HEAVY_BARREL((ImmutableSet<String>)ImmutableSet.of((Object)"MACHINEGUN"), 1, (target, upgrade) -> !((IUpgradeableTool)target.func_77973_b()).getUpgrades(target).func_74764_b("water_cooling"), (upgrade, modifications) -> modifications.func_74757_a("heavy_barrel", true)),
        WATER_COOLING((ImmutableSet<String>)ImmutableSet.of((Object)"MACHINEGUN"), 1, (target, upgrade) -> !((IUpgradeableTool)target.func_77973_b()).getUpgrades(target).func_74764_b("heavy_barrel"), (upgrade, modifications) -> modifications.func_74757_a("water_cooling", true)),
        BELT_FED_LOADER((ImmutableSet<String>)ImmutableSet.of((Object)"MACHINEGUN"), 1, (target, upgrade) -> !((IUpgradeableTool)target.func_77973_b()).getUpgrades(target).func_74764_b("second_magazine"), (upgrade, modifications) -> modifications.func_74757_a("belt_fed_loader", true)),
        SECOND_MAGAZINE((ImmutableSet<String>)ImmutableSet.of((Object)"MACHINEGUN"), 1, (target, upgrade) -> !((IUpgradeableTool)target.func_77973_b()).getUpgrades(target).func_74764_b("belt_fed_loader"), (upgrade, modifications) -> modifications.func_74757_a("second_magazine", true)),
        HASTY_BIPOD((ImmutableSet<String>)ImmutableSet.of((Object)"MACHINEGUN"), 1, (target, upgrade) -> !((IUpgradeableTool)target.func_77973_b()).getUpgrades(target).func_74764_b("precise_bipod"), (upgrade, modifications) -> modifications.func_74757_a("hasty_bipod", true)),
        PRECISE_BIPOD((ImmutableSet<String>)ImmutableSet.of((Object)"MACHINEGUN"), 1, (target, upgrade) -> !((IUpgradeableTool)target.func_77973_b()).getUpgrades(target).func_74764_b("hasty_bipod"), (upgrade, modifications) -> modifications.func_74757_a("precise_bipod", true)),
        SCOPE((ImmutableSet<String>)ImmutableSet.of((Object)"MACHINEGUN", (Object)"AUTOREVOLVER", (Object)"ASSAULT_RIFLE"), 1, (target, upgrade) -> !((IUpgradeableTool)target.func_77973_b()).getUpgrades(target).func_74764_b("infrared_scope"), (upgrade, modifications) -> modifications.func_74757_a("scope", true)),
        INFRARED_SCOPE((ImmutableSet<String>)ImmutableSet.of((Object)"MACHINEGUN", (Object)"ASSAULT_RIFLE"), 1, (target, upgrade) -> !((IUpgradeableTool)target.func_77973_b()).getUpgrades(target).func_74764_b("scope"), (upgrade, modifications) -> modifications.func_74757_a("infrared_scope", true)),
        SHIELD((ImmutableSet<String>)ImmutableSet.of((Object)"MACHINEGUN"), 1, (target, upgrade) -> !((IUpgradeableTool)target.func_77973_b()).getUpgrades(target).func_74764_b("shield"), (upgrade, modifications) -> modifications.func_74757_a("shield", true)),
        TRIPOD((ImmutableSet<String>)ImmutableSet.of((Object)"MACHINEGUN"), 1, (target, upgrade) -> !((IUpgradeableTool)target.func_77973_b()).getUpgrades(target).func_74764_b("tripod"), (upgrade, modifications) -> modifications.func_74757_a("tripod", true)),
        STURDY_BARREL((ImmutableSet<String>)ImmutableSet.of((Object)"SUBMACHINEGUN"), 1, (target, upgrade) -> !((IUpgradeableTool)target.func_77973_b()).getUpgrades(target).func_74764_b("sturdy_barrel"), (upgrade, modifications) -> modifications.func_74757_a("sturdy_barrel", true)),
        SUPPRESSOR((ImmutableSet<String>)ImmutableSet.of((Object)"SUBMACHINEGUN"), 1, (target, upgrade) -> !((IUpgradeableTool)target.func_77973_b()).getUpgrades(target).func_74764_b("suppressor"), (upgrade, modifications) -> modifications.func_74757_a("suppressor", true)),
        BOTTOM_LOADING((ImmutableSet<String>)ImmutableSet.of((Object)"SUBMACHINEGUN"), 1, (target, upgrade) -> !((IUpgradeableTool)target.func_77973_b()).getUpgrades(target).func_74764_b("bottom_loading"), (upgrade, modifications) -> modifications.func_74757_a("bottom_loading", true)),
        FOLDING_STOCK((ImmutableSet<String>)ImmutableSet.of((Object)"SUBMACHINEGUN"), 1, (target, upgrade) -> !((IUpgradeableTool)target.func_77973_b()).getUpgrades(target).func_74764_b("folding_stock"), (upgrade, modifications) -> modifications.func_74757_a("folding_stock", true));

        private final ImmutableSet<String> toolset;
        private final int stackSize;
        private final BiPredicate<ItemStack, ItemStack> applyCheck;
        private final BiConsumer<ItemStack, NBTTagCompound> function;

        private WeaponUpgrades(ImmutableSet<String> toolset, BiConsumer<ItemStack, NBTTagCompound> function) {
            this(toolset, 1, function);
        }

        private WeaponUpgrades(ImmutableSet<String> toolset, int stackSize, BiConsumer<ItemStack, NBTTagCompound> function) {
            this(toolset, stackSize, null, function);
        }

        private WeaponUpgrades(ImmutableSet<String> toolset, int stackSize, BiPredicate<ItemStack, ItemStack> applyCheck, BiConsumer<ItemStack, NBTTagCompound> function) {
            this.toolset = toolset;
            this.stackSize = stackSize;
            this.applyCheck = applyCheck;
            this.function = function;
        }

        static String[] parse() {
            String[] ret = new String[WeaponUpgrades.values().length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = WeaponUpgrades.values()[i].toString().toLowerCase(Locale.US);
            }
            return ret;
        }

        static WeaponUpgrades get(int meta) {
            if (meta >= 0 && meta < WeaponUpgrades.values().length) {
                return WeaponUpgrades.values()[meta];
            }
            return HEAVY_BARREL;
        }

        public boolean isValidFor(String weapon) {
            return this.toolset.contains((Object)weapon);
        }
    }
}

