/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.items.weapons;

import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.tool.RailgunHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.entities.EntityRailgunShot;
import blusunrize.immersiveengineering.common.items.ItemRailgun;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Triple;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.bullets.BulletHelper;
import pl.pabilo8.immersiveintelligence.common.entity.bullets.EntityBullet;
import pl.pabilo8.immersiveintelligence.common.items.ammunition.ItemIIAmmoRailgunGrenade;

public class ItemIIRailgunOverride
extends ItemRailgun {
    public ItemIIRailgunOverride() {
        IEContent.registeredIEItems.removeIf(item -> item instanceof ItemRailgun);
        IEContent.registeredIEItems.add(this);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (Config.IIConfig.Weapons.Railgun.disableRailgunOffhand && hand == EnumHand.OFF_HAND) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        int energy = Config.IEConfig.Tools.railgun_consumption;
        float energyMod = 1.0f + this.getUpgrades(stack).func_74760_g("consumption");
        if (this.extractEnergy(stack, energy = (int)((float)energy * energyMod), true) == energy && !ItemIIRailgunOverride.findAmmo((EntityLivingBase)player).func_190926_b()) {
            player.func_184598_c(hand);
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, this.getChargeTime(stack) <= 20 ? IESounds.chargeFast : IESounds.chargeSlow, SoundCategory.PLAYERS, 1.5f, 1.0f);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase user, int timeLeft) {
        ItemStack ammo;
        int inUse = this.func_77626_a(stack) - timeLeft;
        ItemNBTHelper.remove((ItemStack)stack, (String)"inUse");
        if (inUse < this.getChargeTime(stack)) {
            return;
        }
        int energy = Config.IEConfig.Tools.railgun_consumption;
        float energyMod = 1.0f + this.getUpgrades(stack).func_74760_g("consumption");
        if (this.extractEnergy(stack, energy = (int)((float)energy * energyMod), true) == energy && !(ammo = ItemIIRailgunOverride.findAmmo(user)).func_190926_b()) {
            Triple shader;
            Vec3d vec = user.func_70040_Z();
            float speed = 20.0f;
            float mass = 0.25f;
            world.func_184148_a(null, user.field_70165_t, user.field_70163_u, user.field_70161_v, IESounds.railgunFire, SoundCategory.PLAYERS, 1.0f, 0.5f + 0.5f * user.func_70681_au().nextFloat());
            this.extractEnergy(stack, energy, false);
            if (!world.field_72995_K) {
                if (ammo.func_77973_b() instanceof ItemIIAmmoRailgunGrenade) {
                    Vec3d vv = user.func_174791_d().func_72441_c(0.0, (double)user.func_70047_e() - (double)0.1f, 0.0);
                    EntityBullet a = BulletHelper.createBullet(world, Utils.copyStackWithAmount((ItemStack)ammo, (int)1), vv, vec);
                    a.setShooters((Entity)user, new Entity[0]);
                    mass = a.mass;
                    world.func_72838_d((Entity)a);
                } else {
                    EntityRailgunShot shot = new EntityRailgunShot(user.field_70170_p, user, vec.field_72450_a * (double)speed, vec.field_72448_b * (double)speed, vec.field_72449_c * (double)speed, Utils.copyStackWithAmount((ItemStack)ammo, (int)1));
                    world.func_72838_d((Entity)shot);
                }
            }
            ammo.func_190918_g(1);
            if (Config.IIConfig.Weapons.Railgun.railgunRecoil) {
                user.func_70091_d(MoverType.PISTON, -vec.field_72450_a * (double)mass * 0.25, 0.0, -vec.field_72449_c * (double)mass * 0.25);
            }
            if ((shader = ShaderRegistry.getStoredShaderAndCase((ItemStack)stack)) != null) {
                Vec3d pos = Utils.getLivingFrontPos((EntityLivingBase)user, (double)0.75, (double)((double)user.field_70131_O * 0.75), (EnumHandSide)this.getActiveSide(user), (boolean)false, (float)1.0f);
                ((ShaderRegistry.ShaderRegistryEntry)shader.getMiddle()).getEffectFunction().execute(world, (ItemStack)shader.getLeft(), stack, ((ShaderCase)shader.getRight()).getShaderType(), pos, user.func_70040_Z(), 0.125f);
            }
        }
    }

    public static ItemStack findAmmo(EntityLivingBase entity) {
        if (ItemIIRailgunOverride.isAmmo(entity.func_184586_b(EnumHand.OFF_HAND))) {
            return entity.func_184586_b(EnumHand.OFF_HAND);
        }
        if (ItemIIRailgunOverride.isAmmo(entity.func_184586_b(EnumHand.MAIN_HAND))) {
            return entity.func_184586_b(EnumHand.MAIN_HAND);
        }
        if (entity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            IItemHandler capability = (IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            if (capability == null) {
                return ItemStack.field_190927_a;
            }
            for (int i = 0; i < capability.getSlots(); ++i) {
                ItemStack itemstack = capability.getStackInSlot(i);
                if (!ItemIIRailgunOverride.isAmmo(itemstack)) continue;
                return itemstack;
            }
        }
        return ItemStack.field_190927_a;
    }

    public static boolean isAmmo(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (stack.func_77973_b() instanceof ItemIIAmmoRailgunGrenade) {
            return true;
        }
        return RailgunHandler.getProjectileProperties((ItemStack)stack) != null;
    }

    private EnumHandSide getActiveSide(EntityLivingBase user) {
        EnumHandSide ret = user.func_184591_cq();
        if (user.func_184600_cs() != EnumHand.MAIN_HAND) {
            ret = ret == EnumHandSide.LEFT ? EnumHandSide.RIGHT : EnumHandSide.LEFT;
        }
        return ret;
    }
}

