/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.items.weapons;

import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.ItemUpgradeableTool;
import blusunrize.immersiveengineering.common.util.IEItemFluidHandler;
import blusunrize.immersiveengineering.common.util.inventory.IEItemStackHandler;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.CustomSkinHandler;
import pl.pabilo8.immersiveintelligence.ImmersiveIntelligence;
import pl.pabilo8.immersiveintelligence.api.ISkinnable;
import pl.pabilo8.immersiveintelligence.api.MachinegunCoolantHandler;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.entity.EntityMachinegun;

public class ItemIIMachinegun
extends ItemUpgradeableTool
implements IEItemInterfaces.IAdvancedFluidItem,
ISkinnable {
    public ItemIIMachinegun() {
        super("machinegun", 1, "MACHINEGUN", new String[0]);
        this.fixupItem();
    }

    public int getSlotCount(ItemStack stack) {
        return 3;
    }

    public boolean canModify(ItemStack stack) {
        return true;
    }

    public Slot[] getWorkbenchSlots(Container container, ItemStack stack) {
        IItemHandler inv = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        return new Slot[]{new IESlot.Upgrades(container, inv, 0, 80, 32, "MACHINEGUN", stack, true), new IESlot.Upgrades(container, inv, 1, 100, 32, "MACHINEGUN", stack, true), new IESlot.Upgrades(container, inv, 2, 120, 32, "MACHINEGUN", stack, true)};
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        String skin = this.getSkinnableCurrentSkin(stack);
        if (!skin.isEmpty() && CustomSkinHandler.specialSkins.containsKey(skin)) {
            tooltip.add(TextFormatting.WHITE + I18n.func_135052_a((String)String.format("skin.%1$s.%2$s.name", "immersiveintelligence", skin), (Object[])new Object[0]));
            tooltip.add(TextFormatting.GRAY.toString() + TextFormatting.ITALIC + I18n.func_135052_a((String)String.format("skin.%1$s.%2$s.desc", "immersiveintelligence", skin), (Object[])new Object[0]));
        }
    }

    public IRarity getForgeRarity(ItemStack stack) {
        String skin = this.getSkinnableCurrentSkin(stack);
        if (!skin.isEmpty() && CustomSkinHandler.specialSkins.containsKey(skin)) {
            return CustomSkinHandler.specialSkins.get((Object)skin).rarity;
        }
        return super.getForgeRarity(stack);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        AxisAlignedBB fence;
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        float f = 1.0f;
        float f1 = playerIn.field_70127_C + (playerIn.field_70125_A - playerIn.field_70127_C);
        float f2 = playerIn.field_70126_B + (playerIn.field_70177_z - playerIn.field_70126_B);
        double d0 = playerIn.field_70169_q + (playerIn.field_70165_t - playerIn.field_70169_q);
        double d1 = playerIn.field_70167_r + (playerIn.field_70163_u - playerIn.field_70167_r) + (double)playerIn.func_70047_e();
        double d2 = playerIn.field_70166_s + (playerIn.field_70161_v - playerIn.field_70166_s);
        Vec3d vec3d = new Vec3d(d0, d1, d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = 5.0;
        Vec3d vec3d1 = vec3d.func_72441_c((double)f7 * 5.0, (double)f6 * 5.0, (double)f8 * 5.0);
        RayTraceResult raytraceresult = worldIn.func_72901_a(vec3d, vec3d1, false);
        if (raytraceresult == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
        }
        Vec3d vec3d2 = playerIn.func_70676_i(1.0f);
        boolean flag = false;
        List list = worldIn.func_72839_b((Entity)playerIn, playerIn.func_174813_aQ().func_72321_a(vec3d2.field_72450_a * 5.0, vec3d2.field_72448_b * 5.0, vec3d2.field_72449_c * 5.0).func_186662_g(1.0));
        for (Entity entity : list) {
            AxisAlignedBB axisalignedbb;
            if (!entity.func_70067_L() || !(axisalignedbb = entity.func_174813_aQ().func_186662_g((double)entity.func_70111_Y())).func_72318_a(vec3d)) continue;
            flag = true;
        }
        if (flag) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
        }
        if (raytraceresult.field_72313_a != RayTraceResult.Type.BLOCK) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
        }
        AxisAlignedBB aabb = worldIn.func_180495_p(raytraceresult.func_178782_a()).func_185890_d((IBlockAccess)playerIn.field_70170_p, raytraceresult.func_178782_a());
        EnumFacing facing = EnumFacing.func_176733_a((double)playerIn.field_70177_z);
        float yaw = facing.func_185119_l();
        float pitch = 25.0f;
        switch (facing) {
            case SOUTH: {
                fence = new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 1.0, 1.0);
                break;
            }
            case WEST: {
                fence = new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 1.0, 1.0);
                break;
            }
            case EAST: {
                fence = new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 1.0, 1.0);
                break;
            }
            default: {
                fence = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.5);
            }
        }
        if (aabb == null) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        boolean intersects = Utils.isAABBContained(fence, aabb);
        if (!intersects) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
        }
        EntityMachinegun maschinengewehr = new EntityMachinegun(worldIn, raytraceresult.func_178782_a(), playerIn.func_70079_am(), pitch, itemstack.func_77946_l());
        if (!worldIn.field_72995_K) {
            worldIn.func_72838_d((Entity)maschinengewehr);
        }
        playerIn.func_184220_m((Entity)maschinengewehr);
        itemstack.func_190918_g(1);
        playerIn.func_71029_a(StatList.func_188057_b((Item)this));
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public void fixupItem() {
        Item rItem = (Item)IEContent.registeredIEItems.remove(IEContent.registeredIEItems.size() - 1);
        if (rItem != this) {
            throw new IllegalStateException("fixupItem was not called at the appropriate time");
        }
        this.func_77655_b("immersiveintelligence." + this.itemName);
        this.func_77637_a(ImmersiveIntelligence.creativeTab);
        IIContent.ITEMS.add((Item)this);
    }

    public void removeFromWorkbench(EntityPlayer player, ItemStack stack) {
        NBTTagCompound upgrades = this.getUpgrades(stack);
        if (!Utils.hasUnlockedIIAdvancement(player, "main/let_me_show_you_its_features") && upgrades.func_74764_b("heavy_barrel") && upgrades.func_74764_b("second_magazine") && upgrades.func_74764_b("infrared_scope")) {
            Utils.unlockIIAdvancement(player, "main/let_me_show_you_its_features");
        }
        if (!Utils.hasUnlockedIIAdvancement(player, "main/hans_9000") && upgrades.func_74764_b("belt_fed_loader") && upgrades.func_74764_b("shield") && upgrades.func_74764_b("water_cooling")) {
            Utils.unlockIIAdvancement(player, "main/hans_9000");
        }
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, NBTTagCompound nbt) {
        if (!stack.func_190926_b()) {
            return new IEItemStackHandler(stack){
                final IEItemFluidHandler fluids;
                {
                    super(x0);
                    this.fluids = new IEItemFluidHandler(stack, 0);
                }

                public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                    return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY || super.hasCapability(capability, facing);
                }

                public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                    if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
                        return (T)this.fluids;
                    }
                    return (T)super.getCapability(capability, facing);
                }
            };
        }
        return null;
    }

    public int getCapacity(ItemStack stack, int baseCapacity) {
        return this.getUpgrades(stack).func_74764_b("water_cooling") ? Config.IIConfig.Weapons.Machinegun.waterCoolingTankCapacity : 0;
    }

    public boolean allowFluid(ItemStack container, FluidStack fluid) {
        return this.getUpgrades(container).func_74764_b("water_cooling") && MachinegunCoolantHandler.isValidCoolant(fluid);
    }

    @Override
    public String getSkinnableName() {
        return "machinegun";
    }

    @Override
    public String getSkinnableDefaultTextureLocation() {
        return "immersiveintelligence:textures/items/weapons/";
    }
}

