/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.items.tools;

import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentDurability;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.utils.IWrench;
import pl.pabilo8.immersiveintelligence.api.utils.vehicles.IUpgradableMachine;
import pl.pabilo8.immersiveintelligence.common.items.ItemIIBase;

public class ItemIIWrench
extends ItemIIBase
implements ITool,
IEItemInterfaces.IItemDamageableIE,
IWrench {
    public ItemIIWrench() {
        super("wrench", 1, new String[0]);
        this.canRepair = false;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        list.add(TextFormatting.ITALIC + I18n.func_135052_a((String)"desc.immersiveintelligence.wrench", (Object[])new Object[0]) + TextFormatting.RESET);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    @Nonnull
    public ItemStack getContainerItem(@Nonnull ItemStack stack) {
        ItemStack container = stack.func_77946_l();
        this.damageIETool(container, 1, Utils.RAND, null);
        return container;
    }

    private void damageIETool(ItemStack stack, int amount, Random rand, @Nullable EntityPlayer player) {
        if (amount <= 0) {
            return;
        }
        int unbreakLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)stack);
        for (int i = 0; unbreakLevel > 0 && i < amount; ++i) {
            if (!EnchantmentDurability.func_92097_a((ItemStack)stack, (int)unbreakLevel, (Random)rand)) continue;
            --amount;
        }
        if (amount <= 0) {
            return;
        }
        int curDamage = ItemNBTHelper.getInt((ItemStack)stack, (String)"Damage");
        curDamage += amount;
        if (player instanceof EntityPlayerMP) {
            CriteriaTriggers.field_193132_s.func_193158_a((EntityPlayerMP)player, stack, curDamage);
        }
        if (curDamage >= Config.IIConfig.Tools.wrench_durability) {
            if (player != null) {
                player.func_70669_a(stack);
                player.func_71029_a(StatList.func_188059_c((Item)this));
            }
            stack.func_190918_g(1);
            return;
        }
        ItemNBTHelper.setInt((ItemStack)stack, (String)"Damage", (int)curDamage);
    }

    public boolean func_77645_m() {
        return true;
    }

    public int getMaxDamageIE(ItemStack stack) {
        return Config.IIConfig.Tools.wrench_durability;
    }

    public int getItemDamageIE(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)"Damage");
    }

    public boolean func_77616_k(@Nonnull ItemStack stack) {
        return true;
    }

    public int func_77619_b() {
        return 14;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.field_185305_q || enchantment == Enchantments.field_185307_s || enchantment == Enchantments.field_185296_A;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        if (player != null && !player.field_70170_p.field_72995_K && !player.field_71075_bZ.field_75098_d) {
            IBlockState state = player.field_70170_p.func_180495_p(pos);
            boolean effective = false;
            for (String tool : this.getToolClasses(itemstack)) {
                if (!state.func_177230_c().isToolEffective(tool, state)) continue;
                effective = true;
                break;
            }
            this.damageIETool(itemstack, effective ? 1 : 2, player.func_70681_au(), player);
        }
        return false;
    }

    @Nonnull
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        IUpgradableMachine te;
        if (world.func_175625_s(pos) instanceof IUpgradableMachine && (te = (IUpgradableMachine)((IUpgradableMachine)world.func_175625_s(pos)).getUpgradeMaster()) != null && te.getCurrentlyInstalled() != null) {
            te.addUpgradeInstallProgress(player.func_184812_l_() ? 999999 : Config.IIConfig.Tools.wrench_upgrade_progress);
            if (te.getInstallProgress() >= te.getCurrentlyInstalled().getProgressRequired() && te.addUpgrade(te.getCurrentlyInstalled(), false)) {
                te.resetInstallProgress();
            }
            this.damageWrench(player.func_184586_b(hand), player);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return EnumActionResult.PASS;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase entity, EnumHand hand) {
        return false;
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public int getHarvestLevel(ItemStack stack, @Nonnull String toolClass, @Nullable EntityPlayer player, @Nullable IBlockState blockState) {
        if (this.getToolClasses(stack).contains(toolClass)) {
            return 2;
        }
        return -1;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)"Damage") > 0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        double max = this.getMaxDamageIE(stack);
        return (double)ItemNBTHelper.getInt((ItemStack)stack, (String)"Damage") / max;
    }

    @Nonnull
    public Set<String> getToolClasses(ItemStack stack) {
        int meta = stack.func_77960_j();
        return ImmutableSet.of((Object)"II_WRENCH");
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        for (String type : this.getToolClasses(stack)) {
            if (!state.func_177230_c().isToolEffective(type, state)) continue;
            return 6.0f;
        }
        return super.func_150893_a(stack, state);
    }

    public boolean isTool(ItemStack item) {
        return true;
    }

    public boolean canHarvestBlock(@Nonnull IBlockState state, ItemStack stack) {
        if (state.func_177230_c().isToolEffective("II_WRENCH", state)) {
            return true;
        }
        return super.canHarvestBlock(state, stack);
    }

    @Override
    public boolean canBeUsed(ItemStack stack) {
        return true;
    }

    @Override
    public void damageWrench(ItemStack stack, EntityPlayer player) {
        this.damageIETool(stack, 1, player.func_70681_au(), player);
    }
}

