/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.items.mechanical;

import blusunrize.immersiveengineering.api.energy.wires.IWireCoil;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.rotary.IModelMotorBelt;
import pl.pabilo8.immersiveintelligence.api.rotary.IMotorBeltConnector;
import pl.pabilo8.immersiveintelligence.api.rotary.RotaryUtils;
import pl.pabilo8.immersiveintelligence.client.model.motor_belt.ModelClothMotorBelt;
import pl.pabilo8.immersiveintelligence.client.model.motor_belt.ModelSteelMotorBelt;
import pl.pabilo8.immersiveintelligence.common.items.ItemIIBase;
import pl.pabilo8.immersiveintelligence.common.wire.IIMotorBeltType;

public class ItemIIMotorBelt
extends ItemIIBase
implements IWireCoil {
    public ItemIIMotorBelt() {
        super("motor_belt", 64, MotorBelt.getNames());
    }

    public WireType getWireType(ItemStack stack) {
        return MotorBelt.values()[stack.func_77960_j()].type;
    }

    public boolean canConnectCable(ItemStack stack, TileEntity targetEntity) {
        return targetEntity instanceof IMotorBeltConnector;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        int[] link;
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("linkingPos") && (link = stack.func_77978_p().func_74759_k("linkingPos")) != null && link.length > 3) {
            tooltip.add(I18n.func_135052_a((String)"desc.immersiveengineering.info.attachedToDim", (Object[])new Object[]{link[1], link[2], link[3], link[0]}));
        }
    }

    @Nonnull
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        return RotaryUtils.useCoil(this, player, world, pos, hand, side, hitX, hitY, hitZ);
    }

    public void setRenderModels() {
        MotorBelt.CLOTH.model = new ModelClothMotorBelt();
        MotorBelt.STEEL.model = new ModelSteelMotorBelt();
        MotorBelt.RUBBER.model = new ModelClothMotorBelt();
    }

    public static enum MotorBelt implements IStringSerializable
    {
        CLOTH("light_belts", Config.IIConfig.MechanicalDevices.belt_length[0], 1, 6, Config.IIConfig.MechanicalDevices.belt_max_torque[0], Config.IIConfig.MechanicalDevices.belt_torque_loss[0]),
        STEEL("heavy_belts", Config.IIConfig.MechanicalDevices.belt_length[1], 1, 8, Config.IIConfig.MechanicalDevices.belt_max_torque[1], Config.IIConfig.MechanicalDevices.belt_torque_loss[1]),
        RUBBER("light_belts", Config.IIConfig.MechanicalDevices.belt_length[2], 1, 6, Config.IIConfig.MechanicalDevices.belt_max_torque[2], Config.IIConfig.MechanicalDevices.belt_torque_loss[2]);

        public final String category;
        public final int maxTorque;
        public final float torqueLoss;
        public final int length;
        public final int thickness;
        public final int width;
        public final IIMotorBeltType type;
        public final ResourceLocation res;
        @SideOnly(value=Side.CLIENT)
        public IModelMotorBelt model;

        private MotorBelt(String category, int length, int thickness, int width, int maxTorque, float torqueLoss) {
            this.category = category;
            this.length = length;
            this.thickness = thickness;
            this.maxTorque = maxTorque;
            this.torqueLoss = torqueLoss;
            this.width = width;
            this.res = MotorBelt.getResourceLocation(this.func_176610_l());
            this.type = new IIMotorBeltType(this);
        }

        public static String[] getNames() {
            return (String[])Arrays.stream(MotorBelt.values()).map(MotorBelt::func_176610_l).toArray(String[]::new);
        }

        private static ResourceLocation getResourceLocation(String name) {
            return new ResourceLocation("immersiveintelligence", "textures/rotary/belts/" + name);
        }

        @SideOnly(value=Side.CLIENT)
        public IModelMotorBelt getModel() {
            return this.model;
        }

        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.ENGLISH);
        }
    }
}

