/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.items.armor;

import blusunrize.immersiveengineering.api.tool.IElectricEquipment;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.IEItemFluidHandler;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.utils.IInfraredProtectionEquipment;
import pl.pabilo8.immersiveintelligence.client.model.armor.ModelLightEngineerArmor;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.IIPotions;
import pl.pabilo8.immersiveintelligence.common.items.armor.ItemIILightEngineerArmorBase;
import pl.pabilo8.immersiveintelligence.common.util.IIArmorItemStackHandler;

public class ItemIILightEngineerChestplate
extends ItemIILightEngineerArmorBase
implements IElectricEquipment,
IInfraredProtectionEquipment,
IEItemInterfaces.IAdvancedFluidItem {
    public ItemIILightEngineerChestplate() {
        super(EntityEquipmentSlot.CHEST, "LIGHT_ENGINEER_CHESTPLATE");
    }

    @Override
    public ICapabilityProvider initCapabilities(final ItemStack stack, NBTTagCompound nbt) {
        if (!stack.func_190926_b()) {
            return new IIArmorItemStackHandler(stack){
                final IEItemFluidHandler fluids;
                {
                    super(stack2);
                    this.fluids = new IEItemFluidHandler(stack, 0);
                }

                @Override
                public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                    return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY || super.hasCapability(capability, facing);
                }

                @Override
                public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                    if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
                        return (T)this.fluids;
                    }
                    return super.getCapability(capability, facing);
                }
            };
        }
        return null;
    }

    @Override
    public void finishUpgradeRecalculation(ItemStack stack) {
        FluidStack fs = this.getFluid(stack);
        if (fs != null && fs.amount > this.getCapacity(stack, 0)) {
            fs.amount = this.getCapacity(stack, 0);
            ItemNBTHelper.setFluidStack((ItemStack)stack, (String)"Fluid", (FluidStack)fs);
        }
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        FluidStack fs;
        IFluidHandlerItem fluidHandler;
        super.onArmorTick(world, player, stack);
        if (player.func_70086_ai() != 300 && this.hasUpgrade(stack, "scuba") && this.hasUpgrade(player.func_184582_a(EntityEquipmentSlot.HEAD), "gasmask") && (fluidHandler = FluidUtil.getFluidHandler((ItemStack)stack)) != null && world.func_82737_E() % 20L == 0L && (fs = fluidHandler.drain(Config.IIConfig.Weapons.LightEngineerArmor.scuba_tank_usage, true)) != null && fs.amount > 0) {
            player.func_70050_g((int)Math.min((float)(player.func_70086_ai() + 40), 300.0f * ((float)fs.amount / (float)Config.IIConfig.Weapons.LightEngineerArmor.scuba_tank_usage)));
        }
        if (this.getUpgrades(stack).func_74764_b("camo_mesh") && world.func_82737_E() % 10L == 0L) {
            Material material = world.func_180495_p(player.func_180425_c()).func_185904_a();
            if (player.func_70093_af() && (material == Material.field_151577_b || material == Material.field_151584_j || material == Material.field_151582_l)) {
                player.func_70690_d(new PotionEffect(IIPotions.concealed, 15, 0, false, false));
                player.func_70690_d(new PotionEffect(MobEffects.field_76441_p, 15, 0, true, false));
            }
        }
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        return ModelLightEngineerArmor.getModel(armorSlot, itemStack);
    }

    @Override
    String getMaterialName(ItemArmor.ArmorMaterial material) {
        return "light_engineer_armor";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, List<String> list, @Nonnull ITooltipFlag flag) {
        super.func_77624_a(stack, world, list, flag);
        if (this.hasUpgrade(stack, "scuba")) {
            int amount = this.getFluid(stack) == null ? 0 : this.getFluid((ItemStack)stack).amount;
            list.add(I18n.func_135052_a((String)"desc.immersiveengineering.flavour.drill.fuel", (Object[])new Object[0]) + " " + amount + "/" + this.getCapacity(stack, 0) + "mB");
        }
    }

    public float getXpRepairRatio(ItemStack stack) {
        return 0.1f;
    }

    @Override
    @Nonnull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@Nonnull EntityEquipmentSlot equipmentSlot, @Nonnull ItemStack stack) {
        Multimap<String, AttributeModifier> multimap = super.getAttributeModifiers(equipmentSlot, stack);
        if (equipmentSlot == this.field_77881_a) {
            // empty if block
        }
        return multimap;
    }

    public void onStrike(ItemStack s, EntityEquipmentSlot eqSlot, EntityLivingBase p, Map<String, Object> cache, @Nullable DamageSource dSource, IElectricEquipment.ElectricSource eSource) {
        if (!(dSource instanceof IEDamageSources.ElectricDamageSource)) {
            return;
        }
        if (!this.hasUpgrade(s, "anti_static_mesh")) {
            return;
        }
        IEDamageSources.ElectricDamageSource dmg = (IEDamageSources.ElectricDamageSource)dSource;
        dmg.dmg = this.hasUpgrade(s, "anti_static_mesh") && p.func_70090_H() ? dmg.dmg * Config.IIConfig.Weapons.LightEngineerArmor.anti_static_mesh_water_damage_mod : 0.0f;
    }

    @Override
    public int getSlotCount() {
        return 4;
    }

    @Override
    public boolean invisibleToInfrared(ItemStack stack) {
        return this.hasUpgrade(stack, "ir_mesh");
    }

    public int getCapacity(ItemStack stack, int baseCapacity) {
        return this.hasUpgrade(stack, "scuba") ? Config.IIConfig.Weapons.LightEngineerArmor.scuba_tank_capacity : 0;
    }

    public boolean allowFluid(ItemStack container, FluidStack fluid) {
        return fluid.getFluid() == IIContent.gasOxygen;
    }
}

