/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.items.ammunition;

import blusunrize.immersiveengineering.client.ClientUtils;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.bullets.BulletRegistry;
import pl.pabilo8.immersiveintelligence.client.fx.ParticleExplosion;
import pl.pabilo8.immersiveintelligence.client.fx.ParticleUtils;
import pl.pabilo8.immersiveintelligence.client.model.IBulletModel;
import pl.pabilo8.immersiveintelligence.client.model.bullet.ModelBullet6bCal;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.entity.bullets.EntityBullet;
import pl.pabilo8.immersiveintelligence.common.items.ammunition.ItemIIBulletBase;

public class ItemIIAmmoLightArtillery
extends ItemIIBulletBase {
    public ItemIIAmmoLightArtillery() {
        super("artillery_6bCal", 1);
    }

    @Override
    public float getComponentMultiplier() {
        return 0.65f;
    }

    @Override
    public int getGunpowderNeeded() {
        return 450;
    }

    @Override
    public int getCoreMaterialNeeded() {
        return 3;
    }

    @Override
    public float getInitialMass() {
        return 0.85f;
    }

    @Override
    public float getDefaultVelocity() {
        return Config.IIConfig.Bullets.lightHowiVelocity;
    }

    @Override
    public float getCaliber() {
        return 6.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public Class<? extends IBulletModel> getModel() {
        return ModelBullet6bCal.class;
    }

    @Override
    public float getDamage() {
        return 30.0f;
    }

    @Override
    public ItemStack getCasingStack(int amount) {
        return Utils.getStackWithMetaName(IIContent.itemAmmoCasing, "light_artillery_6bcal", amount);
    }

    @Override
    public BulletRegistry.EnumCoreTypes[] getAllowedCoreTypes() {
        return new BulletRegistry.EnumCoreTypes[]{BulletRegistry.EnumCoreTypes.PIERCING, BulletRegistry.EnumCoreTypes.SHAPED, BulletRegistry.EnumCoreTypes.CANISTER};
    }

    @Override
    public BulletRegistry.EnumFuseTypes[] getAllowedFuseTypes() {
        return new BulletRegistry.EnumFuseTypes[]{BulletRegistry.EnumFuseTypes.CONTACT, BulletRegistry.EnumFuseTypes.TIMED, BulletRegistry.EnumFuseTypes.PROXIMITY};
    }

    @Override
    public float getSupressionRadius() {
        return 3.0f;
    }

    @Override
    public int getSuppressionPower() {
        return 20;
    }

    @Override
    public boolean shouldLoadChunks() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void doPuff(EntityBullet bullet) {
        for (int i = 0; i < 20; ++i) {
            Vec3d v = bullet.getBaseMotion().func_178789_a(-90.0f).func_178785_b((float)i / 20.0f * 360.0f);
            ParticleExplosion particle = new ParticleExplosion((World)ClientUtils.mc().field_71441_e, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, v.field_72450_a * 0.125, v.field_72448_b * 0.0125, v.field_72449_c * 0.125, 3.25f);
            ParticleUtils.particleRenderer.addEffect(particle);
        }
    }
}

