/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.entity.hans.tasks.idle;

import javax.annotation.Nullable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.math.Vec3d;
import pl.pabilo8.immersiveintelligence.common.entity.EntityHans;
import pl.pabilo8.immersiveintelligence.common.entity.hans.HansAnimations;
import pl.pabilo8.immersiveintelligence.common.entity.hans.tasks.AIHansBase;

public class AIHansIdle
extends AIHansBase {
    private final int wanderDistance;
    private int wandersBeforeIdling;
    private static final HansAnimations.HansLegAnimation[] ANIMATIONS = new HansAnimations.HansLegAnimation[]{HansAnimations.HansLegAnimation.KNEELING, HansAnimations.HansLegAnimation.SQUATTING};
    private double lookX;
    private double lookZ;
    protected double x;
    protected double y;
    protected double z;
    private int idleTime;
    private int pastIdleTime;
    private int wanderCount = 0;
    private HansAnimations.HansLegAnimation currentAnimation;
    private boolean isWandering = true;
    private boolean positionValid = false;

    public AIHansIdle(EntityHans hans) {
        super(hans);
        this.func_75248_a(3);
        this.pastIdleTime = this.getIdleTime();
        this.wanderDistance = 3 + hans.func_70681_au().nextInt(2);
        this.reGenerateWanders();
    }

    @Override
    public void setRequiredAnimation() {
        if (this.func_75253_b() && this.currentAnimation != null) {
            this.hans.legAnimation = this.currentAnimation;
        }
    }

    public boolean func_75250_a() {
        if (this.hans.func_70638_az() == null) {
            this.pastIdleTime = Math.max(--this.pastIdleTime, 0);
        } else if (this.pastIdleTime != 0) {
            this.pastIdleTime = this.getIdleTime();
        }
        return this.pastIdleTime == 0 && this.hans.func_70638_az() == null && this.hans.func_70681_au().nextFloat() < 0.01f;
    }

    public boolean func_75253_b() {
        if (this.hans.func_184218_aH() || this.hans.func_70638_az() != null) {
            this.idleTime = 0;
            this.pastIdleTime = this.getIdleTime();
        }
        return this.idleTime >= 0 && this.hans.func_70638_az() == null;
    }

    public void func_75249_e() {
        this.isWandering = this.wanderCount < this.wandersBeforeIdling;
        this.idleTime = 200 + this.hans.func_70681_au().nextInt(120);
        if (!this.isWandering) {
            this.wanderCount = 0;
            this.reGenerateWanders();
            double d0 = Math.PI * 2 * this.hans.func_70681_au().nextDouble();
            this.lookX = Math.cos(d0);
            this.lookZ = Math.sin(d0);
            boolean inside = false;
            block0: for (int x = -1; x < 1; ++x) {
                for (int z = -1; z < 1; ++z) {
                    if (this.hans.field_70170_p.func_175623_d(this.hans.func_180425_c().func_177982_a(x, 0, z))) continue;
                    inside = true;
                    continue block0;
                }
            }
            if (inside) {
                this.currentAnimation = ANIMATIONS[this.hans.func_70681_au().nextInt(ANIMATIONS.length)];
            }
        } else {
            ++this.wanderCount;
            Vec3d vv = this.getWanderPosition();
            if (vv != null) {
                this.x = vv.field_72450_a;
                this.y = vv.field_72448_b;
                this.z = vv.field_72449_c;
                this.positionValid = true;
            } else {
                this.positionValid = false;
            }
        }
    }

    public void func_75246_d() {
        if (this.isWandering) {
            if (this.positionValid) {
                this.hans.getNavigator().func_75492_a(this.x, this.y, this.z, 1.0);
            }
        } else {
            this.hans.func_70671_ap().func_75650_a(this.hans.field_70165_t + this.lookX, this.hans.field_70163_u + (double)this.hans.func_70047_e(), this.hans.field_70161_v + this.lookZ, (float)this.hans.func_184649_cE(), (float)this.hans.func_70646_bf());
        }
        --this.idleTime;
        if (this.pastIdleTime == 0) {
            this.pastIdleTime = this.getIdleTime();
        }
    }

    public int getIdleTime() {
        return this.isWandering ? 150 : 200 + this.hans.func_70681_au().nextInt(this.isWandering ? 50 : 100);
    }

    @Nullable
    protected Vec3d getWanderPosition() {
        if (this.hans.func_70090_H()) {
            Vec3d vec3d = RandomPositionGenerator.func_191377_b((EntityCreature)this.hans, (int)this.wanderDistance, (int)7);
            return vec3d == null ? RandomPositionGenerator.func_191377_b((EntityCreature)this.hans, (int)this.wanderDistance, (int)15) : vec3d;
        }
        return RandomPositionGenerator.func_191377_b((EntityCreature)this.hans, (int)this.wanderDistance, (int)15);
    }

    private void reGenerateWanders() {
        this.wandersBeforeIdling = 2 + this.hans.func_70681_au().nextInt(3);
    }
}

