/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.entity.hans.tasks.hand_weapon;

import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.entity.EntityHans;
import pl.pabilo8.immersiveintelligence.common.entity.hans.HansAnimations;
import pl.pabilo8.immersiveintelligence.common.entity.hans.tasks.hand_weapon.AIHansHandWeapon;
import pl.pabilo8.immersiveintelligence.common.items.weapons.ItemIIRailgunOverride;

public class AIHansRailgun
extends AIHansHandWeapon {
    boolean sniper = false;
    protected final int holdFireTime;

    public AIHansRailgun(EntityHans hans) {
        super(hans, 5.0f, 64.0f, 0.9f);
        this.func_75248_a(3);
        this.holdFireTime = 40;
    }

    @Override
    protected boolean hasAnyAmmo() {
        this.hans.hasAmmo = !ItemIIRailgunOverride.findAmmo((EntityLivingBase)this.hans).func_190926_b();
        return this.hans.hasAmmo;
    }

    @Override
    protected boolean isValidWeapon() {
        return this.getWeapon().func_77973_b() == IEContent.itemRailgun;
    }

    @Override
    public void executeTask() {
        assert (this.attackTarget != null);
        if (this.motionState == AIHansHandWeapon.MotionState.FALLBACK || this.motionState == AIHansHandWeapon.MotionState.COME_TOWARDS) {
            return;
        }
        this.lookOnTarget();
        ItemStack backpack = this.hans.func_184582_a(EntityEquipmentSlot.CHEST);
        ItemStack railgun = this.getWeapon();
        if (EnergyHelper.isFluxItem((ItemStack)backpack) && EnergyHelper.isFluxItem((ItemStack)railgun)) {
            EnergyHelper.insertFlux((ItemStack)railgun, (int)99999, (boolean)false);
        }
        if (this.rangedAttackTime < 0) {
            this.hans.func_184602_cy();
            ++this.rangedAttackTime;
        }
        if (this.rangedAttackTime < this.holdFireTime) {
            this.hans.func_184598_c(EnumHand.MAIN_HAND);
            if (railgun.func_77973_b() instanceof ItemIIRailgunOverride) {
                ItemStack ammo = ItemIIRailgunOverride.findAmmo((EntityLivingBase)this.hans);
                if (ItemIIRailgunOverride.isAmmo(ammo)) {
                    this.hans.hasAmmo = true;
                    this.hans.func_70625_a((Entity)this.attackTarget, 30.0f, 0.0f);
                    IEContent.itemRailgun.onUsingTick(railgun, (EntityLivingBase)this.hans, this.rangedAttackTime++);
                }
                this.hans.field_70125_A = this.calculateBallisticAngle(ammo, this.attackTarget);
                this.sniper = ((ItemIIRailgunOverride)railgun.func_77973_b()).getUpgrades(railgun).func_74767_n("scope");
                if (this.rangedAttackTime >= this.holdFireTime) {
                    IEContent.itemRailgun.func_77615_a(railgun, this.hans.field_70170_p, (EntityLivingBase)this.hans, IEContent.itemRailgun.func_77626_a(railgun) - this.rangedAttackTime);
                    this.rangedAttackTime = -10;
                }
            }
        }
    }

    @Override
    protected float calculateBallisticAngle(ItemStack ammo, EntityLivingBase attackTarget) {
        if (ammo.func_77973_b() == IIContent.itemRailgunGrenade) {
            return Utils.getDirectFireAngle(IIContent.itemRailgunGrenade.getDefaultVelocity(), IIContent.itemRailgunGrenade.getMass(ammo), this.hans.func_174791_d().func_72441_c(0.0, (double)this.hans.func_70047_e() - (double)0.1f, 0.0).func_178788_d(Utils.getEntityCenter((Entity)attackTarget)));
        }
        return Utils.getIEDirectRailgunAngle(ammo, this.hans.func_174791_d().func_72441_c(0.0, (double)this.hans.func_70047_e(), 0.0).func_178788_d(Utils.getEntityCenter((Entity)attackTarget)));
    }

    @Override
    public void setRequiredAnimation() {
        if (this.motionState == AIHansHandWeapon.MotionState.IN_POSITION || this.motionState == AIHansHandWeapon.MotionState.SET_UP) {
            if (this.attackTarget != null && this.canFire) {
                this.hans.legAnimation = this.sniper && !this.hans.enemyContact ? HansAnimations.HansLegAnimation.LYING : HansAnimations.HansLegAnimation.KNEELING;
            }
        } else {
            this.hans.legAnimation = HansAnimations.HansLegAnimation.STANDING;
        }
    }
}

