/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.entity.hans.tasks.hand_weapon;

import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.entities.EntityChemthrowerShot;
import blusunrize.immersiveengineering.common.items.ItemChemthrower;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import pl.pabilo8.immersiveintelligence.common.entity.EntityHans;
import pl.pabilo8.immersiveintelligence.common.entity.hans.tasks.hand_weapon.AIHansHandWeapon;

public class AIHansChemthrower
extends AIHansHandWeapon {
    private final int burstTime;
    private static final ItemChemthrower CHEM = (ItemChemthrower)IEContent.itemChemthrower;

    public AIHansChemthrower(EntityHans hans) {
        super(hans, 10.0f, 4.0f, 0.9f);
        this.burstTime = 20;
    }

    @Override
    protected boolean isValidWeapon() {
        return this.getWeapon().func_77973_b() instanceof ItemChemthrower;
    }

    @Override
    protected boolean hasAnyAmmo() {
        ItemStack chemthrower = this.getWeapon();
        if (chemthrower.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            IFluidHandlerItem capability = (IFluidHandlerItem)chemthrower.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            if (capability == null) {
                return false;
            }
            FluidStack drain = capability.drain(Config.IEConfig.Tools.chemthrower_consumption, false);
            return drain != null && drain.amount == Config.IEConfig.Tools.chemthrower_consumption;
        }
        return false;
    }

    @Override
    protected void executeTask() {
        assert (this.attackTarget != null);
        ItemStack chemthrower = this.getWeapon();
        this.lookOnTarget();
        if (this.rangedAttackTime < 0) {
            this.hans.func_184602_cy();
            ++this.rangedAttackTime;
        }
        if (this.rangedAttackTime < this.burstTime) {
            this.hans.hasAmmo = true;
            this.lookOnTarget();
            this.hans.field_70125_A -= 25.0f;
            ItemNBTHelper.setBoolean((ItemStack)chemthrower, (String)"ignite", (boolean)true);
            this.onUsingTick(chemthrower, (EntityLivingBase)this.hans, IEContent.itemChemthrower.func_77626_a(chemthrower) - this.rangedAttackTime);
            this.hans.field_70125_A += 25.0f;
            if (this.rangedAttackTime >= this.burstTime) {
                CHEM.func_77615_a(chemthrower, this.hans.field_70170_p, (EntityLivingBase)this.hans, CHEM.func_77626_a(chemthrower) - this.rangedAttackTime);
                this.rangedAttackTime = -10;
            }
        }
    }

    @Override
    protected float calculateBallisticAngle(ItemStack ammo, EntityLivingBase attackTarget) {
        return 0.0f;
    }

    @Override
    public void setRequiredAnimation() {
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase living, int count) {
        FluidStack fs = CHEM.getFluid(stack);
        if (fs != null && fs.getFluid() != null) {
            int consumed = Config.IEConfig.Tools.chemthrower_consumption;
            int duration = CHEM.func_77626_a(stack) - count;
            if (consumed * duration <= fs.amount) {
                float range;
                Vec3d v = living.func_70040_Z();
                int split = 8;
                boolean isGas = fs.getFluid().isGaseous() || ChemthrowerHandler.isGas((Fluid)fs.getFluid());
                float scatter = isGas ? 0.15f : 0.05f;
                float f = range = isGas ? 0.5f : 1.0f;
                if (CHEM.getUpgrades(stack).func_74767_n("focus")) {
                    range += 0.25f;
                    scatter -= 0.025f;
                }
                Vec3d look = living.func_174824_e(0.0f).func_178787_e(living.func_70040_Z());
                boolean ignite = ChemthrowerHandler.isFlammable((Fluid)fs.getFluid()) && ItemNBTHelper.getBoolean((ItemStack)stack, (String)"ignite");
                for (int i = 0; i < split; ++i) {
                    Vec3d vecDir = v.func_72441_c(living.func_70681_au().nextGaussian() * (double)scatter, living.func_70681_au().nextGaussian() * (double)scatter, living.func_70681_au().nextGaussian() * (double)scatter);
                    EntityChemthrowerShot chem = new EntityChemthrowerShot(living.field_70170_p, look.field_72450_a, look.field_72448_b, look.field_72449_c, vecDir.field_72450_a * 0.25, vecDir.field_72448_b * 0.25, vecDir.field_72449_c * 0.25, fs);
                    chem.field_70159_w = living.field_70159_w + vecDir.field_72450_a * (double)range;
                    chem.field_70181_x = living.field_70181_x + vecDir.field_72448_b * (double)range;
                    chem.field_70179_y = living.field_70179_y + vecDir.field_72449_c * (double)range;
                    if (!living.field_70122_E) {
                        living.field_70159_w -= vecDir.field_72450_a * 0.0025 * (double)range;
                        living.field_70181_x -= vecDir.field_72448_b * 0.0025 * (double)range;
                        living.field_70179_y -= vecDir.field_72449_c * 0.0025 * (double)range;
                    }
                    if (ignite) {
                        chem.func_70015_d(10);
                    }
                    if (living.field_70170_p.field_72995_K) continue;
                    living.field_70170_p.func_72838_d((Entity)chem);
                }
                if (count % 4 == 0) {
                    if (ignite) {
                        living.field_70170_p.func_184148_a(null, living.field_70165_t, living.field_70163_u, living.field_70161_v, IESounds.sprayFire, SoundCategory.PLAYERS, 0.5f, 1.5f);
                    } else {
                        living.field_70170_p.func_184148_a(null, living.field_70165_t, living.field_70163_u, living.field_70161_v, IESounds.spray, SoundCategory.PLAYERS, 0.5f, 0.75f);
                    }
                }
            } else {
                living.func_184597_cx();
            }
        } else {
            living.func_184597_cx();
        }
    }
}

