/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.entity.hans.tasks;

import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.util.math.Vec3d;
import pl.pabilo8.immersiveintelligence.common.entity.EntityHans;
import pl.pabilo8.immersiveintelligence.common.entity.hans.tasks.AIHansBase;

public class AIHansAvoidArrows
extends AIHansBase {
    private Vec3d arrowUVec;
    private int giveUpDelay;
    private int dodgeDelay;
    private final float dodgeChance;

    protected AIHansAvoidArrows(EntityHans hans) {
        super(hans);
        this.dodgeChance = 0.5f;
        this.func_75248_a(4);
    }

    public static void doDodgeCheckForArrow(Entity arrow) {
        float width = arrow.field_70130_N + 0.3f;
        double vH = Math.sqrt(arrow.field_70159_w * arrow.field_70159_w + arrow.field_70179_y * arrow.field_70179_y);
        double uX = arrow.field_70159_w / vH;
        double uZ = arrow.field_70179_y / vH;
        for (int i = 0; i < arrow.field_70170_p.field_72996_f.size(); ++i) {
            double cos;
            double sin;
            double dZ;
            double dX;
            double dH;
            Entity entity = (Entity)arrow.field_70170_p.field_72996_f.get(i);
            if (!(entity instanceof EntityHans)) continue;
            int dY = (int)entity.field_70163_u - (int)arrow.field_70163_u;
            if (dY < 0) {
                dY = -dY;
            }
            if (dY > 16 || !((dH = Math.sqrt((dX = entity.field_70165_t - arrow.field_70165_t) * dX + (dZ = entity.field_70161_v - arrow.field_70161_v) * dZ)) < 24.0) || !((double)width > dH * (sin = Math.sqrt(1.0 - (cos = (uX * dX + uZ * dZ) / dH) * cos)))) continue;
            AIHansAvoidArrows.tryDodgeArrow((EntityHans)entity, uX, uZ);
        }
    }

    private static void tryDodgeArrow(EntityHans entity, double uX, double uZ) {
        for (EntityAITasks.EntityAITaskEntry entry : entity.field_70714_bg.field_75782_a.toArray(new EntityAITasks.EntityAITaskEntry[0])) {
            if (!(entry.field_75733_a instanceof AIHansAvoidArrows)) continue;
            ((AIHansAvoidArrows)entry.field_75733_a).setDodgeTarget(new Vec3d(uX, 0.0, uZ));
        }
    }

    private void setDodgeTarget(Vec3d motionU) {
        if (motionU == null) {
            this.arrowUVec = null;
            this.giveUpDelay = 0;
        } else if (this.dodgeDelay <= 0 && this.hans.func_70681_au().nextFloat() < this.dodgeChance) {
            this.arrowUVec = motionU;
            this.giveUpDelay = 10;
        }
    }

    public boolean func_75250_a() {
        return this.dodgeDelay-- <= 0 && this.arrowUVec != null && this.giveUpDelay-- > 0 && this.hans.field_70122_E && !this.hans.func_184218_aH();
    }

    public void func_75249_e() {
        if (this.arrowUVec != null) {
            Vec3d selfUVec = new Vec3d(0.0, 1.0, 0.0);
            Vec3d dodgeUVec = selfUVec.func_72431_c(this.arrowUVec);
            double scale = 0.8;
            if (this.hans.func_70681_au().nextBoolean()) {
                scale = -scale;
            }
            this.hans.field_70159_w = dodgeUVec.field_72450_a * scale;
            this.hans.field_70179_y = dodgeUVec.field_72449_c * scale;
            this.hans.field_70181_x = 0.4;
            this.setDodgeTarget(null);
            this.dodgeDelay = 40;
        }
    }

    public boolean func_75253_b() {
        return false;
    }

    @Override
    public void setRequiredAnimation() {
    }
}

