/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.entity.hans;

import blusunrize.immersiveengineering.common.blocks.metal.TileEntityRazorWire;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockLilyPad;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import pl.pabilo8.immersiveintelligence.common.blocks.multiblocks.gate.TileEntityGateBase;
import pl.pabilo8.immersiveintelligence.common.entity.hans.HansUtils;

public class HansWalkNodeProcessor
extends WalkNodeProcessor {
    private boolean canBreakBlocks = false;
    private boolean breakableFlag = false;

    private PathNodeType getPathNodeType(EntityLiving entitylivingIn, int x, int y, int z) {
        this.breakableFlag = false;
        return this.func_186319_a(this.field_176169_a, x, y, z, entitylivingIn, this.field_176168_c, this.field_176165_d, this.field_176166_e, this.func_186324_d(), this.func_186323_c());
    }

    public PathPoint func_186318_b() {
        BlockPos.MutableBlockPos pos;
        int y;
        AxisAlignedBB bounds = this.field_186326_b.func_174813_aQ();
        if (this.func_186322_e() && this.field_186326_b.func_70090_H()) {
            y = (int)bounds.field_72338_b;
            pos = new BlockPos.MutableBlockPos(MathHelper.func_76128_c((double)this.field_186326_b.field_70165_t), y, MathHelper.func_76128_c((double)this.field_186326_b.field_70161_v));
            IBlockState state = this.field_176169_a.func_180495_p((BlockPos)pos);
            while (state.func_185904_a().func_76224_d()) {
                pos.func_185336_p(++y);
                state = this.field_176169_a.func_180495_p((BlockPos)pos);
            }
        } else if (this.field_186326_b.field_70122_E) {
            y = MathHelper.func_76128_c((double)(bounds.field_72338_b + 0.5));
        } else {
            y = MathHelper.func_76128_c((double)this.field_186326_b.field_70163_u);
            pos = new BlockPos.MutableBlockPos(MathHelper.func_76128_c((double)this.field_186326_b.field_70165_t), y, MathHelper.func_76128_c((double)this.field_186326_b.field_70161_v));
            while (y > 0 && (this.field_176169_a.func_180495_p((BlockPos)pos).func_185904_a() == Material.field_151579_a || this.field_176169_a.func_180495_p((BlockPos)pos).func_177230_c().func_176205_b(this.field_176169_a, (BlockPos)pos))) {
                pos.func_185336_p(y--);
            }
            ++y;
        }
        float r = this.field_186326_b.field_70130_N * 0.5f;
        int x = MathHelper.func_76128_c((double)(this.field_186326_b.field_70165_t - (double)r));
        int z = MathHelper.func_76128_c((double)(this.field_186326_b.field_70161_v - (double)r));
        if (this.field_186326_b.func_184643_a(this.getPathNodeType(this.field_186326_b, x, y, z)) < 0.0f) {
            HashSet<BlockPos> diagonals = new HashSet<BlockPos>();
            diagonals.add(new BlockPos(bounds.field_72340_a - (double)r, (double)y, bounds.field_72339_c - (double)r));
            diagonals.add(new BlockPos(bounds.field_72340_a - (double)r, (double)y, bounds.field_72334_f - (double)r));
            diagonals.add(new BlockPos(bounds.field_72336_d - (double)r, (double)y, bounds.field_72339_c - (double)r));
            diagonals.add(new BlockPos(bounds.field_72336_d - (double)r, (double)y, bounds.field_72334_f - (double)r));
            for (BlockPos p : diagonals) {
                PathNodeType pathnodetype = this.getPathNodeType(this.field_186326_b, p.func_177958_n(), p.func_177956_o(), p.func_177952_p());
                if (!(this.field_186326_b.func_184643_a(pathnodetype) >= 0.0f)) continue;
                return this.func_176159_a(p.func_177958_n(), p.func_177956_o(), p.func_177952_p());
            }
        }
        return this.func_176159_a(x, y, z);
    }

    public int func_186320_a(@Nonnull PathPoint[] pathOptions, PathPoint currentPoint, @Nonnull PathPoint targetPoint, float maxDistance) {
        AxisAlignedBB aabb1;
        double d1;
        boolean westPassable;
        int optionCount = 0;
        int step = 0;
        PathNodeType pathnodetype = this.getPathNodeType(this.field_186326_b, currentPoint.field_75839_a, currentPoint.field_75837_b + 1, currentPoint.field_75838_c);
        if (this.field_186326_b.func_184643_a(pathnodetype) >= 0.0f) {
            step = MathHelper.func_76141_d((float)Math.max(1.0f, this.field_186326_b.field_70138_W));
        }
        BlockPos pos = new BlockPos(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c).func_177977_b();
        double floor = (double)currentPoint.field_75837_b - (1.0 - this.field_176169_a.func_180495_p((BlockPos)pos).func_185900_c((IBlockAccess)this.field_176169_a, (BlockPos)pos).field_72337_e);
        PathPoint south = this.getSafePoint(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, step, floor, EnumFacing.SOUTH);
        PathPoint west = this.getSafePoint(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c, step, floor, EnumFacing.WEST);
        PathPoint east = this.getSafePoint(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c, step, floor, EnumFacing.EAST);
        PathPoint north = this.getSafePoint(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, step, floor, EnumFacing.NORTH);
        PathPoint ladderUp = this.func_176159_a(currentPoint.field_75839_a, currentPoint.field_75837_b + 1, currentPoint.field_75838_c);
        PathPoint ladderDown = this.func_176159_a(currentPoint.field_75839_a, currentPoint.field_75837_b - 1, currentPoint.field_75838_c);
        if (south != null && !south.field_75842_i && south.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[optionCount++] = south;
        }
        if (west != null && !west.field_75842_i && west.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[optionCount++] = west;
        }
        if (east != null && !east.field_75842_i && east.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[optionCount++] = east;
        }
        if (north != null && !north.field_75842_i && north.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[optionCount++] = north;
        }
        IBlockState ladderCheck = this.field_176169_a.func_180495_p(new BlockPos(currentPoint.field_75839_a, currentPoint.field_75837_b + 1, currentPoint.field_75838_c));
        if (!ladderUp.field_75842_i && ladderUp.func_75829_a(targetPoint) < maxDistance && ladderCheck.func_177230_c().isLadder(ladderCheck, this.field_176169_a, new BlockPos(currentPoint.field_75839_a, currentPoint.field_75837_b + 1, currentPoint.field_75838_c), (EntityLivingBase)this.field_186326_b)) {
            pathOptions[optionCount++] = ladderUp;
        }
        IBlockState ladderCheckDown = this.field_176169_a.func_180495_p(new BlockPos(currentPoint.field_75839_a, currentPoint.field_75837_b - 1, currentPoint.field_75838_c));
        if (!ladderDown.field_75842_i && ladderDown.func_75829_a(targetPoint) < maxDistance && ladderCheckDown.func_177230_c().isLadder(ladderCheckDown, this.field_176169_a, new BlockPos(currentPoint.field_75839_a, currentPoint.field_75837_b - 1, currentPoint.field_75838_c), (EntityLivingBase)this.field_186326_b)) {
            pathOptions[optionCount++] = ladderDown;
        }
        boolean northPassable = north == null || north.field_186287_m == PathNodeType.OPEN || north.field_186286_l != 0.0f;
        boolean southPassable = south == null || south.field_186287_m == PathNodeType.OPEN || south.field_186286_l != 0.0f;
        boolean eastPassable = east == null || east.field_186287_m == PathNodeType.OPEN || east.field_186286_l != 0.0f;
        boolean bl = westPassable = west == null || west.field_186287_m == PathNodeType.OPEN || west.field_186286_l != 0.0f;
        if (northPassable && westPassable) {
            PathPoint northWestPassable = this.getSafePoint(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, step, floor, EnumFacing.NORTH);
            d1 = (double)this.field_186326_b.field_70130_N / 2.0;
            aabb1 = new AxisAlignedBB((double)currentPoint.field_75839_a - 0.5 - d1 + 0.5, (double)currentPoint.field_75837_b + 1.001, (double)currentPoint.field_75838_c - 0.5 - d1 + 0.5, (double)currentPoint.field_75839_a - 0.5 + d1 + 0.5, (double)((float)currentPoint.field_75837_b + 1.0f + this.field_186326_b.field_70131_O), (double)currentPoint.field_75838_c - 0.5 + d1 + 0.5);
            if (!this.field_186326_b.field_70170_p.func_184143_b(aabb1) && northWestPassable != null && !northWestPassable.field_75842_i && northWestPassable.func_75829_a(targetPoint) < maxDistance) {
                pathOptions[optionCount++] = northWestPassable;
            }
        }
        if (northPassable && eastPassable) {
            PathPoint northEastPassable = this.getSafePoint(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, step, floor, EnumFacing.NORTH);
            d1 = (double)this.field_186326_b.field_70130_N / 2.0;
            aabb1 = new AxisAlignedBB((double)currentPoint.field_75839_a + 0.5 - d1 + 0.5, (double)currentPoint.field_75837_b + 1.001, (double)currentPoint.field_75838_c - 0.5 - d1 + 0.5, (double)currentPoint.field_75839_a + 0.5 + d1 + 0.5, (double)((float)currentPoint.field_75837_b + 1.0f + this.field_186326_b.field_70131_O), (double)currentPoint.field_75838_c - 0.5 + d1 + 0.5);
            if (!this.field_186326_b.field_70170_p.func_184143_b(aabb1) && northEastPassable != null && !northEastPassable.field_75842_i && northEastPassable.func_75829_a(targetPoint) < maxDistance) {
                pathOptions[optionCount++] = northEastPassable;
            }
        }
        if (southPassable && westPassable) {
            PathPoint southWestPassable = this.getSafePoint(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, step, floor, EnumFacing.SOUTH);
            d1 = (double)this.field_186326_b.field_70130_N / 2.0;
            aabb1 = new AxisAlignedBB((double)currentPoint.field_75839_a - 0.5 - d1 + 0.5, (double)currentPoint.field_75837_b + 1.001, (double)currentPoint.field_75838_c + 0.5 - d1 + 0.5, (double)currentPoint.field_75839_a - 0.5 + d1 + 0.5, (double)((float)currentPoint.field_75837_b + 1.0f + this.field_186326_b.field_70131_O), (double)currentPoint.field_75838_c + 0.5 + d1 + 0.5);
            if (!this.field_186326_b.field_70170_p.func_184143_b(aabb1) && southWestPassable != null && !southWestPassable.field_75842_i && southWestPassable.func_75829_a(targetPoint) < maxDistance) {
                pathOptions[optionCount++] = southWestPassable;
            }
        }
        if (southPassable && eastPassable) {
            PathPoint southEastPassable = this.getSafePoint(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, step, floor, EnumFacing.SOUTH);
            d1 = (double)this.field_186326_b.field_70130_N / 2.0;
            aabb1 = new AxisAlignedBB((double)currentPoint.field_75839_a + 0.5 - d1 + 0.5, (double)currentPoint.field_75837_b + 1.001, (double)currentPoint.field_75838_c + 0.5 - d1 + 0.5, (double)currentPoint.field_75839_a + 0.5 + d1 + 0.5, (double)((float)currentPoint.field_75837_b + 1.0f + this.field_186326_b.field_70131_O), (double)currentPoint.field_75838_c + 0.5 + d1 + 0.5);
            if (!this.field_186326_b.field_70170_p.func_184143_b(aabb1) && southEastPassable != null && !southEastPassable.field_75842_i && southEastPassable.func_75829_a(targetPoint) < maxDistance) {
                pathOptions[optionCount++] = southEastPassable;
            }
        }
        return optionCount;
    }

    @Nullable
    private PathPoint getSafePoint(int x, int y, int z, int p_186332_4_, double p_186332_5_, EnumFacing facing) {
        PathPoint point = null;
        BlockPos pos = new BlockPos(x, y, z);
        BlockPos below = pos.func_177977_b();
        double d0 = (double)y - (1.0 - this.field_176169_a.func_180495_p((BlockPos)below).func_185900_c((IBlockAccess)this.field_176169_a, (BlockPos)below).field_72337_e);
        if (d0 - p_186332_5_ > 1.125) {
            return null;
        }
        this.breakableFlag = false;
        PathNodeType type = this.getPathNodeType(this.field_186326_b, x, y, z);
        float priority = this.field_186326_b.func_184643_a(type);
        double width = (double)this.field_186326_b.field_70130_N / 2.0;
        if (priority >= 0.0f) {
            point = this.func_176159_a(x, y, z);
            point.field_186287_m = type;
            point.field_186286_l = Math.max(point.field_186286_l, priority);
            if (this.breakableFlag) {
                point.field_186286_l += 1.0f;
            }
        }
        if (type != PathNodeType.WALKABLE) {
            if (point == null && p_186332_4_ > 0 && type != PathNodeType.FENCE && type != PathNodeType.TRAPDOOR && (point = this.getSafePoint(x, y + 1, z, p_186332_4_ - 1, p_186332_5_, facing)) != null && (point.field_186287_m == PathNodeType.OPEN || point.field_186287_m == PathNodeType.WALKABLE) && this.field_186326_b.field_70130_N < 1.0f) {
                double d2 = (double)(x - facing.func_82601_c()) + 0.5;
                double d3 = (double)(z - facing.func_82599_e()) + 0.5;
                AxisAlignedBB axisalignedbb = new AxisAlignedBB(d2 - width, (double)y + 0.001, d3 - width, d2 + width, (double)((float)y + this.field_186326_b.field_70131_O), d3 + width);
                AxisAlignedBB axisalignedbb1 = this.field_176169_a.func_180495_p(pos).func_185900_c(this.field_176169_a, pos);
                AxisAlignedBB axisalignedbb2 = axisalignedbb.func_72321_a(0.0, axisalignedbb1.field_72337_e - 0.002, 0.0);
                if (this.field_186326_b.field_70170_p.func_184143_b(axisalignedbb2)) {
                    point = null;
                }
            }
            if (type == PathNodeType.OPEN) {
                PathNodeType pathnodetype1;
                AxisAlignedBB axisalignedbb3 = new AxisAlignedBB((double)x - width + 0.5, (double)y + 0.001, (double)z - width + 0.5, (double)x + width + 0.5, (double)((float)y + this.field_186326_b.field_70131_O), (double)z + width + 0.5);
                if (this.field_186326_b.field_70170_p.func_184143_b(axisalignedbb3)) {
                    return null;
                }
                if (this.field_186326_b.field_70130_N >= 1.0f && (pathnodetype1 = this.getPathNodeType(this.field_186326_b, x, y - 1, z)) == PathNodeType.BLOCKED) {
                    point = this.func_176159_a(x, y, z);
                    point.field_186287_m = PathNodeType.WALKABLE;
                    point.field_186286_l = Math.max(point.field_186286_l, priority);
                    if (this.breakableFlag) {
                        point.field_186286_l += 1.0f;
                    }
                    return point;
                }
                int i = 0;
                while (y > 0 && type == PathNodeType.OPEN) {
                    --y;
                    if (i++ >= this.field_186326_b.func_82143_as()) {
                        return null;
                    }
                    type = this.getPathNodeType(this.field_186326_b, x, y, z);
                    priority = this.field_186326_b.func_184643_a(type);
                    if (type != PathNodeType.OPEN && priority >= 0.0f) {
                        point = this.func_176159_a(x, y, z);
                        point.field_186287_m = type;
                        point.field_186286_l = Math.max(point.field_186286_l, priority);
                        if (!this.breakableFlag) break;
                        point.field_186286_l += 1.0f;
                        break;
                    }
                    if (!(priority < 0.0f)) continue;
                    return null;
                }
            }
        }
        return point;
    }

    @Nonnull
    protected PathNodeType func_189553_b(IBlockAccess acc, int x, int y, int z) {
        BlockPos blockpos = new BlockPos(x, y, z);
        IBlockState iblockstate = acc.func_180495_p(blockpos);
        Block block = iblockstate.func_177230_c();
        if (this.field_186326_b != null && block.isLadder(iblockstate, acc, blockpos, (EntityLivingBase)this.field_186326_b)) {
            return PathNodeType.WALKABLE;
        }
        return this.defaultNode(acc, iblockstate, blockpos, block);
    }

    protected PathNodeType defaultNode(IBlockAccess world, IBlockState state, BlockPos pos, Block block) {
        Material material = state.func_185904_a();
        PathNodeType type = block.getAiPathNodeType(state, world, pos, this.field_186326_b);
        if (type != null) {
            return type;
        }
        if (material == Material.field_151579_a || state.func_185890_d(world, pos) == Block.field_185506_k) {
            return PathNodeType.OPEN;
        }
        TileEntity te = world.func_175625_s(pos);
        if (block instanceof BlockDoor) {
            return HansUtils.getDoorNode(state);
        }
        if (te instanceof TileEntityGateBase) {
            return HansUtils.getGateNode((TileEntityGateBase)te);
        }
        if (block instanceof BlockFenceGate) {
            return HansUtils.getFenceGateNode(state);
        }
        if (block instanceof BlockTrapDoor || block instanceof BlockLilyPad) {
            return PathNodeType.TRAPDOOR;
        }
        if (te instanceof TileEntityRazorWire) {
            return PathNodeType.DANGER_OTHER;
        }
        if (block instanceof BlockFire) {
            return PathNodeType.DAMAGE_FIRE;
        }
        if (block instanceof BlockCactus) {
            return PathNodeType.DAMAGE_CACTUS;
        }
        if (block instanceof BlockRailBase) {
            return PathNodeType.RAIL;
        }
        if (this.isFence(world, state, pos, block)) {
            return PathNodeType.FENCE;
        }
        if (material == Material.field_151586_h) {
            return PathNodeType.WATER;
        }
        if (material == Material.field_151587_i) {
            return PathNodeType.LAVA;
        }
        return block.func_176205_b(world, pos) ? PathNodeType.OPEN : PathNodeType.BLOCKED;
    }

    public boolean canBreakBlocks() {
        return this.canBreakBlocks;
    }

    public void setBreakBlocks(boolean flag) {
        this.canBreakBlocks = flag;
    }

    private boolean isFence(IBlockAccess acc, IBlockState iblockstate, BlockPos blockpos, Block block) {
        if (block instanceof BlockFence || block instanceof BlockWall) {
            return true;
        }
        if (this.field_186326_b != null) {
            AxisAlignedBB collision2 = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_186670_a(blockpos.func_177984_a());
            ArrayList list = Lists.newArrayList();
            iblockstate.func_185908_a(this.field_186326_b.field_70170_p, blockpos, collision2, (List)list, null, false);
            return !list.isEmpty();
        }
        return false;
    }
}

