/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.entity.bullets;

import blusunrize.immersiveengineering.common.util.FakePlayerUtil;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.bullets.IBulletComponent;
import pl.pabilo8.immersiveintelligence.common.entity.bullets.EntityBullet;
import pl.pabilo8.immersiveintelligence.common.entity.bullets.EntityNavalMineAnchor;
import pl.pabilo8.immersiveintelligence.common.network.IIPacketHandler;
import pl.pabilo8.immersiveintelligence.common.network.MessageEntityNBTSync;

public class EntityNavalMine
extends EntityBullet {
    public int maxLength = 5;
    boolean isNotRiding = false;
    private static final DataParameter<Integer> dataMarkerMaxLength = EntityDataManager.func_187226_a(EntityNavalMine.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityNavalMine(World worldIn) {
        super(worldIn);
    }

    public void func_70103_a(byte id) {
        super.func_70103_a(id);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(dataMarkerMaxLength, (Object)0);
    }

    @Override
    protected void fromStack(ItemStack stack) {
        super.fromStack(stack);
        this.maxLength = ItemNBTHelper.hasKey((ItemStack)stack, (String)"length") ? ItemNBTHelper.getInt((ItemStack)stack, (String)"length") : 5;
    }

    public EntityNavalMine(World worldIn, ItemStack stack, double x, double y, double z) {
        super(worldIn);
        this.fromStack(stack);
        this.func_70107_b(x, y, z);
        this.force = 0.0f;
        this.initialForce = 0.0f;
    }

    @Override
    public void func_70071_h_() {
        this.onUpdateSuper();
        if (this.field_70171_ac) {
            this.isNotRiding = true;
            if (this.func_184187_bx() instanceof EntityNavalMineAnchor) {
                this.func_184187_bx().field_70145_X = true;
            }
            this.func_70091_d(MoverType.SELF, 0.0, 0.0125f, 0.0);
            if (this.func_184187_bx() instanceof EntityNavalMineAnchor) {
                this.func_184187_bx().field_70145_X = false;
            }
            this.isNotRiding = false;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_186662_g((double)0.35f), input -> !(input instanceof EntityNavalMineAnchor) && !(input instanceof EntityNavalMine)).forEach(this::func_70108_f);
        } else if (this.field_70180_af.func_187223_a()) {
            this.maxLength = (Integer)this.field_70180_af.func_187225_a(dataMarkerMaxLength);
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
            if (this.shooter == null) {
                this.shooter = FakePlayerUtil.getFakePlayer((World)this.field_70170_p);
            }
            NBTTagCompound nbt = new NBTTagCompound();
            this.func_70014_b(nbt);
            IIPacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageEntityNBTSync(this, nbt), Utils.targetPointFromEntity(this, 32));
        } else if (this.field_70170_p.field_72995_K && !this.wasSynced) {
            return;
        }
        if (this.field_70128_L) {
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            for (int j = 0; j < this.components.length; ++j) {
                IBulletComponent c = this.components[j];
                if (!c.hasTrail()) continue;
                c.spawnParticleTrail(this, this.componentNBT[j]);
            }
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setMaxLength(compound.func_74762_e("maxLength"));
    }

    @Override
    protected void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("maxLength", this.maxLength);
    }

    public void setMaxLength(int length) {
        this.maxLength = length;
        this.field_70180_af.func_187227_b(dataMarkerMaxLength, (Object)this.maxLength);
    }

    public void func_70108_f(Entity entityIn) {
        if (entityIn instanceof EntitySquid) {
            return;
        }
        super.func_70108_f(entityIn);
        if (this.field_70173_aa > Config.IIConfig.Weapons.Mines.navalMineArmTime) {
            this.performEffect(new RayTraceResult((Entity)this));
        }
    }

    @Override
    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ().func_186662_g((double)0.3f);
    }

    @Override
    public boolean func_70067_L() {
        return true;
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.func_184218_aH()) {
            this.func_184187_bx().func_70106_y();
        }
    }

    public AxisAlignedBB func_184177_bl() {
        if (this.func_184218_aH()) {
            double diff = Math.min((double)this.maxLength, Math.abs(this.func_184187_bx().field_70163_u - this.field_70163_u));
            return this.func_70046_E().func_72321_a(0.0, diff, 0.0);
        }
        return super.func_184177_bl();
    }

    public boolean func_184218_aH() {
        if (this.isNotRiding) {
            return false;
        }
        return super.func_184218_aH();
    }
}

