/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.entity;

import blusunrize.immersiveengineering.api.energy.DieselHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.utils.IEntitySpecialRepairable;
import pl.pabilo8.immersiveintelligence.api.utils.vehicles.ITowable;
import pl.pabilo8.immersiveintelligence.api.utils.vehicles.IVehicleMultiPart;
import pl.pabilo8.immersiveintelligence.client.ClientProxy;
import pl.pabilo8.immersiveintelligence.client.carversound.sounds.MovingSoundMotorbikeEngine;
import pl.pabilo8.immersiveintelligence.client.fx.ParticleUtils;
import pl.pabilo8.immersiveintelligence.client.render.MotorbikeRenderer;
import pl.pabilo8.immersiveintelligence.client.tmt.ModelRendererTurbo;
import pl.pabilo8.immersiveintelligence.common.IIDamageSources;
import pl.pabilo8.immersiveintelligence.common.IISounds;
import pl.pabilo8.immersiveintelligence.common.entity.EntityVehicleMultiPart;
import pl.pabilo8.immersiveintelligence.common.entity.EntityVehicleSeat;
import pl.pabilo8.immersiveintelligence.common.entity.EntityVehicleWheel;
import pl.pabilo8.immersiveintelligence.common.network.IIPacketHandler;
import pl.pabilo8.immersiveintelligence.common.network.MessageEntityNBTSync;
import pl.pabilo8.immersiveintelligence.common.network.MessageParticleEffect;

public class EntityMotorbike
extends Entity
implements IVehicleMultiPart,
IEntitySpecialRepairable,
IEntityAdditionalSpawnData {
    private static final DataParameter<NBTTagCompound> dataMarkerFluid = EntityDataManager.func_187226_a(EntityMotorbike.class, (DataSerializer)DataSerializers.field_192734_n);
    private static final DataParameter<Integer> dataMarkerFluidCap = EntityDataManager.func_187226_a(EntityMotorbike.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> dataMarkerWheelFrontDurability = EntityDataManager.func_187226_a(EntityMotorbike.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> dataMarkerWheelBackDurability = EntityDataManager.func_187226_a(EntityMotorbike.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> dataMarkerEngineDurability = EntityDataManager.func_187226_a(EntityMotorbike.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> dataMarkerFuelTankDurability = EntityDataManager.func_187226_a(EntityMotorbike.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> dataMarkerAccelerated = EntityDataManager.func_187226_a(EntityMotorbike.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> dataMarkerBrake = EntityDataManager.func_187226_a(EntityMotorbike.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> dataMarkerEngineWorking = EntityDataManager.func_187226_a(EntityMotorbike.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> dataMarkerTurnLeft = EntityDataManager.func_187226_a(EntityMotorbike.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> dataMarkerTurnRight = EntityDataManager.func_187226_a(EntityMotorbike.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> dataMarkerAcceleration = EntityDataManager.func_187226_a(EntityMotorbike.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> dataMarkerSpeed = EntityDataManager.func_187226_a(EntityMotorbike.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> dataMarkerTilt = EntityDataManager.func_187226_a(EntityMotorbike.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> dataMarkerYaw = EntityDataManager.func_187226_a(EntityMotorbike.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<String> dataMarkerUpgrade = EntityDataManager.func_187226_a(EntityMotorbike.class, (DataSerializer)DataSerializers.field_187194_d);
    private final EntityVehicleMultiPart[] partArray;
    public EntityVehicleWheel partWheelFront = new EntityVehicleWheel(this, "wheel_front", 1.0f, 1.0f);
    public EntityVehicleWheel partWheelBack = new EntityVehicleWheel(this, "wheel_back", 1.0f, 1.0f);
    public EntityVehicleMultiPart partFuelTank = new EntityVehicleMultiPart(this, "fuel_tank", 1.0f, 0.45f);
    public EntityVehicleMultiPart partEngine = new EntityVehicleMultiPart(this, "engine", 1.0f, 0.45f);
    public EntityVehicleMultiPart partSeat = new EntityVehicleMultiPart(this, "seat", 1.0f, 0.125f);
    public EntityVehicleMultiPart partUpgradeSeat = new EntityVehicleMultiPart(this, "upgrade_seat", 1.0f, 0.125f);
    public EntityVehicleMultiPart partUpgradeCargo = new EntityVehicleMultiPart(this, "upgrade_cargo", 1.0f, 0.45f);
    private int destroyTimer = -1;
    public FluidTank tank = new FluidTank(12000){};
    NonSidedFluidHandler fluidHandler = new NonSidedFluidHandler(this);
    public float acceleration = 0.0f;
    public float speed = 0.0f;
    public float tilt = 0.0f;
    public float brakeProgress = 0.0f;
    public float engineProgress = 0.0f;
    public boolean accelerated = false;
    public boolean brake = false;
    public boolean engineWorking = false;
    public boolean turnLeft = false;
    public boolean turnRight = false;
    public boolean engineKeyPress = false;
    public boolean towingKeyPress = false;
    public int frontWheelDurability;
    public int backWheelDurability;
    public int engineDurability;
    public int fuelTankDurability;
    public int untowingTries = 0;
    public String upgrade = "";
    static AxisAlignedBB aabb = new AxisAlignedBB(-2.5, 0.0, -2.5, 2.5, 1.5, 2.5);
    static AxisAlignedBB aabb_wheel = new AxisAlignedBB(-0.5, 0.0, 0.5, 0.5, 1.0, -0.5);
    static AxisAlignedBB aabb_tank = new AxisAlignedBB(-0.35, 0.0, 0.35, 0.35, 0.55, -0.35);
    static AxisAlignedBB aabb_storage = new AxisAlignedBB(-0.35, 0.0, 0.35, 0.35, 0.55, -0.35);
    static AxisAlignedBB aabb_engine = new AxisAlignedBB(-0.5, 0.0, 0.5, 0.5, 1.0, -0.5);
    static AxisAlignedBB aabb_woodgas = new AxisAlignedBB(-0.5, 0.0, 0.5, 0.5, 1.0, -0.5);
    static AxisAlignedBB aabb_seat = new AxisAlignedBB(-0.3, -0.25, 0.3, 0.3, 0.25, -0.3);

    public EntityMotorbike(World worldIn) {
        super(worldIn);
        this.func_70105_a(2.5f, 1.5f);
        this.partArray = new EntityVehicleMultiPart[]{this.partWheelFront, this.partWheelBack, this.partFuelTank, this.partEngine, this.partSeat, this.partUpgradeSeat, this.partUpgradeCargo};
        this.frontWheelDurability = Config.IIConfig.Vehicles.Motorbike.wheelDurability;
        this.backWheelDurability = Config.IIConfig.Vehicles.Motorbike.wheelDurability;
        this.engineDurability = Config.IIConfig.Vehicles.Motorbike.engineDurability;
        this.fuelTankDurability = Config.IIConfig.Vehicles.Motorbike.fuelTankDurability;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(dataMarkerFluid, (Object)new NBTTagCompound());
        this.field_70180_af.func_187214_a(dataMarkerFluidCap, (Object)0);
        this.field_70180_af.func_187214_a(dataMarkerWheelFrontDurability, (Object)this.frontWheelDurability);
        this.field_70180_af.func_187214_a(dataMarkerWheelBackDurability, (Object)this.backWheelDurability);
        this.field_70180_af.func_187214_a(dataMarkerEngineDurability, (Object)this.engineDurability);
        this.field_70180_af.func_187214_a(dataMarkerFuelTankDurability, (Object)this.fuelTankDurability);
        this.field_70180_af.func_187214_a(dataMarkerAccelerated, (Object)false);
        this.field_70180_af.func_187214_a(dataMarkerBrake, (Object)false);
        this.field_70180_af.func_187214_a(dataMarkerTurnRight, (Object)false);
        this.field_70180_af.func_187214_a(dataMarkerTurnLeft, (Object)false);
        this.field_70180_af.func_187214_a(dataMarkerEngineWorking, (Object)false);
        this.field_70180_af.func_187214_a(dataMarkerAcceleration, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(dataMarkerSpeed, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(dataMarkerTilt, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(dataMarkerYaw, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(dataMarkerUpgrade, (Object)"");
        if (this.field_70170_p.field_72995_K) {
            this.playEngineSound();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playEngineSound() {
        ClientUtils.mc().func_147118_V().func_147682_a((ISound)new MovingSoundMotorbikeEngine(this));
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.readTank(compound);
        this.acceleration = compound.func_74760_g("acceleration");
        this.speed = compound.func_74760_g("speed");
        this.tilt = compound.func_74760_g("tilt");
        this.accelerated = compound.func_74767_n("accelerated");
        this.brake = compound.func_74767_n("brake");
        this.turnLeft = compound.func_74767_n("turnLeft");
        this.turnRight = compound.func_74767_n("turnRight");
        this.engineWorking = compound.func_74767_n("engineWorking");
        if (compound.func_74764_b("frontWheelDurability")) {
            this.frontWheelDurability = compound.func_74762_e("frontWheelDurability");
        }
        if (compound.func_74764_b("backWheelDurability")) {
            this.backWheelDurability = compound.func_74762_e("backWheelDurability");
        }
        if (compound.func_74764_b("engineDurability")) {
            this.engineDurability = compound.func_74762_e("engineDurability");
        }
        if (compound.func_74764_b("fuelTankDurability")) {
            this.fuelTankDurability = compound.func_74762_e("fuelTankDurability");
        }
        this.upgrade = compound.func_74779_i("upgrade");
    }

    protected void func_70014_b(NBTTagCompound compound) {
        this.writeTank(compound);
        compound.func_74776_a("acceleration", this.acceleration);
        compound.func_74776_a("speed", this.speed);
        compound.func_74776_a("tilt", this.tilt);
        compound.func_74757_a("accelerated", this.accelerated);
        compound.func_74757_a("brake", this.brake);
        compound.func_74757_a("turnLeft", this.turnLeft);
        compound.func_74757_a("turnRight", this.turnRight);
        compound.func_74757_a("engineWorking", this.engineWorking);
        compound.func_74768_a("frontWheelDurability", this.frontWheelDurability);
        compound.func_74768_a("backWheelDurability", this.backWheelDurability);
        compound.func_74768_a("engineDurability", this.engineDurability);
        compound.func_74768_a("fuelTankDurability", this.fuelTankDurability);
        compound.func_74778_a("upgrade", this.upgrade);
    }

    public boolean func_70067_L() {
        return false;
    }

    protected boolean func_184219_q(Entity passenger) {
        return passenger instanceof EntityVehicleSeat;
    }

    public void func_70106_y() {
        this.func_184188_bt().forEach(Entity::func_70106_y);
        super.func_70106_y();
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            passenger.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    public void func_184190_l(Entity passenger) {
        if (passenger != null && this.func_184196_w(passenger)) {
            passenger.field_70177_z = this.field_70177_z;
            passenger.field_70125_A = this.field_70125_A;
        }
    }

    @Override
    public void getSeatRidingPosition(int seatID, Entity passenger) {
        if (seatID == 0 || seatID == 1) {
            double true_angle = Math.toRadians(-this.field_70177_z > 180.0f ? (double)(360.0f - -this.field_70177_z) : (double)(-this.field_70177_z));
            double true_angle2 = Math.toRadians(-this.field_70177_z - 90.0f > 180.0f ? (double)(360.0f - (-this.field_70177_z - 90.0f)) : (double)(-this.field_70177_z - 90.0f));
            float tylt = -(this.tilt * 0.5f + this.tilt * (this.speed / 10.0f) * 0.5f) * 20.0f;
            double true_angle4 = Math.toRadians(tylt - 90.0f > 180.0f ? (double)(360.0f - (tylt - 90.0f)) : (double)(tylt - 90.0f));
            Vec3d pos2 = Utils.offsetPosDirection(seatID == 0 ? -0.4f : -1.35f, true_angle, 0.0);
            Vec3d pos3 = Utils.offsetPosDirection(seatID == 0 ? 0.7f : 0.75f, true_angle2, -true_angle4);
            passenger.func_70107_b(this.field_70165_t + pos2.field_72450_a + pos3.field_72450_a + this.field_70159_w, this.field_70163_u + pos3.field_72448_b, this.field_70161_v + pos2.field_72449_c + pos3.field_72449_c + this.field_70179_y);
        } else if (seatID == 2) {
            double true_angle = Math.toRadians(-this.field_70177_z > 180.0f ? (double)(360.0f - -this.field_70177_z) : (double)(-this.field_70177_z));
            Vec3d pos_mtb = Utils.offsetPosDirection(-2.25f, true_angle, 0.0);
            passenger.func_70634_a(this.field_70165_t + pos_mtb.field_72450_a + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + pos_mtb.field_72449_c + this.field_70179_y);
            passenger.field_70177_z = this.field_70177_z + 180.0f;
        }
    }

    @Override
    public void getSeatRidingAngle(int seatID, Entity passenger) {
        if (seatID == 0 || seatID == 1) {
            passenger.func_181013_g(this.field_70177_z);
            float f = MathHelper.func_76142_g((float)(passenger.field_70177_z - this.field_70177_z));
            float f1 = MathHelper.func_76131_a((float)f, (float)-55.0f, (float)55.0f);
            passenger.field_70126_B += f1 - f;
            passenger.field_70177_z += f1 - f;
            passenger.func_70034_d(passenger.field_70177_z);
        } else if (seatID == 2) {
            passenger.field_70126_B = 180.0f + this.field_70177_z;
            passenger.field_70177_z = 180.0f + this.field_70177_z;
        }
    }

    @Override
    public boolean shouldSeatPassengerSit(int seatID, Entity passenger) {
        return true;
    }

    @Override
    public void onSeatDismount(int seatID, Entity passenger) {
        if (this.speed > 1.0f && seatID < 2) {
            passenger.func_70097_a(IIDamageSources.causeMotorbikeDamageGetOut(this), 4.5f * this.speed);
        }
    }

    public void func_70071_h_() {
        if (this.field_70148_d) {
            if (!this.field_70170_p.field_72995_K) {
                EntityVehicleSeat.getOrCreateSeat(this, 0);
                EntityVehicleSeat.getOrCreateSeat(this, 1);
                EntityVehicleSeat.getOrCreateSeat(this, 2);
            }
            this.updateParts(false);
        }
        if (this.field_70170_p.field_72995_K) {
            Entity pre = ClientUtils.mc().field_71439_g.func_184187_bx();
            this.handleClientKeyOutput();
            if (pre instanceof EntityVehicleSeat && pre.func_184187_bx() == this && ((EntityVehicleSeat)pre).seatID == 0) {
                this.updateParts(false);
                this.handleClientKeyInput();
            }
            this.brakeProgress = this.brake ? Math.min(this.brakeProgress + 0.15f, 1.0f) : Math.max(this.brakeProgress - 0.25f, 0.0f);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.updateTank(false);
            this.handleServerKeyInput();
            this.field_70180_af.func_187227_b(dataMarkerUpgrade, (Object)this.upgrade);
        }
        if (this.destroyTimer == -1) {
            boolean bl = this.accelerated = this.accelerated && this.func_184188_bt().stream().anyMatch(entity -> entity instanceof EntityVehicleSeat && ((EntityVehicleSeat)entity).seatID == 0 && entity.func_184188_bt().size() > 0);
            if (this.engineDurability <= 0) {
                this.destroyTimer = 100;
            }
        } else {
            this.engineWorking = true;
            this.accelerated = true;
            --this.destroyTimer;
        }
        if (!this.field_70170_p.field_72995_K && this.destroyTimer == 0) {
            this.selfDestruct();
        }
        this.engineProgress = MathHelper.func_76131_a((float)(this.engineProgress + (float)(this.engineWorking && this.hasFuel() ? 1 : -25)), (float)0.0f, (float)25.0f);
        boolean bl = this.engineWorking = this.engineWorking && this.hasFuel();
        if (this.engineWorking && this.tank.getFluid() != null && (float)this.field_70170_p.func_82737_E() % ((float)DieselHandler.getBurnTime((Fluid)this.tank.getFluid().getFluid()) / 20.0f) == 0.0f) {
            this.tank.drain((int)Math.ceil((float)Config.IIConfig.Vehicles.Motorbike.fuelBurnAmount * (this.speed / 4.0f)), true);
        }
        if (this.turnLeft) {
            this.tilt -= 0.1f;
        } else if (this.turnRight) {
            this.tilt += 0.1f;
        } else if (this.tilt != 0.0f) {
            float f = this.tilt = this.tilt < 0.0f ? this.tilt + 0.1f : this.tilt - 0.1f;
            if (Math.abs(this.tilt) < 0.01f) {
                this.tilt = 0.0f;
            }
        }
        this.tilt = MathHelper.func_76131_a((float)this.tilt, (float)-1.0f, (float)1.0f);
        boolean canTowedMove = this.func_184182_bu().stream().noneMatch(entity -> entity instanceof ITowable && !((ITowable)entity).canMoveTowed());
        this.acceleration = this.engineWorking && this.engineProgress >= 25.0f && this.accelerated && canTowedMove ? Math.min(this.acceleration + 0.1f, 1.0f) : Math.max(this.acceleration - 0.15f, 0.0f);
        this.speed = MathHelper.func_76131_a((float)(this.speed + (this.acceleration > 0.0f ? 0.25f * this.acceleration : -0.3f)), (float)0.0f, (float)20.0f);
        if (this.brake) {
            this.speed = (float)((double)this.speed * 0.85);
        }
        this.partWheelFront.wheelTraverse = (int)((float)this.partWheelFront.wheelTraverse + this.speed * 2.0f * (1.0f - this.tilt));
        this.partWheelBack.wheelTraverse = (int)((float)this.partWheelBack.wheelTraverse + this.speed * 2.0f);
        List towables = EntityVehicleSeat.getOrCreateSeat(this, 2).func_184188_bt();
        if (towables.size() > 0 && towables.get(0) instanceof ITowable) {
            ((ITowable)towables.get(0)).moveTowableWheels(this.speed);
        }
        if (this.field_70170_p.field_72995_K) {
            double true_angle = Math.toRadians(-this.field_70177_z > 180.0f ? (double)(360.0f - -this.field_70177_z) : (double)(-this.field_70177_z));
            double true_angle2 = Math.toRadians(-this.field_70177_z - 90.0f > 180.0f ? (double)(360.0f - (-this.field_70177_z - 90.0f)) : (double)(-this.field_70177_z - 90.0f));
            if (this.engineWorking && this.engineProgress >= 25.0f) {
                this.spawnExhaustParticle(true_angle, true_angle2);
            }
            if (this.hasFuel() && (float)this.engineDurability < (float)Config.IIConfig.Vehicles.Motorbike.engineDurability * 0.85f) {
                this.spawnEngineDamageParticle(true_angle, true_angle2);
            }
        }
        this.updateParts(false);
        this.handleMovement();
        if (this.tilt != 0.0f && this.speed > 0.0f) {
            this.field_70177_z += this.tilt * (this.speed / 10.0f) * 3.5f;
        }
        if (!this.engineWorking && (this.turnLeft || this.turnRight)) {
            this.field_70177_z = (float)((double)this.field_70177_z + (double)this.tilt * 0.5);
        }
        this.updateParts(true);
        super.func_70071_h_();
    }

    private void handleMovement() {
        this.field_70126_B = MathHelper.func_76142_g((float)this.field_70126_B);
        this.field_70177_z = MathHelper.func_76142_g((float)this.field_70177_z);
        Vec3d pos1_x = this.func_70040_Z().func_186678_a(-1.25);
        this.partWheelFront.field_70177_z = this.field_70177_z + this.tilt * 5.0f;
        this.partWheelFront.travel(0.0f, 0.0f, this.field_70170_p.field_72995_K ? 0.0f : 1.0f, -0.0125f, (double)this.speed * 0.0125 * 2.0);
        this.partWheelBack.field_70177_z = this.field_70177_z;
        this.partWheelBack.travel(0.0f, 0.0f, this.field_70170_p.field_72995_K ? 0.0f : 1.0f, -0.0125f, (double)this.speed * 0.0125 * 2.0);
        if (this.partWheelFront.field_70123_F && this.destroyTimer != -1) {
            this.destroyTimer = 1;
        }
        if (!this.partWheelFront.func_70094_T()) {
            this.field_70159_w = this.partWheelFront.field_70159_w;
            this.field_70181_x = this.partWheelFront.field_70181_x;
            this.field_70179_y = this.partWheelFront.field_70179_y;
            this.func_70018_K();
            Vec3d currentPos = new Vec3d(this.partWheelFront.field_70165_t + pos1_x.field_72450_a, this.partWheelFront.field_70163_u, this.partWheelFront.field_70161_v + pos1_x.field_72449_c);
            this.func_70107_b(currentPos.field_72450_a, currentPos.field_72448_b, currentPos.field_72449_c);
        }
        if (this.field_70170_p.field_72995_K) {
            Utils.setEntityVelocity(this, this.partWheelFront.field_70159_w, this.partWheelFront.field_70181_x, this.partWheelFront.field_70179_y);
        }
        if (!this.field_70170_p.field_72995_K && this.speed > 1.0f) {
            List entitiesWithinAABB = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.partWheelFront.func_174813_aQ());
            for (EntityLivingBase e : entitiesWithinAABB) {
                if (this.func_184196_w((Entity)e)) continue;
                e.func_70097_a(IIDamageSources.causeMotorbikeDamage(this), 6.0f * this.speed);
            }
        }
        if (this.partWheelBack.func_70094_T()) {
            this.partWheelBack.field_70163_u = this.partWheelFront.field_70163_u;
        }
    }

    private void handleServerKeyInput() {
        this.field_70180_af.func_187227_b(dataMarkerAccelerated, (Object)this.accelerated);
        this.field_70180_af.func_187227_b(dataMarkerBrake, (Object)this.brake);
        this.field_70180_af.func_187227_b(dataMarkerTurnLeft, (Object)this.turnLeft);
        this.field_70180_af.func_187227_b(dataMarkerTurnRight, (Object)this.turnRight);
        this.field_70180_af.func_187227_b(dataMarkerEngineWorking, (Object)this.engineWorking);
        this.field_70180_af.func_187227_b(dataMarkerAcceleration, (Object)Float.valueOf(this.acceleration));
        this.field_70180_af.func_187227_b(dataMarkerSpeed, (Object)Float.valueOf(this.speed));
        this.field_70180_af.func_187227_b(dataMarkerTilt, (Object)Float.valueOf(this.tilt));
        this.field_70180_af.func_187227_b(dataMarkerYaw, (Object)Float.valueOf(this.field_70177_z));
        this.field_70180_af.func_187227_b(dataMarkerEngineDurability, (Object)this.engineDurability);
        this.field_70180_af.func_187227_b(dataMarkerFuelTankDurability, (Object)this.fuelTankDurability);
        this.field_70180_af.func_187227_b(dataMarkerWheelBackDurability, (Object)this.frontWheelDurability);
        this.field_70180_af.func_187227_b(dataMarkerWheelFrontDurability, (Object)this.backWheelDurability);
    }

    private void handleClientKeyOutput() {
        this.accelerated = (Boolean)this.field_70180_af.func_187225_a(dataMarkerAccelerated);
        this.brake = (Boolean)this.field_70180_af.func_187225_a(dataMarkerBrake);
        this.turnLeft = (Boolean)this.field_70180_af.func_187225_a(dataMarkerTurnLeft);
        this.turnRight = (Boolean)this.field_70180_af.func_187225_a(dataMarkerTurnRight);
        this.engineWorking = (Boolean)this.field_70180_af.func_187225_a(dataMarkerEngineWorking);
        this.acceleration = ((Float)this.field_70180_af.func_187225_a(dataMarkerAcceleration)).floatValue();
        this.speed = ((Float)this.field_70180_af.func_187225_a(dataMarkerSpeed)).floatValue();
        this.engineDurability = (Integer)this.field_70180_af.func_187225_a(dataMarkerEngineDurability);
        this.backWheelDurability = (Integer)this.field_70180_af.func_187225_a(dataMarkerWheelBackDurability);
        this.frontWheelDurability = (Integer)this.field_70180_af.func_187225_a(dataMarkerWheelFrontDurability);
        this.fuelTankDurability = (Integer)this.field_70180_af.func_187225_a(dataMarkerFuelTankDurability);
        this.upgrade = (String)this.field_70180_af.func_187225_a(dataMarkerUpgrade);
    }

    private void handleClientKeyInput() {
        boolean a = this.accelerated;
        boolean b = this.brake;
        boolean tl = this.turnLeft;
        boolean tr = this.turnRight;
        boolean en = this.engineWorking;
        if (this.field_70170_p.func_82737_E() % 20L == 0L) {
            this.updateTank(true);
        }
        this.accelerated = ClientUtils.mc().field_71474_y.field_74351_w.func_151470_d();
        this.brake = ClientUtils.mc().field_71474_y.field_74368_y.func_151470_d();
        this.turnLeft = ClientUtils.mc().field_71474_y.field_74370_x.func_151470_d();
        this.turnRight = ClientUtils.mc().field_71474_y.field_74366_z.func_151470_d();
        if (this.destroyTimer == -1) {
            if (ClientProxy.keybind_motorbikeEngine.func_151470_d()) {
                if (!this.engineKeyPress) {
                    this.engineKeyPress = true;
                    this.engineWorking = !this.engineWorking;
                }
            } else {
                this.engineKeyPress = false;
            }
            if (ClientProxy.keybind_motorbikeTowing.func_151470_d()) {
                if (!this.towingKeyPress) {
                    this.towingKeyPress = true;
                    NBTTagCompound tag = new NBTTagCompound();
                    tag.func_74757_a("startTowing", true);
                    IIPacketHandler.INSTANCE.sendToServer((IMessage)new MessageEntityNBTSync(this, tag));
                }
            } else {
                this.towingKeyPress = false;
            }
        }
        if (a ^ this.accelerated || b ^ this.brake || tl ^ this.turnLeft || tr ^ this.turnRight || en ^ this.engineWorking) {
            IIPacketHandler.INSTANCE.sendToServer((IMessage)new MessageEntityNBTSync(this, this.updateKeys()));
        }
    }

    public void selfDestruct() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.hasFuel()) {
                this.field_70170_p.func_72885_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)this.tank.getFluidAmount() / 12000.0f * 4.0f, false, false);
            }
            IIPacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageParticleEffect(this.func_145782_y(), 0.0, 0.0, "motorbike_explosion"), Utils.targetPointFromEntity(this, 48));
            this.func_70106_y();
        } else {
            this.spawnDebrisExplosion();
            if (this.hasFuel()) {
                this.spawnExplosionParticles();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private NBTTagCompound updateKeys() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74757_a("accelerated", this.accelerated);
        compound.func_74757_a("brake", this.brake);
        compound.func_74757_a("turnLeft", this.turnLeft);
        compound.func_74757_a("turnRight", this.turnRight);
        compound.func_74757_a("engineWorking", this.engineWorking);
        return compound;
    }

    private boolean hasFuel() {
        return this.tank.getFluidAmount() > 0;
    }

    public AxisAlignedBB func_174813_aQ() {
        return aabb.func_72317_d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return null;
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return this.func_174813_aQ();
    }

    private void spawnExhaustParticle(double angle1, double angle2) {
        float exhaustRandom = (float)(this.field_70170_p.func_82737_E() % 20L) / 20.0f * 0.2f;
        Vec3d exhaustVec = new Vec3d(0.0, 0.3 + (double)exhaustRandom, 0.0).func_178787_e(Utils.offsetPosDirection(0.345f, angle2, 0.0)).func_178787_e(Utils.offsetPosDirection(-1.5f, angle1, 0.0));
        Vec3d exhaustSpeedVec = Utils.offsetPosDirection(-0.25f, angle1, 0.0);
        this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + exhaustVec.field_72450_a, this.field_70163_u + exhaustVec.field_72448_b, this.field_70161_v + exhaustVec.field_72449_c, 0.0 + exhaustSpeedVec.field_72450_a, 0.015625, exhaustSpeedVec.field_72449_c, new int[0]);
    }

    private void spawnEngineDamageParticle(double angle1, double angle2) {
        float worldRandom = Math.abs((float)(this.field_70170_p.func_82737_E() % 40L) / 40.0f - 0.5f) / 0.5f;
        Vec3d smokeVec = new Vec3d(0.0, 0.5, 0.0).func_178787_e(Utils.offsetPosDirection(-0.25f + worldRandom * 0.015625f * 8.0f, angle2, 0.0));
        Vec3d modVec = Utils.offsetPosDirection(4.0f, angle2, 0.0);
        this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + smokeVec.field_72450_a, this.field_70163_u + smokeVec.field_72448_b, this.field_70161_v + smokeVec.field_72449_c, (double)worldRandom * 0.015625 * modVec.field_72450_a, 0.015625 * modVec.field_72448_b, (double)worldRandom * 0.015625 * modVec.field_72449_c, new int[0]);
        if ((double)this.engineDurability < (double)Config.IIConfig.Vehicles.Motorbike.engineDurability * 0.65) {
            Vec3d fireVec = new Vec3d(0.0, 0.55, 0.0).func_178787_e(Utils.offsetPosDirection(0.135f, angle2, 0.0));
            ParticleUtils.spawnFlameFX(this.field_70165_t + fireVec.field_72450_a, this.field_70163_u + fireVec.field_72448_b, this.field_70161_v + fireVec.field_72449_c, (double)worldRandom * modVec.field_72450_a, 2.0, (double)worldRandom * modVec.field_72449_c, 2.5f, 16);
            if ((double)this.engineDurability < (double)Config.IIConfig.Vehicles.Motorbike.engineDurability * 0.35) {
                modVec = Utils.offsetPosDirection(-4.0f, angle2, 0.0);
                Vec3d fireVec2 = new Vec3d(0.0, 0.55, 0.0).func_178787_e(Utils.offsetPosDirection(-0.2f, angle2, 0.0));
                ParticleUtils.spawnFlameFX(this.field_70165_t + fireVec2.field_72450_a, this.field_70163_u + fireVec2.field_72448_b, this.field_70161_v + fireVec2.field_72449_c, (double)worldRandom * modVec.field_72450_a, 2.0, (double)worldRandom * modVec.field_72449_c, 2.5f, 16);
                if ((double)this.engineDurability < (double)Config.IIConfig.Vehicles.Motorbike.engineDurability * 0.2) {
                    smokeVec = new Vec3d(0.0, 0.5, 0.0).func_178787_e(Utils.offsetPosDirection(-0.25f + worldRandom * 0.015625f * 8.0f, angle2, 0.0));
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + smokeVec.field_72450_a, this.field_70163_u + smokeVec.field_72448_b, this.field_70161_v + smokeVec.field_72449_c, (double)worldRandom * 0.015625 * modVec.field_72450_a, 0.015625 * modVec.field_72448_b, (double)worldRandom * 0.015625 * modVec.field_72449_c, new int[0]);
                }
            }
        }
    }

    private void spawnExplosionParticles() {
        ParticleUtils.spawnFlameExplosion(this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0f + (float)this.tank.getFluidAmount() / 12000.0f, this.field_70146_Z);
    }

    public boolean func_70965_a(MultiPartEntityPart part, DamageSource source, float amount) {
        if (part == this.partEngine && source.func_76352_a() || source.func_94541_c() || source.func_76347_k()) {
            this.engineDurability = (int)((double)this.engineDurability - (double)amount * 0.85);
            this.field_70180_af.func_187227_b(dataMarkerEngineDurability, (Object)this.engineDurability);
            if (this.field_70170_p.field_72995_K) {
                this.func_184185_a(IISounds.impact_metal, Math.min(amount / 16.0f, 1.0f), 1.0f);
            }
        } else if ((part == this.partFuelTank || part == this.partSeat) && source.func_76352_a() || source.func_94541_c() || source.func_76347_k()) {
            this.fuelTankDurability = (int)((double)this.fuelTankDurability - (double)amount * 0.85);
            this.field_70180_af.func_187227_b(dataMarkerFuelTankDurability, (Object)this.fuelTankDurability);
            if (this.field_70170_p.field_72995_K) {
                this.func_184185_a(IISounds.impact_metal, Math.min(amount / 16.0f, 1.0f), 1.0f);
            }
        } else if (part == this.partWheelFront) {
            this.frontWheelDurability = (int)((float)this.frontWheelDurability - amount);
            this.field_70180_af.func_187227_b(dataMarkerWheelFrontDurability, (Object)this.frontWheelDurability);
        } else if (part == this.partWheelBack) {
            this.backWheelDurability = (int)((float)this.backWheelDurability - amount);
            this.field_70180_af.func_187227_b(dataMarkerWheelBackDurability, (Object)this.backWheelDurability);
        } else {
            return false;
        }
        return true;
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    public boolean func_90999_ad() {
        return false;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.fluidHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public boolean canRepair() {
        return this.engineDurability < Config.IIConfig.Vehicles.Motorbike.engineDurability || this.fuelTankDurability < Config.IIConfig.Vehicles.Motorbike.fuelTankDurability || this.frontWheelDurability < Config.IIConfig.Vehicles.Motorbike.wheelDurability || this.backWheelDurability < Config.IIConfig.Vehicles.Motorbike.wheelDurability;
    }

    @Override
    public boolean repair(int repairPoints) {
        if (this.engineDurability < Config.IIConfig.Vehicles.Motorbike.engineDurability) {
            this.engineDurability = Math.min(this.engineDurability + repairPoints, Config.IIConfig.Vehicles.Motorbike.engineDurability);
        } else if (this.fuelTankDurability < Config.IIConfig.Vehicles.Motorbike.fuelTankDurability) {
            this.fuelTankDurability = Math.min(this.fuelTankDurability + repairPoints, Config.IIConfig.Vehicles.Motorbike.fuelTankDurability);
        } else if (this.frontWheelDurability < Config.IIConfig.Vehicles.Motorbike.wheelDurability) {
            this.frontWheelDurability = Math.min(this.frontWheelDurability + repairPoints, Config.IIConfig.Vehicles.Motorbike.wheelDurability);
        } else if (this.backWheelDurability < Config.IIConfig.Vehicles.Motorbike.wheelDurability) {
            this.backWheelDurability = Math.min(this.backWheelDurability + repairPoints, Config.IIConfig.Vehicles.Motorbike.wheelDurability);
        } else {
            return false;
        }
        return true;
    }

    @Override
    public int getRepairCost() {
        return 1;
    }

    private void updateTank(boolean read) {
        if (read) {
            this.readTank((NBTTagCompound)this.field_70180_af.func_187225_a(dataMarkerFluid));
        } else {
            NBTTagCompound tag = new NBTTagCompound();
            this.writeTank(tag);
            this.field_70180_af.func_187227_b(dataMarkerFluid, (Object)tag);
        }
    }

    private void writeTank(NBTTagCompound nbt) {
        boolean write = this.tank.getFluidAmount() > 0;
        NBTTagCompound tankTag = this.tank.writeToNBT(new NBTTagCompound());
        if (write) {
            nbt.func_74782_a("tank", (NBTBase)tankTag);
        }
    }

    private void readTank(NBTTagCompound nbt) {
        if (nbt.func_74764_b("tank")) {
            this.tank.readFromNBT(nbt.func_74775_l("tank"));
        }
    }

    @Override
    public boolean onInteractWithPart(EntityVehicleMultiPart part, EntityPlayer player, EnumHand hand) {
        if (!this.func_184182_bu().contains(player)) {
            if (part == this.partFuelTank || part == this.partEngine) {
                FluidStack f = FluidUtil.getFluidContained((ItemStack)player.func_184586_b(EnumHand.MAIN_HAND));
                if (f == null) {
                    f = FluidUtil.getFluidContained((ItemStack)player.func_184586_b(EnumHand.OFF_HAND));
                }
                if (f != null) {
                    if (DieselHandler.isValidFuel((Fluid)f.getFluid())) {
                        FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)this.tank);
                        if (!this.field_70170_p.field_72995_K) {
                            this.updateTank(false);
                        }
                    }
                    return true;
                }
            } else {
                if (!this.field_70170_p.field_72995_K && part == this.partSeat) {
                    return player.func_184220_m((Entity)EntityVehicleSeat.getOrCreateSeat(this, 0));
                }
                if (!this.field_70170_p.field_72995_K && this.upgrade.equals("seat") && part == this.partUpgradeSeat) {
                    return player.func_184220_m((Entity)EntityVehicleSeat.getOrCreateSeat(this, 1));
                }
            }
        }
        return false;
    }

    @Override
    public String[] getOverlayTextOnPart(EntityVehicleMultiPart part, EntityPlayer player, RayTraceResult mop, boolean hammer) {
        if (!this.func_184196_w((Entity)player) && (part == this.partEngine || part == this.partFuelTank) && blusunrize.immersiveengineering.common.util.Utils.isFluidRelatedItemStack((ItemStack)player.func_184586_b(EnumHand.MAIN_HAND))) {
            String s = this.tank.getFluid() != null ? this.tank.getFluid().getLocalizedName() + ": " + this.tank.getFluidAmount() + "mB" : I18n.func_135052_a((String)"gui.immersiveengineering.empty", (Object[])new Object[0]);
            return new String[]{s};
        }
        return null;
    }

    public void setUpgrade(String upgrade) {
        this.upgrade = upgrade;
    }

    public void writeSpawnData(ByteBuf buffer) {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_70014_b(tag);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)tag);
    }

    public void readSpawnData(ByteBuf additionalData) {
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)additionalData);
        if (tag != null) {
            this.func_70037_a(tag);
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
    }

    public void syncKeyPress(NBTTagCompound tag) {
        if (tag.func_74764_b("startTowing")) {
            if (this.acceleration > 0.0f) {
                return;
            }
            EntityVehicleSeat seat = EntityVehicleSeat.getOrCreateSeat(this, 2);
            if (seat.func_184188_bt().size() > 0) {
                Entity towed = (Entity)seat.func_184188_bt().get(0);
                if (towed instanceof ITowable) {
                    ((ITowable)towed).stopTowing();
                } else {
                    towed.func_184210_p();
                }
                this.func_184182_bu().forEach(entity -> {
                    if (entity instanceof EntityPlayer) {
                        ((EntityPlayer)entity).func_146105_b((ITextComponent)new TextComponentTranslation("info.immersiveintelligence.towing.untowed", new Object[0]), true);
                    }
                });
            } else {
                List entitiesWithinAABB = this.field_70170_p.func_175647_a(Entity.class, this.func_174813_aQ(), input -> input instanceof ITowable);
                if (entitiesWithinAABB.size() > 0) {
                    entitiesWithinAABB.sort((o1, o2) -> (int)((o1.func_174791_d().func_72438_d(this.func_174791_d()) - o2.func_174791_d().func_72438_d(this.func_174791_d())) * 10.0));
                    assert (entitiesWithinAABB.get(0) instanceof ITowable);
                    ((ITowable)entitiesWithinAABB.get(0)).startTowing(seat);
                    this.func_184182_bu().forEach(entity -> {
                        if (entity instanceof EntityPlayer) {
                            ((EntityPlayer)entity).func_146105_b((ITextComponent)new TextComponentTranslation("info.immersiveintelligence.towing.towed", new Object[0]), true);
                        }
                    });
                } else {
                    this.func_184182_bu().forEach(entity -> {
                        if (entity instanceof EntityPlayer) {
                            if (this.untowingTries < 50) {
                                ((EntityPlayer)entity).func_146105_b((ITextComponent)new TextComponentTranslation("info.immersiveintelligence.towing.no", new Object[0]), true);
                            } else {
                                ((EntityPlayer)entity).func_146105_b((ITextComponent)new TextComponentTranslation("info.immersiveintelligence.towing.no_easter_egg", new Object[0]), true);
                                this.untowingTries = 0;
                            }
                            ++this.untowingTries;
                        }
                    });
                }
            }
        } else {
            if (tag.func_74764_b("accelerated")) {
                this.accelerated = tag.func_74767_n("accelerated");
            }
            if (tag.func_74764_b("brake")) {
                this.brake = tag.func_74767_n("brake");
            }
            if (tag.func_74764_b("turnLeft")) {
                this.turnLeft = tag.func_74767_n("turnLeft");
            }
            if (tag.func_74764_b("turnRight")) {
                this.turnRight = tag.func_74767_n("turnRight");
            }
            if (tag.func_74764_b("engineWorking")) {
                boolean ew = this.engineWorking;
                this.engineWorking = tag.func_74767_n("engineWorking");
                if (ew ^ this.engineWorking && this.engineWorking) {
                    this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.hasFuel() ? IISounds.motorbike_start : IISounds.motorbike_start_no_fuel, SoundCategory.NEUTRAL, 1.0f, 0.0f);
                }
            }
        }
    }

    public Entity[] func_70021_al() {
        return this.partArray;
    }

    private void updateParts(boolean wheelHandle) {
        double true_angle = Math.toRadians(-this.field_70177_z > 180.0f ? (double)(360.0f - -this.field_70177_z) : (double)(-this.field_70177_z));
        Vec3d pos_x = Utils.offsetPosDirection(1.0f, true_angle, 0.0);
        Vec3d pos1_x = pos_x.func_186678_a(1.25);
        Vec3d pos2_x = pos_x.func_186678_a(-1.5);
        Vec3d pos3_x = pos_x.func_186678_a(0.1);
        Vec3d pos4_x = pos_x.func_186678_a(-0.55);
        Vec3d pos5_x = pos_x.func_186678_a(-1.35);
        this.partSeat.func_70012_b(this.field_70165_t + pos4_x.field_72450_a, this.field_70163_u + 1.175, this.field_70161_v + pos4_x.field_72449_c, 0.0f, 0.0f);
        this.partSeat.func_174826_a(aabb_seat.func_72317_d(this.partSeat.field_70165_t, this.partSeat.field_70163_u, this.partSeat.field_70161_v));
        if (this.field_70170_p.field_72995_K) {
            Utils.setEntityVelocity((Entity)this.partSeat, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        this.partSeat.func_70071_h_();
        this.partUpgradeSeat.func_70012_b(this.field_70165_t + pos5_x.field_72450_a, this.field_70163_u + 1.175, this.field_70161_v + pos5_x.field_72449_c, 0.0f, 0.0f);
        if (this.field_70170_p.field_72995_K) {
            Utils.setEntityVelocity((Entity)this.partUpgradeSeat, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        this.partUpgradeCargo.func_70012_b(this.field_70165_t + pos5_x.field_72450_a, this.field_70163_u + 1.0, this.field_70161_v + pos5_x.field_72449_c, 0.0f, 0.0f);
        if (this.field_70170_p.field_72995_K) {
            Utils.setEntityVelocity((Entity)this.partUpgradeCargo, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        if (this.upgrade.equals("seat")) {
            this.partUpgradeSeat.func_174826_a(aabb_seat.func_72317_d(this.partUpgradeSeat.field_70165_t, this.partUpgradeSeat.field_70163_u, this.partUpgradeSeat.field_70161_v));
            this.partUpgradeCargo.func_174826_a(new AxisAlignedBB(this.partUpgradeCargo.field_70165_t, this.partUpgradeCargo.field_70163_u, this.partUpgradeCargo.field_70161_v, this.partUpgradeCargo.field_70165_t, this.partUpgradeCargo.field_70163_u, this.partUpgradeCargo.field_70161_v));
        } else {
            this.partUpgradeSeat.func_174826_a(new AxisAlignedBB(this.partUpgradeSeat.field_70165_t, this.partUpgradeSeat.field_70163_u, this.partUpgradeSeat.field_70161_v, this.partUpgradeSeat.field_70165_t, this.partUpgradeSeat.field_70163_u, this.partUpgradeSeat.field_70161_v));
            if (!this.upgrade.isEmpty()) {
                this.partUpgradeCargo.func_174826_a((this.upgrade.equals("woodgas") ? aabb_woodgas : (this.upgrade.equals("tank") ? aabb_tank : aabb_storage)).func_72317_d(this.partUpgradeCargo.field_70165_t, this.partUpgradeCargo.field_70163_u, this.partUpgradeCargo.field_70161_v));
            } else {
                this.partUpgradeCargo.func_174826_a(new AxisAlignedBB(this.partUpgradeCargo.field_70165_t, this.partUpgradeCargo.field_70163_u, this.partUpgradeCargo.field_70161_v, this.partUpgradeCargo.field_70165_t, this.partUpgradeCargo.field_70163_u, this.partUpgradeCargo.field_70161_v));
            }
        }
        this.partUpgradeSeat.func_70071_h_();
        this.partUpgradeCargo.func_70071_h_();
        this.partWheelFront.func_70012_b(this.field_70165_t + pos1_x.field_72450_a, wheelHandle ? this.partWheelFront.field_70163_u : this.field_70163_u, this.field_70161_v + pos1_x.field_72449_c, 0.0f, 0.0f);
        this.partWheelFront.func_174826_a(aabb_wheel.func_72317_d(this.partWheelFront.field_70165_t, this.partWheelFront.field_70163_u, this.partWheelFront.field_70161_v));
        if (this.field_70170_p.field_72995_K) {
            Utils.setEntityVelocity((Entity)this.partWheelFront, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        this.partWheelFront.func_70071_h_();
        this.partWheelBack.func_70012_b(this.field_70165_t + pos2_x.field_72450_a, wheelHandle ? this.partWheelBack.field_70163_u : this.field_70163_u, this.field_70161_v + pos2_x.field_72449_c, 0.0f, 0.0f);
        this.partWheelBack.func_174826_a(aabb_wheel.func_72317_d(this.partWheelBack.field_70165_t, this.partWheelBack.field_70163_u, this.partWheelBack.field_70161_v));
        if (this.field_70170_p.field_72995_K) {
            Utils.setEntityVelocity((Entity)this.partWheelBack, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        this.partWheelBack.func_70071_h_();
        this.partEngine.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
        this.partEngine.func_174826_a(aabb_engine.func_72317_d(this.partEngine.field_70165_t, this.partEngine.field_70163_u, this.partEngine.field_70161_v));
        if (this.field_70170_p.field_72995_K) {
            Utils.setEntityVelocity((Entity)this.partEngine, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        this.partEngine.func_70071_h_();
        this.partFuelTank.func_70012_b(this.field_70165_t + pos3_x.field_72450_a, this.field_70163_u + 1.0, this.field_70161_v + pos3_x.field_72449_c, 0.0f, 0.0f);
        this.partFuelTank.func_174826_a(aabb_tank.func_72317_d(this.partFuelTank.field_70165_t, this.partFuelTank.field_70163_u, this.partFuelTank.field_70161_v));
        if (this.field_70170_p.field_72995_K) {
            Utils.setEntityVelocity((Entity)this.partFuelTank, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        this.partFuelTank.func_70071_h_();
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnDebrisExplosion() {
        double true_angle = Math.toRadians(-this.field_70177_z > 180.0f ? (double)(360.0f - -this.field_70177_z) : (double)(-this.field_70177_z));
        double true_angle2 = Math.toRadians(-this.field_70177_z - 90.0f > 180.0f ? (double)(360.0f - (-this.field_70177_z - 90.0f)) : (double)(-this.field_70177_z - 90.0f));
        float tylt = -(this.tilt * (this.speed / 15.0f)) * 45.0f;
        double true_angle4 = Math.toRadians(tylt - 90.0f > 180.0f ? (double)(360.0f - (tylt - 90.0f)) : (double)(tylt - 90.0f));
        ArrayList<ModelRendererTurbo> models = new ArrayList<ModelRendererTurbo>();
        models.addAll(Arrays.asList(MotorbikeRenderer.model.baseModel));
        models.addAll(Arrays.asList(MotorbikeRenderer.model.engineModel));
        models.addAll(Arrays.asList(MotorbikeRenderer.model.exhaustPipesModel));
        models.addAll(Arrays.asList(MotorbikeRenderer.model.steeringGearModel));
        models.addAll(Arrays.asList(MotorbikeRenderer.model.frontThingyModel));
        models.addAll(Arrays.asList(MotorbikeRenderer.model.frontThingyUpperModel));
        models.addAll(Arrays.asList(MotorbikeRenderer.model.backWheelModel));
        models.addAll(Arrays.asList(MotorbikeRenderer.model.frontWheelModel));
        for (ModelRendererTurbo mod : models) {
            Vec3d vx = Utils.offsetPosDirection((float)((double)mod.field_78800_c * 0.0625), -true_angle, 0.0);
            Vec3d vz = Utils.offsetPosDirection((float)((double)(-mod.field_78798_e) * 0.0625), true_angle, 0.0);
            Vec3d vo = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v).func_178787_e(vx).func_178787_e(Utils.offsetPosDirection((float)((double)mod.field_78797_d * 0.0625), -true_angle2, -true_angle4)).func_178787_e(vz);
            Vec3d vecDir = new Vec3d(this.field_70146_Z.nextGaussian() * 0.25, this.field_70146_Z.nextGaussian() * 0.25, this.field_70146_Z.nextGaussian() * 0.025);
            ParticleUtils.spawnTMTModelFX(vo.field_72450_a, vo.field_72448_b, vo.field_72449_c, (vx.field_72450_a + vz.field_72450_a + vecDir.field_72450_a) / 1.5, (0.25 + vecDir.field_72448_b) / 1.5, (vx.field_72449_c + vz.field_72449_c + vecDir.field_72449_c) / 1.5, 0.0625f, mod, MotorbikeRenderer.TEXTURE);
        }
    }

    public void func_184185_a(SoundEvent soundIn, float volume, float pitch) {
        super.func_184185_a(soundIn, volume, pitch);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.field_76373_n.equals("bullet")) {
            DamageSource temp_source = new DamageSource("bullet").func_76349_b().func_76348_h();
            for (EntityVehicleMultiPart part : new EntityVehicleMultiPart[]{this.partWheelFront, this.partWheelBack, this.partFuelTank, this.partEngine}) {
                this.func_70965_a(part, temp_source, amount);
            }
            return true;
        }
        return super.func_70097_a(source, amount);
    }

    static class NonSidedFluidHandler
    implements IFluidHandler {
        EntityMotorbike motorbike;

        NonSidedFluidHandler(EntityMotorbike motorbike) {
            this.motorbike = motorbike;
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (resource == null) {
                return 0;
            }
            if (!DieselHandler.isValidFuel((Fluid)resource.getFluid())) {
                return 0;
            }
            int i = this.motorbike.tank.fill(resource, doFill);
            if (i > 0) {
                this.motorbike.updateTank(false);
            }
            return i;
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (resource == null) {
                return null;
            }
            return this.drain(resource.amount, doDrain);
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            FluidStack f = this.motorbike.tank.drain(maxDrain, doDrain);
            if (f != null && f.amount > 0) {
                this.motorbike.updateTank(false);
            }
            return f;
        }

        public IFluidTankProperties[] getTankProperties() {
            return this.motorbike.tank.getTankProperties();
        }
    }
}

