/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.entity;

import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.EntityArmorInvWrapper;
import net.minecraftforge.items.wrapper.EntityHandsInvWrapper;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.entity.EntityEmplacementWeapon;
import pl.pabilo8.immersiveintelligence.common.entity.EntityFieldHowitzer;
import pl.pabilo8.immersiveintelligence.common.entity.EntityGasCloud;
import pl.pabilo8.immersiveintelligence.common.entity.EntityMachinegun;
import pl.pabilo8.immersiveintelligence.common.entity.EntityMortar;
import pl.pabilo8.immersiveintelligence.common.entity.hans.HansAnimations;
import pl.pabilo8.immersiveintelligence.common.entity.hans.HansPathNavigate;
import pl.pabilo8.immersiveintelligence.common.entity.hans.HansUtils;
import pl.pabilo8.immersiveintelligence.common.entity.hans.tasks.AIHansAlertOthers;
import pl.pabilo8.immersiveintelligence.common.entity.hans.tasks.AIHansBase;
import pl.pabilo8.immersiveintelligence.common.entity.hans.tasks.AIHansClimbLadder;
import pl.pabilo8.immersiveintelligence.common.entity.hans.tasks.AIHansCrewman;
import pl.pabilo8.immersiveintelligence.common.entity.hans.tasks.AIHansHolsterWeapon;
import pl.pabilo8.immersiveintelligence.common.entity.hans.tasks.AIHansHowitzer;
import pl.pabilo8.immersiveintelligence.common.entity.hans.tasks.AIHansMachinegun;
import pl.pabilo8.immersiveintelligence.common.entity.hans.tasks.AIHansMortar;
import pl.pabilo8.immersiveintelligence.common.entity.hans.tasks.AIHansOpenDoor;
import pl.pabilo8.immersiveintelligence.common.entity.hans.tasks.hand_weapon.AIHansHandWeapon;
import pl.pabilo8.immersiveintelligence.common.entity.hans.tasks.idle.AIHansIdle;
import pl.pabilo8.immersiveintelligence.common.entity.hans.tasks.idle.AIHansKazachok;
import pl.pabilo8.immersiveintelligence.common.entity.hans.tasks.idle.AIHansSalute;
import pl.pabilo8.immersiveintelligence.common.entity.hans.tasks.idle.AIHansTimedLookAtEntity;
import pl.pabilo8.immersiveintelligence.common.items.armor.ItemIILightEngineerHelmet;

public class EntityHans
extends EntityCreature
implements INpc {
    private static final int[] EYE_COLOURS = new int[]{5861753, 5465465, 4744313, 4159835, 3897689, 5536091, 4278322, 4016167, 10320214, 4407609, 4736825, 3092008};
    private static final DataParameter<String> DATA_MARKER_LEG_ANIMATION = EntityDataManager.func_187226_a(EntityHans.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> DATA_MARKER_ARM_ANIMATION = EntityDataManager.func_187226_a(EntityHans.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> DATA_MARKER_EYE_COLOUR = EntityDataManager.func_187226_a(EntityHans.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<NBTTagCompound> DATA_MARKER_SPEECH = EntityDataManager.func_187226_a(EntityHans.class, (DataSerializer)DataSerializers.field_192734_n);
    public HansAnimations.HansLegAnimation prevLegAnimation = HansAnimations.HansLegAnimation.STANDING;
    public HansAnimations.HansLegAnimation legAnimation = HansAnimations.HansLegAnimation.STANDING;
    public int legAnimationTimer = 0;
    public HansAnimations.HansArmAnimation prevArmAnimation = HansAnimations.HansArmAnimation.NORMAL;
    public HansAnimations.HansArmAnimation armAnimation = HansAnimations.HansArmAnimation.NORMAL;
    public int armAnimationTimer = 8;
    public HansAnimations.EyeEmotions eyeEmotion = HansAnimations.EyeEmotions.NEUTRAL;
    public HansAnimations.MouthEmotions mouthEmotion = HansAnimations.MouthEmotions.NEUTRAL;
    public HansAnimations.MouthShapes mouthShape = HansAnimations.MouthShapes.CLOSED;
    public ArrayList<Tuple<Integer, HansAnimations.MouthShapes>> mouthShapeQueue = new ArrayList();
    public int speechProgress = 0;
    public int eyeColour;
    public static final float MELEE_DISTANCE = 1.25f;
    private EntityAIBase vehicleTask = null;
    private AIHansHandWeapon weaponTask = null;
    private AIHansOpenDoor doorTask = null;
    public boolean commander = false;
    public boolean enemyContact = false;
    public boolean hasAmmo = true;
    public final NonNullList<ItemStack> mainInventory = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
    private final IItemHandlerModifiable handHandler = new EntityHandsInvWrapper((EntityLivingBase)this);
    private final IItemHandlerModifiable armorHandler = new EntityArmorInvWrapper((EntityLivingBase)this);
    private final IItemHandlerModifiable invHandler = new ItemStackHandler(this.mainInventory);
    private final IItemHandler joinedHandler = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.armorHandler, this.handHandler, this.invHandler});

    public EntityHans(World worldIn) {
        super(worldIn);
        this.func_110163_bv();
        this.func_70095_a(false);
        this.field_70180_af.func_187214_a(DATA_MARKER_LEG_ANIMATION, (Object)this.legAnimation.name().toLowerCase());
        this.field_70180_af.func_187214_a(DATA_MARKER_ARM_ANIMATION, (Object)this.armAnimation.name().toLowerCase());
        this.eyeColour = EYE_COLOURS[this.field_70146_Z.nextInt(EYE_COLOURS.length)];
        this.field_70180_af.func_187214_a(DATA_MARKER_EYE_COLOUR, (Object)this.eyeColour);
        this.field_70180_af.func_187214_a(DATA_MARKER_SPEECH, (Object)new NBTTagCompound());
        this.func_70606_j(20.0f);
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new HansPathNavigate(this, this.field_70170_p);
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70180_af.func_187223_a()) {
                this.eyeColour = (Integer)this.field_70180_af.func_187225_a(DATA_MARKER_EYE_COLOUR);
                this.legAnimation = this.getLegAnimationFromString((String)this.field_70180_af.func_187225_a(DATA_MARKER_LEG_ANIMATION));
                this.armAnimation = this.getArmAnimationFromString((String)this.field_70180_af.func_187225_a(DATA_MARKER_ARM_ANIMATION));
                NBTTagCompound speech = (NBTTagCompound)this.field_70180_af.func_187225_a(DATA_MARKER_SPEECH);
                if (this.mouthShapeQueue.size() == 0) {
                    NBTTagList durations = speech.func_150295_c("durations", 3);
                    NBTTagList shapes = speech.func_150295_c("shapes", 8);
                    for (int i = 0; i < durations.func_74745_c(); ++i) {
                        NBTTagString s = (NBTTagString)shapes.func_179238_g(i);
                        NBTTagInt d = (NBTTagInt)durations.func_179238_g(i);
                        this.mouthShapeQueue.add((Tuple<Integer, HansAnimations.MouthShapes>)new Tuple((Object)d.func_150287_d(), (Object)HansAnimations.MouthShapes.v(s.func_150285_a_())));
                    }
                    this.field_70180_af.func_187227_b(DATA_MARKER_SPEECH, (Object)new NBTTagCompound());
                }
            }
            this.handleSpeech();
            if (this.func_70638_az() != null) {
                this.eyeEmotion = HansAnimations.EyeEmotions.FROWNING;
                this.mouthEmotion = HansAnimations.MouthEmotions.ANGRY;
            } else {
                float hp;
                this.mouthEmotion = HansAnimations.MouthEmotions.ANGRY;
                if (this.legAnimation == HansAnimations.HansLegAnimation.KAZACHOK) {
                    this.mouthEmotion = HansAnimations.MouthEmotions.HAPPY;
                }
                this.eyeEmotion = (double)(hp = this.func_110143_aJ() / this.func_110138_aP()) > 0.75 || this.legAnimation == HansAnimations.HansLegAnimation.KAZACHOK ? HansAnimations.EyeEmotions.HAPPY : ((double)hp > 0.5 ? HansAnimations.EyeEmotions.NEUTRAL : HansAnimations.EyeEmotions.FROWNING);
            }
        } else {
            this.field_70180_af.func_187227_b(DATA_MARKER_EYE_COLOUR, (Object)this.eyeColour);
            if (this.field_70173_aa % 25 == 0) {
                this.enemyContact = this.field_70170_p.func_175647_a(Entity.class, new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t, this.field_70163_u, this.field_70161_v).func_186662_g(14.0), this::isValidTarget).stream().findAny().isPresent();
            }
            HansAnimations.HansLegAnimation currentLeg = this.legAnimation;
            HansAnimations.HansArmAnimation currentArm = this.armAnimation;
            this.legAnimation = this.func_70090_H() ? HansAnimations.HansLegAnimation.SWIMMING : HansAnimations.HansLegAnimation.STANDING;
            this.armAnimation = HansAnimations.HansArmAnimation.NORMAL;
            this.field_70714_bg.field_75782_a.removeIf(entry -> entry.field_75733_a instanceof AIHansBase && ((AIHansBase)entry.field_75733_a).shouldBeRemoved());
            for (EntityAITasks.EntityAITaskEntry entry2 : this.field_70714_bg.field_75782_a) {
                if (!(entry2.field_75733_a instanceof AIHansBase)) continue;
                ((AIHansBase)entry2.field_75733_a).setRequiredAnimation();
            }
            if (currentLeg != this.legAnimation) {
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.getWalkSpeed());
                this.field_70180_af.func_187227_b(DATA_MARKER_LEG_ANIMATION, (Object)this.legAnimation.name().toLowerCase());
            }
            if (currentArm != this.armAnimation) {
                this.field_70180_af.func_187227_b(DATA_MARKER_ARM_ANIMATION, (Object)this.armAnimation.name().toLowerCase());
            }
        }
        this.func_184614_ca().func_77973_b().func_77663_a(this.func_184614_ca(), this.field_70170_p, (Entity)this, 0, true);
        if (this.prevLegAnimation != this.legAnimation) {
            if (this.legAnimationTimer > 0) {
                --this.legAnimationTimer;
            } else {
                this.legAnimationTimer = 8;
                this.prevLegAnimation = this.legAnimation;
                this.func_70105_a(this.legAnimation.aabbWidth, this.legAnimation.aabbHeight);
            }
        }
        if (this.prevArmAnimation != this.armAnimation) {
            if (this.armAnimationTimer > 0) {
                --this.armAnimationTimer;
            } else {
                this.armAnimationTimer = 8;
                this.prevArmAnimation = this.armAnimation;
            }
        }
    }

    private void handleSpeech() {
        if (this.mouthShapeQueue.size() > 0) {
            if (this.speechProgress++ >= (Integer)this.mouthShapeQueue.get(0).func_76341_a()) {
                this.mouthShape = (HansAnimations.MouthShapes)((Object)this.mouthShapeQueue.get(0).func_76340_b());
                this.mouthShapeQueue.remove(0);
                this.speechProgress = 0;
            }
        } else {
            this.mouthShape = HansAnimations.MouthShapes.CLOSED;
            this.speechProgress = 0;
        }
    }

    private double getWalkSpeed() {
        return 0.25 * (double)this.legAnimation.walkSpeedModifier;
    }

    private HansAnimations.HansLegAnimation getLegAnimationFromString(String s) {
        return Arrays.stream(HansAnimations.HansLegAnimation.values()).filter(anim -> s.equalsIgnoreCase(anim.name())).findFirst().orElse(HansAnimations.HansLegAnimation.STANDING);
    }

    private HansAnimations.HansArmAnimation getArmAnimationFromString(String s) {
        return Arrays.stream(HansAnimations.HansArmAnimation.values()).filter(anim -> s.equalsIgnoreCase(anim.name())).findFirst().orElse(HansAnimations.HansArmAnimation.NORMAL);
    }

    @Nonnull
    public HansPathNavigate getNavigator() {
        return (HansPathNavigate)super.func_70661_as();
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 1, false, false, input -> input.func_70089_S() && (input instanceof IMob || input.func_70638_az() == this)));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 1, false, false, input -> input != null && this.isValidTarget((Entity)input)));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new AIHansAlertOthers(this, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIHansHolsterWeapon(this));
        this.updateWeaponTasks();
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityGasCloud.class, 8.0f, (double)0.6f, (double)0.7f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new AIHansIdle(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 6.0f));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIHansClimbLadder(this));
        this.doorTask = new AIHansOpenDoor(this, true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)this.doorTask);
    }

    public double getSprintSpeed() {
        return this.getWalkSpeed() * 1.25;
    }

    public void updateWeaponTasks() {
        if (this.weaponTask != null) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.weaponTask);
        }
        this.weaponTask = HansUtils.getHandWeaponTask(this);
        if (this.weaponTask != null) {
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.weaponTask);
        }
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.125, true));
    }

    public boolean func_184220_m(@Nonnull Entity entity) {
        if (super.func_184220_m(entity)) {
            if (entity instanceof EntityMachinegun) {
                this.vehicleTask = new AIHansMachinegun((EntityLiving)this);
                this.field_70714_bg.func_75776_a(0, this.vehicleTask);
            } else if (entity instanceof EntityMortar) {
                this.vehicleTask = new AIHansMortar((EntityLiving)this);
                this.field_70714_bg.func_75776_a(0, this.vehicleTask);
            } else if (entity.func_184208_bv() instanceof EntityFieldHowitzer) {
                this.vehicleTask = new AIHansHowitzer((EntityLiving)this);
                this.field_70714_bg.func_75776_a(0, this.vehicleTask);
            }
            return true;
        }
        return false;
    }

    public boolean markCrewman(@Nonnull Entity entity) {
        if (this.vehicleTask != null) {
            return false;
        }
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIHansCrewman(this, entity));
        return true;
    }

    public void func_110145_l(@Nonnull Entity entity) {
        super.func_110145_l(entity);
        if (this.vehicleTask != null) {
            this.field_70714_bg.func_85156_a(this.vehicleTask);
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                return (T)this.joinedHandler;
            }
            if (facing.func_176740_k().func_176720_b()) {
                return (T)this.handHandler;
            }
            if (facing.func_176740_k().func_176722_c()) {
                return (T)this.armorHandler;
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_70037_a(@Nonnull NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.readInventory(compound.func_150295_c("npc_inventory", 10));
        if (compound.func_74764_b("HandItems")) {
            NBTTagList handInventory = compound.func_150295_c("HandItems", 10);
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((NBTTagCompound)handInventory.func_179238_g(0)));
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack((NBTTagCompound)handInventory.func_179238_g(1)));
        }
        this.legAnimation = this.getLegAnimationFromString(compound.func_74779_i("leg_animation"));
        this.armAnimation = this.getArmAnimationFromString(compound.func_74779_i("arm_animation"));
        this.eyeColour = compound.func_74762_e("eye_colour");
        this.commander = compound.func_74767_n("commander");
        this.updateWeaponTasks();
    }

    public void func_70014_b(@Nonnull NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74782_a("npc_inventory", (NBTBase)Utils.writeInventory(this.mainInventory));
        compound.func_74778_a("leg_animation", this.legAnimation.name().toLowerCase());
        compound.func_74778_a("arm_animation", this.armAnimation.name().toLowerCase());
        compound.func_74768_a("eye_colour", this.eyeColour);
        compound.func_74757_a("commander", this.commander);
    }

    private void readInventory(NBTTagList npc_inventory) {
        int max = npc_inventory.func_74745_c();
        for (int i = 0; i < max; ++i) {
            NBTTagCompound itemTag = npc_inventory.func_150305_b(i);
            int slot = itemTag.func_74771_c("Slot") & 0xFF;
            if (slot >= this.mainInventory.size()) continue;
            this.mainInventory.set(slot, (Object)new ItemStack(itemTag));
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(52.0);
    }

    public boolean func_70652_k(Entity entityIn) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)(1 + this.field_70146_Z.nextInt(2)));
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        this.func_184185_a(SoundEvents.field_187727_dV, 1.0f, 1.0f);
        return flag;
    }

    protected boolean func_184645_a(EntityPlayer player, @Nonnull EnumHand hand) {
        return !player.func_175149_v() && hand == EnumHand.MAIN_HAND && player.func_174791_d().func_72438_d(this.func_174791_d()) <= 1.0;
    }

    @Nonnull
    public EnumActionResult func_184199_a(EntityPlayer player, @Nonnull Vec3d vec, @Nonnull EnumHand hand) {
        if (player.func_175149_v() || hand == EnumHand.OFF_HAND) {
            return EnumActionResult.FAIL;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70126_B = this.field_70759_as;
            this.field_70177_z = this.field_70759_as;
            ItemStack heldItem = player.func_184586_b(hand);
            if (heldItem.func_190926_b()) {
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIHansSalute(this, (Entity)player));
                this.greetPlayer(player);
            } else if (this.field_70714_bg.field_75782_a.stream().noneMatch(entry -> entry.field_75733_a instanceof AIHansKazachok) && Utils.isFluidRelatedItemStack((ItemStack)heldItem)) {
                FluidStack drain;
                IFluidHandlerItem capability = (IFluidHandlerItem)heldItem.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                if (capability != null && (drain = capability.drain(new FluidStack(IEContent.fluidEthanol, 1000), false)) != null) {
                    this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIHansTimedLookAtEntity(this, (Entity)player, 60, 1.0f));
                    this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIHansKazachok(this, (float)drain.amount / 1000.0f));
                }
            } else if (IIContent.itemSubmachinegun.isAmmo(heldItem, this.func_184607_cu())) {
                for (int i = 0; i < this.mainInventory.size() && !heldItem.func_190926_b(); ++i) {
                    heldItem = this.invHandler.insertItem(i, heldItem.func_77946_l(), false);
                }
                if (heldItem.func_190926_b()) {
                    this.sendPlayerMessage(player, "Danke f\u00c3\u00bcr diese neue Patronen. Meine Maschinenpistole war sehr hungrig!");
                } else {
                    this.sendPlayerMessage(player, "Danke f\u00c3\u00bcr diese neue Patronen, aber habe ich sie genug.");
                }
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIHansTimedLookAtEntity(this, (Entity)player, 60, 1.0f));
            }
            player.func_184611_a(EnumHand.MAIN_HAND, heldItem);
            player.func_184609_a(hand);
        } else if (this.mouthShapeQueue.size() > 0) {
            return EnumActionResult.PASS;
        }
        return EnumActionResult.PASS;
    }

    private void greetPlayer(EntityPlayer player) {
        this.sendPlayerMessage(player, String.format("Guten %1$s, %2$s!", HansUtils.getGermanTimeName(this.field_70170_p.func_72820_D()), player.func_70005_c_()));
        this.mouthShapeQueue.clear();
        this.speechProgress = 0;
        HansAnimations.putMouthShape(this, 'X', 0.0, 0.35);
        HansAnimations.putMouthShape(this, 'F', 0.35, 0.63);
        HansAnimations.putMouthShape(this, 'B', 0.63, 0.7);
        HansAnimations.putMouthShape(this, 'C', 0.7, 0.84);
        HansAnimations.putMouthShape(this, 'B', 0.84, 0.98);
        HansAnimations.putMouthShape(this, 'X', 0.98, 1.27);
        HansAnimations.putMouthShape(this, 'B', 1.27, 1.34);
        HansAnimations.putMouthShape(this, 'A', 1.34, 1.4);
        HansAnimations.putMouthShape(this, 'C', 1.4, 1.45);
        HansAnimations.putMouthShape(this, 'B', 1.45, 0.63);
        HansAnimations.putMouthShape(this, 'E', 1.56, 0.63);
        HansAnimations.putMouthShape(this, 'A', 1.63, 1.72);
        HansAnimations.putMouthShape(this, 'E', 1.72, 1.84);
        HansAnimations.putMouthShape(this, 'D', 1.84, 2.12);
        HansAnimations.putMouthShape(this, 'C', 2.12, 2.19);
        HansAnimations.putMouthShape(this, 'B', 2.19, 2.4);
        HansAnimations.putMouthShape(this, 'X', 2.4, 2.97);
        HansAnimations.putMouthShape(this, 'A', 2.97, 3.1);
        this.field_70180_af.func_187227_b(DATA_MARKER_SPEECH, (Object)this.createServerSpeechTagCompound());
    }

    @Nonnull
    private NBTTagCompound createServerSpeechTagCompound() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList durations = new NBTTagList();
        NBTTagList shapes = new NBTTagList();
        for (Tuple<Integer, HansAnimations.MouthShapes> element : this.mouthShapeQueue) {
            durations.func_74742_a((NBTBase)new NBTTagInt(((Integer)element.func_76341_a()).intValue()));
            shapes.func_74742_a((NBTBase)new NBTTagString(((HansAnimations.MouthShapes)((Object)element.func_76340_b())).name()));
        }
        tag.func_74782_a("durations", (NBTBase)durations);
        tag.func_74782_a("shapes", (NBTBase)shapes);
        this.mouthShapeQueue.clear();
        return tag;
    }

    public HoverEvent func_174823_aP() {
        return super.func_174823_aP();
    }

    public boolean isValidTarget(Entity entity) {
        return entity instanceof IMob || (entity instanceof EntityPlayer || entity instanceof EntityHans || entity instanceof EntityEmplacementWeapon || entity instanceof EntityIronGolem) && entity.func_96124_cp() != this.func_96124_cp();
    }

    public void sendPlayerMessage(EntityPlayer player, String text) {
        ItemStack helmet = this.func_184582_a(EntityEquipmentSlot.HEAD);
        if (helmet.func_77973_b() instanceof ItemIILightEngineerHelmet && IIContent.itemLightEngineerHelmet.getUpgrades(helmet).func_74764_b("gasmask")) {
            ChatUtils.sendServerNoSpamMessages((EntityPlayer)player, (ITextComponent[])new ITextComponent[]{new TextComponentTranslation("chat.type.text", new Object[]{this.func_145748_c_(), ForgeHooks.newChatWithLinks((String)"*Hans Gasmask Noises*")})});
        } else {
            ChatUtils.sendServerNoSpamMessages((EntityPlayer)player, (ITextComponent[])new ITextComponent[]{new TextComponentTranslation("chat.type.text", new Object[]{this.func_145748_c_(), ForgeHooks.newChatWithLinks((String)text)})});
        }
    }

    protected SoundEvent func_184601_bQ(@Nonnull DamageSource damageSourceIn) {
        if (damageSourceIn == DamageSource.field_76370_b) {
            return SoundEvents.field_193806_fH;
        }
        return damageSourceIn == DamageSource.field_76369_e ? SoundEvents.field_193805_fG : SoundEvents.field_187800_eb;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187798_ea;
    }

    @Nonnull
    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_187808_ef;
    }

    @Nonnull
    protected SoundEvent func_184181_aa() {
        return SoundEvents.field_187806_ee;
    }

    @Nonnull
    protected SoundEvent func_184588_d(int heightIn) {
        return heightIn > 4 ? SoundEvents.field_187736_dY : SoundEvents.field_187804_ed;
    }

    public HansAnimations.HansLegAnimation getLegAnimation() {
        return this.legAnimation == HansAnimations.HansLegAnimation.STANDING && this.func_70093_af() ? HansAnimations.HansLegAnimation.SNEAKING : this.legAnimation;
    }

    public AIHansOpenDoor getDoorTask() {
        return this.doorTask;
    }
}

