/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.entity;

import blusunrize.immersiveengineering.client.ClientUtils;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.bullets.BulletHelper;
import pl.pabilo8.immersiveintelligence.api.utils.IAdvancedZoomTool;
import pl.pabilo8.immersiveintelligence.api.utils.IEntitySpecialRepairable;
import pl.pabilo8.immersiveintelligence.api.utils.IEntityZoomProvider;
import pl.pabilo8.immersiveintelligence.api.utils.vehicles.ITowable;
import pl.pabilo8.immersiveintelligence.api.utils.vehicles.IVehicleMultiPart;
import pl.pabilo8.immersiveintelligence.client.ClientProxy;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.IISounds;
import pl.pabilo8.immersiveintelligence.common.entity.EntityVehicleMultiPart;
import pl.pabilo8.immersiveintelligence.common.entity.EntityVehicleSeat;
import pl.pabilo8.immersiveintelligence.common.entity.EntityVehicleWheel;
import pl.pabilo8.immersiveintelligence.common.entity.bullets.EntityBullet;
import pl.pabilo8.immersiveintelligence.common.network.IIPacketHandler;
import pl.pabilo8.immersiveintelligence.common.network.MessageEntityNBTSync;

public class EntityFieldHowitzer
extends Entity
implements IVehicleMultiPart,
IEntitySpecialRepairable,
ITowable,
IEntityZoomProvider {
    private static final DataParameter<Boolean> dataMarkerForward = EntityDataManager.func_187226_a(EntityFieldHowitzer.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> dataMarkerBackward = EntityDataManager.func_187226_a(EntityFieldHowitzer.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> dataMarkerTurnLeft = EntityDataManager.func_187226_a(EntityFieldHowitzer.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> dataMarkerTurnRight = EntityDataManager.func_187226_a(EntityFieldHowitzer.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> dataMarkerGunPitchUp = EntityDataManager.func_187226_a(EntityFieldHowitzer.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> dataMarkerGunPitchDown = EntityDataManager.func_187226_a(EntityFieldHowitzer.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> dataMarkerAcceleration = EntityDataManager.func_187226_a(EntityFieldHowitzer.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> dataMarkerSpeed = EntityDataManager.func_187226_a(EntityFieldHowitzer.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> dataMarkerShootingProgress = EntityDataManager.func_187226_a(EntityFieldHowitzer.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> dataMarkerReloadProgress = EntityDataManager.func_187226_a(EntityFieldHowitzer.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> dataMarkerGunPitch = EntityDataManager.func_187226_a(EntityFieldHowitzer.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> dataMarkerWheelRightDurability = EntityDataManager.func_187226_a(EntityFieldHowitzer.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> dataMarkerWheelLeftDurability = EntityDataManager.func_187226_a(EntityFieldHowitzer.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> dataMarkerMainDurability = EntityDataManager.func_187226_a(EntityFieldHowitzer.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> dataMarkerGunDurability = EntityDataManager.func_187226_a(EntityFieldHowitzer.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> dataMarkerShieldDurability = EntityDataManager.func_187226_a(EntityFieldHowitzer.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<NBTTagCompound> dataMarkerShell = EntityDataManager.func_187226_a(EntityFieldHowitzer.class, (DataSerializer)DataSerializers.field_192734_n);
    public int rightWheelDurability;
    public int leftWheelDurability;
    public int mainDurability;
    public int gunDurability;
    public int shieldDurability;
    public int setupTime = 0;
    public boolean alreadyShoot = false;
    public boolean towingOperation = false;
    public float acceleration = 0.0f;
    public float speed = 0.0f;
    public ItemStack shell = ItemStack.field_190927_a;
    public float shootingProgress = 0.0f;
    public float reloadProgress = 0.0f;
    public float gunPitch = 0.0f;
    public boolean forward = false;
    public boolean backward = false;
    public boolean turnLeft = false;
    public boolean turnRight = false;
    public boolean reloadKeyPress = false;
    public boolean fireKeyPress = false;
    public boolean gunPitchUp = false;
    public boolean gunPitchDown = false;
    public EntityVehicleMultiPart[] partArray;
    public EntityVehicleWheel partWheelRight = new EntityVehicleWheel(this, "wheel_right", 1.0f, 1.0f);
    public EntityVehicleWheel partWheelLeft = new EntityVehicleWheel(this, "wheel_left", 1.0f, 1.0f);
    public EntityVehicleMultiPart partMain = new EntityVehicleMultiPart(this, "main", 1.0f, 1.0f);
    public EntityVehicleMultiPart partMain2 = new EntityVehicleMultiPart(this, "main2", 1.0f, 1.0f);
    public EntityVehicleMultiPart partGun = new EntityVehicleMultiPart(this, "gun", 1.0f, 1.0f);
    public EntityVehicleMultiPart partShieldRight = new EntityVehicleMultiPart(this, "shield_right", 1.0f, 1.0f);
    public EntityVehicleMultiPart partShieldLeft = new EntityVehicleMultiPart(this, "shield_left", 1.0f, 1.0f);
    public int destroyTimer = -1;
    static final AxisAlignedBB AABB = new AxisAlignedBB(-1.5, 0.0, -1.5, 1.5, 1.75, 1.5);
    static final AxisAlignedBB AABB_WHEEL = new AxisAlignedBB(-0.25, 0.0, 0.25, 0.25, 1.0, -0.25);
    static final AxisAlignedBB AABB_MAIN = new AxisAlignedBB(-0.5, 0.125, -0.5, 0.5, 0.625, 0.5);
    static final AxisAlignedBB AABB_GUN = new AxisAlignedBB(-0.35, 0.25, 0.35, 0.35, 1.0, -0.35);
    static final AxisAlignedBB AABB_SHIELD = new AxisAlignedBB(-0.35, 0.0, -0.35, 0.35, 1.25, 0.35);

    public EntityFieldHowitzer(World worldIn) {
        super(worldIn);
        this.partArray = new EntityVehicleMultiPart[]{this.partWheelRight, this.partWheelLeft, this.partMain, this.partMain2, this.partGun, this.partShieldRight, this.partShieldLeft};
        this.rightWheelDurability = Config.IIConfig.Vehicles.FieldHowitzer.wheelDurability;
        this.leftWheelDurability = Config.IIConfig.Vehicles.FieldHowitzer.wheelDurability;
        this.mainDurability = Config.IIConfig.Vehicles.FieldHowitzer.mainDurability;
        this.gunDurability = Config.IIConfig.Vehicles.FieldHowitzer.gunDurability;
        this.shieldDurability = Config.IIConfig.Vehicles.FieldHowitzer.shieldDurability;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(dataMarkerForward, (Object)this.forward);
        this.field_70180_af.func_187214_a(dataMarkerBackward, (Object)this.backward);
        this.field_70180_af.func_187214_a(dataMarkerTurnLeft, (Object)this.turnLeft);
        this.field_70180_af.func_187214_a(dataMarkerTurnRight, (Object)this.turnRight);
        this.field_70180_af.func_187214_a(dataMarkerGunPitchUp, (Object)this.gunPitchUp);
        this.field_70180_af.func_187214_a(dataMarkerGunPitchDown, (Object)this.gunPitchDown);
        this.field_70180_af.func_187214_a(dataMarkerAcceleration, (Object)Float.valueOf(this.acceleration));
        this.field_70180_af.func_187214_a(dataMarkerSpeed, (Object)Float.valueOf(this.speed));
        this.field_70180_af.func_187214_a(dataMarkerShootingProgress, (Object)Float.valueOf(this.shootingProgress));
        this.field_70180_af.func_187214_a(dataMarkerReloadProgress, (Object)Float.valueOf(this.reloadProgress));
        this.field_70180_af.func_187214_a(dataMarkerGunPitch, (Object)Float.valueOf(this.gunPitch));
        this.field_70180_af.func_187214_a(dataMarkerWheelRightDurability, (Object)this.rightWheelDurability);
        this.field_70180_af.func_187214_a(dataMarkerWheelLeftDurability, (Object)this.leftWheelDurability);
        this.field_70180_af.func_187214_a(dataMarkerMainDurability, (Object)this.mainDurability);
        this.field_70180_af.func_187214_a(dataMarkerGunDurability, (Object)this.gunDurability);
        this.field_70180_af.func_187214_a(dataMarkerShieldDurability, (Object)this.shieldDurability);
        this.field_70180_af.func_187214_a(dataMarkerShell, (Object)ItemStack.field_190927_a.serializeNBT());
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.forward = compound.func_74767_n("forward");
        this.backward = compound.func_74767_n("backward");
        this.turnLeft = compound.func_74767_n("turnLeft");
        this.turnRight = compound.func_74767_n("turnRight");
        this.gunPitchUp = compound.func_74767_n("gunPitchUp");
        this.gunPitchDown = compound.func_74767_n("gunPitchDown");
        this.acceleration = compound.func_74760_g("acceleration");
        this.speed = compound.func_74760_g("speed");
        this.shootingProgress = compound.func_74760_g("shootingProgress");
        this.reloadProgress = compound.func_74760_g("reloadProgress");
        this.gunPitch = compound.func_74760_g("gunPitch");
        this.shell = new ItemStack(compound.func_74775_l("shell"));
        if (compound.func_74764_b("rightWheelDurability")) {
            this.rightWheelDurability = compound.func_74762_e("rightWheelDurability");
        }
        if (compound.func_74764_b("leftWheelDurability")) {
            this.leftWheelDurability = compound.func_74762_e("leftWheelDurability");
        }
        if (compound.func_74764_b("mainDurability")) {
            this.mainDurability = compound.func_74762_e("mainDurability");
        }
        if (compound.func_74764_b("gunDurability")) {
            this.gunDurability = compound.func_74762_e("gunDurability");
        }
        if (compound.func_74764_b("shieldDurability")) {
            this.shieldDurability = compound.func_74762_e("shieldDurability");
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74757_a("forward", this.forward);
        compound.func_74757_a("backward", this.backward);
        compound.func_74757_a("turnLeft", this.turnLeft);
        compound.func_74757_a("turnRight", this.turnRight);
        compound.func_74757_a("gunPitchUp", this.gunPitchUp);
        compound.func_74757_a("gunPitchDown", this.gunPitchDown);
        compound.func_74776_a("acceleration", this.acceleration);
        compound.func_74776_a("speed", this.speed);
        compound.func_74776_a("shootingProgress", this.shootingProgress);
        compound.func_74776_a("reloadProgress", this.reloadProgress);
        compound.func_74776_a("gunPitch", this.gunPitch);
        compound.func_74782_a("shell", (NBTBase)this.shell.serializeNBT());
        compound.func_74768_a("rightWheelDurability", this.rightWheelDurability);
        compound.func_74768_a("leftWheelDurability", this.leftWheelDurability);
        compound.func_74768_a("mainDurability", this.mainDurability);
        compound.func_74768_a("gunDurability", this.gunDurability);
        compound.func_74768_a("shieldDurability", this.shieldDurability);
    }

    public AxisAlignedBB func_174813_aQ() {
        return AABB.func_72317_d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return null;
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return this.func_174813_aQ();
    }

    public void func_70071_h_() {
        Entity entity;
        EntityVehicleSeat seat;
        if (this.field_70148_d && !this.field_70170_p.field_72995_K) {
            EntityVehicleSeat.getOrCreateSeat(this, 0);
            EntityVehicleSeat.getOrCreateSeat(this, 1);
        }
        if (!this.field_70170_p.field_72995_K && this.mainDurability <= 0) {
            this.func_70106_y();
        }
        if (this.towingOperation) {
            this.acceleration = Math.round((this.acceleration - Math.signum(this.acceleration) * 2.0f) / 2.0f) * 2;
            ++this.setupTime;
            if (this.setupTime > Config.IIConfig.Vehicles.FieldHowitzer.towingTime) {
                this.towingOperation = false;
            }
        } else if (!this.func_184218_aH()) {
            if (this.field_70170_p.field_72995_K) {
                Entity pre = ClientUtils.mc().field_71439_g.func_184187_bx();
                if (pre instanceof EntityVehicleSeat && pre.func_184187_bx() == this) {
                    int seat2 = ((EntityVehicleSeat)pre).seatID;
                    this.handleClientKeyInput(seat2);
                    this.handleClientKeyOutput(seat2);
                } else {
                    this.handleClientKeyOutput(-1);
                }
            } else {
                this.handleServerKeyInput();
                if (EntityVehicleSeat.getOrCreateSeat(this, 0).func_184188_bt().size() == 0) {
                    this.gunPitchUp = false;
                    this.gunPitchDown = false;
                    this.reloadProgress = 0.0f;
                    this.shootingProgress = 0.0f;
                }
                if (EntityVehicleSeat.getOrCreateSeat(this, 1).func_184188_bt().size() == 0) {
                    this.forward = false;
                    this.backward = false;
                    this.turnLeft = false;
                    this.turnRight = false;
                }
            }
        }
        if (!this.towingOperation) {
            if (this.forward || this.backward || this.turnLeft || this.turnRight) {
                if (this.setupTime < Config.IIConfig.Vehicles.FieldHowitzer.setupTime) {
                    ++this.setupTime;
                } else if (this.shootingProgress == 0.0f && this.reloadProgress == 0.0f) {
                    if (this.turnLeft) {
                        this.partWheelLeft.wheelTraverse = (int)((float)this.partWheelLeft.wheelTraverse + 1.5f);
                        this.partWheelRight.wheelTraverse = (int)((float)this.partWheelRight.wheelTraverse - 1.5f);
                        this.turnTowards(-5.0f, 0.0f);
                    } else if (this.turnRight) {
                        this.partWheelRight.wheelTraverse = (int)((float)this.partWheelRight.wheelTraverse + 1.5f);
                        this.partWheelLeft.wheelTraverse = (int)((float)this.partWheelLeft.wheelTraverse - 1.5f);
                        this.turnTowards(5.0f, 0.0f);
                    } else {
                        this.acceleration = this.forward ? Math.min(this.acceleration + 0.1f, 1.0f) : Math.max(this.acceleration - 0.15f, -1.0f);
                    }
                }
            } else {
                this.setupTime = Math.max(this.setupTime - 1, 0);
                this.acceleration *= 0.25f;
                if ((double)Math.abs(this.acceleration) < 0.15) {
                    this.acceleration = 0.0f;
                }
                if (this.setupTime == 0) {
                    if (this.gunPitchUp) {
                        this.gunPitch = Math.min(this.gunPitch + 0.5f, 85.0f);
                    } else if (this.gunPitchDown) {
                        this.gunPitch = Math.max(this.gunPitch - 0.5f, -5.0f);
                    }
                }
            }
        }
        if (this.reloadProgress == 0.0f && !this.shell.func_190926_b()) {
            if (this.fireKeyPress && this.shootingProgress == 0.0f) {
                this.shootingProgress = 1.0f;
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70180_af.func_187227_b(dataMarkerShootingProgress, (Object)Float.valueOf(this.shootingProgress));
                    this.field_70180_af.func_187227_b(dataMarkerShell, (Object)this.shell.serializeNBT());
                    this.field_70180_af.func_187217_b(dataMarkerShell);
                }
            } else if (this.shootingProgress > 0.0f && this.shootingProgress < (float)Config.IIConfig.Vehicles.FieldHowitzer.fireTime) {
                this.shootingProgress += 1.0f;
                if (!this.field_70170_p.field_72995_K && !this.alreadyShoot && (double)this.shootingProgress > (double)Config.IIConfig.Vehicles.FieldHowitzer.fireTime * 0.6) {
                    double true_angle = Math.toRadians(-this.field_70177_z);
                    double true_angle2 = Math.toRadians(180.0f + this.gunPitch);
                    Vec3d gun_end = Utils.offsetPosDirection(2.0f, true_angle, true_angle2);
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, IISounds.howitzer_shot, SoundCategory.PLAYERS, 1.25f, 0.5f);
                        EntityBullet a = BulletHelper.createBullet(this.field_70170_p, this.shell.func_77946_l(), this.func_174791_d().func_178787_e(gun_end.func_186678_a(-1.0)).func_72441_c(0.0, 1.0, 0.0), gun_end.func_186678_a(-1.0).func_72432_b());
                        a.setShooters(this, this.func_70021_al());
                        this.field_70170_p.func_72838_d((Entity)a);
                    }
                    this.alreadyShoot = true;
                }
            } else if (this.shootingProgress >= (float)Config.IIConfig.Vehicles.FieldHowitzer.fireTime) {
                this.alreadyShoot = false;
                if (!this.field_70170_p.field_72995_K) {
                    blusunrize.immersiveengineering.common.util.Utils.dropStackAtPos((World)this.field_70170_p, (BlockPos)this.func_180425_c(), (ItemStack)IIContent.itemAmmoLightArtillery.getCasingStack(1));
                    this.field_70180_af.func_187227_b(dataMarkerShell, (Object)this.shell.serializeNBT());
                    this.field_70180_af.func_187217_b(dataMarkerShell);
                }
                this.shell = ItemStack.field_190927_a;
                this.shootingProgress = 0.0f;
                this.fireKeyPress = false;
            }
        } else if ((this.reloadKeyPress || this.reloadProgress > 0.0f) && (seat = EntityVehicleSeat.getOrCreateSeat(this, 0)).func_184188_bt().size() > 0 && (entity = (Entity)seat.func_184188_bt().get(0)) instanceof EntityLivingBase) {
            ItemStack stack = ((EntityLivingBase)entity).func_184586_b(EnumHand.MAIN_HAND);
            if (stack.func_77973_b() == IIContent.itemAmmoLightArtillery) {
                if (this.reloadProgress == 0.0f) {
                    this.reloadKeyPress = false;
                    this.reloadProgress = 1.0f;
                } else if (this.reloadProgress < (float)Config.IIConfig.Vehicles.FieldHowitzer.reloadTime) {
                    this.reloadProgress += 1.0f;
                } else if (this.reloadProgress >= (float)Config.IIConfig.Vehicles.FieldHowitzer.reloadTime) {
                    this.reloadProgress = 0.0f;
                    this.shell = stack.func_77946_l();
                    this.shell.func_190920_e(1);
                    if (!this.field_70170_p.field_72995_K) {
                        ((EntityLivingBase)entity).func_184586_b(EnumHand.MAIN_HAND).func_190918_g(1);
                        this.field_70180_af.func_187227_b(dataMarkerShell, (Object)this.shell.serializeNBT());
                        this.field_70180_af.func_187217_b(dataMarkerShell);
                    }
                }
            } else {
                this.reloadProgress = 0.0f;
            }
        }
        this.speed = 0.0f;
        this.updateParts();
        this.handleMovement();
    }

    private void handleMovement() {
        float r = MathHelper.func_76142_g((float)this.field_70177_z);
        double true_angle2 = Math.toRadians(-this.field_70177_z - 90.0f > 180.0f ? (double)(360.0f - (-this.field_70177_z - 90.0f)) : (double)(-this.field_70177_z - 90.0f));
        Vec3d pos1_z = Utils.offsetPosDirection(-0.75f, true_angle2, 0.0);
        this.partWheelLeft.field_70177_z = this.field_70177_z;
        this.partWheelLeft.travel(0.0f, 0.0f, 1.0f, -0.0125f, (double)this.acceleration * 0.015);
        this.partWheelRight.field_70177_z = this.field_70177_z;
        this.partWheelRight.travel(0.0f, 0.0f, 1.0f, -0.0125f, (double)this.acceleration * 0.015);
        if (!(this.partWheelLeft.func_70094_T() || this.partWheelLeft.func_70094_T() || this.partWheelRight.func_70094_T() || this.partWheelRight.func_70094_T())) {
            this.partWheelRight.wheelTraverse = (int)((float)this.partWheelRight.wheelTraverse + this.acceleration * 2.5f);
            this.partWheelLeft.wheelTraverse = (int)((float)this.partWheelLeft.wheelTraverse + this.acceleration * 2.5f);
            Vec3d currentPos = new Vec3d(this.partWheelLeft.field_70165_t + pos1_z.field_72450_a, this.partWheelLeft.field_70163_u, this.partWheelLeft.field_70161_v + pos1_z.field_72449_c);
            this.func_70107_b(currentPos.field_72450_a, currentPos.field_72448_b, currentPos.field_72449_c);
            Utils.setEntityVelocity(this, this.partWheelLeft.field_70159_w, this.partWheelLeft.field_70181_x, this.partWheelLeft.field_70179_y);
        }
    }

    public void turnTowards(float yaw, float pitch) {
        float f = this.field_70125_A;
        float f1 = this.field_70177_z;
        this.field_70177_z = (float)((double)this.field_70177_z + (double)yaw * 0.15);
        this.field_70125_A = (float)((double)this.field_70125_A - (double)pitch * 0.15);
        this.field_70125_A = MathHelper.func_76131_a((float)this.field_70125_A, (float)-90.0f, (float)90.0f);
        this.field_70127_C += this.field_70125_A - f;
        this.field_70126_B += this.field_70177_z - f1;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    @Override
    public boolean canRepair() {
        return this.gunDurability < Config.IIConfig.Vehicles.FieldHowitzer.gunDurability || this.mainDurability < Config.IIConfig.Vehicles.FieldHowitzer.mainDurability || this.leftWheelDurability < Config.IIConfig.Vehicles.FieldHowitzer.wheelDurability || this.rightWheelDurability < Config.IIConfig.Vehicles.FieldHowitzer.wheelDurability || this.shieldDurability < Config.IIConfig.Vehicles.FieldHowitzer.wheelDurability;
    }

    @Override
    public boolean repair(int repairPoints) {
        if (this.gunDurability < Config.IIConfig.Vehicles.FieldHowitzer.gunDurability) {
            this.gunDurability = Math.min(this.gunDurability + repairPoints, Config.IIConfig.Vehicles.FieldHowitzer.gunDurability);
        } else if (this.mainDurability < Config.IIConfig.Vehicles.FieldHowitzer.mainDurability) {
            this.mainDurability = Math.min(this.mainDurability + repairPoints, Config.IIConfig.Vehicles.FieldHowitzer.mainDurability);
        } else if (this.leftWheelDurability < Config.IIConfig.Vehicles.FieldHowitzer.wheelDurability) {
            this.leftWheelDurability = Math.min(this.leftWheelDurability + repairPoints, Config.IIConfig.Vehicles.FieldHowitzer.wheelDurability);
        } else if (this.rightWheelDurability < Config.IIConfig.Vehicles.FieldHowitzer.wheelDurability) {
            this.rightWheelDurability = Math.min(this.rightWheelDurability + repairPoints, Config.IIConfig.Vehicles.FieldHowitzer.wheelDurability);
        } else if (this.shieldDurability < Config.IIConfig.Vehicles.FieldHowitzer.shieldDurability) {
            this.shieldDurability = Math.min(this.shieldDurability + repairPoints, Config.IIConfig.Vehicles.FieldHowitzer.shieldDurability);
        } else {
            return false;
        }
        return true;
    }

    @Override
    public int getRepairCost() {
        return 1;
    }

    @Override
    public Entity getTowingEntity() {
        return this.func_184187_bx();
    }

    @Override
    public boolean startTowing(Entity tower) {
        if (this.getTowingEntity() == null && this.func_184182_bu().stream().allMatch(entity -> entity instanceof EntityVehicleSeat)) {
            this.towingOperation = true;
            this.setupTime = 0;
            this.func_184220_m(tower);
            return true;
        }
        return false;
    }

    @Override
    public boolean stopTowing() {
        if (this.getTowingEntity() != null) {
            this.towingOperation = true;
            this.setupTime = 0;
            this.func_184210_p();
            return true;
        }
        return false;
    }

    @Override
    public boolean canMoveTowed() {
        return !this.towingOperation;
    }

    @Override
    public void moveTowableWheels(float speed) {
        this.partWheelRight.wheelTraverse = (int)((float)this.partWheelRight.wheelTraverse + speed * 2.0f);
        this.partWheelLeft.wheelTraverse = (int)((float)this.partWheelLeft.wheelTraverse + speed * 2.0f);
    }

    protected boolean func_184219_q(Entity passenger) {
        return passenger instanceof EntityVehicleSeat;
    }

    @Override
    public void getSeatRidingPosition(int seatID, Entity passenger) {
        double true_angle = Math.toRadians(-this.field_70177_z > 180.0f ? (double)(360.0f - -this.field_70177_z) : (double)(-this.field_70177_z));
        double true_angle2 = Math.toRadians(-this.field_70177_z - 90.0f > 180.0f ? (double)(360.0f - (-this.field_70177_z - 90.0f)) : (double)(-this.field_70177_z - 90.0f));
        Vec3d pos2 = Utils.offsetPosDirection(-0.65f, true_angle, 0.0);
        Vec3d pos3 = Utils.offsetPosDirection(seatID == 0 ? -0.75f : 0.75f, true_angle2, 0.0);
        if (this.setupTime > 0) {
            double ticks = MathHelper.func_151237_a((double)((double)this.setupTime / ((double)Config.IIConfig.Vehicles.FieldHowitzer.setupTime * 0.2)), (double)0.0, (double)1.0);
            pos3 = pos3.func_178788_d(pos3.func_186678_a(ticks * 0.55)).func_72441_c(0.0, -0.2, 0.0);
        } else if (this.shootingProgress > 0.0f && seatID == 1 || this.shootingProgress > (float)Config.IIConfig.Vehicles.FieldHowitzer.fireTime * 0.3f) {
            pos3 = pos3.func_72441_c(0.0, -0.2, 0.0);
        } else if (seatID == 0 && (this.gunPitchDown || this.gunPitchUp)) {
            pos3 = pos3.func_72441_c(0.0, -0.2, 0.0);
        } else if (seatID == 0 && this.reloadProgress > 0.2f && this.reloadProgress < 0.4f) {
            pos3 = pos3.func_178787_e(pos3.func_186678_a(-0.1875 * (((double)this.reloadProgress - 0.4) / 0.1)));
        } else if (seatID == 0 && this.reloadProgress > 0.4f && this.reloadProgress < 0.5f) {
            pos3 = pos3.func_178787_e(pos3.func_186678_a(-0.1875 * (1.0 - ((double)this.reloadProgress - 0.4) / 0.1)));
        }
        passenger.func_70107_b(this.field_70165_t + pos2.field_72450_a + pos3.field_72450_a, this.field_70163_u + pos3.field_72448_b, this.field_70161_v + pos2.field_72449_c + pos3.field_72449_c);
    }

    @Override
    public void getSeatRidingAngle(int seatID, Entity passenger) {
        float yy = this.field_70177_z;
        if (this.setupTime > 0) {
            yy = (float)((double)yy + MathHelper.func_151237_a((double)((double)this.setupTime / ((double)Config.IIConfig.Vehicles.FieldHowitzer.setupTime * 0.2)), (double)0.0, (double)1.0) * (double)(seatID == 0 ? 65 : -65));
        } else if (seatID == 0 && this.reloadProgress > 0.0f) {
            yy = (double)this.reloadProgress < 0.8 ? (float)((double)yy + MathHelper.func_151237_a((double)((double)this.reloadProgress / ((double)Config.IIConfig.Vehicles.FieldHowitzer.reloadTime * 0.2)), (double)0.0, (double)1.0) * 65.0) : (yy += MathHelper.func_76131_a((float)(1.0f - (this.reloadProgress / (float)Config.IIConfig.Vehicles.FieldHowitzer.reloadTime - 0.8f) / 0.2f), (float)0.0f, (float)1.0f) * 65.0f);
        }
        passenger.func_181013_g(yy);
        float f = MathHelper.func_76142_g((float)(passenger.field_70177_z - this.field_70177_z));
        float f1 = MathHelper.func_76131_a((float)f, (float)-75.0f, (float)75.0f);
        passenger.field_70126_B += f1 - f;
        passenger.field_70177_z += f1 - f;
        passenger.func_70034_d(passenger.field_70177_z);
    }

    @Override
    public boolean shouldSeatPassengerSit(int seatID, Entity passenger) {
        return false;
    }

    @Override
    public void onSeatDismount(int seatID, Entity passenger) {
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            passenger.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    public void func_184190_l(Entity passenger) {
        if (passenger != null && this.func_184196_w(passenger)) {
            passenger.field_70177_z = this.field_70177_z;
            passenger.field_70125_A = this.field_70125_A;
        }
    }

    @Override
    public boolean onInteractWithPart(EntityVehicleMultiPart part, EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K && !this.towingOperation) {
            if (part == this.partShieldRight || part == this.partWheelRight) {
                player.func_184220_m((Entity)EntityVehicleSeat.getOrCreateSeat(this, 0));
            } else if (part == this.partShieldLeft || part == this.partWheelLeft) {
                player.func_184220_m((Entity)EntityVehicleSeat.getOrCreateSeat(this, 1));
            }
            return true;
        }
        return false;
    }

    @Override
    public String[] getOverlayTextOnPart(EntityVehicleMultiPart part, EntityPlayer player, RayTraceResult mop, boolean hammer) {
        return new String[0];
    }

    public World func_82194_d() {
        return this.func_130014_f_();
    }

    public boolean func_70965_a(MultiPartEntityPart part, DamageSource source, float amount) {
        boolean isValidSource;
        boolean bl = isValidSource = source.func_76352_a() || source.func_94541_c() || source.func_76347_k();
        if (part == this.partGun) {
            if (isValidSource) {
                this.gunDurability = (int)((double)this.gunDurability - (double)amount * 0.85);
                this.field_70180_af.func_187227_b(dataMarkerGunDurability, (Object)this.gunDurability);
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, IISounds.impact_metal, SoundCategory.BLOCKS, 1.5f, 1.0f);
            } else {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, IISounds.ricochet_metal, SoundCategory.NEUTRAL, 1.5f, 8.0f / amount);
            }
            return true;
        }
        if (part == this.partMain || part == this.partMain2) {
            if (isValidSource) {
                this.mainDurability = (int)((float)this.mainDurability - amount);
                this.field_70180_af.func_187227_b(dataMarkerMainDurability, (Object)this.mainDurability);
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, IISounds.impact_metal, SoundCategory.BLOCKS, 1.5f, 1.0f);
            } else {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, IISounds.ricochet_metal, SoundCategory.NEUTRAL, 1.5f, 8.0f / amount);
            }
        } else if (part == this.partWheelRight) {
            this.rightWheelDurability = (int)((float)this.rightWheelDurability - amount);
            this.field_70180_af.func_187227_b(dataMarkerWheelRightDurability, (Object)this.rightWheelDurability);
        } else if (part == this.partWheelLeft) {
            this.leftWheelDurability = (int)((float)this.leftWheelDurability - amount);
            this.field_70180_af.func_187227_b(dataMarkerWheelLeftDurability, (Object)this.leftWheelDurability);
        } else if (part == this.partShieldLeft || part == this.partShieldRight) {
            if (isValidSource && amount > 8.0f) {
                if (this.shieldDurability < 0) {
                    this.mainDurability = (int)((double)this.mainDurability - (double)amount * 0.85);
                    this.field_70180_af.func_187227_b(dataMarkerMainDurability, (Object)this.mainDurability);
                } else {
                    this.shieldDurability = (int)((double)this.shieldDurability - (double)amount * 0.85);
                    this.field_70180_af.func_187227_b(dataMarkerShieldDurability, (Object)this.shieldDurability);
                }
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, IISounds.impact_metal, SoundCategory.BLOCKS, 1.5f, 1.0f);
            } else {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, IISounds.ricochet_metal, SoundCategory.NEUTRAL, 1.5f, 8.0f / amount);
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean func_90999_ad() {
        return false;
    }

    public Entity[] func_70021_al() {
        return this.partArray;
    }

    private void updateParts() {
        double true_angle = Math.toRadians(-this.field_70177_z > 180.0f ? (double)(360.0f - -this.field_70177_z) : (double)(-this.field_70177_z));
        double true_angle2 = Math.toRadians(-this.field_70177_z - 90.0f > 180.0f ? (double)(360.0f - (-this.field_70177_z - 90.0f)) : (double)(-this.field_70177_z - 90.0f));
        Vec3d pos1_x = Utils.offsetPosDirection(0.5f, true_angle, 0.0);
        Vec3d pos2_x = pos1_x.func_186678_a(1.0);
        Vec3d pos3 = pos1_x.func_186678_a(-1.5);
        Vec3d pos1_z = Utils.offsetPosDirection(0.75f, true_angle2, 0.0);
        Vec3d pos2_z = Utils.offsetPosDirection(-0.75f, true_angle2, 0.0);
        this.partWheelLeft.func_70012_b(this.field_70165_t + pos1_z.field_72450_a, this.field_70163_u, this.field_70161_v + pos1_z.field_72449_c, 0.0f, 0.0f);
        this.partWheelLeft.func_174826_a(AABB_WHEEL.func_72317_d(this.partWheelLeft.field_70165_t, this.partWheelLeft.field_70163_u, this.partWheelLeft.field_70161_v));
        Utils.setEntityVelocity((Entity)this.partWheelLeft, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.partWheelLeft.func_70071_h_();
        this.partWheelRight.func_70012_b(this.field_70165_t + pos2_z.field_72450_a, this.field_70163_u, this.field_70161_v + pos2_z.field_72449_c, 0.0f, 0.0f);
        this.partWheelRight.func_174826_a(AABB_WHEEL.func_72317_d(this.partWheelRight.field_70165_t, this.partWheelRight.field_70163_u, this.partWheelRight.field_70161_v));
        Utils.setEntityVelocity((Entity)this.partWheelRight, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.partWheelRight.func_70071_h_();
        this.partMain.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
        this.partMain.func_174826_a(AABB_MAIN.func_72317_d(this.partMain.field_70165_t, this.partMain.field_70163_u, this.partMain.field_70161_v));
        Utils.setEntityVelocity((Entity)this.partMain, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.partMain.func_70071_h_();
        this.partMain2.func_70012_b(this.field_70165_t + pos3.field_72450_a, this.field_70163_u + pos3.field_72448_b, this.field_70161_v + pos3.field_72449_c, 0.0f, 0.0f);
        this.partMain2.func_174826_a(AABB_MAIN.func_72317_d(this.partMain2.field_70165_t, this.partMain2.field_70163_u, this.partMain2.field_70161_v));
        Utils.setEntityVelocity((Entity)this.partMain2, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.partMain2.func_70071_h_();
        this.partGun.func_70012_b(this.field_70165_t + pos1_x.field_72450_a, this.field_70163_u + 0.65, this.field_70161_v + pos1_x.field_72449_c, 0.0f, 0.0f);
        this.partGun.func_174826_a(AABB_GUN.func_72317_d(this.partGun.field_70165_t, this.partGun.field_70163_u, this.partGun.field_70161_v));
        Utils.setEntityVelocity((Entity)this.partGun, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.partGun.func_70071_h_();
        this.partShieldLeft.func_70012_b(this.field_70165_t + pos1_z.field_72450_a + pos2_x.field_72450_a, this.field_70163_u + 0.375, this.field_70161_v + pos1_z.field_72449_c + pos2_x.field_72449_c, 0.0f, 0.0f);
        this.partShieldLeft.func_174826_a(AABB_SHIELD.func_72317_d(this.partShieldLeft.field_70165_t, this.partShieldLeft.field_70163_u, this.partShieldLeft.field_70161_v));
        Utils.setEntityVelocity((Entity)this.partShieldLeft, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.partShieldLeft.func_70071_h_();
        this.partShieldRight.func_70012_b(this.field_70165_t + pos2_z.field_72450_a + pos2_x.field_72450_a, this.field_70163_u + 0.375, this.field_70161_v + pos2_z.field_72449_c + pos2_x.field_72449_c, 0.0f, 0.0f);
        this.partShieldRight.func_174826_a(AABB_SHIELD.func_72317_d(this.partShieldRight.field_70165_t, this.partShieldRight.field_70163_u, this.partShieldRight.field_70161_v));
        Utils.setEntityVelocity((Entity)this.partShieldRight, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.partShieldRight.func_70071_h_();
    }

    public void func_70106_y() {
        this.func_184188_bt().forEach(Entity::func_70106_y);
        super.func_70106_y();
    }

    private void handleClientKeyInput(int seat) {
        boolean hasChanged;
        if (seat == 1) {
            boolean f = this.forward;
            boolean b = this.backward;
            boolean tl = this.turnLeft;
            boolean tr = this.turnRight;
            this.forward = ClientUtils.mc().field_71474_y.field_74351_w.func_151470_d();
            this.backward = ClientUtils.mc().field_71474_y.field_74368_y.func_151470_d();
            this.turnLeft = ClientUtils.mc().field_71474_y.field_74370_x.func_151470_d();
            this.turnRight = ClientUtils.mc().field_71474_y.field_74366_z.func_151470_d();
            hasChanged = f ^ this.forward || b ^ this.backward || tl ^ this.turnLeft || tr ^ this.turnRight;
        } else {
            boolean u = this.gunPitchUp;
            boolean d = this.gunPitchDown;
            boolean fk = this.fireKeyPress;
            boolean rr = this.reloadKeyPress;
            this.gunPitchUp = ClientUtils.mc().field_71474_y.field_74351_w.func_151470_d();
            this.gunPitchDown = ClientUtils.mc().field_71474_y.field_74368_y.func_151470_d();
            this.fireKeyPress = Mouse.isButtonDown((int)1);
            this.reloadKeyPress = ClientProxy.keybind_manualReload.func_151470_d();
            boolean bl = hasChanged = u ^ this.gunPitchUp || d ^ this.gunPitchDown || fk ^ this.fireKeyPress || rr ^ this.reloadKeyPress;
        }
        if (hasChanged) {
            IIPacketHandler.INSTANCE.sendToServer((IMessage)new MessageEntityNBTSync(this, this.updateKeys(seat)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private NBTTagCompound updateKeys(int seat) {
        NBTTagCompound compound = new NBTTagCompound();
        if (seat == 1) {
            compound.func_74757_a("forward", this.forward);
            compound.func_74757_a("backward", this.backward);
            compound.func_74757_a("turnLeft", this.turnLeft);
            compound.func_74757_a("turnRight", this.turnRight);
        } else {
            compound.func_74757_a("gunPitchUp", this.gunPitchUp);
            compound.func_74757_a("gunPitchDown", this.gunPitchDown);
            compound.func_74757_a("fireKeyPress", this.fireKeyPress);
            compound.func_74757_a("reloadKeyPress", this.reloadKeyPress);
        }
        return compound;
    }

    public void syncKeyPress(NBTTagCompound tag) {
        if (tag.func_74764_b("forward")) {
            this.forward = tag.func_74767_n("forward");
        }
        if (tag.func_74764_b("backward")) {
            this.backward = tag.func_74767_n("backward");
        }
        if (tag.func_74764_b("turnLeft")) {
            this.turnLeft = tag.func_74767_n("turnLeft");
        }
        if (tag.func_74764_b("turnRight")) {
            this.turnRight = tag.func_74767_n("turnRight");
        }
        if (tag.func_74764_b("gunPitchUp")) {
            this.gunPitchUp = tag.func_74767_n("gunPitchUp");
        }
        if (tag.func_74764_b("gunPitchDown")) {
            this.gunPitchDown = tag.func_74767_n("gunPitchDown");
        }
        if (tag.func_74764_b("fireKeyPress")) {
            this.fireKeyPress = tag.func_74767_n("fireKeyPress");
        }
        if (tag.func_74764_b("reloadKeyPress")) {
            this.reloadKeyPress = tag.func_74767_n("reloadKeyPress");
        }
    }

    private void handleClientKeyOutput(int seat) {
        if (seat != 1) {
            this.forward = (Boolean)this.field_70180_af.func_187225_a(dataMarkerForward);
            this.backward = (Boolean)this.field_70180_af.func_187225_a(dataMarkerBackward);
            this.turnLeft = (Boolean)this.field_70180_af.func_187225_a(dataMarkerTurnLeft);
            this.turnRight = (Boolean)this.field_70180_af.func_187225_a(dataMarkerTurnRight);
        } else {
            this.field_70180_af.func_187225_a(dataMarkerForward);
            this.field_70180_af.func_187225_a(dataMarkerBackward);
            this.field_70180_af.func_187225_a(dataMarkerTurnLeft);
            this.field_70180_af.func_187225_a(dataMarkerTurnRight);
        }
        if (seat != 0) {
            this.gunPitchUp = (Boolean)this.field_70180_af.func_187225_a(dataMarkerGunPitchUp);
            this.gunPitchDown = (Boolean)this.field_70180_af.func_187225_a(dataMarkerGunPitchDown);
        } else {
            this.field_70180_af.func_187225_a(dataMarkerGunPitchUp);
            this.field_70180_af.func_187225_a(dataMarkerGunPitchDown);
        }
        this.acceleration = ((Float)this.field_70180_af.func_187225_a(dataMarkerAcceleration)).floatValue();
        this.speed = ((Float)this.field_70180_af.func_187225_a(dataMarkerSpeed)).floatValue();
        this.shootingProgress = ((Float)this.field_70180_af.func_187225_a(dataMarkerShootingProgress)).floatValue();
        this.reloadProgress = ((Float)this.field_70180_af.func_187225_a(dataMarkerReloadProgress)).floatValue();
        this.gunPitch = ((Float)this.field_70180_af.func_187225_a(dataMarkerGunPitch)).floatValue();
        this.shell = new ItemStack((NBTTagCompound)this.field_70180_af.func_187225_a(dataMarkerShell));
        this.rightWheelDurability = (Integer)this.field_70180_af.func_187225_a(dataMarkerWheelRightDurability);
        this.leftWheelDurability = (Integer)this.field_70180_af.func_187225_a(dataMarkerWheelLeftDurability);
        this.mainDurability = (Integer)this.field_70180_af.func_187225_a(dataMarkerMainDurability);
        this.gunDurability = (Integer)this.field_70180_af.func_187225_a(dataMarkerGunDurability);
        this.shieldDurability = (Integer)this.field_70180_af.func_187225_a(dataMarkerShieldDurability);
    }

    private void handleServerKeyInput() {
        this.field_70180_af.func_187227_b(dataMarkerForward, (Object)this.forward);
        this.field_70180_af.func_187227_b(dataMarkerBackward, (Object)this.backward);
        this.field_70180_af.func_187227_b(dataMarkerTurnLeft, (Object)this.turnLeft);
        this.field_70180_af.func_187227_b(dataMarkerTurnRight, (Object)this.turnRight);
        this.field_70180_af.func_187227_b(dataMarkerGunPitchUp, (Object)this.gunPitchUp);
        this.field_70180_af.func_187227_b(dataMarkerGunPitchDown, (Object)this.gunPitchDown);
        this.field_70180_af.func_187227_b(dataMarkerAcceleration, (Object)Float.valueOf(this.acceleration));
        this.field_70180_af.func_187227_b(dataMarkerSpeed, (Object)Float.valueOf(this.speed));
        this.field_70180_af.func_187227_b(dataMarkerShootingProgress, (Object)Float.valueOf(this.shootingProgress));
        this.field_70180_af.func_187227_b(dataMarkerReloadProgress, (Object)Float.valueOf(this.reloadProgress));
        this.field_70180_af.func_187227_b(dataMarkerGunPitch, (Object)Float.valueOf(this.gunPitch));
        this.field_70180_af.func_187227_b(dataMarkerWheelRightDurability, (Object)this.rightWheelDurability);
        this.field_70180_af.func_187227_b(dataMarkerWheelLeftDurability, (Object)this.leftWheelDurability);
        this.field_70180_af.func_187227_b(dataMarkerMainDurability, (Object)this.mainDurability);
        this.field_70180_af.func_187227_b(dataMarkerGunDurability, (Object)this.gunDurability);
        this.field_70180_af.func_187227_b(dataMarkerShieldDurability, (Object)this.shieldDurability);
        this.field_70180_af.func_187227_b(dataMarkerShell, (Object)this.shell.serializeNBT());
    }

    @Override
    public IAdvancedZoomTool getZoom() {
        return Minecraft.func_71410_x().field_71439_g.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == IIContent.itemBinoculars ? IIContent.itemBinoculars : null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemStack getZoomStack() {
        return Minecraft.func_71410_x().field_71439_g.func_184586_b(EnumHand.MAIN_HAND);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.field_76373_n.equals("bullet")) {
            DamageSource temp_source = new DamageSource("bullet").func_76349_b().func_76348_h();
            for (EntityVehicleMultiPart part : new EntityVehicleMultiPart[]{this.partWheelRight, this.partWheelLeft, this.partShieldLeft, this.partShieldRight, this.partGun}) {
                this.func_70965_a(part, temp_source, amount);
            }
            return true;
        }
        return super.func_70097_a(source, amount);
    }
}

