/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.compat.crafttweaker;

import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CraftTweakerHelper;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import pl.pabilo8.immersiveintelligence.api.crafting.VulcanizerRecipe;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersiveintelligence.Vulcanizer")
@ZenRegister
public class VulcanizerTweaker {
    @ZenMethod
    public static void addRecipe(IIngredient mainInput, IIngredient compoundInput, IIngredient sulfurInput, IItemStack itemMold, IItemStack itemOutput, int energy, String resIn, String resOut) {
        for (IIngredient o : new IIngredient[]{mainInput, compoundInput, sulfurInput}) {
            if (o != null) continue;
            CraftTweakerAPI.getLogger().logError("Could not add vulcanizer recipe for " + itemOutput.getDisplayName() + ", input was null");
            return;
        }
        VulcanizerRecipe r = new VulcanizerRecipe(CraftTweakerHelper.toStack((IItemStack)itemOutput), new ComparableItemStack(CraftTweakerHelper.toStack((IItemStack)itemMold)), CraftTweakerHelper.toIEIngredientStack((IIngredient)mainInput), CraftTweakerHelper.toIEIngredientStack((IIngredient)compoundInput), CraftTweakerHelper.toIEIngredientStack((IIngredient)sulfurInput), energy, new ResourceLocation(resIn + ".png"), new ResourceLocation(resOut + ".png"));
        CraftTweakerAPI.apply((IAction)new Add(r));
    }

    @ZenMethod
    public static void addRecipe(IIngredient mainInput, IIngredient compoundInput, IIngredient sulfurInput, IItemStack itemMold, IItemStack itemOutput, int energy) {
        VulcanizerTweaker.addRecipe(mainInput, compoundInput, sulfurInput, itemMold, itemOutput, energy, VulcanizerRecipe.TEXTURE_LATEX.toString(), VulcanizerRecipe.TEXTURE_RUBBER.toString());
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerHelper.toStack((IItemStack)output)));
    }

    private static class Remove
    implements IAction {
        private final ItemStack output;
        List<VulcanizerRecipe> removedRecipes;

        public Remove(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            this.removedRecipes = VulcanizerRecipe.removeRecipes(this.output);
        }

        public String describe() {
            return "Removing Vulcanizer Recipe for " + this.output.func_82833_r();
        }
    }

    private static class Add
    implements IAction {
        private final VulcanizerRecipe recipe;

        public Add(VulcanizerRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            VulcanizerRecipe.recipeList.put((Object)this.recipe.mold, (Object)this.recipe);
        }

        public String describe() {
            return "Adding Vulcanizer Recipe for " + this.recipe.output.func_82833_r();
        }
    }
}

