/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.compat.crafttweaker;

import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CraftTweakerHelper;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.List;
import net.minecraft.item.ItemStack;
import pl.pabilo8.immersiveintelligence.api.crafting.DustStack;
import pl.pabilo8.immersiveintelligence.api.crafting.FillerRecipe;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersiveintelligence.Filler")
@ZenRegister
public class FillerTweaker {
    @ZenMethod
    public static void addRecipe(IItemStack itemOutput, IIngredient itemInput, String dust, int amount, int time, int energy) {
        ItemStack stackOut = CraftTweakerMC.getItemStack((IItemStack)itemOutput);
        IngredientStack stackIn = CraftTweakerHelper.toIEIngredientStack((IIngredient)itemInput);
        FillerRecipe r = new FillerRecipe(stackOut, stackIn, new DustStack(dust, amount), time, energy);
        CraftTweakerAPI.apply((IAction)new Add(r));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerHelper.toStack((IItemStack)output)));
    }

    private static class Remove
    implements IAction {
        private final ItemStack output;
        List<FillerRecipe> removedRecipes;

        public Remove(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            this.removedRecipes = FillerRecipe.removeRecipesForOutput(this.output);
        }

        public String describe() {
            return "Removing Filler Recipe for " + this.output.func_82833_r();
        }
    }

    private static class Add
    implements IAction {
        private final FillerRecipe recipe;

        public Add(FillerRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            FillerRecipe.recipeList.add(this.recipe);
        }

        public String describe() {
            return "Adding Filler Recipe for " + this.recipe.itemOutput.func_82833_r();
        }
    }
}

