/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.compat.crafttweaker;

import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CraftTweakerHelper;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.List;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.crafting.PaintingRecipe;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersiveintelligence.ChemicalPainter")
@ZenRegister
public class ChemicalPainterTweaker {
    @ZenMethod
    public static void addRecipe(IIngredient itemInput, IChemicalPainterFunction function, int paintAmount, int energy, int time) {
        IngredientStack oItemInput = CraftTweakerHelper.toIEIngredientStack((IIngredient)itemInput);
        if (oItemInput == null) {
            CraftTweakerAPI.getLogger().logError("Could not add chemical painter recipe for " + itemInput.toCommandString() + ", input was null");
            return;
        }
        PaintingRecipe r = new PaintingRecipe((rgb, stack) -> {
            EnumDyeColor dye = Utils.getRGBTextFormatting(rgb);
            return CraftTweakerMC.getItemStack((IItemStack)function.process(CraftTweakerMC.getIItemStack((ItemStack)stack), (int)rgb, dye.func_193350_e()));
        }, oItemInput, energy, time, paintAmount);
        CraftTweakerAPI.apply((IAction)new Add(r));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerHelper.toStack((IItemStack)output)));
    }

    @ZenClass(value="mods.immersiveintelligence.IChemicalPainterFunction")
    @ZenRegister
    public static interface IChemicalPainterFunction {
        public IItemStack process(IItemStack var1, int var2, int var3);
    }

    private static class Remove
    implements IAction {
        private final ItemStack input;
        List<PaintingRecipe> removedRecipes;

        public Remove(ItemStack output) {
            this.input = output;
        }

        public void apply() {
            this.removedRecipes = PaintingRecipe.removeRecipesForInput(this.input);
        }

        public String describe() {
            return "Removing Chemical Painter Recipe for " + this.input.func_82833_r();
        }
    }

    private static class Add
    implements IAction {
        private final PaintingRecipe recipe;

        public Add(PaintingRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            PaintingRecipe.recipeList.add(this.recipe);
        }

        public String describe() {
            return "Adding Chemical Painter Recipe for " + this.recipe.itemInput.getExampleStack().func_82833_r();
        }
    }
}

