/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.compat.crafttweaker;

import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CraftTweakerHelper;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import pl.pabilo8.immersiveintelligence.api.crafting.BathingRecipe;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersiveintelligence.ChemicalBath")
@ZenRegister
public class ChemicalBathTweaker {
    @ZenMethod
    public static void addWashingRecipe(IIngredient itemInput, IItemStack itemOutput, ILiquidStack fluidInput, int energy, int time) {
        Object oItemInput = CraftTweakerHelper.toObject((IIngredient)itemInput);
        if (oItemInput == null) {
            CraftTweakerAPI.getLogger().logError("Could not add chemical bath washing recipe for " + itemOutput.getDisplayName() + ", input was null");
            return;
        }
        FluidStack mcFluidInputStack = CraftTweakerMC.getLiquidStack((ILiquidStack)fluidInput);
        BathingRecipe r = new BathingRecipe(CraftTweakerHelper.toStack((IItemStack)itemOutput), oItemInput, mcFluidInputStack, energy, time, true);
        CraftTweakerAPI.apply((IAction)new Add(r));
    }

    @ZenMethod
    public static void addRecipe(IIngredient itemInput, IItemStack itemOutput, ILiquidStack fluidInput, int energy, int time) {
        Object oItemInput = CraftTweakerHelper.toObject((IIngredient)itemInput);
        if (oItemInput == null) {
            CraftTweakerAPI.getLogger().logError("Could not add chemical bath recipe for " + itemOutput.getDisplayName() + ", input was null");
            return;
        }
        FluidStack mcFluidInputStack = CraftTweakerMC.getLiquidStack((ILiquidStack)fluidInput);
        BathingRecipe r = new BathingRecipe(CraftTweakerHelper.toStack((IItemStack)itemOutput), oItemInput, mcFluidInputStack, energy, time, false);
        CraftTweakerAPI.apply((IAction)new Add(r));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerHelper.toStack((IItemStack)output)));
    }

    private static class Remove
    implements IAction {
        private final ItemStack output;
        List<BathingRecipe> removedRecipes;

        public Remove(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            this.removedRecipes = BathingRecipe.removeRecipesForOutput(this.output);
        }

        public String describe() {
            return "Removing Chemical Bath Recipe for " + this.output.func_82833_r();
        }
    }

    private static class Add
    implements IAction {
        private final BathingRecipe recipe;

        public Add(BathingRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            BathingRecipe.recipeList.add(this.recipe);
        }

        public String describe() {
            return "Adding Chemical Bath Recipe for " + this.recipe.itemOutput.func_82833_r();
        }
    }
}

