/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.compat.crafttweaker;

import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.tileentity.TileEntity;
import pl.pabilo8.immersiveintelligence.common.blocks.metal.TileEntityCO2Filter;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersiveintelligence.CO2Input")
@ZenRegister
public class CO2InputTweaker {
    @ZenMethod
    public static void addMultiblock(String classPath, int time, int amount, int[] pos) {
        try {
            Class<TileEntityMultiblockMetal> c = Class.forName(classPath);
            if (c.isAssignableFrom(TileEntityMultiblockMetal.class)) {
                TileEntityCO2Filter.handlerMap.put(c, new MultiblockCO2Handler(c, time, amount, pos));
                CraftTweakerAPI.getLogger().logInfo("CO2 Collector will now recognise " + classPath + " as a CO2 source");
            } else {
                CraftTweakerAPI.getLogger().logError("Couldn't add " + classPath + " as a CO2 source, class is not a multiblock");
            }
        }
        catch (ClassNotFoundException e) {
            CraftTweakerAPI.getLogger().logError("Couldn't add " + classPath + " as a CO2 source, class doesn't exist");
        }
    }

    @ZenMethod
    public static void addTile(String classPath, int time, int amount) {
        try {
            Class<TileEntity> c = Class.forName(classPath);
            if (c.isAssignableFrom(TileEntity.class)) {
                TileEntityCO2Filter.handlerMap.put(c, new TileEntityCO2Handler(c, time, amount));
                CraftTweakerAPI.getLogger().logInfo("CO2 Collector will now recognise " + classPath + " as a CO2 source");
            }
        }
        catch (ClassNotFoundException e) {
            CraftTweakerAPI.getLogger().logError("Couldn't add " + classPath + " as a CO2 source, class doesn't exist");
        }
    }

    private static class TileEntityCO2Handler
    extends TileEntityCO2Filter.CO2Handler {
        private final Class<TileEntity> c;
        protected final int time;
        protected final int amount;

        public TileEntityCO2Handler(Class<TileEntity> c, int time, int amount) {
            this.c = c;
            this.time = time;
            this.amount = amount;
        }

        @Override
        public int getOutput(TileEntity tile) {
            if (!this.c.isInstance(tile)) {
                return 0;
            }
            if (tile.func_145831_w().func_82737_E() % (long)this.time == 0L) {
                return this.amount;
            }
            return 0;
        }
    }

    private static class MultiblockCO2Handler
    extends TileEntityCO2Handler {
        private final Class<TileEntityMultiblockMetal> c;
        private final List<Integer> pos;

        public MultiblockCO2Handler(Class<TileEntityMultiblockMetal> c, int time, int amount, int[] pos) {
            super(c, time, amount);
            this.c = c;
            this.pos = Arrays.stream(pos).boxed().collect(Collectors.toList());
        }

        @Override
        public int getOutput(TileEntity tile) {
            if (!this.c.isInstance(tile)) {
                return 0;
            }
            if (this.pos.contains(this.c.cast((Object)tile).field_174879_c)) {
                return 0;
            }
            TileEntityMultiblockMetal machine = this.c.cast(this.c.cast(tile).master());
            if (machine == null) {
                return 0;
            }
            int i = 0;
            for (TileEntityMultiblockMetal.MultiblockProcess p : machine.processQueue) {
                if (!p.canProcess(machine) || p.processTick % this.time != 0) continue;
                i += this.amount;
            }
            return i;
        }
    }
}

