/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.compat;

import java.lang.reflect.Constructor;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.oredict.OreDictionary;
import pl.pabilo8.immersiveintelligence.ImmersiveIntelligence;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.compat.IICompatModule;
import twistedgate.immersiveposts.ImmersivePosts;
import twistedgate.immersiveposts.common.blocks.BlockPost;
import twistedgate.immersiveposts.enums.EnumPostMaterial;

public class ImmersivePostsHelper
extends IICompatModule {
    private BlockFence brassFence;
    private BlockFence tungstenFence;
    private BlockFence zincFence;
    private BlockFence platinumFence;
    private BlockFence duraluminiumFence;

    @Override
    public void preInit() {
        this.brassFence = ImmersivePostsHelper.createFence("brass");
        this.tungstenFence = ImmersivePostsHelper.createFence("tungsten");
        this.zincFence = ImmersivePostsHelper.createFence("zinc");
        this.platinumFence = ImmersivePostsHelper.createFence("platinum");
        this.duraluminiumFence = ImmersivePostsHelper.createFence("duraluminium");
        try {
            IIContent.itemMaterialRod.setMetaUnhidden(new int[]{2, 3});
            Constructor constructor = EnumPostMaterial.class.getDeclaredConstructor(String.class, Integer.TYPE, String.class, Block.class, Boolean.TYPE, Boolean.TYPE);
            constructor.setAccessible(true);
            EnumPostMaterial postMatBrass = ImmersivePostsHelper.addPostMaterial("brass", (Block)this.brassFence);
            EnumPostMaterial postMatTungsten = ImmersivePostsHelper.addPostMaterial("tungsten", (Block)this.tungstenFence);
            EnumPostMaterial postMatZinc = ImmersivePostsHelper.addPostMaterial("zinc", (Block)this.zincFence);
            EnumPostMaterial postMatPlatinum = ImmersivePostsHelper.addPostMaterial("platinum", (Block)this.platinumFence);
            EnumPostMaterial postMatDuraluminium = ImmersivePostsHelper.addPostMaterial("duraluminium", (Block)this.duraluminiumFence);
            BlockPost brassPost = ImmersivePostsHelper.createMetalPost(postMatBrass);
            BlockPost tungstenPost = ImmersivePostsHelper.createMetalPost(postMatTungsten);
            BlockPost zincPost = ImmersivePostsHelper.createMetalPost(postMatZinc);
            BlockPost platinumPost = ImmersivePostsHelper.createMetalPost(postMatPlatinum);
            BlockPost duraluminiumPost = ImmersivePostsHelper.createMetalPost(postMatDuraluminium);
            ImmersiveIntelligence.logger.info("It's fine, everything's fine. (no really, don't report it to me or TwistedGate)");
        }
        catch (NoSuchMethodException e) {
            ImmersiveIntelligence.logger.info("Couldn't add Immersive Posts Compat :<");
        }
    }

    @Override
    public void registerRecipes() {
        OreDictionary.registerOre((String)"fenceBrass", (ItemStack)new ItemStack((Block)this.brassFence));
        OreDictionary.registerOre((String)"fenceTungsten", (ItemStack)new ItemStack((Block)this.tungstenFence));
        OreDictionary.registerOre((String)"fenceZinc", (ItemStack)new ItemStack((Block)this.zincFence));
        OreDictionary.registerOre((String)"fencePlatinum", (ItemStack)new ItemStack((Block)this.platinumFence));
        OreDictionary.registerOre((String)"fenceDuraluminium", (ItemStack)new ItemStack((Block)this.duraluminiumFence));
    }

    @Override
    public void init() {
    }

    @Override
    public void postInit() {
    }

    @Optional.Method(modid="immersiveposts")
    private static BlockPost createMetalPost(EnumPostMaterial postMat) {
        return new BlockPost(Material.field_151573_f, postMat);
    }

    private static BlockFence createFence(String name) {
        return new BlockMetalFence(name);
    }

    @Nullable
    @Deprecated
    @Optional.Method(modid="immersiveposts")
    public static EnumPostMaterial addPostMaterial(String name, Block block) {
        return (EnumPostMaterial)EnumHelper.addEnum(EnumPostMaterial.class, (String)name.toUpperCase(), (Class[])new Class[]{String.class, Block.class, Boolean.TYPE, Boolean.TYPE}, (Object[])new Object[]{name + "post", block, true, true});
    }

    public static class BlockMetalFence
    extends BlockFence {
        public final String rawName;
        public ItemBlock itemBlock;

        public BlockMetalFence(String name) {
            this(name, Material.field_151573_f);
        }

        private BlockMetalFence(String name, Material mat) {
            super(mat, mat.func_151565_r());
            this.rawName = name;
            this.func_149663_c("immersiveintelligence.fence_" + name);
            this.func_149711_c(3.0f);
            this.func_149752_b(15.0f);
            this.func_149647_a(ImmersivePosts.creativeTab);
            IIContent.BLOCKS.add((Block)this);
            this.itemBlock = (ItemBlock)new ItemBlock((Block)this).func_77655_b("immersiveintelligence.fence_" + name);
            IIContent.ITEMS.add((Item)this.itemBlock);
        }
    }
}

