/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.blocks.rotary;

import blusunrize.immersiveengineering.api.energy.IRotationAcceptor;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.rotary.CapabilityRotaryEnergy;
import pl.pabilo8.immersiveintelligence.api.rotary.IRotaryEnergy;
import pl.pabilo8.immersiveintelligence.api.rotary.RotaryStorage;
import pl.pabilo8.immersiveintelligence.api.rotary.RotaryUtils;
import pl.pabilo8.immersiveintelligence.api.utils.IRotationalEnergyBlock;
import pl.pabilo8.immersiveintelligence.common.network.IIPacketHandler;
import pl.pabilo8.immersiveintelligence.common.network.MessageRotaryPowerSync;

public class TileEntityTransmissionBox
extends TileEntityIEBase
implements ITickable,
IRotationAcceptor,
IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.IHammerInteraction,
IRotationalEnergyBlock {
    EnumFacing facing = EnumFacing.NORTH;
    public int tick = 0;
    public RotaryStorage energy = new RotaryStorage(){

        @Override
        public IRotaryEnergy.RotationSide getSide(@Nullable EnumFacing facing) {
            return facing == TileEntityTransmissionBox.this.getFacing().func_176734_d() ? IRotaryEnergy.RotationSide.OUTPUT : IRotaryEnergy.RotationSide.INPUT;
        }
    };

    @Override
    public void updateRotationStorage(float rpm, float torque, int part) {
        if (this.field_145850_b.field_72995_K && part == 0) {
            this.energy.setRotationSpeed(rpm);
            this.energy.setTorque(torque);
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityRotaryEnergy.ROTARY_ENERGY && (facing == null || facing == this.getFacing().func_176734_d())) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityRotaryEnergy.ROTARY_ENERGY && (facing == null || facing == this.getFacing().func_176734_d())) {
            return (T)this.energy;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void readCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket) {
        if (nbt.func_74764_b("energy")) {
            this.energy.fromNBT(nbt.func_74775_l("energy"));
        }
        this.facing = EnumFacing.func_82600_a((int)nbt.func_74762_e("facing"));
    }

    public void writeCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket) {
        nbt.func_74782_a("energy", (NBTBase)this.energy.toNBT());
        nbt.func_74768_a("facing", this.facing.ordinal());
    }

    public void func_73660_a() {
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K) {
            TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.facing));
            if (tile != null && tile.hasCapability(CapabilityRotaryEnergy.ROTARY_ENERGY, this.facing.func_176734_d())) {
                IRotaryEnergy cap = (IRotaryEnergy)tile.getCapability(CapabilityRotaryEnergy.ROTARY_ENERGY, this.facing.func_176734_d());
                if (cap != null) {
                    this.energy.handleRotation(cap, this.facing.func_176734_d());
                }
            } else {
                --this.tick;
                if (this.tick < 1) {
                    this.energy.grow(0.0f, 0.0f, 0.98f);
                }
            }
            tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.facing.func_176734_d()));
            if (this.energy.getTorque() > 0.0f && tile instanceof IRotationAcceptor) {
                ((IRotationAcceptor)tile).inputRotation((double)(this.energy.getEnergy() / Config.IIConfig.MechanicalDevices.rof_conversion_ratio) / Config.IEConfig.Machines.dynamo_output, this.facing.func_176734_d());
            }
        }
    }

    public void inputRotation(double rotation, @Nonnull EnumFacing side) {
        if (side == this.facing.func_176734_d() && !this.field_145850_b.field_72995_K) {
            this.tick = 10;
            TileEntity t = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.facing));
            float torque = RotaryUtils.getTorqueForIEDevice(t, 1.0);
            int output = (int)(20.0 * Config.IEConfig.Machines.dynamo_output * rotation * (double)Config.IIConfig.MechanicalDevices.rof_conversion_ratio);
            float speed = (float)output / torque;
            torque = (float)output / speed;
            this.energy.grow(Math.round(speed), Math.round(torque), 0.98f);
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                IIPacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageRotaryPowerSync(this.energy, 0, this.field_174879_c), Utils.targetPointFromTile((TileEntity)this, 24));
            }
        }
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    public int getFacingLimitation() {
        return 0;
    }

    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return true;
    }

    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return true;
    }

    public boolean canRotate(EnumFacing axis) {
        return true;
    }

    public boolean hammerUseSide(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ) {
        return false;
    }
}

