/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.blocks.rotary;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.fluid.IFluidPipe;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityFluidPipe;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.rotary.CapabilityRotaryEnergy;
import pl.pabilo8.immersiveintelligence.api.rotary.IRotaryEnergy;
import pl.pabilo8.immersiveintelligence.api.rotary.RotaryStorage;
import pl.pabilo8.immersiveintelligence.api.utils.IRotationalEnergyBlock;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.blocks.types.IIBlockTypes_MechanicalDevice1;
import pl.pabilo8.immersiveintelligence.common.network.IIPacketHandler;
import pl.pabilo8.immersiveintelligence.common.network.MessageRotaryPowerSync;

public class TileEntityMechanicalPump
extends TileEntityIEBase
implements ITickable,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IHasDummyBlocks,
IEBlockInterfaces.IConfigurableSides,
IFluidPipe,
IEBlockInterfaces.IBlockOverlayText,
IRotationalEnergyBlock,
IEBlockInterfaces.IDirectionalTile {
    public int[] sideConfig = new int[]{0, -1, -1, -1, -1, -1};
    public boolean dummy = false;
    public FluidTank tank = new FluidTank(1000);
    public boolean placeCobble = true;
    public EnumFacing facing = EnumFacing.NORTH;
    boolean checkingArea = false;
    Fluid searchFluid = null;
    ArrayList<BlockPos> openList = new ArrayList();
    ArrayList<BlockPos> closedList = new ArrayList();
    ArrayList<BlockPos> checked = new ArrayList();
    public RotaryStorage rotation = new RotaryStorage(0.0f, 0.0f){

        @Override
        public IRotaryEnergy.RotationSide getSide(@Nullable EnumFacing facing) {
            return facing == TileEntityMechanicalPump.this.getFacing() ? IRotaryEnergy.RotationSide.INPUT : IRotaryEnergy.RotationSide.NONE;
        }
    };
    SidedFluidHandler[] sidedFluidHandler = new SidedFluidHandler[6];

    public void func_73660_a() {
        ApiUtils.checkForNeedlessTicking((TileEntity)this);
        if (this.dummy || this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.tank.getFluidAmount() > 0) {
            int i = this.outputFluid(this.tank.getFluid(), false);
            this.tank.drain(i, true);
        }
        this.handleRotation();
        if (this.field_145850_b.func_175687_A(this.func_174877_v()) > 0 || this.field_145850_b.func_175687_A(this.func_174877_v().func_177982_a(0, 1, 0)) > 0) {
            for (EnumFacing f : EnumFacing.values()) {
                if (this.sideConfig[f.ordinal()] != 0) continue;
                BlockPos output = this.func_174877_v().func_177972_a(f);
                TileEntity tile = blusunrize.immersiveengineering.common.util.Utils.getExistingTileEntity((World)this.field_145850_b, (BlockPos)output);
                if (tile != null && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, f.func_176734_d())) {
                    IFluidHandler handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, f.func_176734_d());
                    FluidStack drain = handler.drain(500, false);
                    if (drain == null || drain.amount <= 0) continue;
                    int out = this.outputFluid(drain, false);
                    handler.drain(out, true);
                    continue;
                }
                if (this.field_145850_b.func_82737_E() % 20L != (long)((this.func_174877_v().func_177958_n() ^ this.func_174877_v().func_177952_p()) & 0x13) || this.field_145850_b.func_180495_p(this.func_174877_v().func_177972_a(f)).func_177230_c() != Blocks.field_150355_j || !Config.IEConfig.Machines.pump_infiniteWater || this.tank.fill(new FluidStack(FluidRegistry.WATER, 1000), false) != 1000 || !this.hasEnoughPower()) continue;
                int connectedSources = 0;
                for (EnumFacing f2 : EnumFacing.field_176754_o) {
                    IBlockState waterState = this.field_145850_b.func_180495_p(this.func_174877_v().func_177972_a(f).func_177972_a(f2));
                    if (waterState.func_177230_c() != Blocks.field_150355_j || Blocks.field_150355_j.func_176201_c(waterState) != 0) continue;
                    ++connectedSources;
                }
                if (connectedSources <= true) continue;
                this.tank.fill(new FluidStack(FluidRegistry.WATER, 1000), true);
            }
            if (this.field_145850_b.func_82737_E() % 40L == (long)(((this.func_174877_v().func_177958_n() ^ this.func_174877_v().func_177952_p()) % 40 + 40) % 40)) {
                if (this.closedList.isEmpty()) {
                    this.prepareAreaCheck();
                } else {
                    int target = this.closedList.size() - 1;
                    BlockPos pos = this.closedList.get(target);
                    FluidStack fs = blusunrize.immersiveengineering.common.util.Utils.drainFluidBlock((World)this.field_145850_b, (BlockPos)pos, (boolean)false);
                    if (fs == null) {
                        this.closedList.remove(target);
                    } else if (this.tank.fill(fs, false) == fs.amount && this.hasEnoughPower()) {
                        fs = blusunrize.immersiveengineering.common.util.Utils.drainFluidBlock((World)this.field_145850_b, (BlockPos)pos, (boolean)true);
                        if (Config.IEConfig.Machines.pump_placeCobble && this.placeCobble) {
                            this.field_145850_b.func_175656_a(pos, Blocks.field_150347_e.func_176223_P());
                        }
                        this.tank.fill(fs, true);
                        this.closedList.remove(target);
                    }
                }
            }
        }
        if (this.checkingArea) {
            this.checkAreaTick();
        }
    }

    private boolean handleRotation() {
        boolean b = false;
        if (this.rotation.getRotationSpeed() > (float)Config.IIConfig.Machines.MechanicalPump.rpmBreakingMax || this.rotation.getTorque() > (float)Config.IIConfig.Machines.MechanicalPump.torqueBreakingMax) {
            this.selfDestruct();
            return false;
        }
        TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177984_a().func_177972_a(this.facing.func_176734_d()));
        if (te != null && te.hasCapability(CapabilityRotaryEnergy.ROTARY_ENERGY, this.facing)) {
            IRotaryEnergy cap = (IRotaryEnergy)te.getCapability(CapabilityRotaryEnergy.ROTARY_ENERGY, this.facing);
            if (this.rotation.handleRotation(cap, this.facing)) {
                IIPacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageRotaryPowerSync(this.rotation, 0, this.func_174877_v()), Utils.targetPointFromTile((TileEntity)this, 24));
            }
        } else {
            b = true;
        }
        if (b && (this.rotation.getTorque() > 0.0f || this.rotation.getRotationSpeed() > 0.0f)) {
            this.rotation.grow(0.0f, 0.0f, 0.98f);
            IIPacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageRotaryPowerSync(this.rotation, 0, this.func_174877_v()), Utils.targetPointFromTile((TileEntity)this, 24));
        }
        return b;
    }

    public void prepareAreaCheck() {
        this.openList.clear();
        this.closedList.clear();
        this.checked.clear();
        for (EnumFacing f : EnumFacing.values()) {
            if (this.sideConfig[f.ordinal()] != 0) continue;
            this.openList.add(this.func_174877_v().func_177972_a(f));
            this.checkingArea = true;
        }
    }

    public void checkAreaTick() {
        int closedListMax = 2048;
        int timeout = 0;
        while (timeout < 64 && this.closedList.size() < 2048 && !this.openList.isEmpty()) {
            ++timeout;
            BlockPos next = this.openList.get(0);
            if (!this.checked.contains(next)) {
                Fluid fluid = blusunrize.immersiveengineering.common.util.Utils.getRelatedFluid((World)this.field_145850_b, (BlockPos)next);
                if (!(fluid == null || fluid == FluidRegistry.WATER && Config.IEConfig.Machines.pump_infiniteWater || this.searchFluid != null && fluid != this.searchFluid)) {
                    if (this.searchFluid == null) {
                        this.searchFluid = fluid;
                    }
                    if (blusunrize.immersiveengineering.common.util.Utils.drainFluidBlock((World)this.field_145850_b, (BlockPos)next, (boolean)false) != null) {
                        this.closedList.add(next);
                    }
                    for (EnumFacing f : EnumFacing.values()) {
                        BlockPos pos2 = next.func_177972_a(f);
                        fluid = blusunrize.immersiveengineering.common.util.Utils.getRelatedFluid((World)this.field_145850_b, (BlockPos)pos2);
                        if (this.checked.contains(pos2) || this.closedList.contains(pos2) || this.openList.contains(pos2) || fluid == null || fluid == FluidRegistry.WATER && Config.IEConfig.Machines.pump_infiniteWater || this.searchFluid != null && fluid != this.searchFluid) continue;
                        this.openList.add(pos2);
                    }
                }
                this.checked.add(next);
            }
            this.openList.remove(0);
        }
        if (this.closedList.size() >= 2048 || this.openList.isEmpty()) {
            this.checkingArea = false;
        }
    }

    public int outputFluid(FluidStack fs, boolean simulate) {
        FluidStack insertResource;
        if (fs == null) {
            return 0;
        }
        int canAccept = fs.amount;
        if (canAccept <= 0) {
            return 0;
        }
        int fluidForSort = canAccept;
        int sum = 0;
        HashMap<DirectionalFluidOutput, Integer> sorting = new HashMap<DirectionalFluidOutput, Integer>();
        for (EnumFacing f : EnumFacing.values()) {
            int temp;
            TileEntity tile;
            if (this.sideConfig[f.ordinal()] != 1 || (tile = blusunrize.immersiveengineering.common.util.Utils.getExistingTileEntity((World)this.field_145850_b, (BlockPos)this.func_174877_v().func_177972_a(f))) == null || !tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, f.func_176734_d())) continue;
            IFluidHandler handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, f.func_176734_d());
            insertResource = blusunrize.immersiveengineering.common.util.Utils.copyFluidStackWithAmount((FluidStack)fs, (int)fs.amount, (boolean)true);
            if (tile instanceof TileEntityFluidPipe && this.hasEnoughPower()) {
                insertResource.tag = new NBTTagCompound();
                insertResource.tag.func_74757_a("pressurized", true);
            }
            if ((temp = handler.fill(insertResource, false)) <= 0) continue;
            sorting.put(new DirectionalFluidOutput(handler, tile, f), temp);
            sum += temp;
        }
        if (sum > 0) {
            int f = 0;
            int i = 0;
            for (DirectionalFluidOutput output : sorting.keySet()) {
                float prio = (float)((Integer)sorting.get(output)).intValue() / (float)sum;
                int amount = (int)((float)fluidForSort * prio);
                if (i++ == sorting.size() - 1) {
                    amount = canAccept;
                }
                insertResource = blusunrize.immersiveengineering.common.util.Utils.copyFluidStackWithAmount((FluidStack)fs, (int)amount, (boolean)true);
                if (output.containingTile instanceof TileEntityFluidPipe && this.hasEnoughPower()) {
                    insertResource.tag = new NBTTagCompound();
                    insertResource.tag.func_74757_a("pressurized", true);
                }
                int r = output.output.fill(insertResource, !simulate);
                f += r;
                if ((canAccept -= r) > 0) continue;
                break;
            }
            return f;
        }
        return 0;
    }

    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.sideConfig = nbt.func_74759_k("sideConfig");
        if (this.sideConfig == null || this.sideConfig.length != 6) {
            this.sideConfig = new int[]{0, -1, -1, -1, -1, -1};
        }
        this.dummy = nbt.func_74767_n("dummy");
        if (nbt.func_74764_b("placeCobble")) {
            this.placeCobble = nbt.func_74767_n("placeCobble");
        }
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
        this.facing = EnumFacing.func_82600_a((int)nbt.func_74762_e("facing"));
        if (descPacket) {
            this.markContainingBlockForUpdate(null);
        }
    }

    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.func_74783_a("sideConfig", this.sideConfig);
        nbt.func_74757_a("dummy", this.dummy);
        nbt.func_74757_a("placeCobble", this.placeCobble);
        nbt.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        nbt.func_74768_a("facing", this.facing.ordinal());
    }

    public IEEnums.SideConfig getSideConfig(int side) {
        return side >= 0 && side < 6 ? IEEnums.SideConfig.values()[this.sideConfig[side] + 1] : IEEnums.SideConfig.NONE;
    }

    public boolean toggleSide(int side, EntityPlayer p) {
        if (side != 1 && !this.dummy) {
            int n = side;
            this.sideConfig[n] = this.sideConfig[n] + 1;
            if (this.sideConfig[side] > 1) {
                this.sideConfig[side] = -1;
            }
            this.func_70296_d();
            this.markContainingBlockForUpdate(null);
            this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 0, 0);
            return true;
        }
        if (p.func_70093_af()) {
            TileEntity tmp;
            TileEntityMechanicalPump master = this;
            if (this.dummy && (tmp = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b())) instanceof TileEntityMechanicalPump) {
                master = (TileEntityMechanicalPump)tmp;
            }
            master.placeCobble = !master.placeCobble;
            ChatUtils.sendServerNoSpamMessages((EntityPlayer)p, (ITextComponent[])new ITextComponent[]{new TextComponentTranslation("chat.immersiveengineering.info.pump.placeCobble." + master.placeCobble, new Object[0])});
            return true;
        }
        return false;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing != null && !this.dummy) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing != null && !this.dummy) {
            if (this.sidedFluidHandler[facing.ordinal()] == null) {
                this.sidedFluidHandler[facing.ordinal()] = new SidedFluidHandler(this, facing);
            }
            return (T)this.sidedFluidHandler[facing.ordinal()];
        }
        return (T)super.getCapability(capability, facing);
    }

    public String[] getOverlayText(EntityPlayer player, RayTraceResult mop, boolean hammer) {
        if (hammer && Config.IEConfig.colourblindSupport && !this.dummy) {
            int i = this.sideConfig[Math.min(this.sideConfig.length - 1, mop.field_178784_b.ordinal())];
            int j = this.sideConfig[Math.min(this.sideConfig.length - 1, mop.field_178784_b.func_176734_d().ordinal())];
            return new String[]{I18n.func_135052_a((String)"desc.immersiveengineering.info.blockSide.facing", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("desc.immersiveengineering.info.blockSide.connectFluid." + i), (Object[])new Object[0]), I18n.func_135052_a((String)"desc.immersiveengineering.info.blockSide.opposite", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("desc.immersiveengineering.info.blockSide.connectFluid." + j), (Object[])new Object[0])};
        }
        return null;
    }

    public boolean useNixieFont(EntityPlayer player, RayTraceResult mop) {
        return false;
    }

    @Override
    public void updateRotationStorage(float rpm, float torque, int part) {
        if (this.field_145850_b.field_72995_K && !this.isDummy() && part == 0) {
            this.rotation.setRotationSpeed(rpm);
            this.rotation.setTorque(torque);
        }
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public void setFacing(EnumFacing facing) {
        TileEntity tileEntity;
        this.facing = facing.func_176740_k().func_176722_c() ? facing : EnumFacing.NORTH;
        if (this.isDummy() && (tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b())) instanceof TileEntityMechanicalPump) {
            ((TileEntityMechanicalPump)tileEntity).setFacing(facing);
        }
    }

    public int getFacingLimitation() {
        return 2;
    }

    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return false;
    }

    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return this.isDummy();
    }

    public boolean canRotate(EnumFacing axis) {
        return this.isDummy();
    }

    public boolean isDummy() {
        return this.dummy;
    }

    public void placeDummies(BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ) {
        this.field_145850_b.func_175656_a(pos.func_177982_a(0, 1, 0), state);
        ((TileEntityMechanicalPump)this.field_145850_b.func_175625_s((BlockPos)pos.func_177982_a((int)0, (int)1, (int)0))).dummy = true;
    }

    public void breakDummies(BlockPos pos, IBlockState state) {
        for (int i = 0; i <= 1; ++i) {
            if (!blusunrize.immersiveengineering.common.util.Utils.isBlockAt((World)this.field_145850_b, (BlockPos)this.func_174877_v().func_177982_a(0, this.dummy ? -1 : 0, 0).func_177982_a(0, i, 0), (Block)IIContent.blockMechanicalDevice1, (int)IIBlockTypes_MechanicalDevice1.MECHANICAL_PUMP.getMeta())) continue;
            this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(0, this.dummy ? -1 : 0, 0).func_177982_a(0, i, 0));
        }
    }

    public float[] getBlockBounds() {
        if (!this.dummy) {
            return null;
        }
        return new float[]{0.1875f, 0.0f, 0.1875f, 0.8125f, 1.0f, 0.8125f};
    }

    public boolean canOutputPressurized(boolean consumePower) {
        int accelPower = Config.IEConfig.Machines.pump_consumption_accelerate;
        return this.hasEnoughPower();
    }

    private boolean hasEnoughPower() {
        return this.rotation.getRotationSpeed() >= (float)Config.IIConfig.Machines.MechanicalPump.rpmMin && this.rotation.getTorque() >= (float)Config.IIConfig.Machines.MechanicalPump.torqueMin;
    }

    public boolean hasOutputConnection(EnumFacing side) {
        return side != null && this.sideConfig[side.ordinal()] == 1;
    }

    private void selfDestruct() {
        this.field_145850_b.func_72876_a(null, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 1.0f, true);
        this.field_145850_b.func_175698_g(this.field_174879_c);
    }

    public static class DirectionalFluidOutput {
        IFluidHandler output;
        EnumFacing direction;
        TileEntity containingTile;

        public DirectionalFluidOutput(IFluidHandler output, TileEntity containingTile, EnumFacing direction) {
            this.output = output;
            this.direction = direction;
            this.containingTile = containingTile;
        }
    }

    static class SidedFluidHandler
    implements IFluidHandler {
        TileEntityMechanicalPump pump;
        EnumFacing facing;

        SidedFluidHandler(TileEntityMechanicalPump pump, EnumFacing facing) {
            this.pump = pump;
            this.facing = facing;
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (resource == null || this.pump.sideConfig[this.facing.ordinal()] != 0) {
                return 0;
            }
            return this.pump.tank.fill(resource, doFill);
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (resource == null) {
                return null;
            }
            return this.drain(resource.amount, doDrain);
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (this.pump.sideConfig[this.facing.ordinal()] != 1) {
                return null;
            }
            return this.pump.tank.drain(maxDrain, doDrain);
        }

        public IFluidTankProperties[] getTankProperties() {
            return this.pump.tank.getTankProperties();
        }
    }
}

