/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.blocks.multiblocks.metal.tileentities.first;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.api.crafting.IMultiblockRecipe;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import blusunrize.immersiveengineering.common.util.inventory.MultiFluidTank;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.IDataConnector;
import pl.pabilo8.immersiveintelligence.api.data.IDataDevice;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeInteger;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeString;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.IIGuiList;
import pl.pabilo8.immersiveintelligence.common.IISounds;
import pl.pabilo8.immersiveintelligence.common.blocks.multiblocks.metal.tileentities.first.MultiblockPrintingPress;

public class TileEntityPrintingPress
extends TileEntityMultiblockMetal<TileEntityPrintingPress, IMultiblockRecipe>
implements IDataDevice,
IEBlockInterfaces.IAdvancedCollisionBounds,
IEBlockInterfaces.IAdvancedSelectionBounds,
IEBlockInterfaces.IGuiTile,
ConveyorHandler.IConveyorAttachable,
IEBlockInterfaces.ISoundTile {
    public boolean active = false;
    public boolean hasPaper = false;
    public DataPacket dataToPrint = new DataPacket();
    public DataPacket newDataToPrint = new DataPacket();
    public int pagesLeft = 0;
    public int processTimeLeft = 0;
    public int rollerRotation = 0;
    public ItemStack renderStack0;
    public ItemStack renderStack1;
    public MultiFluidTank[] tanks = new MultiFluidTank[]{new MultiFluidTank(8000)};
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    IItemHandler inventoryHandler = new IEInventoryHandler(4, (IIEInventory)this, 0, true, true);
    IItemHandler insertionHandler = new IEInventoryHandler(1, (IIEInventory)this, 0, true, true);

    public TileEntityPrintingPress() {
        super((MultiblockHandler.IMultiblock)MultiblockPrintingPress.instance, new int[]{3, 5, 3}, Config.IIConfig.Machines.PrintingPress.energyCapacity, false);
        this.renderStack0 = new ItemStack((Item)IIContent.itemPrintedPage, 1, 0);
        this.renderStack1 = new ItemStack((Item)IIContent.itemPrintedPage, 1, 1);
    }

    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (!this.isDummy()) {
            if (!descPacket) {
                this.inventory = blusunrize.immersiveengineering.common.util.Utils.readInventory((NBTTagList)nbt.func_150295_c("inventory", 10), (int)4);
                this.dataToPrint = new DataPacket();
                this.dataToPrint.fromNBT(nbt.func_74775_l("dataToPrint"));
                this.newDataToPrint = new DataPacket();
                if (nbt.func_74764_b("newDataToPrint")) {
                    this.newDataToPrint.fromNBT(nbt.func_74775_l("newDataToPrint"));
                }
            }
            this.tanks[0].readFromNBT(nbt.func_74775_l("tank"));
            this.active = nbt.func_74767_n("active");
            this.processTimeLeft = nbt.func_74762_e("processTimeLeft");
        }
    }

    public void receiveMessageFromClient(NBTTagCompound message) {
        super.receiveMessageFromClient(message);
    }

    public void receiveMessageFromServer(NBTTagCompound message) {
        super.receiveMessageFromServer(message);
        if (message.func_74764_b("processTimeLeft")) {
            this.processTimeLeft = message.func_74762_e("processTimeLeft");
        }
        if (message.func_74764_b("active")) {
            this.active = message.func_74767_n("active");
        }
        if (message.func_74764_b("inventory")) {
            this.inventory = blusunrize.immersiveengineering.common.util.Utils.readInventory((NBTTagList)message.func_150295_c("inventory", 10), (int)4);
        }
        if (message.func_74764_b("tank")) {
            this.tanks[0] = this.tanks[0].readFromNBT(message.func_74775_l("tank"));
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
    }

    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (!this.isDummy()) {
            if (!descPacket) {
                nbt.func_74782_a("inventory", (NBTBase)blusunrize.immersiveengineering.common.util.Utils.writeInventory(this.inventory));
                nbt.func_74782_a("dataToPrint", (NBTBase)this.dataToPrint.toNBT());
                if (this.newDataToPrint != null) {
                    nbt.func_74782_a("newDataToPrint", (NBTBase)this.newDataToPrint.toNBT());
                }
            }
            nbt.func_74782_a("tank", (NBTBase)this.tanks[0].writeToNBT(new NBTTagCompound()));
            nbt.func_74757_a("active", this.active);
            nbt.func_74768_a("processTimeLeft", this.processTimeLeft);
        }
    }

    public void func_73660_a() {
        super.func_73660_a();
        NBTTagCompound tag = new NBTTagCompound();
        if (this.field_145850_b.field_72995_K) {
            ImmersiveEngineering.proxy.handleTileSound(IISounds.printing_press, (TileEntity)this, this.active, 0.5f, 1.0f);
            if (this.processTimeLeft > 0 && this.active) {
                --this.processTimeLeft;
                this.rollerRotation += 6;
                if (this.rollerRotation > 360) {
                    this.rollerRotation = 0;
                }
            }
        }
        if (this.field_145850_b.field_72995_K || this.isDummy()) {
            return;
        }
        boolean update = false;
        if (this.field_145850_b.func_82737_E() % 20L == 0L) {
            BlockPos pos = this.getBlockPosForPos(2).func_177967_a(this.facing.func_176734_d(), 1);
            ItemStack output = (ItemStack)this.inventory.get(1);
            TileEntity inventoryTile = this.field_145850_b.func_175625_s(pos);
            if (inventoryTile != null) {
                output = blusunrize.immersiveengineering.common.util.Utils.insertStackIntoInventory((TileEntity)inventoryTile, (ItemStack)output, (EnumFacing)this.facing.func_176734_d());
            }
            this.inventory.set(1, (Object)output);
            update = true;
        }
        if (this.pagesLeft > 0) {
            if (this.processTimeLeft % (Config.IIConfig.Machines.PrintingPress.printTime / 4) == 0) {
                update = true;
            }
            if (this.processTimeLeft > 0 && this.energyStorage.getEnergyStored() >= Config.IIConfig.Machines.PrintingPress.energyUsage) {
                this.energyStorage.extractEnergy(Config.IIConfig.Machines.PrintingPress.energyUsage, false);
                --this.processTimeLeft;
                if (this.processTimeLeft % 10 == 0) {
                    update = true;
                    this.active = true;
                }
            } else if (!((ItemStack)this.inventory.get(0)).func_190926_b() && this.processTimeLeft < 1) {
                if (this.newDataToPrint != null) {
                    this.dataToPrint = this.newDataToPrint;
                    this.newDataToPrint = null;
                }
                this.active = true;
                this.hasPaper = true;
                this.inventoryHandler.extractItem(0, 1, false);
                this.processTimeLeft = Config.IIConfig.Machines.PrintingPress.printTime;
                update = true;
            } else {
                this.active = false;
            }
            if (this.processTimeLeft < 1 && this.hasPaper) {
                this.onProcessFinishButInYellow();
                update = true;
                this.hasPaper = false;
                this.field_145850_b.func_184133_a(null, this.getBlockPosForPos(2), IISounds.paper_eject, SoundCategory.BLOCKS, 0.3f, 1.0f);
            }
            tag.func_74782_a("inventory", (NBTBase)blusunrize.immersiveengineering.common.util.Utils.writeInventory(this.inventory));
        } else {
            this.active = false;
        }
        if (update) {
            tag.func_74768_a("processTimeLeft", this.processTimeLeft);
            tag.func_74757_a("active", this.active);
        }
        if (Utils.handleBucketTankInteraction((IFluidTank[])this.tanks, this.inventory, (int)2, (int)3, (int)0, (boolean)false)) {
            update = true;
            tag.func_74782_a("tank", (NBTBase)this.tanks[0].writeToNBT(new NBTTagCompound()));
        }
        if (update) {
            ImmersiveEngineering.packetHandler.sendToAllAround((IMessage)new MessageTileSync((TileEntityIEBase)this, tag), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 32.0));
        }
    }

    void onProcessFinishButInYellow() {
        --this.pagesLeft;
        this.processTimeLeft = 0;
        if (this.pagesLeft < 1) {
            this.active = false;
        }
        DataTypeString item_type = this.dataToPrint.getVarInType(DataTypeString.class, this.dataToPrint.getPacketVariable(Character.valueOf('m')));
        switch (item_type.value) {
            case "text": {
                String toPrint = this.dataToPrint.getPacketVariable(Character.valueOf('t')).valueToString();
                StringBuilder printedChars = new StringBuilder();
                int black_amount = 0;
                int cyan_amount = 0;
                int magenta_amount = 0;
                int yellow_amount = 0;
                for (FluidStack stack : this.tanks[0].fluids) {
                    if (stack.getFluid().getName().equals("ink")) {
                        black_amount += stack.amount;
                        continue;
                    }
                    if (stack.getFluid().getName().equals("ink_cyan")) {
                        cyan_amount += stack.amount;
                        continue;
                    }
                    if (stack.getFluid().getName().equals("ink_magenta")) {
                        magenta_amount += stack.amount;
                        continue;
                    }
                    if (!stack.getFluid().getName().equals("ink_yellow")) continue;
                    yellow_amount += stack.amount;
                }
                int black_amount_start = black_amount;
                int cyan_amount_start = cyan_amount;
                int magenta_amount_start = magenta_amount;
                int yellow_amount_start = yellow_amount;
                ArrayList<Float> black_cost = new ArrayList<Float>();
                ArrayList<Float> cyan_cost = new ArrayList<Float>();
                ArrayList<Float> magenta_cost = new ArrayList<Float>();
                ArrayList<Float> yellow_cost = new ArrayList<Float>();
                black_cost.add(Float.valueOf(1.0f));
                cyan_cost.add(Float.valueOf(0.0f));
                magenta_cost.add(Float.valueOf(0.0f));
                yellow_cost.add(Float.valueOf(0.0f));
                int charnum = 0;
                int shouldstartfrom = 0;
                int tag_endings_needed = 0;
                for (char c : toPrint.toCharArray()) {
                    if (++charnum < shouldstartfrom) continue;
                    if (c == '<') {
                        String fragment = toPrint.substring(charnum - 1);
                        if (fragment.startsWith("<br>")) {
                            shouldstartfrom = charnum + 4;
                            printedChars.append("<br>");
                            continue;
                        }
                        if (!fragment.startsWith("<hexcol=")) continue;
                        if (((Float)black_cost.get(black_cost.size() - 1)).floatValue() * (float)Config.IIConfig.Machines.PrintingPress.printInkUsage > (float)black_amount) {
                            black_cost.set(black_cost.size() - 1, Float.valueOf((float)black_amount / (float)Config.IIConfig.Machines.PrintingPress.printInkUsage));
                        }
                        if (((Float)cyan_cost.get(cyan_cost.size() - 1)).floatValue() * (float)Config.IIConfig.Machines.PrintingPress.printInkUsage > (float)cyan_amount) {
                            cyan_cost.set(cyan_cost.size() - 1, Float.valueOf((float)cyan_amount / (float)Config.IIConfig.Machines.PrintingPress.printInkUsage));
                        }
                        if (((Float)magenta_cost.get(magenta_cost.size() - 1)).floatValue() * (float)Config.IIConfig.Machines.PrintingPress.printInkUsage > (float)magenta_amount) {
                            magenta_cost.set(magenta_cost.size() - 1, Float.valueOf((float)magenta_amount / (float)Config.IIConfig.Machines.PrintingPress.printInkUsage));
                        }
                        if (((Float)yellow_cost.get(yellow_cost.size() - 1)).floatValue() * (float)Config.IIConfig.Machines.PrintingPress.printInkUsage > (float)yellow_amount) {
                            yellow_cost.set(yellow_cost.size() - 1, Float.valueOf((float)yellow_amount / (float)Config.IIConfig.Machines.PrintingPress.printInkUsage));
                        }
                        try {
                            int color = Integer.parseInt(fragment.substring(8, 14), 16);
                            Color col = new Color(color);
                            int[] colors = Utils.rgbToCmyk(col.getRed(), col.getGreen(), col.getBlue());
                            cyan_cost.add(Float.valueOf((float)colors[0] / 255.0f));
                            yellow_cost.add(Float.valueOf((float)colors[1] / 255.0f));
                            magenta_cost.add(Float.valueOf((float)colors[2] / 255.0f));
                            black_cost.add(Float.valueOf((float)colors[3] / 255.0f));
                            ++tag_endings_needed;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        shouldstartfrom = charnum + 15;
                        printedChars.append("<hexcol=").append(fragment, 8, 14).append(":");
                        continue;
                    }
                    if (tag_endings_needed > 0 && c == '>') {
                        printedChars.append(">");
                        --tag_endings_needed;
                        black_cost.remove(black_cost.size() - 1);
                        cyan_cost.remove(cyan_cost.size() - 1);
                        magenta_cost.remove(magenta_cost.size() - 1);
                        yellow_cost.remove(yellow_cost.size() - 1);
                        continue;
                    }
                    if (((Float)black_cost.get(black_cost.size() - 1)).floatValue() == 0.0f && ((Float)cyan_cost.get(cyan_cost.size() - 1)).floatValue() == 0.0f && ((Float)magenta_cost.get(magenta_cost.size() - 1)).floatValue() == 0.0f && ((Float)yellow_cost.get(yellow_cost.size() - 1)).floatValue() == 0.0f) {
                        printedChars.append(" ");
                        continue;
                    }
                    if (((Float)black_cost.get(black_cost.size() - 1)).floatValue() * (float)Config.IIConfig.Machines.PrintingPress.printInkUsage <= (float)black_amount && ((Float)cyan_cost.get(cyan_cost.size() - 1)).floatValue() * (float)Config.IIConfig.Machines.PrintingPress.printInkUsage <= (float)cyan_amount && ((Float)magenta_cost.get(magenta_cost.size() - 1)).floatValue() * (float)Config.IIConfig.Machines.PrintingPress.printInkUsage <= (float)magenta_amount && ((Float)yellow_cost.get(yellow_cost.size() - 1)).floatValue() * (float)Config.IIConfig.Machines.PrintingPress.printInkUsage <= (float)yellow_amount) {
                        printedChars.append(c);
                        black_amount = (int)((float)black_amount - ((Float)black_cost.get(black_cost.size() - 1)).floatValue() * (float)Config.IIConfig.Machines.PrintingPress.printInkUsage);
                        cyan_amount = (int)((float)cyan_amount - ((Float)cyan_cost.get(cyan_cost.size() - 1)).floatValue() * (float)Config.IIConfig.Machines.PrintingPress.printInkUsage);
                        magenta_amount = (int)((float)magenta_amount - ((Float)magenta_cost.get(magenta_cost.size() - 1)).floatValue() * (float)Config.IIConfig.Machines.PrintingPress.printInkUsage);
                        yellow_amount = (int)((float)yellow_amount - ((Float)yellow_cost.get(yellow_cost.size() - 1)).floatValue() * (float)Config.IIConfig.Machines.PrintingPress.printInkUsage);
                        continue;
                    }
                    if (((Float)black_cost.get(black_cost.size() - 1)).floatValue() * (float)Config.IIConfig.Machines.PrintingPress.printInkUsage > (float)black_amount) {
                        black_cost.set(black_cost.size() - 1, Float.valueOf((float)black_amount / (float)Config.IIConfig.Machines.PrintingPress.printInkUsage));
                    }
                    if (((Float)cyan_cost.get(cyan_cost.size() - 1)).floatValue() * (float)Config.IIConfig.Machines.PrintingPress.printInkUsage > (float)cyan_amount) {
                        cyan_cost.set(cyan_cost.size() - 1, Float.valueOf((float)cyan_amount / (float)Config.IIConfig.Machines.PrintingPress.printInkUsage));
                    }
                    if (((Float)magenta_cost.get(magenta_cost.size() - 1)).floatValue() * (float)Config.IIConfig.Machines.PrintingPress.printInkUsage > (float)magenta_amount) {
                        magenta_cost.set(magenta_cost.size() - 1, Float.valueOf((float)magenta_amount / (float)Config.IIConfig.Machines.PrintingPress.printInkUsage));
                    }
                    if (((Float)yellow_cost.get(yellow_cost.size() - 1)).floatValue() * (float)Config.IIConfig.Machines.PrintingPress.printInkUsage > (float)yellow_amount) {
                        yellow_cost.set(yellow_cost.size() - 1, Float.valueOf((float)yellow_amount / (float)Config.IIConfig.Machines.PrintingPress.printInkUsage));
                    }
                    if (((Float)black_cost.get(black_cost.size() - 1)).floatValue() == 0.0f && ((Float)cyan_cost.get(cyan_cost.size() - 1)).floatValue() == 0.0f && ((Float)magenta_cost.get(magenta_cost.size() - 1)).floatValue() == 0.0f && ((Float)yellow_cost.get(yellow_cost.size() - 1)).floatValue() == 0.0f) {
                        printedChars.append(" ");
                        continue;
                    }
                    printedChars.append("> <hexcol=");
                    int[] colors = Utils.cmykToRgb(Math.round(((Float)cyan_cost.get(cyan_cost.size() - 1)).floatValue() * 255.0f), Math.round(((Float)magenta_cost.get(magenta_cost.size() - 1)).floatValue() * 255.0f), Math.round(((Float)yellow_cost.get(yellow_cost.size() - 1)).floatValue() * 255.0f), Math.round(((Float)black_cost.get(black_cost.size() - 1)).floatValue() * 255.0f));
                    printedChars.append(String.format("%02x%02x%02x:", Math.round(colors[0]), Math.round(colors[1]), Math.round(colors[2])));
                }
                while (tag_endings_needed > 0) {
                    --tag_endings_needed;
                    printedChars.append(">");
                }
                this.tanks[0].drain(FluidRegistry.getFluidStack((String)"ink", (int)(black_amount_start - black_amount)), true);
                this.tanks[0].drain(FluidRegistry.getFluidStack((String)"ink_cyan", (int)(cyan_amount_start - cyan_amount)), true);
                this.tanks[0].drain(FluidRegistry.getFluidStack((String)"ink_magenta", (int)(magenta_amount_start - magenta_amount)), true);
                this.tanks[0].drain(FluidRegistry.getFluidStack((String)"ink_yellow", (int)(yellow_amount_start - yellow_amount)), true);
                ItemStack stack = new ItemStack((Item)IIContent.itemPrintedPage, 1, 1);
                IIContent.itemPrintedPage.setText(stack, printedChars.toString());
                stack = this.inventoryHandler.insertItem(1, stack, false);
                if (stack.func_190926_b()) break;
                blusunrize.immersiveengineering.common.util.Utils.dropStackAtPos((World)this.field_145850_b, (BlockPos)this.getBlockPosForPos(2), (ItemStack)stack, (EnumFacing)this.facing);
                break;
            }
            case "blueprint": {
                this.inventoryHandler.insertItem(1, new ItemStack((Item)IIContent.itemPrintedPage, 1, 3), false);
                break;
            }
            case "code": {
                this.inventoryHandler.insertItem(1, new ItemStack((Item)IIContent.itemPrintedPage, 1, 2), false);
                break;
            }
            default: {
                this.inventoryHandler.insertItem(1, new ItemStack((Item)IIContent.itemPrintedPage, 1, 0), false);
            }
        }
    }

    public float[] getBlockBounds() {
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    public int[] getEnergyPos() {
        return new int[]{34};
    }

    public int[] getRedstonePos() {
        return new int[0];
    }

    public boolean isInWorldProcessingMachine() {
        return false;
    }

    public void doProcessOutput(ItemStack output) {
    }

    public void doProcessFluidOutput(FluidStack output) {
    }

    public void onProcessFinish(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
    }

    public int getMaxProcessPerTick() {
        return 1;
    }

    public int getProcessQueueMaxLength() {
        return 1;
    }

    public float getMinProcessDistance(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
        return 0.0f;
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        if (slot == 0) {
            return blusunrize.immersiveengineering.common.util.Utils.compareToOreName((ItemStack)stack, (String)"pageEmpty");
        }
        if (slot == 1) {
            return blusunrize.immersiveengineering.common.util.Utils.compareToOreName((ItemStack)stack, (String)"pageWritten") || blusunrize.immersiveengineering.common.util.Utils.compareToOreName((ItemStack)stack, (String)"pageEmpty");
        }
        return stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
    }

    public int getSlotLimit(int slot) {
        return slot == 1 ? 12 : 64;
    }

    public int[] getOutputSlots() {
        return new int[]{1};
    }

    public int[] getOutputTanks() {
        return new int[0];
    }

    public boolean additionalCanProcessCheck(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
        return false;
    }

    public IFluidTank[] getInternalTanks() {
        return this.tanks;
    }

    protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side) {
        TileEntityPrintingPress master = (TileEntityPrintingPress)this.master();
        if (master != null && this.field_174879_c == 29 && side.func_176740_k() == EnumFacing.Axis.Y) {
            return master.tanks;
        }
        return new FluidTank[0];
    }

    protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resource) {
        String fname = resource.getFluid().getName();
        if (this.field_174879_c == 29 && side.func_176740_k() == EnumFacing.Axis.Y && (fname.equals("ink") || fname.equals("ink_cyan") || fname.equals("ink_magenta") || fname.equals("ink_yellow"))) {
            TileEntityPrintingPress master = (TileEntityPrintingPress)this.master();
            return master != null && master.tanks[iTank].getFluidAmount() < master.tanks[iTank].getCapacity();
        }
        return false;
    }

    protected boolean canDrainTankFrom(int iTank, EnumFacing side) {
        return side.func_176740_k() == EnumFacing.Axis.Y && iTank == 0;
    }

    public void doGraphicalUpdates(int slot) {
        this.func_70296_d();
    }

    public IMultiblockRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    protected IMultiblockRecipe readRecipeFromNBT(NBTTagCompound tag) {
        return null;
    }

    @Override
    public void onReceive(DataPacket packet, EnumFacing side) {
        if (this.field_174879_c == 6) {
            ((TileEntityPrintingPress)this.master()).onReceive(packet, side);
        }
        if (!this.isDummy()) {
            if (packet.variables.containsKey(Character.valueOf('c'))) {
                IDataType c = packet.getPacketVariable(Character.valueOf('c'));
                if (c instanceof DataTypeString) {
                    IDataConnector conn = Utils.findConnectorFacing(this.getBlockPosForPos(6), this.field_145850_b, this.mirrored ? this.facing.func_176746_e() : this.facing.func_176735_f());
                    if (conn == null) {
                        return;
                    }
                    DataPacket p = new DataPacket();
                    switch (((DataTypeString)c).value) {
                        case "get_ink": 
                        case "get_ink_black": {
                            int amount = this.tanks[0].fluids.stream().filter(fluidStack -> fluidStack.getFluid().getName().equals("ink")).mapToInt(fs -> fs.amount).sum();
                            p.setVariable(Character.valueOf('c'), new DataTypeString("ink_black"));
                            p.setVariable(Character.valueOf('g'), new DataTypeInteger(amount));
                            conn.sendPacket(p);
                            break;
                        }
                        case "get_ink_cyan": {
                            int amount = this.tanks[0].fluids.stream().filter(fluidStack -> fluidStack.getFluid().getName().equals("ink_cyan")).mapToInt(fs -> fs.amount).sum();
                            p.setVariable(Character.valueOf('c'), new DataTypeString("ink_cyan"));
                            p.setVariable(Character.valueOf('g'), new DataTypeInteger(amount));
                            conn.sendPacket(p);
                            break;
                        }
                        case "get_ink_yellow": {
                            int amount = this.tanks[0].fluids.stream().filter(fluidStack -> fluidStack.getFluid().getName().equals("ink_yellow")).mapToInt(fs -> fs.amount).sum();
                            p.setVariable(Character.valueOf('c'), new DataTypeString("ink_yellow"));
                            p.setVariable(Character.valueOf('g'), new DataTypeInteger(amount));
                            conn.sendPacket(p);
                            break;
                        }
                        case "get_ink_magenta": {
                            int amount = this.tanks[0].fluids.stream().filter(fluidStack -> fluidStack.getFluid().getName().equals("ink_magenta")).mapToInt(fs -> fs.amount).sum();
                            p.setVariable(Character.valueOf('c'), new DataTypeString("ink_magenta"));
                            p.setVariable(Character.valueOf('g'), new DataTypeInteger(amount));
                            conn.sendPacket(p);
                            break;
                        }
                        case "get_energy": {
                            p.setVariable(Character.valueOf('c'), new DataTypeString("energy"));
                            p.setVariable(Character.valueOf('g'), new DataTypeInteger(this.energyStorage.getEnergyStored()));
                            conn.sendPacket(p);
                            break;
                        }
                        case "get_paper": {
                            p.setVariable(Character.valueOf('c'), new DataTypeString("paper"));
                            p.setVariable(Character.valueOf('g'), new DataTypeInteger(((ItemStack)this.inventory.get(0)).func_190916_E()));
                            conn.sendPacket(p);
                        }
                    }
                }
            } else {
                this.energyStorage.extractEnergy(Config.IIConfig.Machines.PrintingPress.energyUsage, false);
                this.pagesLeft = packet.getVarInType(DataTypeInteger.class, (IDataType)packet.getPacketVariable((Character)Character.valueOf((char)'a'))).value;
                this.newDataToPrint = packet.clone();
            }
        }
    }

    public List<AxisAlignedBB> getAdvancedSelectionBounds() {
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        if (this.field_174879_c == 0 || this.field_174879_c == 1) {
            list.add(new AxisAlignedBB(0.0, 0.8125, 0.0, 1.0, 1.0, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            switch (this.mirrored ^ this.field_174879_c == 1 ? this.facing.func_176734_d() : this.facing) {
                case NORTH: {
                    list.add(new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.25, 0.8125, 0.25).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                    list.add(new AxisAlignedBB(0.0625, 0.0, 0.75, 0.25, 0.8125, 0.9375).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                    break;
                }
                case SOUTH: {
                    list.add(new AxisAlignedBB(0.75, 0.0, 0.0625, 0.9375, 0.8125, 0.25).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                    list.add(new AxisAlignedBB(0.75, 0.0, 0.75, 0.9375, 0.8125, 0.9375).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                    break;
                }
                case EAST: {
                    list.add(new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.25, 0.8125, 0.25).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                    list.add(new AxisAlignedBB(0.75, 0.0, 0.0625, 0.9375, 0.8125, 0.25).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                    break;
                }
                case WEST: {
                    list.add(new AxisAlignedBB(0.0625, 0.0, 0.75, 0.25, 0.8125, 0.9375).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                    list.add(new AxisAlignedBB(0.75, 0.0, 0.75, 0.9375, 0.8125, 0.9375).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                }
            }
        } else if (this.field_174879_c == 2) {
            list.add(new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.25, 0.875).func_72321_a((double)this.facing.func_82601_c() * 0.125, 0.0, (double)this.facing.func_82599_e() * 0.125).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            switch (this.facing) {
                case NORTH: {
                    list.add(new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.125, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                    list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.125, 0.875).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                    list.add(new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.125, 0.875).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                    break;
                }
                case SOUTH: {
                    list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.125, 0.125).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                    list.add(new AxisAlignedBB(0.0, 0.0, 0.125, 0.125, 1.125, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                    list.add(new AxisAlignedBB(0.875, 0.0, 0.125, 1.0, 1.125, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                    break;
                }
                case EAST: {
                    list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.125, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                    list.add(new AxisAlignedBB(0.125, 0.0, 0.0, 1.0, 1.125, 0.125).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                    list.add(new AxisAlignedBB(0.125, 0.0, 0.875, 1.0, 1.125, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                    break;
                }
                case WEST: {
                    list.add(new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.125, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                    list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 0.875, 1.125, 0.125).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                    list.add(new AxisAlignedBB(0.0, 0.0, 0.875, 0.875, 1.125, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                }
            }
        } else if (this.field_174879_c == 15) {
            list.add(new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.4375, 0.875).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
        } else if (this.field_174879_c == 16) {
            list.add(new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.4375, 0.9375).func_191194_a(new Vec3d((this.mirrored ? this.facing.func_176746_e() : this.facing.func_176735_f()).func_176730_m()).func_186678_a(0.0625)).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
        } else if (this.field_174879_c == 34) {
            list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            list.add(new AxisAlignedBB(0.125, 0.5, 0.125, 0.875, 1.0, 0.875).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
        } else if (this.field_174879_c == 27) {
            list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_191195_a((double)this.facing.func_82601_c() * 0.0625, 0.0, (double)this.facing.func_82599_e() * 0.0625).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
        } else if (this.field_174879_c == 28) {
            if (this.facing.func_176740_k() == EnumFacing.Axis.X) {
                list.add(new AxisAlignedBB(0.125, 0.0, 0.0, 0.875, 0.875, 1.0).func_191195_a(0.0, 0.0, this.facing == EnumFacing.EAST ^ this.mirrored ? -0.25 : 0.25).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            } else {
                list.add(new AxisAlignedBB(0.0, 0.0, 0.125, 1.0, 0.875, 0.875).func_191195_a(this.facing == EnumFacing.NORTH ^ this.mirrored ? -0.25 : 0.25, 0.0, 0.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            }
        } else if (this.field_174879_c == 29) {
            if (this.facing.func_176740_k() == EnumFacing.Axis.X) {
                list.add(new AxisAlignedBB(0.125, 0.0, 0.0, 0.875, 0.875, 1.0).func_191195_a(0.0, 0.0, this.facing == EnumFacing.EAST ^ this.mirrored ? 0.125 : -0.125).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            } else {
                list.add(new AxisAlignedBB(0.0, 0.0, 0.125, 1.0, 0.875, 0.875).func_191195_a(this.facing == EnumFacing.NORTH ^ this.mirrored ? 0.125 : -0.125, 0.0, 0.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            }
            list.add(new AxisAlignedBB(0.25, 0.875, 0.25, 0.75, 1.0, 0.75).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
        } else {
            list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
        }
        return list;
    }

    public boolean isOverrideBox(AxisAlignedBB box, EntityPlayer player, RayTraceResult mop, ArrayList<AxisAlignedBB> list) {
        return false;
    }

    public List<AxisAlignedBB> getAdvancedColisionBounds() {
        return this.getAdvancedSelectionBounds();
    }

    public boolean canOpenGui() {
        return true;
    }

    public int getGuiID() {
        return IIGuiList.GUI_PRINTING_PRESS.ordinal();
    }

    @Nullable
    public TileEntity getGuiMaster() {
        return this.master();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (this.field_174879_c == 27 && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.field_174879_c == 27) {
            TileEntityPrintingPress master = (TileEntityPrintingPress)this.master();
            return (T)master.insertionHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void onGuiOpened(EntityPlayer player, boolean clientside) {
        if (!clientside) {
            NBTTagCompound tag = new NBTTagCompound();
            ImmersiveEngineering.packetHandler.sendToAllAround((IMessage)new MessageTileSync((TileEntityIEBase)this, tag), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 32.0));
        }
    }

    public EnumFacing[] sigOutputDirections() {
        if (this.field_174879_c == 2) {
            return new EnumFacing[]{this.mirrored ? this.facing.func_176735_f() : this.facing.func_176746_e()};
        }
        return new EnumFacing[0];
    }

    public boolean shoudlPlaySound(String sound) {
        return true;
    }
}

