/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.blocks.multiblocks.metal.tileentities.first;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.api.crafting.IMultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorageAdvanced;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.blocks.wooden.BlockTypes_WoodenDevice0;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import blusunrize.immersiveengineering.common.util.inventory.MultiFluidTank;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.IDataDevice;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeInteger;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeItemStack;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeString;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;
import pl.pabilo8.immersiveintelligence.api.utils.IIMultiblockInterfaces;
import pl.pabilo8.immersiveintelligence.api.utils.MachineUpgrade;
import pl.pabilo8.immersiveintelligence.api.utils.vehicles.IUpgradableMachine;
import pl.pabilo8.immersiveintelligence.client.render.multiblock.metal.PackerRenderer;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.IIGuiList;
import pl.pabilo8.immersiveintelligence.common.blocks.multiblocks.metal.tileentities.first.MultiblockPacker;
import pl.pabilo8.immersiveintelligence.common.blocks.types.IIBlockTypes_MetalDevice;
import pl.pabilo8.immersiveintelligence.common.items.ammunition.ItemIIBulletMagazine;

public class TileEntityPacker
extends TileEntityMultiblockMetal<TileEntityPacker, IMultiblockRecipe>
implements IDataDevice,
IIMultiblockInterfaces.IAdvancedBounds,
ConveyorHandler.IConveyorAttachable,
IEBlockInterfaces.IGuiTile,
IUpgradableMachine {
    public static HashMap<Predicate<ItemStack>, Function<ItemStack, IItemHandler>> itemHandleMap = new HashMap();
    public static HashMap<Predicate<ItemStack>, Function<ItemStack, FluidHandlerItemStack>> fluidHandleMap = new HashMap();
    public boolean repeatActions = false;
    protected ArrayList<MachineUpgrade> upgrades = new ArrayList();
    MachineUpgrade currentlyInstalled = null;
    int upgradeProgress = 0;
    public int clientUpgradeProgress = 0;
    public int processTime = 0;
    public ArrayList<PackerTask> tasks = new ArrayList();
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)55, (Object)ItemStack.field_190927_a);
    public IItemHandler containerHandler = new IEInventoryHandler(1, (IIEInventory)this, 0, true, true);
    IItemHandler inventoryHandler = new IEInventoryHandler(54, (IIEInventory)this, 1, true, true);
    public FluxStorageAdvanced energyStorageUpgrade = new FluxStorageAdvanced(Config.IIConfig.Machines.Packer.energyCapacityUpgrade);
    public MultiFluidTank fluidTank = new MultiFluidTank(Config.IIConfig.Machines.Packer.fluidCapacityUpgrade);

    public TileEntityPacker() {
        super((MultiblockHandler.IMultiblock)MultiblockPacker.instance, MultiblockPacker.instance.getSize(), Config.IIConfig.Machines.Packer.energyCapacity, true);
    }

    public void readCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (this.isDummy()) {
            return;
        }
        if (!descPacket) {
            this.inventory = blusunrize.immersiveengineering.common.util.Utils.readInventory((NBTTagList)nbt.func_150295_c("inventory", 10), (int)this.inventory.size());
        }
        this.getUpgradesFromNBT(nbt);
        this.repeatActions = nbt.func_74767_n("repeatActions");
        if (this.hasUpgrade(IIContent.UPGRADE_PACKER_ENERGY)) {
            this.energyStorage.readFromNBT(nbt.func_74775_l("energy_upgrade"));
        }
        this.readTasks(nbt.func_150295_c("tasks", 10));
    }

    public void writeCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (this.isDummy()) {
            return;
        }
        if (!descPacket) {
            nbt.func_74782_a("inventory", (NBTBase)blusunrize.immersiveengineering.common.util.Utils.writeInventory(this.inventory));
        }
        this.saveUpgradesToNBT(nbt);
        nbt.func_74757_a("repeatActions", this.repeatActions);
        if (this.hasUpgrade(IIContent.UPGRADE_PACKER_ENERGY)) {
            nbt.func_74782_a("energy_upgrade", (NBTBase)this.energyStorage.writeToNBT(new NBTTagCompound()));
        }
        nbt.func_74782_a("tasks", (NBTBase)this.writeTasks());
    }

    public void receiveMessageFromServer(@Nonnull NBTTagCompound message) {
        super.receiveMessageFromServer(message);
        if (message.func_74764_b("inventory")) {
            this.inventory = blusunrize.immersiveengineering.common.util.Utils.readInventory((NBTTagList)message.func_150295_c("inventory", 10), (int)this.inventory.size());
        }
        if (message.func_74764_b("repeatActions")) {
            this.repeatActions = message.func_74767_n("repeatActions");
        }
        if (message.func_74764_b("tasks")) {
            this.readTasks(message.func_150295_c("tasks", 10));
        }
    }

    public void receiveMessageFromClient(@Nonnull NBTTagCompound message) {
        super.receiveMessageFromServer(message);
        if (message.func_74764_b("repeatActions")) {
            this.repeatActions = message.func_74767_n("repeatActions");
        }
        if (message.func_74764_b("tasks")) {
            this.readTasks(message.func_150295_c("tasks", 10));
        }
    }

    public NBTTagList writeTasks() {
        NBTTagList tagTasks = new NBTTagList();
        for (PackerTask task : this.tasks) {
            tagTasks.func_74742_a((NBTBase)task.toNBT());
        }
        return tagTasks;
    }

    private void readTasks(NBTTagList tagTasks) {
        this.tasks.clear();
        for (NBTBase task : tagTasks) {
            if (!(task instanceof NBTTagCompound)) continue;
            this.tasks.add(new PackerTask((NBTTagCompound)task));
        }
    }

    public void func_73660_a() {
        BlockPos pos;
        TileEntity inventoryTile;
        super.func_73660_a();
        boolean update = false;
        if (!this.containerHandler.getStackInSlot(0).func_190926_b()) {
            if (this.processTime < Config.IIConfig.Machines.Packer.actionTime) {
                ItemStack packedItem;
                if (this.processTime == 0) {
                    update = true;
                }
                ++this.processTime;
                if ((double)this.processTime == (double)Config.IIConfig.Machines.Packer.actionTime * 0.5 && !(packedItem = this.containerHandler.getStackInSlot(0)).func_190926_b() && this.energyStorage.getEnergyStored() >= Config.IIConfig.Machines.Packer.energyUsage) {
                    this.energyStorage.extractEnergy(Config.IIConfig.Machines.Packer.energyUsage, false);
                    boolean unpacker = this.hasUpgrade(IIContent.UPGRADE_UNPACKER_CONVERSION);
                    boolean repeat = true;
                    int repeats = 0;
                    while (repeat) {
                        repeat = false;
                        if (++repeats <= 100) {
                            block6: for (PackerTask task : this.tasks) {
                                boolean isLimited;
                                boolean bl = isLimited = task.expirationAmount != -1;
                                if (this.field_145850_b.field_72995_K && unpacker) break;
                                block0 : switch (task.actionType) {
                                    case ITEM: {
                                        Optional<Function> handlerFunction = itemHandleMap.entrySet().stream().filter(p -> ((Predicate)p.getKey()).test(packedItem)).map(Map.Entry::getValue).findFirst();
                                        if (!handlerFunction.isPresent()) break;
                                        IItemHandler handler = (IItemHandler)handlerFunction.get().apply(packedItem);
                                        IItemHandler handlerIn = unpacker ? handler : this.inventoryHandler;
                                        IItemHandler handlerOut = unpacker ? this.inventoryHandler : handler;
                                        int slots = Math.min(task.mode == PackerPutMode.SLOT ? task.stack.inputSize : Integer.MAX_VALUE, isLimited ? task.expirationAmount : Integer.MAX_VALUE);
                                        int amount = Math.min(task.mode == PackerPutMode.AMOUNT ? task.stack.inputSize : Integer.MAX_VALUE, isLimited ? task.expirationAmount : Integer.MAX_VALUE);
                                        for (int i = 0; i < handlerIn.getSlots(); ++i) {
                                            if ("*".equals(task.stack.oreName) || task.stack.matchesItemStackIgnoringSize(handlerIn.extractItem(i, amount, true))) {
                                                ItemStack extracted = handlerIn.extractItem(i, amount, false);
                                                amount -= extracted.func_190916_E();
                                                if (isLimited) {
                                                    task.expirationAmount = Math.max(0, task.expirationAmount - extracted.func_190916_E());
                                                }
                                                if ((extracted = ItemHandlerHelper.insertItem((IItemHandler)handlerOut, (ItemStack)extracted, (boolean)false)).func_190916_E() == 0) {
                                                    repeat = this.repeatActions;
                                                }
                                                amount += extracted.func_190916_E();
                                                handlerIn.insertItem(i, extracted, false);
                                                --slots;
                                            }
                                            if (isLimited && task.expirationAmount <= 0 || slots <= 0) continue block6;
                                            if (amount <= 0) break block0;
                                        }
                                        continue block6;
                                    }
                                    case FLUID: {
                                        if (!unpacker) break;
                                        break;
                                    }
                                    case ENERGY: {
                                        if (unpacker) {
                                            EnergyHelper.insertFlux((ItemStack)packedItem, (int)this.energyStorageUpgrade.receiveEnergy(EnergyHelper.extractFlux((ItemStack)packedItem, (int)10000000, (boolean)false), false), (boolean)false);
                                            break;
                                        }
                                        this.energyStorageUpgrade.receiveEnergy(EnergyHelper.insertFlux((ItemStack)packedItem, (int)this.energyStorageUpgrade.extractEnergy(10000000, false), (boolean)false), false);
                                    }
                                }
                            }
                            this.tasks.removeIf(packerTask -> packerTask.expirationAmount == 0);
                            continue;
                        }
                        break;
                    }
                }
            } else {
                this.processTime = 0;
                if (!this.field_145850_b.field_72995_K) {
                    EnumFacing ff = this.mirrored ? this.facing.func_176735_f() : this.facing.func_176746_e();
                    BlockPos pos2 = this.getBlockPosForPos(2).func_177967_a(ff, 1);
                    ItemStack output = this.containerHandler.extractItem(0, 64, false);
                    TileEntity inventoryTile2 = this.field_145850_b.func_175625_s(pos2);
                    if (inventoryTile2 != null) {
                        output = blusunrize.immersiveengineering.common.util.Utils.insertStackIntoInventory((TileEntity)inventoryTile2, (ItemStack)output, (EnumFacing)ff.func_176734_d());
                    }
                    if (!output.func_190926_b()) {
                        blusunrize.immersiveengineering.common.util.Utils.dropStackAtPos((World)this.field_145850_b, (BlockPos)pos2, (ItemStack)output);
                    }
                }
                update = true;
            }
        }
        if (this.field_145850_b.field_72995_K) {
            if ((float)this.clientUpgradeProgress < this.getMaxClientProgress()) {
                this.clientUpgradeProgress = (int)Math.min((float)this.clientUpgradeProgress + (float)Config.IIConfig.Tools.wrench_upgrade_progress / 2.0f, this.getMaxClientProgress());
            }
        } else if (this.hasUpgrade(IIContent.UPGRADE_UNPACKER_CONVERSION) && (inventoryTile = this.field_145850_b.func_175625_s(pos = this.getBlockPosForPos(23).func_177972_a(this.facing))) != null) {
            for (int i = 0; i < this.inventory.size(); ++i) {
                ItemStack output = (ItemStack)this.inventory.get(i);
                if (output.func_190926_b()) continue;
                output = blusunrize.immersiveengineering.common.util.Utils.insertStackIntoInventory((TileEntity)inventoryTile, (ItemStack)output, (EnumFacing)this.facing.func_176734_d());
                this.inventory.set(i, (Object)output);
            }
        }
        if (update) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74782_a("inventory", (NBTBase)blusunrize.immersiveengineering.common.util.Utils.writeInventory(this.inventory));
            ImmersiveEngineering.packetHandler.sendToAllAround((IMessage)new MessageTileSync((TileEntityIEBase)this, tag), Utils.targetPointFromTile((TileEntity)this, 32));
        }
    }

    @Override
    @Nonnull
    public float[] getBlockBounds() {
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    @Nonnull
    public int[] getEnergyPos() {
        return new int[]{25};
    }

    @Nonnull
    public int[] getRedstonePos() {
        return new int[]{10};
    }

    public boolean isInWorldProcessingMachine() {
        return false;
    }

    public void doProcessOutput(@Nonnull ItemStack output) {
    }

    public void doProcessFluidOutput(@Nonnull FluidStack output) {
    }

    public void onProcessFinish(@Nonnull TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
    }

    public int getMaxProcessPerTick() {
        return 1;
    }

    public int getProcessQueueMaxLength() {
        return 1;
    }

    public float getMinProcessDistance(@Nonnull TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
        return 0.0f;
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    public int getSlotLimit(int slot) {
        return slot == 0 ? 1 : 64;
    }

    @Nonnull
    public int[] getOutputSlots() {
        return new int[0];
    }

    @Nonnull
    public int[] getOutputTanks() {
        return new int[0];
    }

    public boolean additionalCanProcessCheck(@Nonnull TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
        return false;
    }

    @Nonnull
    public IFluidTank[] getInternalTanks() {
        return new IFluidTank[0];
    }

    @Nonnull
    protected IFluidTank[] getAccessibleFluidTanks(@Nonnull EnumFacing side) {
        return new FluidTank[0];
    }

    protected boolean canFillTankFrom(int iTank, @Nonnull EnumFacing side, @Nonnull FluidStack resource) {
        return false;
    }

    protected boolean canDrainTankFrom(int iTank, @Nonnull EnumFacing side) {
        return false;
    }

    public void doGraphicalUpdates(int slot) {
    }

    @Nullable
    public IMultiblockRecipe findRecipeForInsertion(@Nonnull ItemStack inserting) {
        return null;
    }

    @Nullable
    protected IMultiblockRecipe readRecipeFromNBT(@Nonnull NBTTagCompound tag) {
        return null;
    }

    @Override
    public void onReceive(DataPacket packet, EnumFacing side) {
        TileEntityPacker master = (TileEntityPacker)this.master();
        if (master == null) {
            return;
        }
        if (this.field_174879_c == 9) {
            IDataType a = packet.getPacketVariable(Character.valueOf('a'));
            IDataType m = packet.getPacketVariable(Character.valueOf('m'));
            IDataType e = packet.getPacketVariable(Character.valueOf('e'));
            IDataType s = packet.getPacketVariable(Character.valueOf('s'));
            IDataType c = packet.getPacketVariable(Character.valueOf('c'));
            switch (c.valueToString()) {
                case "add": {
                    PackerPutMode mode = PackerPutMode.fromName(m.valueToString());
                    PackerActionType action = PackerActionType.fromName(a.valueToString());
                    IngredientStack stack = Utils.ingredientFromData(s);
                    PackerTask packerTask2 = new PackerTask(mode, action, stack);
                    if (packet.hasVariable(Character.valueOf('e'))) {
                        packerTask2.expirationAmount = packet.getVarInType(DataTypeInteger.class, (IDataType)e).value;
                    }
                    master.tasks.add(packerTask2);
                    break;
                }
                case "remove": {
                    if (a instanceof DataTypeInteger) {
                        master.tasks.remove(((DataTypeInteger)a).value);
                        break;
                    }
                    Predicate<PackerTask> p = s instanceof DataTypeString ? packerTask -> packerTask.stack.oreName.equals(s.valueToString()) : (s instanceof DataTypeItemStack ? packerTask -> packerTask.stack.equals((Object)Utils.ingredientFromData(s)) : packerTask -> true);
                    if (packet.hasVariable(Character.valueOf('m'))) {
                        p = p.and(packerTask -> packerTask.mode == PackerPutMode.fromName(m.valueToString()));
                    }
                    if (packet.hasVariable(Character.valueOf('a'))) {
                        p = p.and(packerTask -> packerTask.actionType == PackerActionType.fromName(a.valueToString()));
                    }
                    master.tasks.removeIf(p);
                    break;
                }
                case "clear": {
                    master.tasks.clear();
                }
            }
        }
    }

    @Override
    @Nonnull
    public List<AxisAlignedBB> getBounds(boolean collision) {
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        switch (this.field_174879_c) {
            case 23: {
                list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                switch (this.facing) {
                    case NORTH: {
                        list.add(new AxisAlignedBB(0.0, 0.125, 0.815, 1.0, 0.8125, 0.96875).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                        break;
                    }
                    case SOUTH: {
                        list.add(new AxisAlignedBB(0.0, 0.125, 0.03125, 1.0, 0.8125, 0.185).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                        break;
                    }
                    case EAST: {
                        list.add(new AxisAlignedBB(0.03125, 0.125, 0.0, 0.185, 0.8125, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                        break;
                    }
                    case WEST: {
                        list.add(new AxisAlignedBB(0.815, 0.125, 0.0, 0.96875, 0.8125, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                    }
                }
                break;
            }
            case 0: 
            case 1: 
            case 2: {
                list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                switch (this.facing) {
                    case NORTH: {
                        list.add(new AxisAlignedBB(0.0, 0.125, 0.96875, 1.0, 1.0, 0.96875).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                        break;
                    }
                    case SOUTH: {
                        list.add(new AxisAlignedBB(0.0, 0.125, 0.03125, 1.0, 1.0, 0.03125).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                        break;
                    }
                    case EAST: {
                        list.add(new AxisAlignedBB(0.03125, 0.125, 0.0, 0.03125, 1.0, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                        break;
                    }
                    case WEST: {
                        list.add(new AxisAlignedBB(0.96875, 0.125, 0.0, 0.96875, 1.0, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                    }
                }
                break;
            }
            case 13: {
                break;
            }
            default: {
                list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            }
        }
        if (this.field_174879_c == 1 || this.field_174879_c == 13) {
            switch (this.facing) {
                case NORTH: {
                    list.add(new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 0.125).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                    break;
                }
                case SOUTH: {
                    list.add(new AxisAlignedBB(0.375, 0.0, 0.875, 0.625, 1.0, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                    break;
                }
                case EAST: {
                    list.add(new AxisAlignedBB(0.875, 0.0, 0.375, 1.0, 1.0, 0.625).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                    break;
                }
                case WEST: {
                    list.add(new AxisAlignedBB(0.0, 0.0, 0.375, 0.125, 1.0, 0.625).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                }
            }
        }
        return list;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.master() != null && (this.field_174879_c == 23 || this.field_174879_c == 0);
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            TileEntityPacker master = (TileEntityPacker)this.master();
            if (master == null) {
                return null;
            }
            if (this.field_174879_c == 23) {
                return (T)master.inventoryHandler;
            }
            if (this.field_174879_c == 0) {
                return (T)master.containerHandler;
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public EnumFacing[] sigOutputDirections() {
        if (this.field_174879_c == 23) {
            return new EnumFacing[]{this.facing};
        }
        if (this.field_174879_c == 0) {
            return new EnumFacing[]{this.facing.func_176746_e()};
        }
        return new EnumFacing[0];
    }

    public void onEntityCollision(@Nonnull World world, @Nonnull Entity entity) {
    }

    public void onGuiOpened(EntityPlayer player, boolean clientside) {
        if (!clientside) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74782_a("inventory", (NBTBase)blusunrize.immersiveengineering.common.util.Utils.writeInventory(this.inventory));
            tag.func_74782_a("tasks", (NBTBase)this.writeTasks());
            tag.func_74757_a("repeatActions", this.repeatActions);
            ImmersiveEngineering.packetHandler.sendTo((IMessage)new MessageTileSync((TileEntityIEBase)this, tag), (EntityPlayerMP)player);
        }
    }

    public boolean canOpenGui() {
        return true;
    }

    public int getGuiID() {
        return IIGuiList.GUI_PACKER.ordinal();
    }

    @Nullable
    public TileEntity getGuiMaster() {
        return this.master();
    }

    @Override
    public boolean addUpgrade(MachineUpgrade upgrade, boolean test) {
        boolean b;
        boolean bl = b = !this.hasUpgrade(upgrade);
        if (!test && b) {
            this.upgrades.add(upgrade);
        }
        return b;
    }

    @Override
    public boolean hasUpgrade(MachineUpgrade upgrade) {
        return this.upgrades.stream().anyMatch(machineUpgrade -> machineUpgrade.getName().equals(upgrade.getName()));
    }

    @Override
    public boolean upgradeMatches(MachineUpgrade upgrade) {
        return upgrade == IIContent.UPGRADE_UNPACKER_CONVERSION || upgrade == IIContent.UPGRADE_PACKER_FLUID && !this.hasUpgrade(IIContent.UPGRADE_PACKER_ENERGY) || upgrade == IIContent.UPGRADE_PACKER_ENERGY && !this.hasUpgrade(IIContent.UPGRADE_PACKER_FLUID);
    }

    public TileEntityPacker getUpgradeMaster() {
        return (TileEntityPacker)this.master();
    }

    @Override
    public void saveUpgradesToNBT(NBTTagCompound tag) {
        for (MachineUpgrade upgrade : this.upgrades) {
            tag.func_74757_a(upgrade.getName(), true);
        }
    }

    @Override
    public void getUpgradesFromNBT(NBTTagCompound tag) {
        this.upgrades.clear();
        this.upgrades.addAll(MachineUpgrade.getUpgradesFromNBT(tag));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderWithUpgrades(MachineUpgrade ... upgrades) {
        PackerRenderer.renderWithUpgrades(upgrades);
    }

    public ArrayList<MachineUpgrade> getUpgrades() {
        return this.upgrades;
    }

    @Override
    @Nullable
    public MachineUpgrade getCurrentlyInstalled() {
        return this.currentlyInstalled;
    }

    @Override
    public int getInstallProgress() {
        return this.upgradeProgress;
    }

    @Override
    public int getClientInstallProgress() {
        return this.clientUpgradeProgress;
    }

    @Override
    public boolean addUpgradeInstallProgress(int toAdd) {
        this.upgradeProgress += toAdd;
        return true;
    }

    @Override
    public boolean resetInstallProgress() {
        this.currentlyInstalled = null;
        if (this.upgradeProgress > 0) {
            this.upgradeProgress = 0;
            this.clientUpgradeProgress = 0;
            return true;
        }
        Predicate<PackerTask> task = this.hasUpgrade(IIContent.UPGRADE_PACKER_FLUID) ? p -> p.actionType == PackerActionType.ENERGY : (this.hasUpgrade(IIContent.UPGRADE_PACKER_ENERGY) ? p -> p.actionType == PackerActionType.FLUID : p -> p.actionType != PackerActionType.ITEM);
        this.tasks.removeIf(task);
        return false;
    }

    @Override
    public void startUpgrade(@Nonnull MachineUpgrade upgrade) {
        this.currentlyInstalled = upgrade;
        this.upgradeProgress = 0;
        this.clientUpgradeProgress = 0;
    }

    @Override
    public void removeUpgrade(MachineUpgrade upgrade) {
        this.upgrades.remove(upgrade);
    }

    static {
        ItemStack[] crates = new ItemStack[]{new ItemStack((Block)IEContent.blockWoodenDevice0, 1, BlockTypes_WoodenDevice0.CRATE.getMeta()), new ItemStack((Block)IEContent.blockWoodenDevice0, 1, BlockTypes_WoodenDevice0.REINFORCED_CRATE.getMeta()), new ItemStack((Block)IIContent.blockMetalDevice, 1, IIBlockTypes_MetalDevice.METAL_CRATE.getMeta()), new ItemStack((Block)IIContent.blockSmallCrate, 1, 0), new ItemStack((Block)IIContent.blockSmallCrate, 1, 1), new ItemStack((Block)IIContent.blockSmallCrate, 1, 2), new ItemStack((Block)IIContent.blockSmallCrate, 1, 3), new ItemStack((Block)IIContent.blockSmallCrate, 1, 4), new ItemStack((Block)IIContent.blockSmallCrate, 1, 5)};
        itemHandleMap.put(stack -> Arrays.stream(crates).anyMatch(s -> s.func_77969_a(stack)), stack -> new ItemStackHandler(blusunrize.immersiveengineering.common.util.Utils.readInventory((NBTTagList)ItemNBTHelper.getTag((ItemStack)stack).func_150295_c("inventory", 10), (int)27), (ItemStack)stack){
            final ItemStack ss;
            final /* synthetic */ ItemStack val$stack;
            {
                this.val$stack = itemStack;
                super(x0);
                this.ss = this.val$stack;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return IEApi.isAllowedInCrate((ItemStack)stack);
            }

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                ItemNBTHelper.getTag((ItemStack)this.ss).func_74782_a("inventory", (NBTBase)blusunrize.immersiveengineering.common.util.Utils.writeInventory((Collection)this.stacks));
            }
        });
        ItemStack[] shulkerBoxes = new ItemStack[]{new ItemStack(Blocks.field_190977_dl), new ItemStack(Blocks.field_190978_dm), new ItemStack(Blocks.field_190979_dn), new ItemStack(Blocks.field_190980_do), new ItemStack(Blocks.field_190981_dp), new ItemStack(Blocks.field_190982_dq), new ItemStack(Blocks.field_190983_dr), new ItemStack(Blocks.field_190984_ds), new ItemStack(Blocks.field_190985_dt), new ItemStack(Blocks.field_190986_du), new ItemStack(Blocks.field_190987_dv), new ItemStack(Blocks.field_190988_dw), new ItemStack(Blocks.field_190989_dx), new ItemStack(Blocks.field_190990_dy), new ItemStack(Blocks.field_190991_dz)};
        itemHandleMap.put(stack -> Arrays.stream(shulkerBoxes).anyMatch(s -> s.func_77969_a(stack)), stack -> new ItemStackHandler(blusunrize.immersiveengineering.common.util.Utils.readInventory((NBTTagList)ItemNBTHelper.getTag((ItemStack)stack).func_74775_l("BlockEntityTag").func_150295_c("Items", 10), (int)27), (ItemStack)stack){
            final ItemStack ss;
            final /* synthetic */ ItemStack val$stack;
            {
                this.val$stack = itemStack;
                super(x0);
                this.ss = this.val$stack;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return !(Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockShulkerBox);
            }

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                NBTTagCompound tag = ItemNBTHelper.getTagCompound((ItemStack)this.val$stack, (String)"BlockEntityTag");
                tag.func_74782_a("Items", (NBTBase)blusunrize.immersiveengineering.common.util.Utils.writeInventory((Collection)this.stacks));
                ItemNBTHelper.setTagCompound((ItemStack)this.val$stack, (String)"BlockEntityTag", (NBTTagCompound)tag);
            }
        });
        itemHandleMap.put(stack -> stack.func_77973_b() == IIContent.itemBulletMagazine, stack -> new ItemStackHandler((NonNullList)ItemIIBulletMagazine.readInventory(ItemNBTHelper.getTag((ItemStack)stack).func_74775_l("bullets"), ItemIIBulletMagazine.getBulletCapactity(stack)), (ItemStack)stack){
            final ItemStack ss;
            final /* synthetic */ ItemStack val$stack;
            {
                this.val$stack = itemStack;
                super(x0);
                this.ss = this.val$stack;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.func_77973_b() == ItemIIBulletMagazine.getMatchingType(this.ss);
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                ItemNBTHelper.getTag((ItemStack)this.ss).func_74782_a("bullets", (NBTBase)ItemIIBulletMagazine.writeInventory((NonNullList<ItemStack>)this.stacks));
            }
        });
        itemHandleMap.put(stack -> stack.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), stack -> (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null));
    }

    @ParametersAreNonnullByDefault
    public static class PackerTask {
        public PackerPutMode mode;
        public PackerActionType actionType;
        public IngredientStack stack;
        public int expirationAmount = -1;

        public PackerTask(PackerPutMode mode, PackerActionType actionType, IngredientStack stack) {
            this.actionType = actionType;
            this.mode = mode;
            this.stack = stack;
        }

        public PackerTask(NBTTagCompound nbt) {
            this(PackerPutMode.valueOf(nbt.func_74779_i("mode").toUpperCase()), PackerActionType.valueOf(nbt.func_74779_i("action_type").toUpperCase()), IngredientStack.readFromNBT((NBTTagCompound)nbt.func_74775_l("stack")));
            if (nbt.func_74764_b("expiration_amount")) {
                this.expirationAmount = nbt.func_74762_e("expiration_amount");
            }
        }

        public NBTTagCompound toNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("mode", this.mode.func_176610_l());
            nbt.func_74778_a("action_type", this.actionType.name().toLowerCase());
            nbt.func_74782_a("stack", (NBTBase)this.stack.writeToNBT(new NBTTagCompound()));
            if (this.expirationAmount != -1) {
                nbt.func_74768_a("expiration_amount", this.expirationAmount);
            }
            return nbt;
        }
    }

    public static enum PackerActionType {
        ITEM,
        FLUID,
        ENERGY;


        public String getActionName(boolean unpacker) {
            switch (this) {
                default: {
                    return unpacker ? "unpack" : "pack";
                }
                case FLUID: {
                    return unpacker ? "discharge" : "charge";
                }
                case ENERGY: 
            }
            return unpacker ? "drain" : "fill";
        }

        public static PackerActionType fromName(String name) {
            switch (name.toLowerCase()) {
                default: {
                    return ITEM;
                }
                case "fluid": {
                    return FLUID;
                }
                case "energy": 
            }
            return ENERGY;
        }
    }

    public static enum PackerPutMode implements IStringSerializable
    {
        ALL_POSSIBLE,
        SLOT,
        AMOUNT;


        @Nonnull
        public String func_176610_l() {
            return this.toString().toLowerCase();
        }

        public static PackerPutMode fromName(String name) {
            switch (name.toLowerCase()) {
                default: {
                    return ALL_POSSIBLE;
                }
                case "slot": {
                    return SLOT;
                }
                case "amount": 
            }
            return AMOUNT;
        }
    }
}

