/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.blocks.multiblocks.metal.tileentities.first;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.api.crafting.IMultiblockRecipe;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import elucent.albedo.lighting.ILightProvider;
import elucent.albedo.lighting.Light;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.particle.ParticleRedstone;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.crafting.PaintingRecipe;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.IDataConnector;
import pl.pabilo8.immersiveintelligence.api.data.IDataDevice;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeInteger;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeString;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;
import pl.pabilo8.immersiveintelligence.api.utils.IIMultiblockInterfaces;
import pl.pabilo8.immersiveintelligence.common.IIGuiList;
import pl.pabilo8.immersiveintelligence.common.IISounds;
import pl.pabilo8.immersiveintelligence.common.blocks.multiblocks.metal.tileentities.first.MultiblockChemicalPainter;

@Optional.Interface(iface="elucent.albedo.lighting.ILightProvider", modid="albedo")
public class TileEntityChemicalPainter
extends TileEntityMultiblockMetal<TileEntityChemicalPainter, PaintingRecipe>
implements IEBlockInterfaces.IGuiTile,
IEBlockInterfaces.ISoundTile,
IIMultiblockInterfaces.IAdvancedBounds,
ILightProvider,
IDataDevice {
    private static final Predicate<FluidStack> CYAN = fluidStack -> fluidStack != null && fluidStack.getFluid().getName().equals("ink_cyan");
    private static final Predicate<FluidStack> MAGENTA = fluidStack -> fluidStack != null && fluidStack.getFluid().getName().equals("ink_magenta");
    private static final Predicate<FluidStack> YELLOW = fluidStack -> fluidStack != null && fluidStack.getFluid().getName().equals("ink_yellow");
    private static final Predicate<FluidStack> BLACK = fluidStack -> fluidStack != null && fluidStack.getFluid().getName().equals("ink");
    public FluidTank[] tanks = new FluidTank[]{new FluidTank(Config.IIConfig.Machines.ChemicalPainter.fluidCapacity), new FluidTank(Config.IIConfig.Machines.ChemicalPainter.fluidCapacity), new FluidTank(Config.IIConfig.Machines.ChemicalPainter.fluidCapacity), new FluidTank(Config.IIConfig.Machines.ChemicalPainter.fluidCapacity)};
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    public int processTime;
    public int processTimeMax;
    public ItemStack effect = ItemStack.field_190927_a;
    public boolean active = false;
    public int color = 0xFF00FF;
    IItemHandler insertionHandler = new IEInventoryHandler(1, (IIEInventory)this, 0, true, false);
    IItemHandler outputHandler = new IEInventoryHandler(1, (IIEInventory)this, 1, true, false);

    public TileEntityChemicalPainter() {
        super((MultiblockHandler.IMultiblock)MultiblockChemicalPainter.instance, MultiblockChemicalPainter.instance.getSize(), Config.IIConfig.Machines.ChemicalPainter.energyCapacity, true);
    }

    public void readCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (this.isDummy()) {
            return;
        }
        this.tanks[0].readFromNBT(nbt.func_74775_l("tank1"));
        this.tanks[1].readFromNBT(nbt.func_74775_l("tank2"));
        this.tanks[2].readFromNBT(nbt.func_74775_l("tank3"));
        this.tanks[3].readFromNBT(nbt.func_74775_l("tank4"));
        this.processTime = nbt.func_74762_e("processTime");
        this.processTimeMax = nbt.func_74762_e("processTimeMax");
        this.effect = new ItemStack(nbt.func_74775_l("effect"));
        this.color = nbt.func_74762_e("color");
        if (!descPacket) {
            this.inventory = blusunrize.immersiveengineering.common.util.Utils.readInventory((NBTTagList)nbt.func_150295_c("inventory", 10), (int)4);
        }
    }

    public void writeCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (this.isDummy()) {
            return;
        }
        nbt.func_74782_a("tank1", (NBTBase)this.tanks[0].writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("tank2", (NBTBase)this.tanks[1].writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("tank3", (NBTBase)this.tanks[2].writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("tank4", (NBTBase)this.tanks[3].writeToNBT(new NBTTagCompound()));
        nbt.func_74768_a("color", this.color);
        nbt.func_74768_a("processTime", this.processTime);
        nbt.func_74768_a("processTimeMax", this.processTimeMax);
        nbt.func_74782_a("effect", (NBTBase)this.effect.serializeNBT());
        if (!descPacket) {
            nbt.func_74782_a("inventory", (NBTBase)blusunrize.immersiveengineering.common.util.Utils.writeInventory(this.inventory));
        }
    }

    public void receiveMessageFromServer(@Nonnull NBTTagCompound message) {
        super.receiveMessageFromServer(message);
        if (this.isDummy()) {
            return;
        }
        if (message.func_74764_b("processTime")) {
            this.processTime = message.func_74762_e("processTime");
        }
        if (message.func_74764_b("processTimeMax")) {
            this.processTimeMax = message.func_74762_e("processTimeMax");
        }
        if (message.func_74764_b("active")) {
            this.active = message.func_74767_n("active");
        }
        if (message.func_74764_b("inventory")) {
            this.inventory = blusunrize.immersiveengineering.common.util.Utils.readInventory((NBTTagList)message.func_150295_c("inventory", 10), (int)4);
        }
        if (message.func_74764_b("tank1")) {
            this.tanks[0].readFromNBT(message.func_74775_l("tank1"));
        }
        if (message.func_74764_b("tank2")) {
            this.tanks[1].readFromNBT(message.func_74775_l("tank2"));
        }
        if (message.func_74764_b("tank3")) {
            this.tanks[2].readFromNBT(message.func_74775_l("tank3"));
        }
        if (message.func_74764_b("tank4")) {
            this.tanks[3].readFromNBT(message.func_74775_l("tank4"));
        }
        if (message.func_74764_b("output")) {
            this.effect = new ItemStack(message.func_74775_l("output"));
        }
        if (message.func_74764_b("color")) {
            this.color = message.func_74762_e("color");
        }
    }

    public void receiveMessageFromClient(NBTTagCompound message) {
        super.receiveMessageFromClient(message);
        if (message.func_74764_b("color")) {
            this.color = message.func_74762_e("color");
        }
    }

    public void func_73660_a() {
        TileEntityMultiblockMetal.MultiblockProcess process;
        PaintingRecipe recipe;
        super.func_73660_a();
        if (this.isDummy()) {
            return;
        }
        if (this.active && this.processTime < this.processTimeMax) {
            ++this.processTime;
        }
        if (this.field_145850_b.field_72995_K) {
            TileEntityChemicalPainter t1 = (TileEntityChemicalPainter)this.getTileForPos(52);
            TileEntityChemicalPainter t2 = (TileEntityChemicalPainter)this.getTileForPos(47);
            TileEntityChemicalPainter t3 = (TileEntityChemicalPainter)this.getTileForPos(53);
            ImmersiveEngineering.proxy.handleTileSound(IISounds.chemical_painter_lights, (TileEntity)this, this.shoudlPlaySound("immersiveintelligence:chemical_painter_lights"), 1.5f, 1.0f);
            if (t1 != null) {
                ImmersiveEngineering.proxy.handleTileSound(IESounds.spray, (TileEntity)t1, this.shoudlPlaySound("immersiveengineering:spray"), 1.5f, 0.5f);
            }
            if (t2 != null) {
                ImmersiveEngineering.proxy.handleTileSound(IISounds.chemical_painter_lift_up, (TileEntity)t2, this.shoudlPlaySound("immersiveintelligence:chemical_painter_lift_up"), 1.5f, 0.75f);
            }
            if (t3 != null) {
                ImmersiveEngineering.proxy.handleTileSound(IISounds.chemical_painter_lift_down, (TileEntity)t2, this.shoudlPlaySound("immersiveintelligence:chemical_painter_lift_down"), 1.5f, 0.75f);
            }
            if (this.active && this.shoudlPlaySound("immersiveengineering:spray")) {
                this.spawnPaintParticle();
            }
            return;
        }
        boolean wasActive = this.active;
        boolean update = false;
        this.active = this.shouldRenderAsActive();
        if (this.energyStorage.getEnergyStored() > 0 && this.processQueue.size() < this.getProcessQueueMaxLength() && Arrays.stream(this.tanks).anyMatch(ft -> ft.getFluidAmount() > 0) && (recipe = PaintingRecipe.findRecipe((ItemStack)this.inventory.get(0))) != null) {
            float[] cmyk = Utils.rgbToCmyk(Utils.rgbIntToRGB(this.color));
            int i = 0;
            while (i < cmyk.length) {
                int n = i++;
                cmyk[n] = cmyk[n] * (float)recipe.getPaintAmount();
            }
            boolean goAheadMrJoestar = true;
            for (int i2 = 0; i2 < cmyk.length; ++i2) {
                if (!((float)this.tanks[i2].getFluidAmount() < cmyk[i2])) continue;
                goAheadMrJoestar = false;
                break;
            }
            if (goAheadMrJoestar) {
                PaintingProcess process2 = new PaintingProcess(recipe, 0);
                this.addProcessToQueue((TileEntityMultiblockMetal.MultiblockProcess)process2, false);
                update = true;
                this.processTime = 0;
                this.processTimeMax = recipe.getTotalProcessTime();
                this.effect = recipe.process.apply(this.color, ((ItemStack)this.inventory.get(0)).func_77946_l());
                for (int i3 = 0; i3 < this.tanks.length; ++i3) {
                    this.tanks[i3].drain((int)cmyk[i3], true);
                }
            }
        }
        if (this.processTime >= this.processTimeMax && this.processQueue.size() > 0 && (process = (TileEntityMultiblockMetal.MultiblockProcess)this.processQueue.get(0)) instanceof PaintingProcess && ItemHandlerHelper.insertItemStacked((IItemHandler)this.outputHandler, (ItemStack)((ItemStack)((PaintingRecipe)process.recipe).getActualItemOutputs((TileEntity)this).get(0)), (boolean)true).func_190926_b()) {
            ((PaintingProcess)process).processFinish(this);
        }
        if (this.active) {
            if ((double)this.processTime == Math.ceil(0.1 * (double)this.processTimeMax)) {
                this.field_145850_b.func_184133_a(null, this.getBlockPosForPos(70), IISounds.vulcanizer_pull_start, SoundCategory.BLOCKS, 0.65f, 1.5f);
            } else if ((double)this.processTime == Math.ceil(0.2 * (double)this.processTimeMax)) {
                this.field_145850_b.func_184133_a(null, this.getBlockPosForPos(70), IISounds.vulcanizer_pull_end, SoundCategory.BLOCKS, 0.65f, 1.5f);
            } else if ((double)this.processTime == Math.ceil(0.7 * (double)this.processTimeMax)) {
                this.field_145850_b.func_184133_a(null, this.getBlockPosForPos(70), IISounds.vulcanizer_pull_start, SoundCategory.BLOCKS, 0.65f, 1.5f);
            } else if ((double)this.processTime == Math.ceil(0.8 * (double)this.processTimeMax)) {
                this.field_145850_b.func_184133_a(null, this.getBlockPosForPos(70), IISounds.vulcanizer_pull_end, SoundCategory.BLOCKS, 0.65f, 1.5f);
            }
        }
        Utils.handleBucketTankInteraction((IFluidTank[])this.tanks, this.inventory, (int)2, (int)3, (int)0, (boolean)false, CYAN);
        Utils.handleBucketTankInteraction((IFluidTank[])this.tanks, this.inventory, (int)2, (int)3, (int)1, (boolean)false, MAGENTA);
        Utils.handleBucketTankInteraction((IFluidTank[])this.tanks, this.inventory, (int)2, (int)3, (int)2, (boolean)false, YELLOW);
        Utils.handleBucketTankInteraction((IFluidTank[])this.tanks, this.inventory, (int)2, (int)3, (int)3, (boolean)false, BLACK);
        if (this.field_145850_b.func_82737_E() % 20L == 0L) {
            BlockPos pos = this.getBlockPosForPos(25).func_177972_a(this.mirrored ? this.facing.func_176746_e() : this.facing.func_176735_f());
            ItemStack output = (ItemStack)this.inventory.get(1);
            TileEntity inventoryTile = this.field_145850_b.func_175625_s(pos);
            if (inventoryTile != null) {
                output = blusunrize.immersiveengineering.common.util.Utils.insertStackIntoInventory((TileEntity)inventoryTile, (ItemStack)output, (EnumFacing)(this.mirrored ? this.facing.func_176746_e() : this.facing.func_176735_f()));
            }
            this.inventory.set(1, (Object)output);
        }
        if (update || wasActive != this.active) {
            this.func_70296_d();
            this.markContainingBlockForUpdate(null);
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("color", this.color);
            tag.func_74768_a("processTime", this.processTime);
            tag.func_74768_a("processTimeMax", this.processTimeMax);
            tag.func_74757_a("active", this.active);
            tag.func_74782_a("inventory", (NBTBase)blusunrize.immersiveengineering.common.util.Utils.writeInventory(this.inventory));
            NBTTagCompound itemTag = new NBTTagCompound();
            this.effect.func_77955_b(itemTag);
            tag.func_74782_a("output", (NBTBase)itemTag);
            tag.func_74782_a("tank1", (NBTBase)this.tanks[0].writeToNBT(new NBTTagCompound()));
            tag.func_74782_a("tank2", (NBTBase)this.tanks[1].writeToNBT(new NBTTagCompound()));
            tag.func_74782_a("tank3", (NBTBase)this.tanks[2].writeToNBT(new NBTTagCompound()));
            tag.func_74782_a("tank4", (NBTBase)this.tanks[3].writeToNBT(new NBTTagCompound()));
            ImmersiveEngineering.packetHandler.sendToAllAround((IMessage)new MessageTileSync((TileEntityIEBase)this, tag), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 32.0));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnPaintParticle() {
        Vec3d pos = new Vec3d((Vec3i)this.getBlockPosForPos(52)).func_72441_c(0.5, 0.5, 0.5);
        Vec3d facing = new Vec3d(this.getFacing().func_176734_d().func_176730_m());
        facing = facing.func_186678_a((double)0.65f);
        float mod = (float)(Math.random() * 2.0);
        float[] rgb = Utils.rgbIntToRGB(this.color);
        float ff = (float)(this.func_145831_w().func_82737_E() % 200L) / 200.0f;
        float ny = -0.275f + Math.abs(ff % 0.2f / 0.2f - 0.5f) * 2.0f * 0.55f;
        float nx = Math.abs(ff % 0.33f / 0.33f - 0.5f) * 2.0f * 0.55f;
        facing = facing.func_178787_e(facing.func_178785_b(90.0f).func_186678_a((double)ny)).func_72441_c(0.0, (double)(-nx), 0.0);
        for (int i = 2; i < 4; ++i) {
            Vec3d vv = facing.func_186678_a((double)i * 0.5);
            ParticleRedstone particle = (ParticleRedstone)ClientUtils.mc().field_71452_i.func_178927_a(EnumParticleTypes.REDSTONE.func_179348_c(), pos.field_72450_a + vv.field_72450_a, pos.field_72448_b + vv.field_72448_b, pos.field_72449_c + vv.field_72449_c, facing.field_72450_a, facing.field_72448_b, facing.field_72449_c, new int[0]);
            if (particle == null) continue;
            particle.func_187114_a(6);
            particle.field_70570_a = 3.25f;
            particle.func_70538_b(rgb[0] * mod, rgb[1] * mod, rgb[2] * mod);
        }
    }

    @Override
    @Nonnull
    public float[] getBlockBounds() {
        return new float[0];
    }

    @Nonnull
    public int[] getEnergyPos() {
        return new int[]{47};
    }

    @Nonnull
    public int[] getRedstonePos() {
        return new int[]{14};
    }

    public boolean isInWorldProcessingMachine() {
        return true;
    }

    public boolean additionalCanProcessCheck(@Nonnull TileEntityMultiblockMetal.MultiblockProcess<PaintingRecipe> process) {
        return true;
    }

    public void doProcessOutput(@Nonnull ItemStack output) {
        BlockPos pos = this.getBlockPosForPos(25).func_177972_a(this.mirrored ? this.facing.func_176746_e() : this.facing.func_176735_f());
        TileEntity inventoryTile = this.field_145850_b.func_175625_s(pos);
        if (inventoryTile != null) {
            output = blusunrize.immersiveengineering.common.util.Utils.insertStackIntoInventory((TileEntity)inventoryTile, (ItemStack)output, (EnumFacing)(this.mirrored ? this.facing.func_176746_e() : this.facing.func_176735_f()));
        }
        if (!output.func_190926_b()) {
            blusunrize.immersiveengineering.common.util.Utils.dropStackAtPos((World)this.field_145850_b, (BlockPos)pos, (ItemStack)output, (EnumFacing)this.facing);
        }
    }

    public void doProcessFluidOutput(@Nonnull FluidStack output) {
    }

    public void onProcessFinish(@Nonnull TileEntityMultiblockMetal.MultiblockProcess<PaintingRecipe> process) {
    }

    public int getMaxProcessPerTick() {
        return 1;
    }

    public int getProcessQueueMaxLength() {
        return 1;
    }

    public float getMinProcessDistance(@Nonnull TileEntityMultiblockMetal.MultiblockProcess<PaintingRecipe> process) {
        return 0.0f;
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    @Nonnull
    public int[] getOutputSlots() {
        return new int[]{1};
    }

    @Nonnull
    public int[] getOutputTanks() {
        return new int[0];
    }

    @Nonnull
    public IFluidTank[] getInternalTanks() {
        return this.tanks;
    }

    @Nonnull
    protected IFluidTank[] getAccessibleFluidTanks(@Nonnull EnumFacing side) {
        TileEntityChemicalPainter master = (TileEntityChemicalPainter)this.master();
        if (master != null) {
            switch (this.field_174879_c) {
                case 19: {
                    return new FluidTank[]{master.tanks[0]};
                }
                case 18: {
                    return new FluidTank[]{master.tanks[1]};
                }
                case 16: {
                    return new FluidTank[]{master.tanks[2]};
                }
                case 15: {
                    return new FluidTank[]{master.tanks[3]};
                }
            }
        }
        return new FluidTank[0];
    }

    protected boolean canFillTankFrom(int iTank, @Nonnull EnumFacing side, @Nonnull FluidStack resource) {
        if (side == this.facing) {
            TileEntityChemicalPainter master = (TileEntityChemicalPainter)this.master();
            if (master == null) {
                return false;
            }
            switch (this.field_174879_c) {
                case 19: {
                    return master.tanks[0].getFluidAmount() < master.tanks[0].getCapacity() && CYAN.test(resource);
                }
                case 18: {
                    return master.tanks[1].getFluidAmount() < master.tanks[1].getCapacity() && MAGENTA.test(resource);
                }
                case 16: {
                    return master.tanks[2].getFluidAmount() < master.tanks[2].getCapacity() && YELLOW.test(resource);
                }
                case 15: {
                    return master.tanks[3].getFluidAmount() < master.tanks[3].getCapacity() && BLACK.test(resource);
                }
            }
            return false;
        }
        return false;
    }

    protected boolean canDrainTankFrom(int iTank, @Nonnull EnumFacing side) {
        return false;
    }

    public void doGraphicalUpdates(int slot) {
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
    }

    @Nullable
    public PaintingRecipe findRecipeForInsertion(@Nonnull ItemStack inserting) {
        return PaintingRecipe.findRecipe(inserting);
    }

    @Nullable
    protected PaintingRecipe readRecipeFromNBT(@Nonnull NBTTagCompound tag) {
        return PaintingRecipe.loadFromNBT(tag);
    }

    public void onGuiOpened(EntityPlayer player, boolean clientside) {
        if (!clientside) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("color", this.color);
            tag.func_74768_a("processTime", this.processTime);
            tag.func_74768_a("processTimeMax", this.processTimeMax);
            ImmersiveEngineering.packetHandler.sendTo((IMessage)new MessageTileSync((TileEntityIEBase)this, tag), (EntityPlayerMP)player);
        }
    }

    public boolean canOpenGui() {
        return this.formed;
    }

    public int getGuiID() {
        return IIGuiList.GUI_CHEMICAL_PAINTER.ordinal();
    }

    public TileEntity getGuiMaster() {
        return this.master();
    }

    public boolean shoudlPlaySound(@Nonnull String sound) {
        TileEntityChemicalPainter master = (TileEntityChemicalPainter)this.master();
        if (master != null && master.processQueue.size() > 0) {
            switch (sound) {
                case "immersiveintelligence:chemical_painter_lights": {
                    return Utils.inRange(master.processTime, master.processTimeMax, 0.65f, 0.95f);
                }
                case "immersiveengineering:spray": {
                    return Utils.inRange(master.processTime, master.processTimeMax, 0.25, 0.75);
                }
                case "immersiveintelligence:chemical_painter_lift_up": {
                    return Utils.inRange(master.processTime, master.processTimeMax, 0.05, 0.2);
                }
                case "immersiveintelligence:chemical_painter_lift_down": {
                    return Utils.inRange(master.processTime, master.processTimeMax, 0.7, 0.85);
                }
            }
        }
        return false;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (this.field_174879_c == 29 && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == (this.mirrored ? this.facing.func_176735_f() : this.facing.func_176746_e())) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.field_174879_c == 29) {
            TileEntityChemicalPainter master = (TileEntityChemicalPainter)this.master();
            return (T)master.insertionHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    @Nonnull
    public List<AxisAlignedBB> getBounds(boolean collision) {
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        switch (this.field_174879_c) {
            case 41: 
            case 42: 
            case 43: {
                switch (this.facing) {
                    case NORTH: {
                        list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 0.5).func_186670_a(this.func_174877_v()));
                        break;
                    }
                    case SOUTH: {
                        list.add(new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 0.5, 1.0).func_186670_a(this.func_174877_v()));
                        break;
                    }
                    case EAST: {
                        list.add(new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 0.5, 1.0).func_186670_a(this.func_174877_v()));
                        break;
                    }
                    case WEST: {
                        list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 0.5, 1.0).func_186670_a(this.func_174877_v()));
                    }
                }
                break;
            }
            case 35: 
            case 36: 
            case 38: 
            case 39: {
                list.add(new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375).func_186670_a(this.func_174877_v()));
                break;
            }
            case 55: 
            case 56: 
            case 58: 
            case 59: {
                list.add(new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.625, 0.9375).func_186670_a(this.func_174877_v()));
            }
        }
        return list;
    }

    public Light provideLight() {
        TileEntityChemicalPainter master;
        if (this.field_174879_c == 47 && (master = (TileEntityChemicalPainter)this.master()) != null && master.active && Utils.inRange(master.processTime, master.processTimeMax, 0.65f, 0.95f)) {
            return Light.builder().pos(this.func_174877_v()).color(0.8235294f, 0.20392157f, 0.92156863f).radius(5.0f).build();
        }
        return null;
    }

    @Override
    public void onReceive(DataPacket packet, @Nullable EnumFacing side) {
        TileEntityChemicalPainter master = (TileEntityChemicalPainter)this.master();
        if (this.field_174879_c == 10 && master != null) {
            IDataType c = packet.getPacketVariable(Character.valueOf('c'));
            IDataType p = packet.getPacketVariable(Character.valueOf('p'));
            if (c instanceof DataTypeString && side != null) {
                IDataConnector conn = Utils.findConnectorFacing(this.getBlockPosForPos(10), this.field_145850_b, side.func_176734_d());
                if (conn == null) {
                    return;
                }
                DataPacket reply = new DataPacket();
                switch (((DataTypeString)c).value) {
                    case "get_ink": 
                    case "get_ink_black": {
                        reply.setVariable(Character.valueOf('c'), new DataTypeString("ink_black"));
                        reply.setVariable(Character.valueOf('g'), new DataTypeInteger(master.tanks[0].getFluidAmount()));
                        conn.sendPacket(reply);
                        break;
                    }
                    case "get_ink_cyan": {
                        reply.setVariable(Character.valueOf('c'), new DataTypeString("ink_cyan"));
                        reply.setVariable(Character.valueOf('g'), new DataTypeInteger(master.tanks[1].getFluidAmount()));
                        conn.sendPacket(reply);
                        break;
                    }
                    case "get_ink_yellow": {
                        reply.setVariable(Character.valueOf('c'), new DataTypeString("ink_yellow"));
                        reply.setVariable(Character.valueOf('g'), new DataTypeInteger(master.tanks[2].getFluidAmount()));
                        conn.sendPacket(reply);
                        break;
                    }
                    case "get_ink_magenta": {
                        reply.setVariable(Character.valueOf('c'), new DataTypeString("ink_magenta"));
                        reply.setVariable(Character.valueOf('g'), new DataTypeInteger(master.tanks[3].getFluidAmount()));
                        conn.sendPacket(reply);
                        break;
                    }
                    case "get_energy": {
                        reply.setVariable(Character.valueOf('c'), new DataTypeString("energy"));
                        reply.setVariable(Character.valueOf('g'), new DataTypeInteger(master.energyStorage.getEnergyStored()));
                        conn.sendPacket(reply);
                        break;
                    }
                    case "get_color": {
                        reply.setVariable(Character.valueOf('c'), new DataTypeString("color"));
                        reply.setVariable(Character.valueOf('g'), new DataTypeInteger(master.color));
                        conn.sendPacket(reply);
                        break;
                    }
                    case "get_color_hex": {
                        reply.setVariable(Character.valueOf('c'), new DataTypeString("color"));
                        reply.setVariable(Character.valueOf('g'), new DataTypeString(String.format("#%06X", master.color)));
                        conn.sendPacket(reply);
                    }
                }
            }
            if (p instanceof DataTypeInteger) {
                master.color = MathHelper.func_76125_a((int)((DataTypeInteger)p).value, (int)0, (int)0xFFFFFF);
            } else if (p instanceof DataTypeString) {
                try {
                    int color = Integer.parseInt(p.valueToString(), 16);
                    master.color = MathHelper.func_76125_a((int)color, (int)0, (int)0xFFFFFF);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    public static class PaintingProcess
    extends TileEntityMultiblockMetal.MultiblockProcessInMachine<PaintingRecipe> {
        public PaintingProcess(PaintingRecipe recipe, int ... inputSlots) {
            super((IMultiblockRecipe)recipe, inputSlots);
        }

        public void processFinish(TileEntityMultiblockMetal multiblock) {
            super.processFinish(multiblock);
        }
    }
}

