/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.blocks.multiblocks.metal.tileentities.first;

import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorageAdvanced;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.bullets.BulletHelper;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.IDataConnector;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeBoolean;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeInteger;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeItemStack;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeString;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataTypeNumeric;
import pl.pabilo8.immersiveintelligence.api.utils.IBooleanAnimatedPartsBlock;
import pl.pabilo8.immersiveintelligence.api.utils.IIMultiblockInterfaces;
import pl.pabilo8.immersiveintelligence.client.fx.ParticleUtils;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.IISounds;
import pl.pabilo8.immersiveintelligence.common.blocks.multiblocks.metal.tileentities.base.TileEntityMultiblockIIGeneric;
import pl.pabilo8.immersiveintelligence.common.blocks.multiblocks.metal.tileentities.first.MultiblockArtilleryHowitzer;
import pl.pabilo8.immersiveintelligence.common.entity.bullets.EntityBullet;
import pl.pabilo8.immersiveintelligence.common.items.ammunition.ItemIIAmmoArtillery;
import pl.pabilo8.immersiveintelligence.common.network.IIPacketHandler;
import pl.pabilo8.immersiveintelligence.common.network.MessageBooleanAnimatedPartsSync;
import pl.pabilo8.immersiveintelligence.common.util.IISoundAnimation;
import pl.pabilo8.immersiveintelligence.common.util.NBTTagCollector;

public class TileEntityArtilleryHowitzer
extends TileEntityMultiblockIIGeneric<TileEntityArtilleryHowitzer>
implements IBooleanAnimatedPartsBlock,
ConveyorHandler.IConveyorAttachable,
IIMultiblockInterfaces.ILadderMultiblock,
IIMultiblockInterfaces.IExplosionResistantMultiblock {
    private static final AxisAlignedBB AABB_FULL = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB AABB_EMPTY = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final AxisAlignedBB AABB_DOOR = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    private static final AxisAlignedBB AABB_TALLER_FLOOR = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.4375, 1.0);
    private static final AxisAlignedBB AABB_LOWER_FLOOR = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0);
    private static final AxisAlignedBB AABB_TABLE_TOP = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);
    private static final AxisAlignedBB[] AABB_LADDER = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.9375), new AxisAlignedBB(0.0, 0.0, 0.0625, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.9375, 1.0, 1.0), new AxisAlignedBB(0.0625, 0.0, 0.0, 1.0, 1.0, 1.0)};
    private static final AxisAlignedBB[] AABB_DOOR_HOLDERS_RIGHT = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 0.625, 1.0), new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 0.625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 0.625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 0.5)};
    private static final AxisAlignedBB[] AABB_DOOR_HOLDERS_LEFT = new AxisAlignedBB[]{new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 0.625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 0.625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 0.5), new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 0.625, 1.0)};
    private static final IISoundAnimation loadingSoundAnimation = new IISoundAnimation(18.0);
    private static final IISoundAnimation unloadingSoundAnimation = new IISoundAnimation(18.0);
    private static final IISoundAnimation firingSoundAnimation = new IISoundAnimation(15.96);
    public ArrayList<HowitzerOrder> orderList = new ArrayList();
    public ArtilleryHowitzerAnimation animation = ArtilleryHowitzerAnimation.STOP;
    public int animationTime = 0;
    public int animationTimeMax = 0;
    public int shellConveyorTime = 0;
    public boolean isDoorOpened = false;
    public boolean platformPosition = false;
    public int platformTime = 0;
    public int doorTime = 0;
    public float turretYaw = 0.0f;
    public float turretPitch = 0.0f;
    public float plannedYaw = 0.0f;
    public float plannedPitch = 0.0f;
    public NonNullList<ItemStack> loadedShells;
    public IItemHandler inventoryHandler;
    public IItemHandler insertionHandler;

    public TileEntityArtilleryHowitzer() {
        super(MultiblockArtilleryHowitzer.instance);
        this.energyStorage = new FluxStorageAdvanced(Config.IIConfig.Machines.ArtilleryHowitzer.energyCapacity);
        this.inventory = NonNullList.func_191197_a((int)12, (Object)ItemStack.field_190927_a);
        this.loadedShells = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
        this.inventoryHandler = new IEInventoryHandler(this.inventory.size(), (IIEInventory)this, 0, true, true);
        this.insertionHandler = new IEInventoryHandler(1, (IIEInventory)this, 0, true, false);
    }

    @Override
    public void onUpdate() {
        boolean rs;
        if (this.field_145850_b.field_72995_K) {
            this.handleSounds();
        }
        if (this.isDoorOpened ^ (rs = this.field_145850_b.func_175640_z(this.getBlockPosForPos(this.getRedstonePos(true)[0])) ^ this.redstoneControlInverted)) {
            this.isDoorOpened = rs;
            if (!this.field_145850_b.field_72995_K) {
                IIPacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageBooleanAnimatedPartsSync(this.isDoorOpened, 0, this.func_174877_v()), Utils.targetPointFromTile((TileEntity)this, 48));
            }
        }
        if (this.energyStorage.getEnergyStored() < Config.IIConfig.Machines.ArtilleryHowitzer.energyUsagePassive) {
            return;
        }
        this.energyStorage.extractEnergy(Config.IIConfig.Machines.ArtilleryHowitzer.energyUsagePassive, false);
        this.doorTime = MathHelper.func_76125_a((int)(this.doorTime + (this.isDoorOpened ? 1 : -2)), (int)0, (int)Config.IIConfig.Machines.ArtilleryHowitzer.doorTime);
        this.platformTime = MathHelper.func_76125_a((int)(this.platformTime + (this.platformPosition ? 1 : -1)), (int)0, (int)Config.IIConfig.Machines.ArtilleryHowitzer.platformTime);
        if (!this.isDoorOpened) {
            this.animation = ArtilleryHowitzerAnimation.HIDE;
        }
        if (this.shellConveyorTime < Config.IIConfig.Machines.ArtilleryHowitzer.conveyorTime) {
            ++this.shellConveyorTime;
        } else {
            int i;
            for (i = 5; i > 0; --i) {
                if (!this.inventoryHandler.getStackInSlot(i).func_190926_b()) continue;
                this.inventory.set(i, (Object)this.inventoryHandler.extractItem(i - 1, 1, false));
            }
            for (i = 11; i > 6; --i) {
                if (!this.inventoryHandler.getStackInSlot(i).func_190926_b()) continue;
                this.inventory.set(i, (Object)this.inventoryHandler.extractItem(i - 1, 1, false));
            }
            if (!this.field_145850_b.field_72995_K && !this.inventoryHandler.getStackInSlot(11).func_190926_b()) {
                BlockPos outPos = this.getBlockPosForPos(327).func_177972_a(this.facing.func_176734_d()).func_177972_a(EnumFacing.UP);
                ItemStack casing = this.inventoryHandler.extractItem(11, 1, false);
                if (this.field_145850_b.func_175625_s(outPos) != null) {
                    casing = blusunrize.immersiveengineering.common.util.Utils.insertStackIntoInventory((TileEntity)this.field_145850_b.func_175625_s(outPos), (ItemStack)casing, (EnumFacing)this.facing);
                }
                if (!casing.func_190926_b()) {
                    blusunrize.immersiveengineering.common.util.Utils.dropStackAtPos((World)this.field_145850_b, (BlockPos)outPos, (ItemStack)casing);
                }
            }
            this.shellConveyorTime = 0;
            if (!this.field_145850_b.field_72995_K) {
                this.forceTileUpdate();
            }
        }
        if (this.animation == ArtilleryHowitzerAnimation.STOP) {
            if (this.field_145850_b.field_72995_K || this.orderList.isEmpty()) {
                return;
            }
            HowitzerOrder newOrder = this.orderList.get(0);
            if (newOrder.animation.isFulfilled(this)) {
                this.orderList.remove(0);
            } else if (newOrder.animation.matchesRequirements(this)) {
                this.animation = newOrder.animation;
                this.animationTime = 0;
                this.animationTimeMax = this.animation.animationTime;
                this.plannedPitch = newOrder.pitch;
                this.plannedYaw = newOrder.yaw;
                this.forceTileUpdate();
                this.orderList.remove(0);
            }
            return;
        }
        boolean canContinue = true;
        switch (this.animation.gunPosition) {
            case NEUTRAL: {
                break;
            }
            case LOADING: {
                this.platformPosition = false;
                this.plannedYaw = this.facing.func_185119_l();
                this.plannedPitch = 0.0f;
                canContinue = this.platformTime == 0;
                break;
            }
            case ON_TARGET: {
                this.platformPosition = true;
                canContinue = this.platformTime == Config.IIConfig.Machines.ArtilleryHowitzer.platformTime && this.isAimed();
            }
        }
        this.turnToTarget();
        if (canContinue) {
            if (this.animationTime < this.animationTimeMax) {
                ++this.animationTime;
            } else {
                this.animation = ArtilleryHowitzerAnimation.STOP;
                this.animationTimeMax = 0;
                this.animationTime = 0;
                this.forceTileUpdate();
            }
            if (this.field_145850_b.field_72995_K) {
                this.handleAnimationSounds();
            }
            if (this.animationTime == (int)((float)this.animationTimeMax * this.animation.executeTime)) {
                switch (this.animation) {
                    case AIM: {
                        break;
                    }
                    case FIRE1: 
                    case FIRE2: 
                    case FIRE3: 
                    case FIRE4: {
                        this.fireGun(this.animation.ordinal() - ArtilleryHowitzerAnimation.FIRE1.ordinal());
                        break;
                    }
                    case LOAD1: 
                    case LOAD2: 
                    case LOAD3: 
                    case LOAD4: {
                        int slot = this.animation.ordinal() - ArtilleryHowitzerAnimation.LOAD1.ordinal();
                        this.loadedShells.set(slot, (Object)this.inventoryHandler.extractItem(5, 1, false));
                        break;
                    }
                    case UNLOAD1: 
                    case UNLOAD2: 
                    case UNLOAD3: 
                    case UNLOAD4: {
                        int slot = this.animation.ordinal() - ArtilleryHowitzerAnimation.UNLOAD1.ordinal();
                        this.inventory.set(6, (Object)((ItemStack)this.loadedShells.get(slot)).func_77946_l());
                        this.loadedShells.set(slot, (Object)ItemStack.field_190927_a);
                    }
                }
            }
        }
    }

    private void fireGun(int i) {
        double true_angle = Math.toRadians(-this.turretYaw > 180.0f ? (double)(360.0f - -this.turretYaw) : (double)(-this.turretYaw));
        double true_angle2 = Math.toRadians(-(-90.0f - this.turretPitch));
        Vec3d gun_end = Utils.offsetPosDirection(3.0f, true_angle, true_angle2);
        Vec3d gun_dir = gun_end.func_72432_b();
        if (this.field_145850_b.field_72995_K) {
            Vec3d gun_end_particle = gun_dir.func_186678_a(4.5);
            ParticleUtils.spawnGunfireFX(this.getGunPosition().field_72450_a + gun_end_particle.field_72450_a, this.getGunPosition().field_72448_b + gun_end_particle.field_72448_b, this.getGunPosition().field_72449_c + gun_end_particle.field_72449_c, gun_dir.field_72450_a, gun_dir.field_72448_b, gun_dir.field_72449_c, 8.0f);
        }
        this.field_145850_b.func_184133_a(null, this.func_174877_v(), IISounds.howitzer_shot, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (!this.field_145850_b.field_72995_K) {
            ItemStack bullet = (ItemStack)this.loadedShells.get(i);
            EntityBullet a = BulletHelper.createBullet(this.field_145850_b, bullet, this.getGunPosition().func_178787_e(gun_end), gun_dir);
            a.setShootPos(this.getMultiblockBlocks());
            a.field_70170_p.func_72838_d((Entity)a);
        }
        this.loadedShells.set(i, (Object)IIContent.itemAmmoArtillery.getCasingStack(1));
    }

    private boolean isAimed() {
        return this.plannedYaw == this.turretYaw && this.plannedPitch == this.turretPitch;
    }

    @Override
    public void readCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (this.isDummy()) {
            return;
        }
        if (!descPacket) {
            this.loadedShells = blusunrize.immersiveengineering.common.util.Utils.readInventory((NBTTagList)nbt.func_150295_c("loaded_shells", 10), (int)this.loadedShells.size());
            if (nbt.func_74764_b("bullet")) {
                this.loadedShells = NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{new ItemStack(nbt.func_74775_l("bullet")), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a});
            }
        }
        this.turretYaw = nbt.func_74760_g("turretYaw");
        this.plannedYaw = nbt.func_74760_g("plannedYaw");
        this.turretPitch = nbt.func_74760_g("turretPitch");
        this.plannedPitch = nbt.func_74760_g("plannedPitch");
        this.isDoorOpened = nbt.func_74767_n("isDoorOpened");
        this.animation = ArtilleryHowitzerAnimation.values()[nbt.func_74762_e("animation")];
        this.animationTime = nbt.func_74762_e("animation_time");
        this.animationTimeMax = nbt.func_74762_e("animation_time_max");
        this.doorTime = nbt.func_74762_e("door_time");
        this.platformTime = nbt.func_74762_e("platform_time");
        this.platformPosition = nbt.func_74767_n("platform_position");
        this.shellConveyorTime = nbt.func_74762_e("shell_conveyor_time");
        this.orderList.clear();
        for (NBTBase order : nbt.func_150295_c("order_queue", 10)) {
            if (!(order instanceof NBTTagCompound)) continue;
            NBTTagCompound compound = (NBTTagCompound)order;
            this.orderList.add(new HowitzerOrder(ArtilleryHowitzerAnimation.values()[compound.func_74762_e("order")], compound.func_74760_g("pitch"), compound.func_74760_g("yaw")));
        }
    }

    @Override
    public void writeCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (this.isDummy()) {
            return;
        }
        if (!descPacket) {
            nbt.func_74782_a("loaded_shells", (NBTBase)blusunrize.immersiveengineering.common.util.Utils.writeInventory(this.loadedShells));
        }
        nbt.func_74776_a("turretYaw", this.turretYaw);
        nbt.func_74776_a("plannedYaw", this.plannedYaw);
        nbt.func_74776_a("turretPitch", this.turretPitch);
        nbt.func_74776_a("plannedPitch", this.plannedPitch);
        nbt.func_74757_a("isDoorOpened", this.isDoorOpened);
        nbt.func_74768_a("animation", this.animation.ordinal());
        nbt.func_74768_a("animation_time", this.animationTime);
        nbt.func_74768_a("animation_time_max", this.animationTimeMax);
        nbt.func_74768_a("door_time", this.doorTime);
        nbt.func_74768_a("platform_time", this.platformTime);
        nbt.func_74757_a("platform_position", this.platformPosition);
        nbt.func_74768_a("shell_conveyor_time", this.shellConveyorTime);
        nbt.func_74782_a("order_queue", (NBTBase)this.orderList.stream().map(order -> {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("order", order.animation.ordinal());
            tag.func_74776_a("pitch", order.pitch);
            tag.func_74776_a("yaw", order.yaw);
            return tag;
        }).collect(new NBTTagCollector()));
    }

    public void receiveMessageFromClient(@Nonnull NBTTagCompound message) {
    }

    @Override
    public void receiveMessageFromServer(@Nonnull NBTTagCompound message) {
        super.receiveMessageFromServer(message);
        if (this.isFullSyncMessage(message) || this.isDummy()) {
            return;
        }
        if (message.func_74764_b("loaded_shells")) {
            this.loadedShells = blusunrize.immersiveengineering.common.util.Utils.readInventory((NBTTagList)message.func_150295_c("loaded_shells", 10), (int)this.loadedShells.size());
        }
        if (message.func_74764_b("turretYaw")) {
            this.turretYaw = message.func_74760_g("turretYaw");
        }
        if (message.func_74764_b("plannedYaw")) {
            this.plannedYaw = message.func_74760_g("plannedYaw");
        }
        if (message.func_74764_b("turretPitch")) {
            this.turretPitch = message.func_74760_g("turretPitch");
        }
        if (message.func_74764_b("plannedPitch")) {
            this.plannedPitch = message.func_74760_g("plannedPitch");
        }
        if (message.func_74764_b("isDoorOpened")) {
            this.isDoorOpened = message.func_74767_n("isDoorOpened");
        }
        if (message.func_74764_b("animation")) {
            this.animation = ArtilleryHowitzerAnimation.values()[message.func_74762_e("animation")];
        }
        if (message.func_74764_b("animation_time")) {
            this.animationTime = message.func_74762_e("animation_time");
        }
        if (message.func_74764_b("animation_time_max")) {
            this.animationTimeMax = message.func_74762_e("animation_time_max");
        }
        if (message.func_74764_b("door_time")) {
            this.doorTime = message.func_74762_e("door_time");
        }
        if (message.func_74764_b("platform_time")) {
            this.platformTime = message.func_74762_e("platform_time");
        }
        if (message.func_74764_b("platform_position")) {
            this.platformPosition = message.func_74767_n("platform_position");
        }
        if (message.func_74764_b("shell_conveyor_time")) {
            this.shellConveyorTime = message.func_74762_e("shell_conveyor_time");
        }
    }

    private void turnToTarget() {
        if (Double.isNaN(this.turretPitch)) {
            this.turretPitch = 0.0f;
        }
        if (Double.isNaN(this.turretYaw)) {
            this.turretYaw = 0.0f;
        }
        if (this.isAimed()) {
            return;
        }
        this.plannedYaw = MathHelper.func_76142_g((float)this.plannedYaw);
        float p = this.plannedPitch - this.turretPitch;
        this.turretPitch += Math.signum(p) * MathHelper.func_76131_a((float)Math.abs(p), (float)0.0f, (float)Config.IIConfig.Machines.ArtilleryHowitzer.rotateSpeed);
        float y = MathHelper.func_76142_g((float)(360.0f + this.plannedYaw - this.turretYaw));
        if (Math.abs(p) < (float)Config.IIConfig.Machines.ArtilleryHowitzer.rotateSpeed * 0.5f) {
            this.turretPitch = this.plannedPitch;
        }
        this.turretYaw = Math.abs(y) < (float)Config.IIConfig.Machines.ArtilleryHowitzer.rotateSpeed * 0.5f ? this.plannedYaw : MathHelper.func_76142_g((float)(this.turretYaw + Math.signum(y) * MathHelper.func_76131_a((float)Math.abs(y), (float)0.0f, (float)Config.IIConfig.Machines.ArtilleryHowitzer.rotateSpeed)));
    }

    @SideOnly(value=Side.CLIENT)
    private void handleAnimationSounds() {
        SoundEvent[] sounds;
        IISoundAnimation current = null;
        switch (this.animation) {
            case FIRE1: 
            case FIRE2: 
            case FIRE3: 
            case FIRE4: {
                current = firingSoundAnimation;
                break;
            }
            case LOAD1: 
            case LOAD2: 
            case LOAD3: 
            case LOAD4: {
                current = loadingSoundAnimation;
                break;
            }
            case UNLOAD1: 
            case UNLOAD2: 
            case UNLOAD3: 
            case UNLOAD4: {
                current = unloadingSoundAnimation;
                break;
            }
        }
        if (current != null && (sounds = current.getSounds(this.animationTime)) != null) {
            for (SoundEvent sound : sounds) {
                Vec3d vv = new Vec3d((Vec3i)this.getBlockPosForPos(202)).func_72441_c((double)blusunrize.immersiveengineering.common.util.Utils.RAND.nextFloat(), (double)blusunrize.immersiveengineering.common.util.Utils.RAND.nextFloat(), (double)blusunrize.immersiveengineering.common.util.Utils.RAND.nextFloat());
                this.field_145850_b.func_184148_a((EntityPlayer)ClientUtils.mc().field_71439_g, vv.field_72450_a, vv.field_72448_b, vv.field_72449_c, sound, SoundCategory.BLOCKS, 0.75f, 1.0f);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void handleSounds() {
        boolean pitchOK;
        boolean hasActiveEnergy;
        boolean hasEnergy = this.energyStorage.getEnergyStored() >= Config.IIConfig.Machines.ArtilleryHowitzer.energyUsagePassive;
        boolean bl = hasActiveEnergy = this.energyStorage.getEnergyStored() >= Config.IIConfig.Machines.ArtilleryHowitzer.energyUsagePassive + Config.IIConfig.Machines.ArtilleryHowitzer.energyUsageActive;
        boolean platformOK = this.animation == ArtilleryHowitzerAnimation.STOP || this.platformTime == (this.platformPosition ? Config.IIConfig.Machines.ArtilleryHowitzer.platformTime : 0);
        boolean yawOK = this.turretYaw == MathHelper.func_76142_g((float)this.plannedYaw);
        boolean bl2 = pitchOK = this.turretPitch == this.plannedPitch;
        if (platformOK) {
            if (!yawOK) {
                if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                    this.field_145850_b.func_184133_a((EntityPlayer)ClientUtils.mc().field_71439_g, this.getBlockPosForPos(525), IISounds.howitzer_rotation_v, SoundCategory.BLOCKS, 0.5f, 1.0f);
                }
            } else if (!pitchOK && this.field_145850_b.func_82737_E() % 20L == 0L) {
                this.field_145850_b.func_184133_a((EntityPlayer)ClientUtils.mc().field_71439_g, this.getBlockPosForPos(525), IISounds.howitzer_rotation_h, SoundCategory.BLOCKS, 0.5f, 1.0f);
            }
        } else if (hasEnergy) {
            boolean isFinish;
            boolean isStart = this.platformTime == 1;
            boolean bl3 = isFinish = this.platformTime == Config.IIConfig.Machines.ArtilleryHowitzer.platformTime - 1;
            if (this.platformPosition ? isStart : isFinish) {
                this.field_145850_b.func_184133_a((EntityPlayer)ClientUtils.mc().field_71439_g, this.getBlockPosForPos(525).func_177977_b(), IISounds.howitzer_platform_start, SoundCategory.BLOCKS, 0.5f, 1.0f);
            }
            if (this.platformPosition ? isFinish : isStart) {
                this.field_145850_b.func_184133_a((EntityPlayer)ClientUtils.mc().field_71439_g, this.getBlockPosForPos(525).func_177977_b(), IISounds.howitzer_platform_end, SoundCategory.BLOCKS, 0.5f, 1.0f);
            }
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                this.field_145850_b.func_184133_a((EntityPlayer)ClientUtils.mc().field_71439_g, this.getBlockPosForPos(525), this.platformPosition ? IISounds.howitzer_platform_raise : IISounds.howitzer_platform_lower, SoundCategory.BLOCKS, 0.5f, 1.0f);
            }
        }
        if (this.isDoorOpened && this.doorTime < Config.IIConfig.Machines.ArtilleryHowitzer.doorTime) {
            if (hasActiveEnergy && this.field_145850_b.func_82737_E() % 20L == 0L) {
                this.field_145850_b.func_184133_a((EntityPlayer)ClientUtils.mc().field_71439_g, this.getBlockPosForPos(525).func_177984_a(), IISounds.howitzer_door_open, SoundCategory.BLOCKS, 0.5f, 1.0f);
            }
        } else if (!this.isDoorOpened && this.doorTime > 0 && hasActiveEnergy && this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.field_145850_b.func_184133_a((EntityPlayer)ClientUtils.mc().field_71439_g, this.getBlockPosForPos(525).func_177984_a(), IISounds.howitzer_door_close, SoundCategory.BLOCKS, 0.5f, 1.0f);
        }
    }

    @Override
    @Nonnull
    public int[] getEnergyPos() {
        return new int[]{449};
    }

    @Override
    @Nonnull
    public int[] getRedstonePos(boolean in) {
        int[] nArray;
        if (in) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 481;
        } else {
            nArray = new int[]{};
        }
        return nArray;
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        return stack.func_77973_b() instanceof ItemIIAmmoArtillery;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 1;
    }

    @Override
    @Nonnull
    public int[] getDataPos(boolean input) {
        return new int[]{441};
    }

    @Override
    public void receiveData(DataPacket packet, int pos) {
        IDataConnector conn = Utils.findConnectorFacing(this.getBlockPosForPos(441), this.field_145850_b, EnumFacing.UP);
        if (packet.getPacketVariable(Character.valueOf('y')) instanceof IDataTypeNumeric) {
            this.plannedYaw = ((IDataTypeNumeric)packet.getPacketVariable(Character.valueOf('y'))).floatValue() % 360.0f;
            if (this.plannedYaw < 0.0f) {
                this.plannedYaw = 360.0f - this.plannedYaw;
            }
        }
        if (packet.getPacketVariable(Character.valueOf('p')) instanceof IDataTypeNumeric) {
            this.plannedPitch = Math.abs(Math.min(Math.max(-Math.abs(((IDataTypeNumeric)packet.getPacketVariable(Character.valueOf('p'))).floatValue() % 360.0f), -105.0f), 0.0f));
        }
        if (this.animationTime == 0 && packet.getPacketVariable(Character.valueOf('c')) instanceof DataTypeString) {
            String command = packet.getPacketVariable(Character.valueOf('c')).valueToString();
            ArtilleryHowitzerAnimation anim = ArtilleryHowitzerAnimation.v(command, this);
            if (anim != null) {
                if (anim == ArtilleryHowitzerAnimation.STOP) {
                    this.orderList.clear();
                }
                if (anim.matchesRequirements(this)) {
                    this.animation = anim;
                    this.animationTime = 0;
                    this.animationTimeMax = anim.animationTime;
                    this.forceTileUpdate();
                }
            } else {
                if (this.animation == ArtilleryHowitzerAnimation.STOP && this.orderList.isEmpty()) {
                    switch (command) {
                        case "fire_all": {
                            float vOffset = 0.0f;
                            float hOffset = 0.0f;
                            if (packet.hasVariable(Character.valueOf('v'))) {
                                vOffset = packet.getVarInType(IDataTypeNumeric.class, packet.getPacketVariable(Character.valueOf('v'))).floatValue();
                            }
                            if (packet.hasVariable(Character.valueOf('h'))) {
                                hOffset = packet.getVarInType(IDataTypeNumeric.class, packet.getPacketVariable(Character.valueOf('v'))).floatValue();
                            }
                            this.orderList.add(new HowitzerOrder(ArtilleryHowitzerAnimation.FIRE1, this.plannedPitch - vOffset, this.plannedYaw - hOffset));
                            this.orderList.add(new HowitzerOrder(ArtilleryHowitzerAnimation.FIRE2, this.plannedPitch + vOffset, this.plannedYaw + hOffset));
                            this.orderList.add(new HowitzerOrder(ArtilleryHowitzerAnimation.FIRE3, this.plannedPitch - vOffset, this.plannedYaw - hOffset));
                            this.orderList.add(new HowitzerOrder(ArtilleryHowitzerAnimation.FIRE4, this.plannedPitch + vOffset, this.plannedYaw + hOffset));
                            break;
                        }
                        case "load_all": {
                            this.orderList.add(new HowitzerOrder(ArtilleryHowitzerAnimation.LOAD1));
                            this.orderList.add(new HowitzerOrder(ArtilleryHowitzerAnimation.LOAD2));
                            this.orderList.add(new HowitzerOrder(ArtilleryHowitzerAnimation.LOAD3));
                            this.orderList.add(new HowitzerOrder(ArtilleryHowitzerAnimation.LOAD4));
                            break;
                        }
                        case "unload_all": {
                            this.orderList.add(new HowitzerOrder(ArtilleryHowitzerAnimation.UNLOAD1));
                            this.orderList.add(new HowitzerOrder(ArtilleryHowitzerAnimation.UNLOAD2));
                            this.orderList.add(new HowitzerOrder(ArtilleryHowitzerAnimation.UNLOAD3));
                            this.orderList.add(new HowitzerOrder(ArtilleryHowitzerAnimation.UNLOAD4));
                        }
                    }
                }
                if (conn == null) {
                    return;
                }
                DataPacket pp = null;
                switch (command) {
                    case "get_energy": {
                        pp = Utils.getSimpleCallbackMessage(packet, "energy", new DataTypeInteger(this.energyStorage.getEnergyStored()));
                        break;
                    }
                    case "get_state_progress": {
                        pp = Utils.getSimpleCallbackMessage(packet, "state_progress", new DataTypeInteger((int)((float)this.animationTime / (float)this.animationTimeMax * 100.0f)));
                        break;
                    }
                    case "get_yaw": {
                        pp = Utils.getSimpleCallbackMessage(packet, "yaw", new DataTypeInteger((int)this.turretYaw));
                        break;
                    }
                    case "get_pitch": {
                        pp = Utils.getSimpleCallbackMessage(packet, "pitch", new DataTypeInteger((int)this.turretPitch));
                        break;
                    }
                    case "get_planned_yaw": {
                        pp = Utils.getSimpleCallbackMessage(packet, "planned_yaw", new DataTypeInteger((int)this.plannedYaw));
                        break;
                    }
                    case "get_planned_pitch": {
                        pp = Utils.getSimpleCallbackMessage(packet, "planned_pitch", new DataTypeInteger((int)this.plannedPitch));
                        break;
                    }
                    case "get_platform_height": {
                        pp = Utils.getSimpleCallbackMessage(packet, "platform_height", new DataTypeInteger(this.platformTime));
                        break;
                    }
                    case "get_door_opened": {
                        pp = Utils.getSimpleCallbackMessage(packet, "door_opened", new DataTypeBoolean(this.isDoorOpened && this.doorTime == Config.IIConfig.Machines.ArtilleryHowitzer.doorTime));
                        break;
                    }
                    case "get_door_closed": {
                        pp = Utils.getSimpleCallbackMessage(packet, "door_closed", new DataTypeBoolean(!this.isDoorOpened && this.doorTime == 0));
                        break;
                    }
                    case "get_door_opening": {
                        pp = Utils.getSimpleCallbackMessage(packet, "door_opening", new DataTypeBoolean(this.doorTime != 0 && this.doorTime != Config.IIConfig.Machines.ArtilleryHowitzer.doorTime));
                        break;
                    }
                    case "get_loaded_shell": {
                        int i = packet.getVarInType(DataTypeInteger.class, (IDataType)packet.getPacketVariable((Character)Character.valueOf((char)'i'))).value;
                        pp = Utils.getSimpleCallbackMessage(packet, "loaded_shell", new DataTypeItemStack((ItemStack)this.loadedShells.get(i)));
                        break;
                    }
                    case "get_stored_shell": {
                        int i = packet.getVarInType(DataTypeInteger.class, (IDataType)packet.getPacketVariable((Character)Character.valueOf((char)'i'))).value;
                        pp = Utils.getSimpleCallbackMessage(packet, "stored_shell", new DataTypeItemStack((ItemStack)this.inventory.get(MathHelper.func_76125_a((int)i, (int)0, (int)5))));
                        break;
                    }
                    case "get_state": {
                        pp = Utils.getSimpleCallbackMessage(packet, "state", new DataTypeString(this.animation.func_176610_l()));
                        break;
                    }
                    case "get_state_num": {
                        pp = Utils.getSimpleCallbackMessage(packet, "state", new DataTypeInteger(this.animation.ordinal()));
                    }
                }
                if (pp != null) {
                    conn.sendPacket(pp);
                }
            }
        }
        this.forceTileUpdate();
    }

    @Override
    public List<AxisAlignedBB> getBounds(boolean collision) {
        TileEntityArtilleryHowitzer master = (TileEntityArtilleryHowitzer)this.master();
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        block0 : switch (this.field_174879_c) {
            case 102: 
            case 103: 
            case 104: 
            case 111: 
            case 112: 
            case 113: 
            case 120: 
            case 122: 
            case 129: 
            case 130: 
            case 131: 
            case 183: 
            case 184: 
            case 185: 
            case 264: 
            case 265: 
            case 266: 
            case 273: 
            case 275: 
            case 282: 
            case 283: 
            case 284: 
            case 291: 
            case 293: 
            case 345: 
            case 346: 
            case 347: 
            case 364: 
            case 417: 
            case 418: 
            case 419: 
            case 445: {
                list.add(AABB_EMPTY.func_186670_a(this.func_174877_v()));
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 39: 
            case 41: 
            case 48: 
            case 49: 
            case 50: {
                list.add(AABB_LOWER_FLOOR.func_186670_a(this.func_174877_v()));
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 29: 
            case 33: 
            case 38: 
            case 42: 
            case 47: 
            case 51: 
            case 57: 
            case 58: 
            case 59: {
                list.add(AABB_TALLER_FLOOR.func_186670_a(this.func_174877_v()));
                break;
            }
            case 506: 
            case 507: 
            case 508: 
            case 509: 
            case 510: 
            case 515: 
            case 516: 
            case 517: 
            case 518: 
            case 519: 
            case 524: 
            case 525: 
            case 526: 
            case 527: 
            case 528: 
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 542: 
            case 543: 
            case 544: 
            case 545: 
            case 546: {
                list.add((master != null && master.doorTime > 1 ? AABB_EMPTY : AABB_DOOR).func_186670_a(this.func_174877_v()));
                break;
            }
            case 520: 
            case 529: 
            case 538: {
                list.add(AABB_DOOR_HOLDERS_RIGHT[(this.mirrored ? this.facing : this.facing.func_176734_d()).func_176745_a() - 2].func_186670_a(this.func_174877_v()));
                break;
            }
            case 514: 
            case 523: 
            case 532: {
                list.add(AABB_DOOR_HOLDERS_LEFT[(this.mirrored ? this.facing : this.facing.func_176734_d()).func_176745_a() - 2].func_186670_a(this.func_174877_v()));
                break;
            }
            case 488: 
            case 492: 
            case 497: 
            case 501: 
            case 504: 
            case 505: 
            case 511: 
            case 512: 
            case 540: 
            case 541: 
            case 547: 
            case 548: 
            case 551: 
            case 555: 
            case 560: 
            case 564: {
                list.add(AABB_TABLE_TOP.func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                break;
            }
            case 101: 
            case 141: 
            case 182: 
            case 222: 
            case 263: 
            case 303: 
            case 344: 
            case 384: 
            case 425: 
            case 465: {
                list.add(new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 1.0, 0.6875).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                switch (this.mirrored ? this.facing : this.facing.func_176734_d()) {
                    case NORTH: 
                    case WEST: {
                        list.add(new AxisAlignedBB(0.6875, 0.0, 0.0, 1.0, 1.0, 0.3125).func_186670_a(this.func_174877_v()));
                        list.add(new AxisAlignedBB(0.0, 0.0, 0.6875, 0.3125, 1.0, 1.0).func_186670_a(this.func_174877_v()));
                        break block0;
                    }
                    case SOUTH: 
                    case EAST: {
                        list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 0.3125, 1.0, 0.3125).func_186670_a(this.func_174877_v()));
                        list.add(new AxisAlignedBB(0.6875, 0.0, 0.6875, 1.0, 1.0, 1.0).func_186670_a(this.func_174877_v()));
                        break block0;
                    }
                }
                list.add(AABB_EMPTY.func_186670_a(this.func_174877_v()));
                break;
            }
            case 105: 
            case 137: 
            case 186: 
            case 218: 
            case 267: 
            case 299: 
            case 348: 
            case 380: 
            case 429: 
            case 461: {
                list.add(new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 1.0, 0.6875).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                switch (this.mirrored ? this.facing : this.facing.func_176734_d()) {
                    case NORTH: 
                    case WEST: {
                        list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 0.3125, 1.0, 0.3125).func_186670_a(this.func_174877_v()));
                        list.add(new AxisAlignedBB(0.6875, 0.0, 0.6875, 1.0, 1.0, 1.0).func_186670_a(this.func_174877_v()));
                        break block0;
                    }
                    case SOUTH: 
                    case EAST: {
                        list.add(new AxisAlignedBB(0.6875, 0.0, 0.0, 1.0, 1.0, 0.3125).func_186670_a(this.func_174877_v()));
                        list.add(new AxisAlignedBB(0.0, 0.0, 0.6875, 0.3125, 1.0, 1.0).func_186670_a(this.func_174877_v()));
                        break block0;
                    }
                }
                list.add(AABB_EMPTY.func_186670_a(this.func_174877_v()));
                break;
            }
            case 66: 
            case 147: 
            case 228: 
            case 309: 
            case 390: 
            case 410: 
            case 471: {
                list.add(AABB_LADDER[this.facing.func_176745_a() - 2].func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                break;
            }
            default: {
                list.add(AABB_FULL.func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            }
        }
        return list;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.field_174879_c == 410 && this.master() != null;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.field_174879_c == 410) {
            TileEntityArtilleryHowitzer master = (TileEntityArtilleryHowitzer)this.master();
            if (master == null) {
                return null;
            }
            return (T)master.insertionHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void onAnimationChangeClient(boolean state, int part) {
        if (part == 0) {
            this.isDoorOpened = state;
        }
    }

    @Override
    public void onAnimationChangeServer(boolean state, int part) {
        if (part == 0) {
            this.isDoorOpened = state;
        }
        IIPacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageBooleanAnimatedPartsSync(this.isDoorOpened, 1, this.func_174877_v()), Utils.targetPointFromPos(this.func_174877_v(), this.field_145850_b, 32));
    }

    public EnumFacing[] sigOutputDirections() {
        if (this.field_174879_c == 2) {
            return new EnumFacing[]{this.mirrored ? this.facing.func_176735_f() : this.facing.func_176746_e()};
        }
        return new EnumFacing[0];
    }

    public void onEntityCollision(@Nonnull World world, @Nonnull Entity entity) {
        if (!world.field_72995_K && this.field_174879_c == 410 && entity instanceof EntityItem) {
            TileEntityArtilleryHowitzer master = (TileEntityArtilleryHowitzer)this.master();
            if (master == null || !((ItemStack)master.inventory.get(0)).func_190926_b()) {
                return;
            }
            EntityItem entityItem = (EntityItem)entity;
            if (entityItem.func_92059_d().func_77973_b() != IIContent.itemAmmoArtillery) {
                return;
            }
            ItemStack stack = master.inventoryHandler.insertItem(0, entityItem.func_92059_d().func_77946_l(), false);
            if (stack.func_190926_b()) {
                entityItem.func_92058_a(ItemStack.field_190927_a);
            }
        }
    }

    private Vec3d getGunPosition() {
        BlockPos shoot_pos = this.getBlockPosForPos(445).func_177967_a(EnumFacing.UP, 1);
        return new Vec3d((double)shoot_pos.func_177958_n() + 0.5, (double)shoot_pos.func_177956_o() + 1.5, (double)shoot_pos.func_177952_p() + 0.5);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        if (!this.isDummy()) {
            BlockPos nullPos = this.getBlockPosForPos(0);
            return new AxisAlignedBB(nullPos, nullPos.func_177967_a(this.facing, this.structureDimensions[1]).func_177967_a(this.mirrored ? this.facing.func_176735_f() : this.facing.func_176746_e(), this.structureDimensions[2]).func_177981_b(this.structureDimensions[0])).func_186662_g(5.0);
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_186670_a(this.func_174877_v());
    }

    @Override
    public boolean isLadder() {
        switch (this.field_174879_c) {
            case 66: 
            case 147: 
            case 228: 
            case 309: 
            case 390: 
            case 471: {
                return true;
            }
        }
        return false;
    }

    @Override
    public float getExplosionResistance() {
        switch (this.field_174879_c) {
            case 506: 
            case 507: 
            case 508: 
            case 509: 
            case 510: 
            case 515: 
            case 516: 
            case 517: 
            case 518: 
            case 519: 
            case 524: 
            case 525: 
            case 526: 
            case 527: 
            case 528: 
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 542: 
            case 543: 
            case 544: 
            case 545: 
            case 546: {
                TileEntityArtilleryHowitzer master = (TileEntityArtilleryHowitzer)this.master();
                return master != null && master.doorTime > 1 ? 2000.0f : IIContent.blockMetalMultiblock0.getBlockResistance();
            }
        }
        return IIContent.blockMetalMultiblock0.getBlockResistance();
    }

    static {
        loadingSoundAnimation.withSound(0.64, IISounds.metal_breadbox_open).withSound(0.84, IISounds.howitzer_door_open).withSound(1.88, IISounds.howitzer_door_open).withSound(2.76, IISounds.howitzer_door_open).withSound(3.68, IISounds.howitzer_door_close).withSound(4.36, IISounds.metal_locker_open).withSound(5.0, IISounds.howitzer_chain).withSound(6.12, IISounds.metal_breadbox_open).withSound(8.24, IISounds.metal_breadbox_close).withSound(8.4, IISounds.howitzer_shell_put).withSound(8.92, IISounds.howitzer_platform_start).withSound(9.04, IISounds.howitzer_chain).withSound(11.28, IISounds.metal_breadbox_open).withSound(11.52, IISounds.metal_locker_close).withSound(11.96, IISounds.inserter_forward).withSound(12.44, IISounds.inserter_forward).withSound(12.8, IISounds.inserter_forward).withSound(13.2, IISounds.inserter_forward).withSound(13.24, IISounds.howitzer_door_open).withSound(13.96, IISounds.howitzer_shell_pick).withSound(14.24, IISounds.inserter_forward).withSound(14.72, IISounds.inserter_forward).withSound(14.96, IISounds.howitzer_platform_start).withSound(15.12, IISounds.inserter_forward).withSound(15.56, IISounds.inserter_forward).withSound(15.96, IISounds.inserter_forward).withSound(16.36, IISounds.howitzer_shell_put).withSound(16.44, IISounds.inserter_forward).withSound(16.68, IISounds.inserter_forward).withSound(17.0, IISounds.howitzer_door_close).withSound(17.3, IISounds.metal_locker_open).compile(Config.IIConfig.Machines.ArtilleryHowitzer.loadRackTime);
        firingSoundAnimation.withSound(0.0, IISounds.metal_breadbox_open).withSound(0.52, IISounds.inserter_forward).withSound(1.0, IISounds.inserter_forward).withSound(1.32, IISounds.inserter_forward).withSound(1.76, IISounds.inserter_forward).withSound(2.24, IISounds.inserter_forward).withSound(2.28, IISounds.inserter_forward).withSound(2.8, IISounds.inserter_forward).withSound(3.24, IISounds.inserter_forward).withSound(3.72, IISounds.inserter_forward).withSound(4.16, IISounds.inserter_forward).withSound(4.4, IISounds.metal_breadbox_close).withSound(4.56, IISounds.inserter_forward).withSound(4.96, IISounds.howitzer_shell_pick).withSound(5.04, IISounds.inserter_forward).withSound(5.48, IISounds.inserter_forward).withSound(5.92, IISounds.inserter_forward).withSound(6.36, IISounds.inserter_forward).withSound(6.8, IISounds.inserter_forward).withSound(7.08, IISounds.metal_breadbox_close).withSound(7.72, IISounds.howitzer_shell_put).withSound(7.8, IISounds.inserter_forward).withSound(8.24, IISounds.inserter_forward).withSound(8.44, IISounds.inserter_forward).withSound(8.48, IISounds.inserter_forward).withSound(9.0, IISounds.inserter_forward).withSound(9.52, IISounds.inserter_forward).withSound(10.0, IISounds.inserter_forward).withSound(10.36, IISounds.inserter_forward).withSound(10.64, IISounds.inserter_forward).withSound(10.68, IISounds.inserter_forward).withSound(11.2, IISounds.inserter_forward).withSound(11.68, IISounds.inserter_forward).withSound(12.16, IISounds.inserter_forward).withSound(12.24, IISounds.howitzer_shell_pick).withSound(12.64, IISounds.inserter_backward).withSound(13.08, IISounds.inserter_backward).withSound(13.52, IISounds.inserter_backward).withSound(13.96, IISounds.inserter_forward).withSound(14.12, IISounds.metal_breadbox_close).withSound(14.48, IISounds.howitzer_shell_put).withSound(14.76, IISounds.inserter_backward).withSound(15.24, IISounds.inserter_backward).withSound(15.6, IISounds.inserter_backward).withSound(15.72, IISounds.metal_breadbox_open).compile(Config.IIConfig.Machines.ArtilleryHowitzer.gunFireTime);
        unloadingSoundAnimation.withSound(0.0, IISounds.inserter_forward).withSound(0.04, IISounds.metal_breadbox_open).withSound(0.36, IISounds.howitzer_door_open).withSound(0.48, IISounds.inserter_forward).withSound(0.96, IISounds.inserter_forward).withSound(1.24, IISounds.metal_breadbox_close).withSound(1.36, IISounds.howitzer_shell_pick).withSound(1.44, IISounds.inserter_forward).withSound(1.92, IISounds.inserter_forward).withSound(2.36, IISounds.inserter_forward).withSound(2.84, IISounds.inserter_forward).withSound(3.32, IISounds.inserter_forward).withSound(3.8, IISounds.inserter_forward).withSound(4.0, IISounds.howitzer_shell_put).withSound(4.28, IISounds.inserter_forward).withSound(4.72, IISounds.inserter_forward).withSound(5.16, IISounds.inserter_forward).withSound(5.6, IISounds.inserter_forward).withSound(5.76, IISounds.metal_breadbox_close).withSound(5.92, IISounds.metal_locker_open).withSound(6.6, IISounds.howitzer_chain).withSound(8.08, IISounds.howitzer_door_close).withSound(9.28, IISounds.metal_breadbox_close).withSound(10.32, IISounds.howitzer_door_close).withSound(12.44, IISounds.metal_locker_close).compile(Config.IIConfig.Machines.ArtilleryHowitzer.loadRackTime);
    }

    public static class HowitzerOrder {
        final ArtilleryHowitzerAnimation animation;
        final float pitch;
        final float yaw;

        public HowitzerOrder(ArtilleryHowitzerAnimation animation, float pitch, float yaw) {
            this.animation = animation;
            this.pitch = pitch;
            this.yaw = yaw;
        }

        public HowitzerOrder(ArtilleryHowitzerAnimation animation) {
            this(animation, 0.0f, 0.0f);
        }
    }

    public static enum GunPosition {
        ON_TARGET,
        NEUTRAL,
        LOADING;

    }

    public static enum ArtilleryHowitzerAnimation implements IStringSerializable
    {
        STOP(false, false, GunPosition.NEUTRAL, t -> true, t -> false, 0, null, 1.0f),
        HIDE(false, false, GunPosition.LOADING, t -> true, t -> t.platformTime == 0, 0, null, 1.0f),
        LOAD1(true, false, GunPosition.LOADING, t -> ((ItemStack)t.loadedShells.get(0)).func_190926_b() && !((ItemStack)t.inventory.get(5)).func_190926_b(), t -> !((ItemStack)t.loadedShells.get(0)).func_190926_b(), Config.IIConfig.Machines.ArtilleryHowitzer.loadRackTime, "LOAD", 1.0f),
        LOAD2(true, false, GunPosition.LOADING, t -> ((ItemStack)t.loadedShells.get(1)).func_190926_b() && !((ItemStack)t.inventory.get(5)).func_190926_b(), t -> !((ItemStack)t.loadedShells.get(1)).func_190926_b(), Config.IIConfig.Machines.ArtilleryHowitzer.loadRackTime, "LOAD", 1.0f),
        LOAD3(true, false, GunPosition.LOADING, t -> ((ItemStack)t.loadedShells.get(2)).func_190926_b() && !((ItemStack)t.inventory.get(5)).func_190926_b(), t -> !((ItemStack)t.loadedShells.get(2)).func_190926_b(), Config.IIConfig.Machines.ArtilleryHowitzer.loadRackTime, "LOAD", 1.0f),
        LOAD4(true, false, GunPosition.LOADING, t -> ((ItemStack)t.loadedShells.get(3)).func_190926_b() && !((ItemStack)t.inventory.get(5)).func_190926_b(), t -> !((ItemStack)t.loadedShells.get(3)).func_190926_b(), Config.IIConfig.Machines.ArtilleryHowitzer.loadRackTime, "LOAD", 1.0f),
        UNLOAD1(true, false, GunPosition.LOADING, t -> !((ItemStack)t.loadedShells.get(0)).func_190926_b(), t -> ((ItemStack)t.loadedShells.get(0)).func_190926_b(), Config.IIConfig.Machines.ArtilleryHowitzer.loadRackTime, "UNLOAD", 1.0f),
        UNLOAD2(true, false, GunPosition.LOADING, t -> !((ItemStack)t.loadedShells.get(1)).func_190926_b(), t -> ((ItemStack)t.loadedShells.get(1)).func_190926_b(), Config.IIConfig.Machines.ArtilleryHowitzer.loadRackTime, "UNLOAD", 1.0f),
        UNLOAD3(true, false, GunPosition.LOADING, t -> !((ItemStack)t.loadedShells.get(2)).func_190926_b(), t -> ((ItemStack)t.loadedShells.get(2)).func_190926_b(), Config.IIConfig.Machines.ArtilleryHowitzer.loadRackTime, "UNLOAD", 1.0f),
        UNLOAD4(true, false, GunPosition.LOADING, t -> !((ItemStack)t.loadedShells.get(3)).func_190926_b(), t -> ((ItemStack)t.loadedShells.get(3)).func_190926_b(), Config.IIConfig.Machines.ArtilleryHowitzer.loadRackTime, "UNLOAD", 1.0f),
        FIRE1(true, true, GunPosition.ON_TARGET, t -> ((ItemStack)t.loadedShells.get(0)).func_77973_b() == IIContent.itemAmmoArtillery, t -> ((ItemStack)t.loadedShells.get(0)).func_190926_b(), Config.IIConfig.Machines.ArtilleryHowitzer.gunFireTime, "FIRE", (float)Config.IIConfig.Machines.ArtilleryHowitzer.gunFireMoment),
        FIRE2(true, true, GunPosition.ON_TARGET, t -> ((ItemStack)t.loadedShells.get(1)).func_77973_b() == IIContent.itemAmmoArtillery, t -> ((ItemStack)t.loadedShells.get(1)).func_190926_b(), Config.IIConfig.Machines.ArtilleryHowitzer.gunFireTime, "FIRE", (float)Config.IIConfig.Machines.ArtilleryHowitzer.gunFireMoment),
        FIRE3(true, true, GunPosition.ON_TARGET, t -> ((ItemStack)t.loadedShells.get(2)).func_77973_b() == IIContent.itemAmmoArtillery, t -> ((ItemStack)t.loadedShells.get(2)).func_190926_b(), Config.IIConfig.Machines.ArtilleryHowitzer.gunFireTime, "FIRE", (float)Config.IIConfig.Machines.ArtilleryHowitzer.gunFireMoment),
        FIRE4(true, true, GunPosition.ON_TARGET, t -> ((ItemStack)t.loadedShells.get(3)).func_77973_b() == IIContent.itemAmmoArtillery, t -> ((ItemStack)t.loadedShells.get(3)).func_190926_b(), Config.IIConfig.Machines.ArtilleryHowitzer.gunFireTime, "FIRE", (float)Config.IIConfig.Machines.ArtilleryHowitzer.gunFireMoment),
        AIM(true, true, GunPosition.ON_TARGET, t -> true, t -> false, 0, null, 1.0f);

        final boolean requiresPlatform;
        final boolean platformUp;
        final GunPosition gunPosition;
        @Nullable
        final String alias;
        final Predicate<TileEntityArtilleryHowitzer> requirements;
        final Predicate<TileEntityArtilleryHowitzer> fulfilled;
        final int animationTime;
        final float executeTime;

        private ArtilleryHowitzerAnimation(boolean requiresPlatform, boolean platformUp, GunPosition gunPosition, Predicate<TileEntityArtilleryHowitzer> requirements, @Nullable Predicate<TileEntityArtilleryHowitzer> fulfilled, int animationTime, String alias, float executeTime) {
            this.requiresPlatform = requiresPlatform;
            this.platformUp = platformUp;
            this.gunPosition = gunPosition;
            this.requirements = requirements;
            this.fulfilled = fulfilled;
            this.animationTime = animationTime;
            this.alias = alias;
            this.executeTime = executeTime;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public boolean matchesRequirements(TileEntityArtilleryHowitzer te) {
            return this.requirements.test(te);
        }

        public boolean isFulfilled(TileEntityArtilleryHowitzer te) {
            return this.fulfilled.test(te);
        }

        @Nullable
        public static ArtilleryHowitzerAnimation v(String s, TileEntityArtilleryHowitzer te) {
            String ss = s.toUpperCase();
            Optional<ArtilleryHowitzerAnimation> found = Arrays.stream(ArtilleryHowitzerAnimation.values()).filter(e -> e.alias != null && e.alias.toLowerCase().equals(s)).filter(a -> a.matchesRequirements(te)).findFirst();
            return found.orElseGet(() -> Arrays.stream(ArtilleryHowitzerAnimation.values()).filter(e -> e.name().equals(ss)).findFirst().orElse(null));
        }
    }
}

