/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.blocks.multiblocks.metal.tileentities.base;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorageAdvanced;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.IDataConnector;
import pl.pabilo8.immersiveintelligence.api.data.IDataDevice;
import pl.pabilo8.immersiveintelligence.api.utils.IIMultiblockInterfaces;
import pl.pabilo8.immersiveintelligence.common.blocks.MultiblockStuctureBase;
import pl.pabilo8.immersiveintelligence.common.blocks.multiblocks.metal.tileentities.base.TileEntityMultiblockIIBase;

public abstract class TileEntityMultiblockIIGeneric<T extends TileEntityMultiblockIIGeneric<T>>
extends TileEntityMultiblockIIBase<T>
implements IIMultiblockInterfaces.IIIInventory,
EnergyHelper.IIEInternalFluxHandler,
IEBlockInterfaces.IHammerInteraction,
IEBlockInterfaces.IRedstoneOutput,
IDataDevice,
IEBlockInterfaces.IComparatorOverride,
IIMultiblockInterfaces.IAdvancedBounds {
    protected boolean redstoneControlInverted = false;
    public NonNullList<ItemStack> inventory;
    EnergyHelper.IEForgeEnergyWrapper wrapper = new EnergyHelper.IEForgeEnergyWrapper((EnergyHelper.IIEInternalFluxConnector)this, null);
    public FluxStorageAdvanced energyStorage;

    public TileEntityMultiblockIIGeneric(MultiblockStuctureBase<T> multiblock) {
        super(multiblock);
    }

    public void readCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (this.isDummy()) {
            return;
        }
        if (!descPacket) {
            if (this.energyStorage.getMaxEnergyStored() != 0) {
                this.energyStorage.readFromNBT(nbt);
            }
            if (this.inventory.size() != 0) {
                this.inventory = blusunrize.immersiveengineering.common.util.Utils.readInventory((NBTTagList)nbt.func_150295_c("inventory", 10), (int)this.inventory.size());
            }
        }
    }

    public void writeCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (this.isDummy()) {
            return;
        }
        if (!descPacket) {
            if (this.energyStorage.getMaxEnergyStored() != 0) {
                this.energyStorage.writeToNBT(nbt);
            }
            if (this.inventory.size() != 0) {
                nbt.func_74782_a("inventory", (NBTBase)blusunrize.immersiveengineering.common.util.Utils.writeInventory(this.inventory));
            }
        }
    }

    @Override
    public void receiveMessageFromServer(@Nonnull NBTTagCompound message) {
        super.receiveMessageFromServer(message);
        if (this.isDummy() || this.isFullSyncMessage(message)) {
            return;
        }
        if (message.func_74764_b("inventory")) {
            this.inventory = blusunrize.immersiveengineering.common.util.Utils.readInventory((NBTTagList)message.func_150295_c("inventory", 10), (int)this.inventory.size());
        }
        if (message.func_74764_b("ifluxEnergy")) {
            this.energyStorage.readFromNBT(message);
        }
    }

    public abstract int[] getRedstonePos(boolean var1);

    public final boolean isRedstonePos(boolean input) {
        return Arrays.stream(this.getRedstonePos(input)).anyMatch(i -> this.field_174879_c == i);
    }

    public final boolean canConnectRedstone(@Nonnull IBlockState state, @Nonnull EnumFacing side) {
        return this.isRedstonePos(false) || this.isRedstonePos(true);
    }

    public boolean hammerUseSide(@Nonnull EnumFacing side, @Nonnull EntityPlayer player, float hitX, float hitY, float hitZ) {
        if (this.isRedstonePos(true)) {
            TileEntityMultiblockIIGeneric master = (TileEntityMultiblockIIGeneric)this.master();
            if (master != null) {
                master.redstoneControlInverted = !master.redstoneControlInverted;
                ChatUtils.sendServerNoSpamMessages((EntityPlayer)player, (ITextComponent[])new ITextComponent[]{new TextComponentTranslation("chat.immersiveengineering.info.rsControl." + (master.redstoneControlInverted ? "invertedOn" : "invertedOff"), new Object[0])});
                this.forceTileUpdate();
            }
            return true;
        }
        return false;
    }

    public int getStrongRSOutput(@Nonnull IBlockState state, @Nonnull EnumFacing side) {
        return 0;
    }

    @Nonnull
    public abstract int[] getDataPos(boolean var1);

    public final boolean isDataPos(boolean input) {
        return Arrays.stream(this.getDataPos(input)).anyMatch(i -> this.field_174879_c == i);
    }

    @Override
    public final void onReceive(DataPacket packet, @Nullable EnumFacing side) {
        TileEntityMultiblockIIGeneric master = (TileEntityMultiblockIIGeneric)this.master();
        if (master != null && this.isDataPos(true)) {
            master.receiveData(packet, this.field_174879_c);
        }
    }

    public void receiveData(DataPacket packet, int pos) {
    }

    public void sendData(DataPacket packet, EnumFacing facing, int pos) {
        IDataConnector conn = Utils.findConnectorFacing(this.getBlockPosForPos(pos), this.field_145850_b, facing);
        if (conn != null) {
            conn.sendPacket(packet);
        }
    }

    @Override
    @Nonnull
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public int getComparatorInputOverride() {
        if (!this.isRedstonePos(false)) {
            return 0;
        }
        TileEntityMultiblockIIGeneric master = (TileEntityMultiblockIIGeneric)this.master();
        if (master == null) {
            return 0;
        }
        return blusunrize.immersiveengineering.common.util.Utils.calcRedstoneFromInventory((IIEInventory)master);
    }

    @Nonnull
    public abstract int[] getEnergyPos();

    public boolean isEnergyPos() {
        return Arrays.stream(this.getEnergyPos()).anyMatch(i -> this.field_174879_c == i);
    }

    @Nonnull
    public final FluxStorage getFluxStorage() {
        TileEntityMultiblockIIGeneric master = (TileEntityMultiblockIIGeneric)this.master();
        if (master != null) {
            return master.energyStorage;
        }
        return this.energyStorage;
    }

    @Nonnull
    public IEEnums.SideConfig getEnergySideConfig(EnumFacing facing) {
        return this.formed && this.isEnergyPos() ? IEEnums.SideConfig.INPUT : IEEnums.SideConfig.NONE;
    }

    public EnergyHelper.IEForgeEnergyWrapper getCapabilityWrapper(EnumFacing facing) {
        if (this.formed && this.isEnergyPos()) {
            return this.wrapper;
        }
        return null;
    }

    public void postEnergyTransferUpdate(int energy, boolean simulate) {
        TileEntityMultiblockIIGeneric master;
        if (!simulate && !this.field_145850_b.field_72995_K && (master = (TileEntityMultiblockIIGeneric)this.master()) != null) {
            this.sendNBTMessageClient(master.energyStorage.writeToNBT(new NBTTagCompound()), Utils.targetPointFromTile((TileEntity)master, 40));
        }
    }
}

