/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.blocks.multiblocks.metal.tileentities.base;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.ImmersiveIntelligence;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.common.blocks.MultiblockStuctureBase;

public abstract class TileEntityMultiblockIIBase<T extends TileEntityMultiblockIIBase<T>>
extends TileEntityMultiblockPart<T>
implements IEBlockInterfaces.IMirrorAble,
IIEInventory {
    private final MultiblockStuctureBase<T> multiblock;

    protected TileEntityMultiblockIIBase(MultiblockStuctureBase<T> multiblock) {
        super(multiblock.getSize());
        this.multiblock = multiblock;
    }

    public final void func_73660_a() {
        ApiUtils.checkForNeedlessTicking((TileEntity)this);
        if (!this.isDummy()) {
            this.onUpdate();
        }
    }

    protected abstract void onUpdate();

    public void receiveMessageFromServer(@Nonnull NBTTagCompound message) {
        if (this.isFullSyncMessage(message)) {
            this.readCustomNBT(message, false);
        }
    }

    protected final boolean isFullSyncMessage(@Nonnull NBTTagCompound message) {
        return message.func_74764_b("_sync_all_values");
    }

    @Nonnull
    protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side) {
        return new IFluidTank[0];
    }

    @Nonnull
    public NonNullList<ItemStack> getInventory() {
        return NonNullList.func_191196_a();
    }

    protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resource) {
        return false;
    }

    protected boolean canDrainTankFrom(int iTank, EnumFacing side) {
        return false;
    }

    public float[] getBlockBounds() {
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    public boolean getIsMirrored() {
        return this.mirrored;
    }

    public IEProperties.PropertyBoolInverted getBoolProperty(Class<? extends IEBlockInterfaces.IUsesBooleanProperty> inf) {
        return IEProperties.BOOLEANS[0];
    }

    public ItemStack getOriginalBlock() {
        if (this.field_174879_c < 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack s = ItemStack.field_190927_a;
        try {
            int blocksPerLevel = this.structureDimensions[1] * this.structureDimensions[2];
            int h = this.field_174879_c / blocksPerLevel;
            int l = this.field_174879_c % blocksPerLevel / this.structureDimensions[2];
            int w = this.field_174879_c % this.structureDimensions[2];
            s = this.multiblock.getStructureManual()[h][l][w];
        }
        catch (Exception e) {
            ImmersiveIntelligence.logger.info((Object)e);
        }
        return s.func_77946_l();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (!this.isDummy()) {
            BlockPos nullPos = this.getBlockPosForPos(0);
            return new AxisAlignedBB(nullPos, nullPos.func_177967_a(this.facing, this.structureDimensions[1]).func_177967_a(this.mirrored ? this.facing.func_176735_f() : this.facing.func_176746_e(), this.structureDimensions[2]).func_177981_b(this.structureDimensions[0]));
        }
        return super.getRenderBoundingBox();
    }

    public BlockPos[] getMultiblockBlocks() {
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        BlockPos origin = this.func_174877_v().func_177973_b(new Vec3i(this.offset[0], this.offset[1], this.offset[2]));
        for (int y = 0; y < this.structureDimensions[0]; ++y) {
            for (int x = 0; x < this.structureDimensions[1]; ++x) {
                for (int z = 0; z < this.structureDimensions[2]; ++z) {
                    blocks.add(origin.func_177967_a(this.facing, x).func_177967_a(this.facing.func_176746_e(), z).func_177982_a(0, y, 0));
                }
            }
        }
        return blocks.toArray(new BlockPos[0]);
    }

    public boolean canRenderBreaking() {
        return !this.isDummy();
    }

    public void forceTileUpdate() {
        TileEntityMultiblockIIBase master = (TileEntityMultiblockIIBase)this.master();
        if (master != null) {
            master.func_70296_d();
            master.markContainingBlockForUpdate(null);
            NBTTagCompound nbt = new NBTTagCompound();
            master.writeCustomNBT(nbt, false);
            nbt.func_74757_a("_sync_all_values", true);
            this.sendNBTMessageClient(nbt, Utils.targetPointFromTile((TileEntity)master, 40));
        }
    }

    public void sendNBTMessageClient(NBTTagCompound message, NetworkRegistry.TargetPoint to) {
        ImmersiveEngineering.packetHandler.sendToAllAround((IMessage)new MessageTileSync((TileEntityIEBase)this, message), to);
    }

    public void sendNBTMessageServer(NBTTagCompound message) {
        ImmersiveEngineering.packetHandler.sendToServer((IMessage)new MessageTileSync((TileEntityIEBase)this, message));
    }
}

