/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.blocks.metal;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import pl.pabilo8.immersiveintelligence.api.bullets.BulletHelper;
import pl.pabilo8.immersiveintelligence.api.bullets.IBullet;
import pl.pabilo8.immersiveintelligence.common.entity.bullets.EntityBullet;
import pl.pabilo8.immersiveintelligence.common.items.tools.ItemIITrenchShovel;

public class TileEntityTellermine
extends TileEntityIEBase
implements IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IAdvancedCollisionBounds,
IEBlockInterfaces.ITileDrop,
IEBlockInterfaces.IPlayerInteraction {
    public static final Material[] MATCHING_MATERIALS = new Material[]{Material.field_151578_c, Material.field_151577_b, Material.field_151595_p, Material.field_151572_C};
    public int coreColor = 0xFFFFFF;
    public ItemStack mineStack = ItemStack.field_190927_a;
    private static final ArrayList<AxisAlignedBB> AABB = new ArrayList();
    public int digLevel = 0;
    private boolean armed = true;
    public boolean grass = false;

    public void readCustomNBT(NBTTagCompound nbtTagCompound, boolean b) {
        this.digLevel = nbtTagCompound.func_74762_e("digLevel");
        this.armed = nbtTagCompound.func_74767_n("armed");
        this.grass = nbtTagCompound.func_74767_n("grass");
        this.readOnPlacement(null, new ItemStack(nbtTagCompound.func_74775_l("mineStack")));
    }

    public void writeCustomNBT(NBTTagCompound nbtTagCompound, boolean b) {
        nbtTagCompound.func_74768_a("digLevel", this.digLevel);
        nbtTagCompound.func_74757_a("armed", this.armed);
        nbtTagCompound.func_74757_a("grass", this.grass);
        nbtTagCompound.func_74782_a("mineStack", (NBTBase)this.mineStack.serializeNBT());
    }

    public void explode() {
        if (!this.armed) {
            return;
        }
        if (!this.field_145850_b.field_72995_K && this.mineStack.func_77973_b() instanceof IBullet) {
            EntityBullet bullet = BulletHelper.createBullet(this.field_145850_b, this.mineStack, new Vec3d((Vec3i)this.field_174879_c).func_72441_c(0.5, 0.5, 0.5), new Vec3d(0.0, 0.0, 0.0), 1.0f);
            bullet.fuse = 1;
            this.field_145850_b.func_72838_d((Entity)bullet);
        }
        this.field_145850_b.func_175698_g(this.func_174877_v());
    }

    public List<AxisAlignedBB> getAdvancedColisionBounds() {
        return AABB;
    }

    public float[] getBlockBounds() {
        return new float[]{0.125f, -0.0625f * (float)this.digLevel, 0.125f, 0.875f, 0.1875f - 0.0625f * (float)this.digLevel, 0.875f};
    }

    public boolean interact(EnumFacing side, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (this.digLevel < 3 && heldItem.func_77973_b().getToolClasses(heldItem).contains("shovel")) {
            heldItem.func_77972_a(1, (EntityLivingBase)player);
            Material material = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_185904_a();
            if (Arrays.stream(MATCHING_MATERIALS).noneMatch(material1 -> material1 == material)) {
                return true;
            }
            this.digLevel += heldItem.func_77973_b() instanceof ItemIITrenchShovel ? 3 : 1;
            this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187571_bR, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            return true;
        }
        if (this.digLevel == 3 && heldItem.func_77973_b() instanceof ItemBlock && ((ItemBlock)heldItem.func_77973_b()).func_179223_d() == Blocks.field_150329_H) {
            this.grass = true;
            if (!player.func_184812_l_()) {
                heldItem.func_190918_g(1);
            }
            this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187571_bR, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            return true;
        }
        if (this.armed && heldItem.func_77973_b().getToolClasses(heldItem).contains("IE_WIRECUTTER")) {
            heldItem.func_77972_a(8, (EntityLivingBase)player);
            this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187763_eJ, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            this.armed = false;
            this.grass = false;
        }
        return false;
    }

    public void onEntityCollision(World world, Entity entity) {
        super.onEntityCollision(world, entity);
        this.explode();
    }

    public void readOnPlacement(EntityLivingBase placer, ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof IBullet) {
            this.mineStack = stack;
            this.coreColor = ((IBullet)item).getCore(stack).getColour();
        }
    }

    public ItemStack getTileDrop(@Nullable EntityPlayer player, IBlockState state) {
        return this.mineStack;
    }

    public NonNullList<ItemStack> getTileDrops(@Nullable EntityPlayer player, IBlockState state) {
        this.explode();
        return NonNullList.func_193580_a((Object)(this.armed ? ItemStack.field_190927_a : this.mineStack), (Object[])new ItemStack[0]);
    }

    static {
        AABB.add(new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.125, 0.75));
    }
}

