/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.utils.IEntitySpecialRepairable;
import pl.pabilo8.immersiveintelligence.api.utils.MachineUpgrade;
import pl.pabilo8.immersiveintelligence.client.render.metal_device.RepairCrateRenderer;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.IIGuiList;
import pl.pabilo8.immersiveintelligence.common.IIPotions;
import pl.pabilo8.immersiveintelligence.common.IISounds;
import pl.pabilo8.immersiveintelligence.common.blocks.metal.TileEntityEffectCrate;

public class TileEntityRepairCrate
extends TileEntityEffectCrate
implements IEBlockInterfaces.ISoundTile {
    public boolean repaired = false;
    public boolean shouldRepairArmor = true;
    public boolean shouldRepairVehicles = true;

    public TileEntityRepairCrate() {
        this.inventory = NonNullList.func_191197_a((int)16, (Object)ItemStack.field_190927_a);
        this.insertionHandler = new IEInventoryHandler(16, (IIEInventory)this);
    }

    @Override
    boolean isSupplied() {
        return (this.shouldRepairArmor || this.shouldRepairVehicles) && this.inventory.stream().anyMatch(stack -> !stack.func_190926_b());
    }

    @Override
    void useSupplies() {
        for (ItemStack itemStack : this.inventory) {
            if (itemStack.func_190926_b()) continue;
            itemStack.func_190918_g(1);
            break;
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.shouldRepairArmor = nbt.func_74767_n("shouldHeal");
        this.shouldRepairVehicles = nbt.func_74767_n("shouldBoost");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74757_a("shouldHeal", this.shouldRepairArmor);
        nbt.func_74757_a("shouldBoost", this.shouldRepairVehicles);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        ImmersiveEngineering.proxy.handleTileSound(IISounds.welding_mid, (TileEntity)this, this.hasUpgrade(IIContent.UPGRADE_INSERTER) && this.focusedEntity != null, 0.5f, 1.0f);
    }

    @Override
    boolean affectEntity(Entity entity, boolean upgraded) {
        if (!upgraded || Config.IIConfig.Machines.EffectCrates.repairCrateEnergyPerAction <= this.energyStorage) {
            this.repaired = false;
            if (entity instanceof IEntitySpecialRepairable) {
                IEntitySpecialRepairable repairable = (IEntitySpecialRepairable)entity;
                if (repairable.canRepair()) {
                    this.repaired = repairable.repair(2);
                }
            } else if (entity instanceof EntityLivingBase && !((EntityLivingBase)entity).func_70644_a(IIPotions.undergoing_repairs)) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(IIPotions.undergoing_repairs, upgraded ? 200 : 400, upgraded ? 1 : 0, true, true));
                this.repaired = true;
            }
            if (!upgraded && this.repaired) {
                this.energyStorage -= Config.IIConfig.Machines.EffectCrates.repairCrateEnergyPerAction;
            }
            return this.repaired;
        }
        return false;
    }

    @Override
    boolean checkEntity(Entity entity) {
        return entity instanceof IEntitySpecialRepairable || entity instanceof EntityLivingBase;
    }

    public int getGuiID() {
        return IIGuiList.GUI_REPAIR_CRATE.ordinal();
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        return Utils.compareToOreName((ItemStack)stack, (String)"plateSteel");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderWithUpgrades(MachineUpgrade ... upgrades) {
        RepairCrateRenderer.renderWithUpgrade(upgrades);
    }

    public boolean shoudlPlaySound(String sound) {
        return this.focusedEntity != null;
    }

    @Override
    public void onAnimationChangeClient(boolean state, int part) {
        if (part == 1) {
            this.shouldRepairArmor = state;
        } else if (part == 2) {
            this.shouldRepairVehicles = state;
        } else {
            super.onAnimationChangeClient(state, part);
        }
    }

    @Override
    public void onAnimationChangeServer(boolean state, int part) {
        if (part == 1) {
            this.shouldRepairArmor = state;
        } else if (part == 2) {
            this.shouldRepairVehicles = state;
        } else {
            super.onAnimationChangeServer(state, part);
        }
    }

    @Override
    protected NBTTagCompound makeSyncEntity() {
        if (this.hasUpgrade(IIContent.UPGRADE_INSERTER)) {
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), this.focusedEntity != null ? IISounds.welding_start : IISounds.welding_end, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        return super.makeSyncEntity();
    }
}

