/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.api.energy.wires.redstone.IRedstoneConnector;
import blusunrize.immersiveengineering.api.energy.wires.redstone.RedstoneWireNetwork;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import java.util.Objects;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.DataWireNetwork;
import pl.pabilo8.immersiveintelligence.api.data.IDataConnector;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeBoolean;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeInteger;
import pl.pabilo8.immersiveintelligence.common.network.IIPacketHandler;
import pl.pabilo8.immersiveintelligence.common.network.MessageProgrammableSpeakerSync;
import pl.pabilo8.immersiveintelligence.common.wire.IIDataWireType;

public class TileEntityProgrammableSpeaker
extends TileEntityImmersiveConnectable
implements IRedstoneConnector,
IDataConnector,
ITickable,
IEBlockInterfaces.IHammerInteraction,
IEBlockInterfaces.IBlockOverlayText,
IEBlockInterfaces.ISoundTile {
    public int redstoneChannel = 0;
    public boolean rsDirty = false;
    public boolean active = false;
    public String soundID = "immersiveintelligence:siren";
    public float soundVolume = 1.0f;
    public float tone = 1.0f;
    protected WireType wireData = null;
    protected RedstoneWireNetwork redstoneNetwork = new RedstoneWireNetwork().add((IRedstoneConnector)this);
    protected DataWireNetwork dataNetwork = new DataWireNetwork().add(this);
    EnumFacing facing = EnumFacing.NORTH;
    @SideOnly(value=Side.CLIENT)
    SoundEvent sound;
    private boolean refreshWireNetwork = false;

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            if (this.active) {
                this.updateSound();
            }
            if (!this.soundID.equals("") && this.sound != null) {
                ImmersiveEngineering.proxy.handleTileSound(this.sound, (TileEntity)this, this.active, this.soundVolume * ((float)(Config.IIConfig.Machines.ProgrammableSpeaker.soundRange + 4) / 20.0f), this.tone);
            }
        } else if (this.func_145830_o()) {
            boolean wasActive = this.active;
            boolean bl = this.active = this.getNetwork().getPowerOutput(this.redstoneChannel) > 0;
            if (this.active ^ wasActive) {
                IIPacketHandler.INSTANCE.sendToDimension((IMessage)new MessageProgrammableSpeakerSync(this.active, this.func_174877_v(), this.tone, this.soundVolume, this.soundID), this.field_145850_b.field_73011_w.getDimension());
            }
        }
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K && !this.refreshWireNetwork) {
            this.refreshWireNetwork = true;
            this.redstoneNetwork.removeFromNetwork(null);
            this.dataNetwork.removeFromNetwork(null);
        }
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K && this.rsDirty) {
            this.redstoneNetwork.updateValues();
        }
    }

    public RedstoneWireNetwork getNetwork() {
        return this.redstoneNetwork;
    }

    public void setNetwork(RedstoneWireNetwork net) {
        this.redstoneNetwork = net;
    }

    public void onChange() {
        this.soundVolume = (float)this.getNetwork().channelValues[this.redstoneChannel] / 15.0f;
    }

    @Override
    public DataWireNetwork getDataNetwork() {
        return this.dataNetwork;
    }

    @Override
    public void setDataNetwork(DataWireNetwork net) {
        this.dataNetwork = net;
    }

    @Override
    public void onDataChange() {
    }

    @Override
    public World getConnectorWorld() {
        return this.func_145831_w();
    }

    @Override
    public void onPacketReceive(DataPacket packet) {
        boolean once;
        boolean bl = once = packet.getPacketVariable(Character.valueOf('o')) instanceof DataTypeBoolean && ((DataTypeBoolean)packet.getPacketVariable((Character)Character.valueOf((char)'o'))).value;
        if (packet.getPacketVariable(Character.valueOf('t')) instanceof DataTypeInteger) {
            this.tone = MathHelper.func_76131_a((float)((float)((DataTypeInteger)packet.getPacketVariable((Character)Character.valueOf((char)'t'))).value / 100.0f), (float)-2.0f, (float)2.0f);
        }
        if (packet.getPacketVariable(Character.valueOf('v')) instanceof DataTypeInteger) {
            this.soundVolume = MathHelper.func_76131_a((float)((float)((DataTypeInteger)packet.getPacketVariable((Character)Character.valueOf((char)'v'))).value / 100.0f), (float)0.0f, (float)1.0f);
        }
        if (packet.variables.containsKey(Character.valueOf('s'))) {
            if (once) {
                SoundEvent s = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(packet.getPacketVariable(Character.valueOf('s')).valueToString()));
                if (s != null) {
                    this.field_145850_b.func_184133_a(null, this.func_174877_v(), s, SoundCategory.BLOCKS, (float)(Config.IIConfig.Machines.ProgrammableSpeaker.soundRange + 4) / 20.0f, this.tone);
                }
            } else {
                this.soundID = packet.getPacketVariable(Character.valueOf('s')).valueToString();
                IIPacketHandler.INSTANCE.sendToDimension((IMessage)new MessageProgrammableSpeakerSync(this.active, this.func_174877_v(), this.tone, this.soundVolume, this.soundID), this.field_145850_b.field_73011_w.getDimension());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateSound() {
        this.sound = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(this.soundID));
    }

    @Override
    public void sendPacket(DataPacket packet) {
    }

    public void updateInput(byte[] signals) {
        this.rsDirty = false;
    }

    public boolean hammerUseSide(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            this.redstoneChannel = (this.redstoneChannel + 1) % 16;
        }
        this.func_70296_d();
        this.redstoneNetwork.updateValues();
        this.onChange();
        this.markContainingBlockForUpdate(null);
        this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 254, 0);
        return true;
    }

    public boolean canConnectCable(WireType cableType, TargetingInfo target, Vec3i offset) {
        String category = cableType.getCategory();
        return Objects.equals(category, WireType.REDSTONE.getCategory()) && this.limitType == null || Objects.equals(category, IIDataWireType.DATA.getCategory()) && this.wireData == null;
    }

    public void connectCable(WireType cableType, TargetingInfo target, IImmersiveConnectable other) {
        if (Objects.equals(cableType.getCategory(), WireType.REDSTONE.getCategory()) && this.limitType == null) {
            RedstoneWireNetwork.updateConnectors((BlockPos)this.field_174879_c, (World)this.field_145850_b, (RedstoneWireNetwork)this.redstoneNetwork);
            this.limitType = cableType;
        } else if (Objects.equals(cableType.getCategory(), IIDataWireType.DATA.getCategory()) && this.wireData == null) {
            DataWireNetwork.updateConnectors(this.field_174879_c, this.field_145850_b, this.dataNetwork);
            this.wireData = cableType;
        }
        this.markContainingBlockForUpdate(null);
    }

    public void removeCable(ImmersiveNetHandler.Connection connection) {
        WireType type;
        WireType wireType = type = connection != null ? connection.cableType : null;
        if (type == null) {
            this.limitType = null;
            this.wireData = null;
        }
        if (type == this.limitType) {
            this.redstoneNetwork.removeFromNetwork((IRedstoneConnector)this);
            this.limitType = null;
        }
        if (type == this.wireData) {
            this.dataNetwork.removeFromNetwork(this);
            this.wireData = null;
        }
        this.markContainingBlockForUpdate(null);
    }

    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con, TargetingInfo target, Vec3i offsetLink) {
        return this.getConnectionOffset(con, Objects.equals(con.cableType.getCategory(), "DATA"));
    }

    private Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con, boolean data) {
        if (data) {
            return new Vec3d(0.5, (double)0.325f, 0.5);
        }
        return new Vec3d(0.5, (double)0.2f, 0.5);
    }

    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74757_a("active", this.active);
        nbt.func_74778_a("sound", this.soundID);
        nbt.func_74776_a("volume", this.soundVolume);
        nbt.func_74768_a("facing", this.facing.ordinal());
        nbt.func_74768_a("redstoneChannel", this.redstoneChannel);
        nbt.func_74776_a("tone", this.tone);
    }

    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.active = nbt.func_74767_n("active");
        this.soundID = nbt.func_74779_i("sound");
        this.soundVolume = nbt.func_74760_g("volume");
        this.facing = EnumFacing.func_82600_a((int)nbt.func_74762_e("facing"));
        this.redstoneChannel = nbt.func_74762_e("redstoneChannel");
        this.tone = nbt.func_74760_g("tone");
    }

    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con) {
        return new Vec3d(0.5, (double)0.2f, 0.5);
    }

    public void onConnectivityUpdate(BlockPos pos, int dimension) {
        this.refreshWireNetwork = false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        int inc = this.getRenderRadiusIncrease();
        return new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - inc), (double)(this.field_174879_c.func_177956_o() - inc), (double)(this.field_174879_c.func_177952_p() - inc), (double)(this.field_174879_c.func_177958_n() + inc + 1), (double)(this.field_174879_c.func_177956_o() + inc + 1), (double)(this.field_174879_c.func_177952_p() + inc + 1));
    }

    int getRenderRadiusIncrease() {
        return Math.max(WireType.REDSTONE.getMaxLength(), IIDataWireType.DATA.getMaxLength());
    }

    public boolean moveConnectionTo(ImmersiveNetHandler.Connection c, BlockPos newEnd) {
        return true;
    }

    public String[] getOverlayText(EntityPlayer player, RayTraceResult mop, boolean hammer) {
        if (!hammer) {
            return null;
        }
        return new String[]{I18n.func_135052_a((String)"desc.immersiveengineering.info.redstoneChannel", (Object[])new Object[]{I18n.func_135052_a((String)("item.fireworksCharge." + EnumDyeColor.func_176764_b((int)this.redstoneChannel).func_176762_d()), (Object[])new Object[0])})};
    }

    public boolean useNixieFont(EntityPlayer player, RayTraceResult mop) {
        return false;
    }

    public boolean shoudlPlaySound(String sound) {
        return this.active;
    }
}

