/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.blocks.wooden.BlockIIRubberLog;

public class TileEntityLatexCollector
extends TileEntityIEBase
implements IEBlockInterfaces.IPlayerInteraction,
ITickable,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IDirectionalTile {
    public EnumFacing facing = EnumFacing.NORTH;
    public ItemStack bucket = ItemStack.field_190927_a;
    public float timer = 0.0f;
    public int bucketTime = 10;

    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.facing = EnumFacing.func_82600_a((int)nbt.func_74762_e("facing"));
        this.bucket = new ItemStack(nbt.func_74775_l("bucket"));
        if (nbt.func_74764_b("noSetup")) {
            this.bucketTime = 0;
        }
        nbt.func_74776_a("timer", this.timer);
    }

    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.func_74768_a("facing", this.facing.ordinal());
        nbt.func_74782_a("bucket", (NBTBase)this.bucket.serializeNBT());
        if (this.bucketTime < 10) {
            nbt.func_74757_a("noSetup", true);
        }
        this.timer = nbt.func_74760_g("timer");
    }

    public boolean interact(EnumFacing side, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (this.bucket.func_190926_b() && heldItem.func_77973_b() == Items.field_151133_ar) {
            this.bucket = heldItem.func_77946_l();
            this.bucket.func_190920_e(1);
            heldItem.func_190918_g(1);
            this.updateBucket();
            this.timer = 0.0f;
            return true;
        }
        if (!this.bucket.func_190926_b() && heldItem.func_190926_b()) {
            player.field_71071_by.func_70441_a(this.bucket.func_77946_l());
            this.bucket = ItemStack.field_190927_a;
            this.updateBucket();
            this.timer = 0.0f;
            return true;
        }
        return heldItem.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
    }

    private void updateBucket() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("bucket", (NBTBase)this.bucket.serializeNBT());
        ImmersiveEngineering.packetHandler.sendToAllAround((IMessage)new MessageTileSync((TileEntityIEBase)this, nbt), Utils.targetPointFromTile((TileEntity)this, 32));
    }

    public void receiveMessageFromServer(NBTTagCompound message) {
        super.receiveMessageFromServer(message);
        if (message.func_74764_b("bucket")) {
            this.bucket = new ItemStack(message.func_74775_l("bucket"));
            this.bucketTime = 10;
        }
    }

    public void func_73660_a() {
        if (this.bucketTime > 0) {
            --this.bucketTime;
        }
        if (!this.bucket.func_190926_b() && this.bucket.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            IFluidHandlerItem capability = (IFluidHandlerItem)this.bucket.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            if (capability == null) {
                return;
            }
            if (capability.fill(new FluidStack(IIContent.fluidLatex, 1000), false) == 1000 && this.timer < (float)Config.IIConfig.Machines.LatexCollector.collectTime && this.isNextToTree()) {
                this.timer = Math.min(this.timer + this.getIncomeModifier(), (float)Config.IIConfig.Machines.LatexCollector.collectTime);
            } else if (this.timer == (float)Config.IIConfig.Machines.LatexCollector.collectTime && capability.fill(new FluidStack(IIContent.fluidLatex, 1000), true) == 1000) {
                this.timer = 0.0f;
                if (!this.field_145850_b.field_72995_K) {
                    this.bucket = capability.getContainer();
                    this.updateBucket();
                }
            }
        }
    }

    public boolean isNextToTree() {
        IBlockState log = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(this.facing).func_177984_a());
        return log.func_177230_c() instanceof BlockIIRubberLog && log.func_177229_b((IProperty)IIContent.blockRubberLog.property) == BlockIIRubberLog.IIBlockTypesRubberLog.STRIPPED;
    }

    public float getIncomeModifier() {
        int def = 4;
        if (this.field_145850_b.func_175625_s(this.field_174879_c.func_177967_a(this.facing, 2)) instanceof TileEntityLatexCollector) {
            --def;
        }
        if (this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.facing).func_177972_a(this.facing.func_176746_e())) instanceof TileEntityLatexCollector) {
            --def;
        }
        if (this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.facing).func_177972_a(this.facing.func_176735_f())) instanceof TileEntityLatexCollector) {
            --def;
        }
        return (float)def / 4.0f;
    }

    public float[] getBlockBounds() {
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.875f, 1.0f};
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    public int getFacingLimitation() {
        return 2;
    }

    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return false;
    }

    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return false;
    }

    public boolean canRotate(EnumFacing axis) {
        return false;
    }
}

