/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.ILootContainer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.utils.IBooleanAnimatedPartsBlock;
import pl.pabilo8.immersiveintelligence.api.utils.MachineUpgrade;
import pl.pabilo8.immersiveintelligence.api.utils.vehicles.IUpgradableMachine;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.network.IIPacketHandler;
import pl.pabilo8.immersiveintelligence.common.network.MessageBooleanAnimatedPartsSync;

public abstract class TileEntityEffectCrate
extends TileEntityImmersiveConnectable
implements IEBlockInterfaces.IDirectionalTile,
IBooleanAnimatedPartsBlock,
ITickable,
IUpgradableMachine,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IBlockBounds,
IIEInventory,
IEBlockInterfaces.IGuiTile,
IEBlockInterfaces.ITileDrop,
IEBlockInterfaces.IComparatorOverride,
ILootContainer {
    public ResourceLocation lootTable;
    public EnumFacing facing = EnumFacing.NORTH;
    public String name;
    public boolean open = false;
    public float lidAngle = 0.0f;
    protected ArrayList<MachineUpgrade> upgrades = new ArrayList();
    MachineUpgrade currentlyInstalled = null;
    int upgradeProgress = 0;
    public int clientUpgradeProgress = 0;
    public int energyStorage = 0;
    float inserterAnimation = 0.0f;
    float inserterHeight = 0.0f;
    float inserterAngle = 0.0f;
    Entity focusedEntity = null;
    @Nonnull
    NonNullList<ItemStack> inventory;
    @Nonnull
    public IItemHandler insertionHandler;

    public EnumFacing getFacing() {
        return this.facing;
    }

    public void setFacing(EnumFacing facing) {
        this.facing = facing;
        if (facing.func_176740_k().func_176720_b()) {
            this.facing = EnumFacing.NORTH;
        }
    }

    public int getFacingLimitation() {
        return 2;
    }

    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return false;
    }

    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return !entity.func_70093_af();
    }

    public boolean canRotate(EnumFacing axis) {
        return !axis.func_176740_k().func_176720_b();
    }

    @Nullable
    public ITextComponent func_145748_c_() {
        return this.name != null ? new TextComponentString(this.name) : new TextComponentTranslation("tile.immersiveintelligence.metal_device.metal_crate.name", new Object[0]);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public void doGraphicalUpdates(int slot) {
        this.func_70296_d();
    }

    public ItemStack getTileDrop(EntityPlayer player, IBlockState state) {
        ItemStack stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("inventory", (NBTBase)blusunrize.immersiveengineering.common.util.Utils.writeInventory(this.inventory));
        if (!tag.func_82582_d()) {
            stack.func_77982_d(tag);
        }
        if (this.name != null) {
            stack.func_151001_c(this.name);
        }
        return stack;
    }

    public void readOnPlacement(EntityLivingBase placer, ItemStack stack) {
        if (stack.func_77942_o()) {
            this.readCustomNBT(stack.func_77978_p(), false);
            if (stack.func_82837_s()) {
                this.name = stack.func_82833_r();
            }
        }
    }

    public boolean preventInventoryDrop() {
        return true;
    }

    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        if (nbt.func_74764_b("name")) {
            this.name = nbt.func_74779_i("name");
        }
        if (nbt.func_74764_b("open")) {
            this.open = nbt.func_74767_n("open");
        }
        if (nbt.func_74764_b("facing")) {
            this.setFacing(EnumFacing.func_82600_a((int)nbt.func_74762_e("facing")));
        }
        this.getUpgradesFromNBT(nbt);
        this.energyStorage = nbt.func_74762_e("energyStorage");
        if (!descPacket) {
            if (nbt.func_150297_b("lootTable", 8)) {
                this.lootTable = new ResourceLocation(nbt.func_74779_i("lootTable"));
            } else {
                this.inventory = blusunrize.immersiveengineering.common.util.Utils.readInventory((NBTTagList)nbt.func_150295_c("inventory", 10), (int)this.inventory.size());
            }
        }
    }

    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        if (this.name != null) {
            nbt.func_74778_a("name", this.name);
        }
        nbt.func_74757_a("open", this.open);
        nbt.func_74768_a("facing", this.facing.func_176745_a());
        this.saveUpgradesToNBT(nbt);
        nbt.func_74768_a("energyStorage", this.energyStorage);
        if (!descPacket) {
            if (this.lootTable != null) {
                nbt.func_74778_a("lootTable", this.lootTable.toString());
            } else {
                nbt.func_74782_a("inventory", (NBTBase)blusunrize.immersiveengineering.common.util.Utils.writeInventory(this.inventory));
            }
        }
    }

    @Override
    public void onAnimationChangeClient(boolean state, int part) {
        this.open = state;
    }

    @Override
    public void onAnimationChangeServer(boolean state, int part) {
        this.open = state;
    }

    public void receiveMessageFromServer(NBTTagCompound message) {
        this.focusedEntity = message.func_74764_b("focused") ? this.field_145850_b.func_73045_a(message.func_74762_e("focused")) : null;
    }

    public void func_73660_a() {
        this.updateLid();
        if (!this.open && this.focusedEntity != null) {
            this.focusedEntity = null;
            ImmersiveEngineering.packetHandler.sendToAllAround((IMessage)new MessageTileSync((TileEntityIEBase)this, this.makeSyncEntity()), Utils.targetPointFromTile((TileEntity)this, 16));
        }
        if (this.field_145850_b.field_72995_K) {
            if (this.energyStorage > 0 && this.hasUpgrade(IIContent.UPGRADE_INSERTER)) {
                this.inserterAnimation = this.calculateInserterAnimation(0.0f);
                this.inserterHeight = this.calculateInserterHeight(0.0f);
                this.inserterAngle = this.calculateInserterAngle(0.0f);
            } else if ((float)this.clientUpgradeProgress < this.getMaxClientProgress()) {
                this.clientUpgradeProgress = (int)Math.min((float)this.clientUpgradeProgress + (float)Config.IIConfig.Tools.wrench_upgrade_progress / 2.0f, this.getMaxClientProgress());
            }
        } else if (this.energyStorage > Config.IIConfig.Machines.EffectCrates.energyDrain && this.open && this.hasUpgrade(IIContent.UPGRADE_INSERTER) && this.isSupplied() && this.field_145850_b.func_82737_E() % (long)this.getEffectTime() == 0L) {
            List entitiesWithinAABB = this.field_145850_b.func_72872_a(Entity.class, new AxisAlignedBB(this.func_174877_v()).func_72317_d(0.5, 0.5, 0.5).func_186662_g((double)this.getRange()));
            entitiesWithinAABB.removeIf(entity -> !this.checkEntity((Entity)entity));
            if (entitiesWithinAABB.size() > 0) {
                if (this.affectEntityUpgraded((Entity)entitiesWithinAABB.get(0))) {
                    this.useSupplies();
                }
                if (!entitiesWithinAABB.contains(this.focusedEntity)) {
                    this.focusedEntity = (Entity)entitiesWithinAABB.get(0);
                    this.inserterAnimation = 0.0f;
                    this.inserterHeight = 0.0f;
                    ImmersiveEngineering.packetHandler.sendToAllAround((IMessage)new MessageTileSync((TileEntityIEBase)this, this.makeSyncEntity()), Utils.targetPointFromTile((TileEntity)this, 16));
                }
            } else if (this.focusedEntity != null) {
                this.focusedEntity = null;
                this.inserterAnimation = 0.0f;
                this.inserterHeight = 0.0f;
                ImmersiveEngineering.packetHandler.sendToAllAround((IMessage)new MessageTileSync((TileEntityIEBase)this, this.makeSyncEntity()), Utils.targetPointFromTile((TileEntity)this, 16));
            }
        }
    }

    public float calculateInserterAnimation(float partialTicks) {
        if (this.focusedEntity != null) {
            return Math.min(this.inserterAnimation + 0.05f * (1.0f + partialTicks), 1.0f);
        }
        return Math.max(this.inserterAnimation - 0.025f * (1.0f + partialTicks), 0.0f);
    }

    public float calculateInserterHeight(float partialTicks) {
        if (this.focusedEntity != null) {
            return MathHelper.func_76131_a((float)((float)((double)((float)this.field_174879_c.func_177956_o() + 1.35f) - this.focusedEntity.field_70163_u - (double)partialTicks * this.focusedEntity.field_70181_x)), (float)-1.0f, (float)1.0f);
        }
        return Math.signum(this.inserterHeight) * Math.abs(this.inserterHeight - 0.1f * (1.0f + partialTicks));
    }

    public float calculateInserterAngle(float partialTicks) {
        if (this.focusedEntity != null) {
            Vec3d vec3d = Utils.getEntityCenter(this.focusedEntity).func_178787_e(new Vec3d(this.focusedEntity.field_70159_w, 0.0, this.focusedEntity.field_70179_y).func_186678_a((double)partialTicks)).func_178788_d(new Vec3d((Vec3i)this.field_174879_c));
            float yaw = vec3d.field_72450_a < 0.0 && vec3d.field_72449_c >= 0.0 ? (float)(Math.atan(Math.abs(vec3d.field_72450_a / vec3d.field_72449_c)) / Math.PI * 180.0) : (vec3d.field_72450_a <= 0.0 && vec3d.field_72449_c <= 0.0 ? (float)(Math.atan(Math.abs(vec3d.field_72449_c / vec3d.field_72450_a)) / Math.PI * 180.0) + 90.0f : (vec3d.field_72450_a >= 0.0 && vec3d.field_72449_c < 0.0 ? (float)(Math.atan(Math.abs(vec3d.field_72450_a / vec3d.field_72449_c)) / Math.PI * 180.0) + 180.0f : (float)(Math.atan(Math.abs(vec3d.field_72449_c / vec3d.field_72450_a)) / Math.PI * 180.0) + 270.0f));
            return yaw;
        }
        return this.inserterAngle;
    }

    protected NBTTagCompound makeSyncEntity() {
        NBTTagCompound tag = new NBTTagCompound();
        if (this.focusedEntity != null) {
            tag.func_74768_a("focused", this.focusedEntity.func_145782_y());
        } else {
            tag.func_74757_a("hasNoFocus", true);
        }
        return tag;
    }

    public boolean interact(EnumFacing side, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            this.open = !this.open;
            IIPacketHandler.INSTANCE.sendToDimension((IMessage)new MessageBooleanAnimatedPartsSync(this.open, 0, this.field_174879_c), this.field_145850_b.field_73011_w.getDimension());
            return true;
        }
        if (this.open && this.isSupplied()) {
            this.affectEntityBasic((Entity)player);
            this.useSupplies();
            return true;
        }
        return false;
    }

    @Override
    public boolean addUpgrade(MachineUpgrade upgrade, boolean test) {
        boolean b;
        boolean bl = b = !this.hasUpgrade(upgrade) && upgrade.equals(IIContent.UPGRADE_INSERTER);
        if (!test && b) {
            this.upgrades.add(upgrade);
        }
        return b;
    }

    @Override
    public boolean hasUpgrade(MachineUpgrade upgrade) {
        return this.upgrades.stream().anyMatch(machineUpgrade -> machineUpgrade.getName().equals(upgrade.getName()));
    }

    @Override
    public boolean upgradeMatches(MachineUpgrade upgrade) {
        return upgrade == IIContent.UPGRADE_INSERTER;
    }

    @Override
    public <T extends TileEntity> T getUpgradeMaster() {
        return (T)this;
    }

    @Override
    public void saveUpgradesToNBT(NBTTagCompound tag) {
        for (MachineUpgrade upgrade : this.upgrades) {
            tag.func_74757_a(upgrade.getName(), true);
        }
    }

    @Override
    public void getUpgradesFromNBT(NBTTagCompound tag) {
        this.upgrades.clear();
        this.upgrades.addAll(MachineUpgrade.getUpgradesFromNBT(tag));
    }

    public ArrayList<MachineUpgrade> getUpgrades() {
        return this.upgrades;
    }

    @Override
    @Nullable
    public MachineUpgrade getCurrentlyInstalled() {
        return this.currentlyInstalled;
    }

    @Override
    public int getInstallProgress() {
        return this.upgradeProgress;
    }

    @Override
    public int getClientInstallProgress() {
        return this.clientUpgradeProgress;
    }

    @Override
    public boolean addUpgradeInstallProgress(int toAdd) {
        this.upgradeProgress += toAdd;
        return true;
    }

    @Override
    public boolean resetInstallProgress() {
        this.currentlyInstalled = null;
        if (this.upgradeProgress > 0) {
            this.upgradeProgress = 0;
            this.clientUpgradeProgress = 0;
            return true;
        }
        return false;
    }

    @Override
    public void startUpgrade(@Nonnull MachineUpgrade upgrade) {
        this.currentlyInstalled = upgrade;
        this.upgradeProgress = 0;
        this.clientUpgradeProgress = 0;
    }

    @Override
    public void removeUpgrade(MachineUpgrade upgrade) {
        this.upgrades.remove(upgrade);
    }

    protected boolean canTakeLV() {
        return true;
    }

    protected boolean canTakeMV() {
        return true;
    }

    public boolean isEnergyOutput() {
        return true;
    }

    public boolean canConnectCable(WireType cableType, TargetingInfo target, Vec3i offset) {
        return this.hasUpgrade(IIContent.UPGRADE_INSERTER) && super.canConnectCable(cableType, target, offset);
    }

    public int outputEnergy(int amount, boolean simulate, int energyType) {
        if (amount > 0 && this.energyStorage < Config.IIConfig.Machines.EffectCrates.maxEnergyStored) {
            if (!simulate) {
                int rec = Math.min(Config.IIConfig.Machines.EffectCrates.maxEnergyStored - this.energyStorage, Config.IIConfig.Machines.EffectCrates.energyDrain);
                this.energyStorage += rec;
                return rec;
            }
            return Math.min(Config.IIConfig.Machines.EffectCrates.maxEnergyStored - this.energyStorage, Config.IIConfig.Machines.EffectCrates.energyDrain);
        }
        return 0;
    }

    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con) {
        return new Vec3d(0.5, 0.9375, 0.5);
    }

    private void updateLid() {
        if (this.open && this.lidAngle < 1.5f) {
            this.lidAngle = Math.min(this.lidAngle + 0.2f, 1.5f);
        } else if (!this.open && this.lidAngle > 0.0f) {
            this.lidAngle = Math.max(this.lidAngle - 0.3f, 0.0f);
        }
    }

    abstract boolean isSupplied();

    abstract void useSupplies();

    int getEffectTime() {
        return 20;
    }

    int getRange() {
        return 3;
    }

    private boolean affectEntityUpgraded(Entity entity) {
        return this.affectEntity(entity, true);
    }

    private boolean affectEntityBasic(Entity entity) {
        return this.affectEntity(entity, false);
    }

    abstract boolean affectEntity(Entity var1, boolean var2);

    abstract boolean checkEntity(Entity var1);

    @Nonnull
    public float[] getBlockBounds() {
        if (this.hasUpgrade(IIContent.UPGRADE_INSERTER)) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.8125f, 1.0f};
        }
        if (this.facing == EnumFacing.NORTH || this.facing == EnumFacing.SOUTH) {
            return new float[]{0.0f, 0.0f, 0.25f, 1.0f, 0.58f, 0.75f};
        }
        return new float[]{0.25f, 0.0f, 0.0f, 0.75f, 0.58f, 1.0f};
    }

    public int getComparatorInputOverride() {
        return blusunrize.immersiveengineering.common.util.Utils.calcRedstoneFromInventory((IIEInventory)this);
    }

    public boolean canOpenGui() {
        return !this.open;
    }

    public TileEntity getGuiMaster() {
        return this;
    }

    public void onGuiOpened(@Nullable EntityPlayer player, boolean clientside) {
        if (this.lootTable != null && !clientside) {
            LootTable loottable = this.field_145850_b.func_184146_ak().func_186521_a(this.lootTable);
            this.lootTable = null;
            LootContext.Builder contextBuilder = new LootContext.Builder((WorldServer)this.field_145850_b);
            if (player != null) {
                contextBuilder.func_186469_a(player.func_184817_da());
            }
            LootContext context = contextBuilder.func_186471_a();
            Random rand = new Random();
            List list = loottable.func_186462_a(rand, context);
            ArrayList listSlots = Lists.newArrayList();
            for (int i = 0; i < this.inventory.size(); ++i) {
                if (!((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
                listSlots.add(i);
            }
            Collections.shuffle(listSlots, rand);
            if (listSlots.isEmpty()) {
                return;
            }
            blusunrize.immersiveengineering.common.util.Utils.shuffleLootItems((List)list, (int)listSlots.size(), (Random)rand);
            for (ItemStack itemstack : list) {
                int slot = (Integer)listSlots.remove(listSlots.size() - 1);
                this.inventory.set(slot, (Object)itemstack);
            }
            this.func_70296_d();
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.insertionHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public ResourceLocation func_184276_b() {
        return this.lootTable;
    }
}

