/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.blocks.metal;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import java.util.Set;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.common.wire.IIDataWireType;

public class TileEntityDataRelay
extends TileEntityImmersiveConnectable
implements ITickable,
IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.IBlockBounds {
    public EnumFacing facing = EnumFacing.DOWN;
    boolean firstTick = true;
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K && this.firstTick) {
            Set conns = ImmersiveNetHandler.INSTANCE.getConnections(this.field_145850_b, this.field_174879_c);
            if (conns != null) {
                for (ImmersiveNetHandler.Connection conn : conns) {
                    if (this.field_174879_c.compareTo((Vec3i)conn.end) >= 0 || !this.field_145850_b.func_175667_e(conn.end)) continue;
                    this.markContainingBlockForUpdate(null);
                }
            }
            this.firstTick = false;
        }
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    public int getFacingLimitation() {
        return 0;
    }

    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return true;
    }

    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return false;
    }

    public boolean canConnectCable(WireType cableType, TargetingInfo target, Vec3i offset) {
        if (cableType != IIDataWireType.DATA) {
            return false;
        }
        return this.limitType == null || this.limitType == cableType;
    }

    public boolean canRotate(EnumFacing axis) {
        return false;
    }

    public boolean isEnergyOutput() {
        return false;
    }

    public int outputEnergy(int amount, boolean simulate, int energyType) {
        return 0;
    }

    protected float getBaseDamage(ImmersiveNetHandler.Connection c) {
        return 240.0f / (float)c.cableType.getTransferRate();
    }

    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("facing", this.facing.ordinal());
    }

    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (nbt.func_74764_b("facing")) {
            this.facing = EnumFacing.func_82600_a((int)nbt.func_74762_e("facing"));
        }
    }

    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con) {
        EnumFacing side = this.facing.func_176734_d();
        double conRadius = con.cableType.getRenderDiameter() / 2.0;
        return new Vec3d(0.5 + (double)side.func_82601_c() * (0.5 - conRadius), 0.5 + (double)side.func_96559_d() * (0.5 - conRadius), 0.5 + (double)side.func_82599_e() * (0.5 - conRadius));
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        int inc = this.getRenderRadiusIncrease();
        return new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - inc), (double)(this.field_174879_c.func_177956_o() - inc), (double)(this.field_174879_c.func_177952_p() - inc), (double)(this.field_174879_c.func_177958_n() + inc + 1), (double)(this.field_174879_c.func_177956_o() + inc + 1), (double)(this.field_174879_c.func_177952_p() + inc + 1));
    }

    int getRenderRadiusIncrease() {
        return IIDataWireType.DATA.getMaxLength();
    }

    public float[] getBlockBounds() {
        float length = 1.0f;
        float wMin = 0.25f;
        float wMax = 0.75f;
        switch (this.facing.func_176734_d()) {
            case UP: {
                return new float[]{wMin, 0.0f, wMin, wMax, length, wMax};
            }
            case DOWN: {
                return new float[]{wMin, 1.0f - length, wMin, wMax, 1.0f, wMax};
            }
            case SOUTH: {
                return new float[]{wMin, wMin, 0.0f, wMax, wMax, length};
            }
            case NORTH: {
                return new float[]{wMin, wMin, 1.0f - length, wMax, wMax, 1.0f};
            }
            case EAST: {
                return new float[]{0.0f, wMin, wMin, length, wMax, wMax};
            }
            case WEST: {
                return new float[]{1.0f - length, wMin, wMin, 1.0f, wMax, wMax};
            }
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }
}

