/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.ammunition_system.emplacement_weapons;

import blusunrize.immersiveengineering.client.ClientUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.StreamSupport;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeInteger;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeString;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;
import pl.pabilo8.immersiveintelligence.api.utils.IInfraredProtectionEquipment;
import pl.pabilo8.immersiveintelligence.client.ShaderUtil;
import pl.pabilo8.immersiveintelligence.client.gui.emplacement.GuiEmplacementPageStorage;
import pl.pabilo8.immersiveintelligence.client.render.multiblock.metal.EmplacementRenderer;
import pl.pabilo8.immersiveintelligence.client.tmt.ModelRendererTurbo;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.blocks.multiblocks.metal.tileentities.second.TileEntityEmplacement;
import pl.pabilo8.immersiveintelligence.common.entity.EntityEmplacementWeapon;

public class EmplacementWeaponInfraredObserver
extends TileEntityEmplacement.EmplacementWeapon {
    private AxisAlignedBB vision;
    int setupDelay = 0;
    boolean requiresPlatformRefill = false;
    private static final Runnable INSERTER_ANIM_LENS = () -> {
        Utils.bindTexture(EmplacementRenderer.textureInfraredObserver);
        GlStateManager.func_179137_b((double)-0.3125, (double)0.4225, (double)1.375);
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        for (ModelRendererTurbo mod : EmplacementRenderer.modelInfraredObserver.lensModel) {
            mod.render();
        }
    };
    private static final Runnable INSERTER_ANIM_NONE = () -> {};

    @Override
    public String getName() {
        return "infrared_observer";
    }

    @Override
    public float getYawTurnSpeed() {
        return Config.IIConfig.Weapons.EmplacementWeapons.InfraredObserver.yawRotateTime;
    }

    @Override
    public float getPitchTurnSpeed() {
        return Config.IIConfig.Weapons.EmplacementWeapons.InfraredObserver.pitchRotateSpeed;
    }

    @Override
    public void aimAt(float yaw, float pitch) {
        this.nextPitch = pitch;
        float p = pitch - this.pitch;
        this.pitch += Math.signum(p) * MathHelper.func_76131_a((float)Math.abs(p), (float)0.0f, (float)this.getPitchTurnSpeed());
        this.pitch %= 180.0f;
    }

    @Override
    public boolean isSetUp(boolean door) {
        return this.setupDelay == (door ? Config.IIConfig.Weapons.EmplacementWeapons.InfraredObserver.setupTime : 0);
    }

    @Override
    public void doSetUp(boolean door) {
        if (door) {
            if (!this.isAimedAt(this.yaw, -90.0f)) {
                this.aimAt(this.yaw, -90.0f);
                return;
            }
            if (this.setupDelay < Config.IIConfig.Weapons.EmplacementWeapons.InfraredObserver.setupTime) {
                ++this.setupDelay;
            }
        } else {
            if (!this.isAimedAt(this.yaw, -90.0f)) {
                this.aimAt(this.yaw, -90.0f);
                return;
            }
            if (this.setupDelay > 0) {
                --this.setupDelay;
            }
        }
    }

    @Override
    public boolean requiresPlatformRefill() {
        return this.requiresPlatformRefill;
    }

    @Override
    public void init(TileEntityEmplacement te, boolean firstTime) {
        super.init(te, firstTime);
        EnumFacing facing = EnumFacing.func_176733_a((double)MathHelper.func_76142_g((float)this.yaw));
        Vec3i vv = facing.func_176730_m();
        Vec3i vv2 = facing.func_176746_e().func_176730_m();
        this.vision = new AxisAlignedBB(te.func_174877_v()).func_72317_d(-0.5, 0.0, -0.5).func_72321_a((double)((float)vv.func_177958_n() * Config.IIConfig.Weapons.EmplacementWeapons.InfraredObserver.detectionRadius), 0.0, (double)((float)vv.func_177952_p() * Config.IIConfig.Weapons.EmplacementWeapons.InfraredObserver.detectionRadius)).func_72314_b((double)((float)vv2.func_177958_n() * Config.IIConfig.Weapons.EmplacementWeapons.InfraredObserver.detectionRadius), (double)Config.IIConfig.Weapons.EmplacementWeapons.InfraredObserver.detectionRadius, (double)((float)vv2.func_177952_p() * Config.IIConfig.Weapons.EmplacementWeapons.InfraredObserver.detectionRadius));
        if (firstTime) {
            te.sendAttackSignal = true;
        }
    }

    @Override
    public void tick(TileEntityEmplacement te, boolean active) {
    }

    @Override
    public NBTTagCompound saveToNBT(boolean forClient) {
        NBTTagCompound tag = super.saveToNBT(forClient);
        tag.func_74768_a("setupDelay", this.setupDelay);
        tag.func_74757_a("requiresPlatformRefill", this.requiresPlatformRefill);
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.setupDelay = tagCompound.func_74762_e("setupDelay");
        this.requiresPlatformRefill = tagCompound.func_74767_n("requiresPlatformRefill");
    }

    @Override
    public boolean canShoot(TileEntityEmplacement te) {
        return te.isDoorOpened;
    }

    @Override
    public void handleDataPacket(DataPacket packet) {
        super.handleDataPacket(packet);
        String c = packet.getPacketVariable(Character.valueOf('c')).valueToString();
        if (c.equals("facing")) {
            EnumFacing facing;
            IDataType f = packet.getPacketVariable(Character.valueOf('f'));
            if (f instanceof DataTypeInteger) {
                this.nextYaw = EnumFacing.func_176731_b((int)((DataTypeInteger)f).value).func_185119_l();
            } else if (f instanceof DataTypeString && (facing = EnumFacing.func_176739_a((String)f.valueToString())) != null) {
                this.nextYaw = facing.func_185119_l();
            }
            if (this.nextYaw != this.yaw) {
                this.requiresPlatformRefill = true;
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(TileEntityEmplacement te, float partialTicks) {
        GlStateManager.func_179094_E();
        float p = this.nextPitch - this.pitch;
        boolean power = te.energyStorage.getEnergyStored() >= this.getEnergyUpkeepCost();
        float pp = this.pitch + (power ? Math.signum(p) * MathHelper.func_76131_a((float)Math.abs(p), (float)0.0f, (float)1.0f) * partialTicks * this.getPitchTurnSpeed() : 0.0f);
        float yy = this.yaw;
        float setupProgress = MathHelper.func_76131_a((float)((float)this.setupDelay + (this.pitch == -90.0f ? (te.isDoorOpened ? (te.progress == Config.IIConfig.Machines.Emplacement.lidTime ? partialTicks : 0.0f) : -partialTicks) : 0.0f)), (float)0.0f, (float)Config.IIConfig.Weapons.EmplacementWeapons.InfraredObserver.setupTime) / (float)Config.IIConfig.Weapons.EmplacementWeapons.InfraredObserver.setupTime;
        float setupHalf = 1.0f - Math.abs(0.5f - setupProgress) * 2.0f;
        GlStateManager.func_179147_l();
        Utils.bindTexture(EmplacementRenderer.textureInfraredObserver);
        GlStateManager.func_179114_b((float)yy, (float)0.0f, (float)1.0f, (float)0.0f);
        for (ModelRendererTurbo mod : EmplacementRenderer.modelInfraredObserver.baseModel) {
            mod.render();
        }
        GlStateManager.func_179109_b((float)0.0f, (float)1.5f, (float)0.1875f);
        GlStateManager.func_179114_b((float)pp, (float)1.0f, (float)0.0f, (float)0.0f);
        for (ModelRendererTurbo mod : EmplacementRenderer.modelInfraredObserver.observerModel) {
            mod.render();
        }
        for (ModelRendererTurbo mod : EmplacementRenderer.modelInfraredObserver.hatchModel) {
            mod.field_78795_f = (double)setupProgress < 0.1 ? 1.25f - 2.8207963f * (1.0f - setupProgress / 0.1f) : (setupProgress < 0.9f ? 1.25f : (setupProgress < 1.0f ? 1.25f - (setupProgress - 0.9f) / 0.1f * 2.8207963f : -1.5707963f));
            mod.render();
        }
        if (setupProgress > 0.5f) {
            for (ModelRendererTurbo mod : EmplacementRenderer.modelInfraredObserver.lensModel) {
                mod.render();
            }
        }
        float p1 = 95.0f;
        float p2 = 255.0f;
        float prog = 0.75f;
        float h = 0.0f;
        if (setupProgress > 0.1f && setupProgress < 0.9f) {
            if (setupHalf < 0.4f) {
                p1 = (1.0f - (setupHalf - 0.2f) / 0.2f) * 95.0f;
                p2 = p1 + 160.0f;
            } else if (setupHalf < 0.6f) {
                p1 = 0.0f;
                h = (setupHalf - 0.4f) / 0.2f * 0.75f;
                p2 = p1 + 160.0f;
            } else {
                p1 = (setupHalf - 0.6f) / 0.4f * 95.0f;
                h = 0.75f;
                p2 = p1 + 160.0f - (setupHalf - 0.6f) / 0.4f * 85.0f;
            }
            prog = (1.0f - (setupProgress > 0.45f ? (setupProgress < 0.65f ? (setupProgress - 0.45f) / 0.2f : 1.0f) : 0.0f)) * 0.75f;
        }
        GlStateManager.func_179137_b((double)0.3125, (double)-0.625, (double)-0.3751);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)h);
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        EmplacementRenderer.renderInserter(false, 0.0f, p1, p2, prog, (double)setupProgress > 0.5 ? INSERTER_ANIM_NONE : INSERTER_ANIM_LENS);
        GlStateManager.func_179121_F();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderUpgradeProgress(int clientProgress, int serverProgress, float partialTicks) {
        GlStateManager.func_179094_E();
        int req = IIContent.UPGRADE_EMPLACEMENT_WEAPON_IROBSERVER.getProgressRequired();
        int l = EmplacementRenderer.modelInfraredObserverConstruction.length;
        double maxClientProgress = Utils.getMaxClientProgress(serverProgress, req, l);
        double cc = (int)Math.min((double)((float)clientProgress + partialTicks * ((float)Config.IIConfig.Tools.wrench_upgrade_progress / 2.0f)), maxClientProgress);
        double progress = MathHelper.func_151237_a((double)(cc / (double)req), (double)0.0, (double)1.0);
        Utils.bindTexture(EmplacementRenderer.textureInfraredObserver);
        int i = 0;
        while ((double)i < (double)l * progress) {
            if ((long)(1 + i) > Math.round((double)l * progress)) {
                GlStateManager.func_179094_E();
                double scale = 1.0 - progress * (double)l % 1.0;
                GlStateManager.func_179147_l();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)Math.min(scale, 1.0)));
                GlStateManager.func_179137_b((double)0.0, (double)(scale * 1.5), (double)0.0);
                EmplacementRenderer.modelInfraredObserverConstruction[i].func_78785_a(0.0625f);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179121_F();
            } else {
                EmplacementRenderer.modelInfraredObserverConstruction[i].func_78785_a(0.0625f);
            }
            ++i;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179140_f();
        GlStateManager.func_179152_a((float)0.98f, (float)0.98f, (float)0.98f);
        GlStateManager.func_179109_b((float)0.03125f, (float)0.0f, (float)-0.01325f);
        ShaderUtil.blueprint_static(0.35f, (float)ClientUtils.mc().field_71439_g.field_70173_aa + partialTicks);
        i = l - 1;
        while ((double)i >= Math.max((double)l * progress - 1.0, 0.0)) {
            EmplacementRenderer.modelInfraredObserverConstruction[i].func_78785_a(0.0625f);
            --i;
        }
        ShaderUtil.releaseShader();
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    @Override
    public AxisAlignedBB getVisionAABB() {
        return this.vision;
    }

    @Override
    public EntityEmplacementWeapon.EmplacementHitboxEntity[] getCollisionBoxes() {
        if (this.entity == null) {
            return new EntityEmplacementWeapon.EmplacementHitboxEntity[0];
        }
        ArrayList<EntityEmplacementWeapon.EmplacementHitboxEntity> list = new ArrayList<EntityEmplacementWeapon.EmplacementHitboxEntity>();
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "baseBox", 1.0f, 0.25f, new Vec3d(0.0, 0.25, 0.0), Vec3d.field_186680_a, 4));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "backBox", 0.5f, 0.75f, new Vec3d(0.75, 0.75, 0.0), Vec3d.field_186680_a, 4));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "observeBox", 1.25f, 1.25f, new Vec3d(-0.25, 1.5, 0.0), Vec3d.field_186680_a, 4));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "observeBox", 0.5f, 0.5f, new Vec3d(-0.25, 1.5, 0.0), new Vec3d(-1.0, 0.0, -0.25), 4));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "observeBox", 0.25f, 0.25f, new Vec3d(-0.25, 1.5, 0.0), new Vec3d(-1.325, 0.0, -0.25), 4));
        return list.toArray(new EntityEmplacementWeapon.EmplacementHitboxEntity[0]);
    }

    @Override
    public NonNullList<ItemStack> getBaseInventory() {
        return NonNullList.func_191196_a();
    }

    @Override
    public void renderStorageInventory(GuiEmplacementPageStorage gui, int mx, int my, float partialTicks, boolean first) {
    }

    @Override
    public void performPlatformRefill(TileEntityEmplacement te) {
        float y = MathHelper.func_76142_g((float)(360.0f + this.nextYaw - this.yaw));
        this.yaw = Math.abs(y) < this.getYawTurnSpeed() * 0.5f ? this.nextYaw : MathHelper.func_76142_g((float)(this.yaw + Math.signum(y) * MathHelper.func_76131_a((float)Math.abs(y), (float)0.0f, (float)this.getYawTurnSpeed())));
        if (this.yaw == this.nextYaw) {
            this.requiresPlatformRefill = false;
            this.syncWithClient(te);
        }
        EnumFacing facing = EnumFacing.func_176733_a((double)MathHelper.func_76142_g((float)this.yaw)).func_176734_d();
        Vec3i vv = facing.func_176730_m();
        Vec3i vv2 = facing.func_176746_e().func_176730_m();
        this.vision = new AxisAlignedBB(te.func_174877_v()).func_72317_d(-0.5, 0.0, -0.5).func_72321_a((double)((float)vv.func_177958_n() * Config.IIConfig.Weapons.EmplacementWeapons.InfraredObserver.detectionRadius), 0.0, (double)((float)vv.func_177952_p() * Config.IIConfig.Weapons.EmplacementWeapons.InfraredObserver.detectionRadius)).func_72314_b((double)((float)vv2.func_177958_n() * Config.IIConfig.Weapons.EmplacementWeapons.InfraredObserver.detectionRadius), (double)Config.IIConfig.Weapons.EmplacementWeapons.InfraredObserver.detectionRadius, (double)((float)vv2.func_177952_p() * Config.IIConfig.Weapons.EmplacementWeapons.InfraredObserver.detectionRadius));
    }

    @Override
    public int getEnergyUpkeepCost() {
        return Config.IIConfig.Weapons.EmplacementWeapons.InfraredObserver.energyUpkeepCost;
    }

    @Override
    public int getMaxHealth() {
        return Config.IIConfig.Weapons.EmplacementWeapons.InfraredObserver.maxHealth;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected Tuple<ResourceLocation, List<ModelRendererTurbo>> getDebris() {
        return new Tuple((Object)EmplacementRenderer.textureInfraredObserver, Arrays.asList(EmplacementRenderer.modelInfraredObserverConstruction));
    }

    @Override
    public boolean canSeeEntity(Entity entity) {
        return StreamSupport.stream(entity.func_184193_aE().spliterator(), false).noneMatch(stack -> stack.func_77973_b() instanceof IInfraredProtectionEquipment && ((IInfraredProtectionEquipment)stack.func_77973_b()).invisibleToInfrared((ItemStack)stack));
    }
}

