/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.ammunition_system.emplacement_weapons;

import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.entities.EntityChemthrowerShot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.client.ShaderUtil;
import pl.pabilo8.immersiveintelligence.client.gui.emplacement.GuiEmplacementPageStorage;
import pl.pabilo8.immersiveintelligence.client.render.multiblock.metal.EmplacementRenderer;
import pl.pabilo8.immersiveintelligence.client.tmt.ModelRendererTurbo;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.blocks.multiblocks.metal.tileentities.second.TileEntityEmplacement;
import pl.pabilo8.immersiveintelligence.common.entity.EntityEmplacementWeapon;

public class EmplacementWeaponHeavyChemthrower
extends TileEntityEmplacement.EmplacementWeapon {
    private AxisAlignedBB vision;
    int setupDelay = 0;
    float shootDelay = Config.IIConfig.Weapons.EmplacementWeapons.HeavyChemthrower.sprayTime;
    boolean shouldIgnite = false;
    FluidTank tank = new FluidTank(Config.IIConfig.Weapons.EmplacementWeapons.HeavyChemthrower.tankCapacity);
    private Vec3d vv;
    SidedFluidHandler fluidHandler = new SidedFluidHandler(this);

    @Override
    public String getName() {
        return "heavy_chemthrower";
    }

    @Override
    public float getYawTurnSpeed() {
        return Config.IIConfig.Weapons.EmplacementWeapons.HeavyChemthrower.yawRotateSpeed;
    }

    @Override
    public float getPitchTurnSpeed() {
        return Config.IIConfig.Weapons.EmplacementWeapons.HeavyChemthrower.pitchRotateSpeed;
    }

    @Override
    public void aimAt(float yaw, float pitch) {
        super.aimAt(yaw, pitch);
    }

    @Override
    public boolean isSetUp(boolean door) {
        return this.setupDelay == (door ? Config.IIConfig.Weapons.EmplacementWeapons.HeavyChemthrower.setupTime : 0);
    }

    @Override
    public void doSetUp(boolean door) {
        if (door) {
            if (this.setupDelay < Config.IIConfig.Weapons.EmplacementWeapons.HeavyChemthrower.setupTime) {
                ++this.setupDelay;
            }
        } else {
            if (!this.isAimedAt(0.0f, -90.0f)) {
                this.aimAt(0.0f, -90.0f);
                return;
            }
            if (this.setupDelay > 0) {
                --this.setupDelay;
            }
        }
    }

    @Override
    public boolean requiresPlatformRefill() {
        return false;
    }

    @Override
    public float[] getAnglePrediction(Vec3d posTurret, Vec3d posTarget, Vec3d motion) {
        double initialY;
        this.shouldIgnite = true;
        float force = 4.0f;
        this.vv = posTurret.func_178788_d(posTarget.func_178787_e(motion));
        double dist = this.vv.func_72438_d(new Vec3d(0.0, this.vv.field_72448_b, 0.0));
        double gravity = 0.0;
        FluidStack fluid = this.tank.getFluid();
        if (fluid != null) {
            boolean isGas = fluid.getFluid().isGaseous() || ChemthrowerHandler.isGas((Fluid)fluid.getFluid());
            gravity = (isGas ? 0.025f : 0.05f) * (float)(fluid.getFluid().getDensity(fluid) < 0 ? -1 : 1);
        }
        double motionY = initialY = this.vv.func_72432_b().field_72448_b;
        while (dist > 0.0) {
            dist -= (double)force;
            force = (float)((double)force * 0.99);
            motionY *= 0.99;
            motionY -= gravity;
        }
        this.vv = this.vv.func_72441_c(0.0, motionY - initialY, 0.0).func_72432_b();
        float yy = (float)(Math.atan2(this.vv.field_72450_a, this.vv.field_72449_c) * 180.0 / 3.1415927410125732);
        float pp = (float)Math.toDegrees(Math.atan2(this.vv.field_72448_b, this.vv.func_72438_d(new Vec3d(0.0, this.vv.field_72448_b, 0.0))));
        return new float[]{yy, pp};
    }

    @Override
    public void init(TileEntityEmplacement te, boolean firstTime) {
        super.init(te, firstTime);
        this.vision = new AxisAlignedBB(te.func_174877_v()).func_72317_d(-0.5, 0.0, -0.5).func_186662_g((double)Config.IIConfig.Weapons.EmplacementWeapons.HeavyChemthrower.detectionRadius);
    }

    @Override
    public void tick(TileEntityEmplacement te, boolean active) {
        if (this.shootDelay > 0.0f) {
            this.shootDelay -= 1.0f;
        }
    }

    @Override
    public void shoot(TileEntityEmplacement te) {
        super.shoot(te);
        Vec3d gun = te.getWeaponCenter().func_178787_e(this.vv.func_186678_a(-3.0));
        super.shoot(te);
        float range = 4.0f;
        float scatter = 0.025f;
        int split = Math.min(this.tank.getFluidAmount() / 4, 6);
        if (this.tank.getFluid() == null) {
            this.tank.fill(new FluidStack(IEContent.fluidCreosote, 1000), true);
        } else if (!te.func_145831_w().field_72995_K) {
            for (int i = 0; i < split; ++i) {
                Vec3d vecDir = this.vv.func_186678_a(-1.0).func_72432_b().func_186678_a((double)range).func_178787_e(new Vec3d(blusunrize.immersiveengineering.common.util.Utils.RAND.nextGaussian() * (double)scatter, blusunrize.immersiveengineering.common.util.Utils.RAND.nextGaussian() * (double)scatter, blusunrize.immersiveengineering.common.util.Utils.RAND.nextGaussian() * (double)scatter));
                Vec3d g1 = gun.func_178787_e(this.vv.func_178785_b(90.0f).func_186678_a(0.25));
                Vec3d g2 = gun.func_178787_e(this.vv.func_178785_b(-90.0f).func_186678_a(0.25));
                EntityChemthrowerShot chem = new EntityChemthrowerShot(te.func_145831_w(), g1.field_72450_a, g1.field_72448_b, g1.field_72449_c, vecDir.field_72450_a, vecDir.field_72448_b, vecDir.field_72449_c, this.tank.getFluid());
                EntityChemthrowerShot chem2 = new EntityChemthrowerShot(te.func_145831_w(), g2.field_72450_a, g2.field_72448_b, g2.field_72449_c, vecDir.field_72450_a, vecDir.field_72448_b, vecDir.field_72449_c, this.tank.getFluid());
                chem.field_70159_w = vecDir.field_72450_a;
                chem.field_70181_x = vecDir.field_72448_b;
                chem.field_70179_y = vecDir.field_72449_c;
                chem2.field_70159_w = vecDir.field_72450_a;
                chem2.field_70181_x = vecDir.field_72448_b;
                chem2.field_70179_y = vecDir.field_72449_c;
                this.tank.drain(4, true);
                if (this.shouldIgnite) {
                    chem.func_70015_d(10);
                    chem2.func_70015_d(10);
                }
                te.func_145831_w().func_72838_d((Entity)chem);
                te.func_145831_w().func_72838_d((Entity)chem2);
            }
        }
        this.shootDelay = Config.IIConfig.Weapons.EmplacementWeapons.Autocannon.bulletFireTime;
    }

    @Override
    public NBTTagCompound saveToNBT(boolean forClient) {
        NBTTagCompound tag = super.saveToNBT(forClient);
        tag.func_74768_a("setupDelay", this.setupDelay);
        tag.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.setupDelay = tagCompound.func_74762_e("setupDelay");
        this.tank.readFromNBT(tagCompound.func_74775_l("tank"));
    }

    @Override
    public boolean canShoot(TileEntityEmplacement te) {
        return this.vv != null && this.shootDelay <= 0.0f && te.isDoorOpened && this.tank.getFluidAmount() > 0;
    }

    @Override
    @Nullable
    public IFluidHandler getFluidHandler(boolean in) {
        return in ? this.fluidHandler : null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(TileEntityEmplacement te, float partialTicks) {
        GlStateManager.func_179094_E();
        float p = this.nextPitch - this.pitch;
        float y = this.nextYaw - this.yaw;
        boolean power = te.energyStorage.getEnergyStored() >= this.getEnergyUpkeepCost();
        float pp = this.pitch + (power ? Math.signum(p) * MathHelper.func_76131_a((float)Math.abs(p), (float)0.0f, (float)1.0f) * partialTicks * this.getPitchTurnSpeed() : 0.0f);
        float yy = this.yaw + (power ? Math.signum(y) * MathHelper.func_76131_a((float)Math.abs(y), (float)0.0f, (float)1.0f) * partialTicks * this.getYawTurnSpeed() : 0.0f);
        float setupProgress = 1.0f - MathHelper.func_76131_a((float)((float)this.setupDelay + (this.pitch == -90.0f ? (te.isDoorOpened ? (te.progress == Config.IIConfig.Machines.Emplacement.lidTime ? partialTicks : 0.0f) : -partialTicks) : 0.0f)), (float)0.0f, (float)Config.IIConfig.Weapons.EmplacementWeapons.HeavyChemthrower.setupTime) / (float)Config.IIConfig.Weapons.EmplacementWeapons.HeavyChemthrower.setupTime;
        Utils.bindTexture(EmplacementRenderer.textureHeavyChemthrower);
        for (ModelRendererTurbo mod : EmplacementRenderer.modelHeavyChemthrower.baseModel) {
            mod.render();
        }
        GlStateManager.func_179114_b((float)yy, (float)0.0f, (float)1.0f, (float)0.0f);
        for (ModelRendererTurbo mod : EmplacementRenderer.modelHeavyChemthrower.turretModel) {
            mod.render();
        }
        GlStateManager.func_179109_b((float)0.28125f, (float)0.875f, (float)0.25f);
        GlStateManager.func_179114_b((float)pp, (float)1.0f, (float)0.0f, (float)0.0f);
        for (ModelRendererTurbo mod : EmplacementRenderer.modelHeavyChemthrower.barrelStartModel) {
            mod.render();
        }
        for (ModelRendererTurbo mod : EmplacementRenderer.modelHeavyChemthrower.barrelMidModel) {
            mod.field_78795_f = 1.0E-8f;
            mod.hasOffset = true;
            mod.field_82907_q = MathHelper.func_76131_a((float)((setupProgress - 0.5f) / 0.5f), (float)0.0f, (float)1.0f) * -9.0f;
            mod.render();
        }
        GlStateManager.func_179129_p();
        for (ModelRendererTurbo mod : EmplacementRenderer.modelHeavyChemthrower.barrelEndModel) {
            mod.field_78795_f = 1.0E-8f;
            mod.hasOffset = true;
            mod.field_82907_q = Math.min(setupProgress / 0.5f, 1.0f) * -9.0f + MathHelper.func_76131_a((float)((setupProgress - 0.5f) / 0.5f), (float)0.0f, (float)1.0f) * -9.0f;
            mod.render();
        }
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderUpgradeProgress(int clientProgress, int serverProgress, float partialTicks) {
        GlStateManager.func_179094_E();
        int req = IIContent.UPGRADE_EMPLACEMENT_WEAPON_HEAVY_CHEMTHROWER.getProgressRequired();
        int l = EmplacementRenderer.modelHeavyChemthrowerConstruction.length;
        double maxClientProgress = Utils.getMaxClientProgress(serverProgress, req, l);
        double cc = (int)Math.min((double)((float)clientProgress + partialTicks * ((float)Config.IIConfig.Tools.wrench_upgrade_progress / 2.0f)), maxClientProgress);
        double progress = MathHelper.func_151237_a((double)(cc / (double)req), (double)0.0, (double)1.0);
        Utils.bindTexture(EmplacementRenderer.textureHeavyChemthrower);
        int i = 0;
        while ((double)i < (double)l * progress) {
            if ((long)(1 + i) > Math.round((double)l * progress)) {
                GlStateManager.func_179094_E();
                double scale = 1.0 - progress * (double)l % 1.0;
                GlStateManager.func_179147_l();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)Math.min(scale, 1.0)));
                GlStateManager.func_179137_b((double)0.0, (double)(scale * 1.5), (double)0.0);
                EmplacementRenderer.modelHeavyChemthrowerConstruction[i].func_78785_a(0.0625f);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179121_F();
            } else {
                EmplacementRenderer.modelHeavyChemthrowerConstruction[i].func_78785_a(0.0625f);
            }
            ++i;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179140_f();
        GlStateManager.func_179152_a((float)0.98f, (float)0.98f, (float)0.98f);
        GlStateManager.func_179109_b((float)0.03125f, (float)0.0f, (float)-0.01325f);
        ShaderUtil.blueprint_static(0.35f, (float)ClientUtils.mc().field_71439_g.field_70173_aa + partialTicks);
        i = l - 1;
        while ((double)i >= Math.max((double)l * progress - 1.0, 0.0)) {
            EmplacementRenderer.modelHeavyChemthrowerConstruction[i].func_78785_a(0.0625f);
            --i;
        }
        ShaderUtil.releaseShader();
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    @Override
    public AxisAlignedBB getVisionAABB() {
        return this.vision;
    }

    @Override
    public void syncWithEntity(EntityEmplacementWeapon entity) {
        super.syncWithEntity(entity);
        if (entity == this.entity) {
            entity.aabb = new AxisAlignedBB(-3.0, 0.0, -3.0, 3.0, 3.0, 3.0);
            if (this.setupDelay != 0 && this.setupDelay != Config.IIConfig.Weapons.EmplacementWeapons.HeavyChemthrower.setupTime && entity.field_70173_aa % 20 == 0) {
                entity.partArray = this.getCollisionBoxes();
            }
        }
    }

    @Override
    public EntityEmplacementWeapon.EmplacementHitboxEntity[] getCollisionBoxes() {
        if (this.entity == null) {
            return new EntityEmplacementWeapon.EmplacementHitboxEntity[0];
        }
        float t = (float)this.setupDelay / (float)Config.IIConfig.Weapons.EmplacementWeapons.HeavyChemthrower.setupTime;
        ArrayList<EntityEmplacementWeapon.EmplacementHitboxEntity> list = new ArrayList<EntityEmplacementWeapon.EmplacementHitboxEntity>();
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "baseBox", 1.0f, 1.25f, new Vec3d(0.0, 0.5, 0.0), Vec3d.field_186680_a, 12));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "baseBoxTop", 0.5f, 0.25f, new Vec3d(-0.25, 1.25, 0.25), Vec3d.field_186680_a, 12));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "baseBoxTop", 0.5f, 0.25f, new Vec3d(-0.25, 1.25, -0.25), Vec3d.field_186680_a, 12));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "barrelLeft", 0.5f, 1.0f, new Vec3d(0.75, 0.8125, 0.5), Vec3d.field_186680_a, 4));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "barrelRight", 0.5f, 1.0f, new Vec3d(0.75, 0.8125, -0.5), Vec3d.field_186680_a, 4));
        for (float f = -0.25f; f <= 0.25f; f += 0.5f) {
            list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "gunBarrelLeft", 0.3125f, 0.3125f, new Vec3d(0.0, 0.8125, -0.25), new Vec3d(-0.8125, 0.0, 0.0), 12));
            if (t > 0.35f) {
                list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "gunBarrelLeft", 0.3125f, 0.3125f, new Vec3d(0.0, 0.8125, (double)f), new Vec3d(-1.125, 0.0, 0.0), 12));
            }
            if (t > 0.5f) {
                list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "gunBarrelLeft", 0.3125f, 0.3125f, new Vec3d(0.0, 0.8125, (double)f), new Vec3d(-1.4375, 0.0, 0.0), 12));
            }
            if (t > 0.65f) {
                list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "gunBarrelLeft", 0.3125f, 0.3125f, new Vec3d(0.0, 0.8125, (double)f), new Vec3d(-1.75, 0.0, 0.0), 12));
            }
            if (t > 0.75f) {
                list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "gunBarrelLeft", 0.3125f, 0.3125f, new Vec3d(0.0, 0.8125, (double)f), new Vec3d(-2.0625, 0.0, 0.0), 12));
            }
            if (!(t > 0.9f)) continue;
            list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "gunBarrelLeft", 0.425f, 0.425f, new Vec3d(0.0, 0.8125, (double)f), new Vec3d(-2.487500011920929, 0.0, 0.0), 12));
        }
        return list.toArray(new EntityEmplacementWeapon.EmplacementHitboxEntity[0]);
    }

    @Override
    public NonNullList<ItemStack> getBaseInventory() {
        return NonNullList.func_191196_a();
    }

    @Override
    public void renderStorageInventory(GuiEmplacementPageStorage gui, int mx, int my, float partialTicks, boolean first) {
        if (first) {
            gui.bindIcons();
            gui.func_73729_b(gui.getGuiLeft() + 4, gui.getGuiTop() + 18, 0, 0, 20, 50);
            ClientUtils.handleGuiTank((IFluidTank)this.tank, (int)(gui.getGuiLeft() + 6), (int)(gui.getGuiTop() + 20), (int)16, (int)46, (int)20, (int)0, (int)20, (int)50, (int)mx, (int)my, (String)gui.TEXTURE_ICONS.toString(), null);
        } else {
            ArrayList tooltip = new ArrayList();
            if (Utils.isPointInRectangle(gui.getGuiLeft() + 6, gui.getGuiTop() + 20, gui.getGuiLeft() + 6 + 20, gui.getGuiTop() + 20 + 50, mx, my)) {
                ClientUtils.handleGuiTank((IFluidTank)this.tank, (int)(gui.getGuiLeft() + 6), (int)(gui.getGuiTop() + 20), (int)16, (int)46, (int)20, (int)0, (int)20, (int)50, (int)mx, (int)my, (String)gui.TEXTURE_ICONS.toString(), tooltip);
            }
            if (!tooltip.isEmpty()) {
                ClientUtils.drawHoveringText(tooltip, (int)(mx - gui.getGuiLeft()), (int)(my - gui.getGuiTop()), (FontRenderer)gui.field_146297_k.field_71466_p, (int)(gui.getGuiLeft() + gui.getXSize()), (int)-1);
                RenderHelper.func_74520_c();
            }
        }
    }

    @Override
    public void performPlatformRefill(TileEntityEmplacement te) {
    }

    @Override
    public int getEnergyUpkeepCost() {
        return Config.IIConfig.Weapons.EmplacementWeapons.HeavyChemthrower.energyUpkeepCost;
    }

    @Override
    public int getMaxHealth() {
        return Config.IIConfig.Weapons.EmplacementWeapons.HeavyChemthrower.maxHealth;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected Tuple<ResourceLocation, List<ModelRendererTurbo>> getDebris() {
        return new Tuple((Object)EmplacementRenderer.textureHeavyChemthrower, Arrays.asList(EmplacementRenderer.modelHeavyChemthrowerConstruction));
    }

    private double getStackMass() {
        if (this.tank.getFluid() != null) {
            return (this.tank.getFluid().getFluid().isGaseous() ? 0.025f : 0.05f) * (float)(this.tank.getFluid().getFluid().getDensity(this.tank.getFluid()) < 0 ? -1 : 1);
        }
        return 0.0;
    }

    static class SidedFluidHandler
    implements IFluidHandler {
        EmplacementWeaponHeavyChemthrower barrel;

        SidedFluidHandler(EmplacementWeaponHeavyChemthrower barrel) {
            this.barrel = barrel;
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (resource == null) {
                return 0;
            }
            return this.barrel.tank.fill(resource, doFill);
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (resource == null) {
                return null;
            }
            return this.drain(resource.amount, doDrain);
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            return this.barrel.tank.drain(maxDrain, doDrain);
        }

        public IFluidTankProperties[] getTankProperties() {
            return this.barrel.tank.getTankProperties();
        }
    }
}

