/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common;

import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.bullets.IBullet;
import pl.pabilo8.immersiveintelligence.api.crafting.PrecissionAssemblerRecipe;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.blocks.types.IIBlockTypes_MetalDecoration;
import pl.pabilo8.immersiveintelligence.common.items.ammunition.ItemIIBulletMagazine;

public class IICreativeTab
extends CreativeTabs {
    public static List<Fluid> fluidBucketMap = new ArrayList<Fluid>();

    public IICreativeTab(String name) {
        super(name);
    }

    public ItemStack func_78016_d() {
        return new ItemStack((Block)IIContent.blockMetalDecoration, 1, IIBlockTypes_MetalDecoration.COIL_DATA.ordinal());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_78018_a(NonNullList<ItemStack> list) {
        super.func_78018_a(list);
        this.addExampleBullets(list);
        for (Fluid fluid : fluidBucketMap) {
            this.addFluidBucket(fluid, list);
        }
    }

    public void addFluidBucket(Fluid fluid, NonNullList list) {
        UniversalBucket bucket = ForgeModContainer.getInstance().universalBucket;
        ItemStack stack = new ItemStack((Item)bucket);
        FluidBucketWrapper fluidHandler = new FluidBucketWrapper(stack);
        FluidStack fs = new FluidStack(fluid, bucket.getCapacity());
        if (fluidHandler.fill(fs, true) == fs.amount) {
            list.add((Object)fluidHandler.getContainer());
        }
    }

    public void addAssemblySchemes(NonNullList<ItemStack> list) {
        for (PrecissionAssemblerRecipe recipe : PrecissionAssemblerRecipe.recipeList) {
            list.add((Object)IIContent.itemAssemblyScheme.getStackForRecipe(recipe));
        }
    }

    public void addExampleBullets(NonNullList<ItemStack> list) {
        for (IBullet bullet : new IBullet[]{IIContent.itemAmmoArtillery, IIContent.itemAmmoLightArtillery, IIContent.itemAmmoMortar}) {
            list.add((Object)bullet.getBulletWithParams("core_brass", "canister", "tnt", "tracer_powder"));
            list.add((Object)bullet.getBulletWithParams("core_brass", "canister", "rdx", "tracer_powder"));
            list.add((Object)bullet.getBulletWithParams("core_brass", "canister", "hmx", "tracer_powder"));
            list.add((Object)bullet.getBulletWithParams("core_tungsten", "piercing", "tnt", "tracer_powder"));
            list.add((Object)bullet.getBulletWithParams("core_tungsten", "piercing", "rdx", "tracer_powder"));
            list.add((Object)bullet.getBulletWithParams("core_tungsten", "piercing", "hmx", "tracer_powder"));
            list.add((Object)bullet.getBulletWithParams("core_steel", "shaped", "tnt", "tracer_powder"));
            list.add((Object)bullet.getBulletWithParams("core_steel", "shaped", "rdx", "tracer_powder"));
            list.add((Object)bullet.getBulletWithParams("core_steel", "shaped", "hmx", "tracer_powder"));
        }
        list.add((Object)IIContent.itemAmmoArtillery.getBulletWithParams("core_brass", "canister", "hmx", "white_phosphorus").func_151001_c("Phosphorgranate mk. 1"));
        list.add((Object)IIContent.itemAmmoArtillery.getBulletWithParams("core_brass", "canister", "fluid_napalm").func_151001_c("Napalmgranate mk. 1"));
        list.add((Object)IIContent.itemAmmoArtillery.getBulletWithParams("core_brass", "canister", "nuke").func_151001_c("Geburtstagsgranate mk.1"));
        list.add((Object)IIContent.itemGrenade.getBulletWithParams("core_brass", "canister", "tnt").func_151001_c("Stielhandgranate mk.1"));
        list.add((Object)IIContent.itemGrenade.getBulletWithParams("core_brass", "canister", "white_phosphorus").func_151001_c("Phosphorhandgranate mk.1"));
        list.add((Object)IIContent.itemGrenade.getBulletWithParams("core_brass", "canister", "rdx").func_151001_c("Sprenghandgranate mk.1"));
        list.add((Object)IIContent.itemGrenade.getBulletWithParams("core_brass", "canister", "hmx").func_151001_c("Sprenghandgranate mk.2"));
        list.add((Object)IIContent.itemGrenade.getBulletWithParams("core_brass", "canister", "gas_chlorine").func_151001_c("Chemhandgranate mk.1"));
        ItemStack grenade_firework = IIContent.itemGrenade.getBulletWithParams("core_brass", "canister", "firework").func_151001_c("Feuerwerkhandgranate mk.1");
        try {
            ((NBTTagList)ItemNBTHelper.getTag((ItemStack)grenade_firework).func_74781_a("component_nbt")).func_150304_a(0, (NBTBase)JsonToNBT.func_180713_a((String)"{Explosion:{Type:0b,Colors:[I;3887386]}}"));
        }
        catch (NBTException e) {
            e.printStackTrace();
        }
        list.add((Object)IIContent.itemRailgunGrenade.getBulletWithParams("core_brass", "canister", "gas_chlorine").func_151001_c("Schienenkanone Chemgranate mk.1"));
        list.add((Object)IIContent.itemRailgunGrenade.getBulletWithParams("core_brass", "canister", "rdx").func_151001_c("Schienenkanone Sprenggranate mk.1"));
        list.add((Object)grenade_firework);
        list.add((Object)IIContent.itemAmmoRevolver.getBulletWithParams("core_brass", "canister", "white_phosphorus").func_151001_c("Flammpatrone mk.1"));
        list.add((Object)IIContent.itemAmmoRevolver.getBulletWithParams("core_tungsten", "piercing", new String[0]).func_151001_c("Wolframpatrone mk.1"));
        ItemStack bullet_tracer = IIContent.itemAmmoRevolver.getBulletWithParams("core_brass", "canister", "tracer_powder").func_151001_c("Markierungspatrone mk.1");
        try {
            ((NBTTagList)ItemNBTHelper.getTag((ItemStack)bullet_tracer).func_74781_a("component_nbt")).func_150304_a(0, (NBTBase)JsonToNBT.func_180713_a((String)"{colour:3887386}"));
        }
        catch (NBTException e) {
            e.printStackTrace();
        }
        list.add((Object)bullet_tracer);
        ItemStack bullet1 = IIContent.itemAmmoMachinegun.getBulletWithParams("core_brass", "softpoint", "tnt").func_151001_c("Sprengpatrone mk.1");
        ItemStack bullet2 = IIContent.itemAmmoMachinegun.getBulletWithParams("core_tungsten", "piercing", "shrapnel_tungsten").func_151001_c("Wolframpatrone mk.1");
        ItemStack bullet3 = IIContent.itemAmmoMachinegun.getBulletWithParams("core_steel", "piercing", new String[0]).func_151001_c("Stahlpatrone mk.1");
        ItemStack bullet4 = IIContent.itemAmmoMachinegun.getBulletWithParams("core_brass", "softpoint", "white_phosphorus").func_151001_c("Phosphorpatrone mk.1");
        list.add((Object)bullet1);
        list.add((Object)bullet2);
        list.add((Object)bullet3);
        list.add((Object)bullet4);
        list.add((Object)ItemIIBulletMagazine.getMagazine("machinegun", bullet1, bullet2, bullet3, bullet4));
        list.add((Object)ItemIIBulletMagazine.getMagazine("submachinegun", IIContent.itemAmmoSubmachinegun.getBulletWithParams("core_brass", "softpoint", "tnt").func_151001_c("Sprengpatrone mk.1"), IIContent.itemAmmoSubmachinegun.getBulletWithParams("core_tungsten", "piercing", "shrapnel_tungsten").func_151001_c("Wolframpatrone mk.1"), IIContent.itemAmmoSubmachinegun.getBulletWithParams("core_steel", "piercing", new String[0]).func_151001_c("Stahlpatrone mk.1"), IIContent.itemAmmoSubmachinegun.getBulletWithParams("core_brass", "softpoint", "white_phosphorus").func_151001_c("Phosphorpatrone mk.1")));
        ItemStack bullet5 = IIContent.itemAmmoMachinegun.getBulletWithParams("core_uranium", "piercing", "shrapnel_uranium").func_151001_c("Uraniumpatrone mk.1");
        list.add((Object)bullet5);
        list.add((Object)ItemIIBulletMagazine.getMagazine("machinegun", bullet5, bullet5, bullet5, bullet5));
        list.add((Object)this.addColorBulletMagazine(IIContent.itemAmmoMachinegun, "cpds_drum", 65327, 0xFF0000, 25343, 0xFFEE00));
        list.add((Object)this.addColorBulletMagazine(IIContent.itemAmmoAutocannon, "autocannon", 65327, 0xFF0000, 25343, 0xFFEE00));
        list.add((Object)this.addColorBulletMagazine(IIContent.itemAmmoMachinegun, "machinegun", 65327, 0xFF0000, 25343, 0xFFEE00));
        list.add((Object)this.addColorBulletMagazine(IIContent.itemAmmoAssaultRifle, "assault_rifle", 65327, 0xFF0000, 25343, 0xFFEE00));
        list.add((Object)this.addColorBulletMagazine(IIContent.itemAmmoSubmachinegun, "submachinegun", 65327, 0xFF0000, 25343, 0xFFEE00));
        list.add((Object)this.addColorBulletMagazine(IIContent.itemAmmoSubmachinegun, "submachinegun_drum", 65327, 0xFF0000, 25343, 0xFFEE00));
        list.add((Object)IIContent.blockRadioExplosives.bullet.getBulletWithParams("core_brass", "canister", "tnt").func_151001_c("Radio-Sprengstoff TNT mk.1"));
        list.add((Object)IIContent.blockRadioExplosives.bullet.getBulletWithParams("core_brass", "canister", "white_phosphorus").func_151001_c("Radio-Sprengstoff Phosphor mk.1"));
        list.add((Object)IIContent.blockTellermine.bullet.getBulletWithParams("core_brass", "softpoint", "tnt").func_151001_c("Tellermine mk.1"));
        list.add((Object)IIContent.blockTripmine.bullet.getBulletWithParams("core_brass", "softpoint", "tnt").func_151001_c("SD-Mine mk.1"));
        list.add((Object)IIContent.itemNavalMine.getBulletWithParams("core_brass", "softpoint", "rdx").func_151001_c("Seemine mk.1"));
    }

    ItemStack addColorBulletMagazine(IBullet type, String magName, int ... colors) {
        ArrayList<ItemStack> bullets = new ArrayList<ItemStack>();
        for (int color : colors) {
            ItemStack stack = type.getBulletWithParams("core_brass", "softpoint", "tracer_powder").func_151001_c(this.getGermanColorName(color) + "markierungspatrone");
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("colour", color);
            type.setComponentNBT(stack, tag);
            type.setPaintColour(stack, color);
            ItemNBTHelper.setInt((ItemStack)stack, (String)"fuse", (int)2);
            bullets.add(stack);
        }
        ItemStack stack = new ItemStack((Item)IIContent.itemBulletMagazine, 1, IIContent.itemBulletMagazine.getMetaBySubname(magName));
        NonNullList l = NonNullList.func_191197_a((int)ItemIIBulletMagazine.getBulletCapactity(stack), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < l.size(); ++i) {
            l.set(i, bullets.get(i % bullets.size()));
        }
        ItemNBTHelper.getTag((ItemStack)stack).func_74782_a("bullets", (NBTBase)ItemIIBulletMagazine.writeInventory((NonNullList<ItemStack>)l));
        ItemIIBulletMagazine.makeDefault(stack);
        return stack;
    }

    private String getGermanColorName(int color) {
        switch (Utils.getRGBTextFormatting(color)) {
            case WHITE: {
                return "Wei\u00c3\u0178";
            }
            case ORANGE: {
                return "Orange";
            }
            case MAGENTA: {
                return "Magenta";
            }
            case LIGHT_BLUE: {
                return "Hellblau";
            }
            case YELLOW: {
                return "Gelb";
            }
            case LIME: {
                return "Lime";
            }
            case PINK: {
                return "Rosa";
            }
            case GRAY: {
                return "Grau";
            }
            case SILVER: {
                return "Silber";
            }
            case CYAN: {
                return "Cyan";
            }
            case PURPLE: {
                return "Purpur";
            }
            case BLUE: {
                return "Blau";
            }
            case BROWN: {
                return "Braun";
            }
            case GREEN: {
                return "Gr\u00c3\u00bcn";
            }
            case RED: {
                return "Rot";
            }
        }
        return "Schwarz";
    }
}

