/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.tmt;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.ARBBufferObject;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TmtTessellator
extends Tessellator {
    private static final int nativeBufferSize = 0x200000;
    private static final int trivertsInBuffer = 262140;
    public static boolean renderingWorldRenderer = false;
    public boolean defaultTexture = false;
    private int rawBufferSize = 0;
    public int textureID = 0;
    private static final boolean convertQuadsToTriangles = false;
    private static final ByteBuffer byteBuffer = GLAllocation.func_74524_c((int)0x800000);
    private static final IntBuffer intBuffer = byteBuffer.asIntBuffer();
    private static final FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
    private static final ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
    private int[] rawBuffer;
    private int vertexCount = 0;
    private double textureU;
    private double textureV;
    private double textureW;
    private int brightness;
    private int color;
    private boolean hasColor = false;
    private boolean hasTexture = false;
    private boolean hasBrightness = false;
    private boolean hasNormals = false;
    private int rawBufferIndex = 0;
    private int addedVertices = 0;
    private boolean isColorDisabled = false;
    public int drawMode;
    public double xOffset;
    public double yOffset;
    public double zOffset;
    private int normal;
    public static TmtTessellator instance = new TmtTessellator();
    public boolean isDrawing = false;
    private static boolean useVBO = false;
    private static IntBuffer vertexBuffers;
    private int vboIndex = 0;
    private static final int vboCount = 10;

    public TmtTessellator() {
        super(0x200000);
    }

    public void func_78381_a() {
        if (!this.isDrawing) {
            throw new IllegalStateException("Not tesselating!");
        }
        this.isDrawing = false;
        int offs = 0;
        while (offs < this.vertexCount) {
            int vtc = 0;
            if (this.drawMode == 7) {
                // empty if block
            }
            vtc = Math.min(this.vertexCount - offs, 65536);
            intBuffer.clear();
            intBuffer.put(this.rawBuffer, offs * 10, vtc * 10);
            byteBuffer.position(0);
            byteBuffer.limit(vtc * 40);
            offs += vtc;
            if (useVBO) {
                this.vboIndex = (this.vboIndex + 1) % 10;
                ARBBufferObject.glBindBufferARB((int)34962, (int)vertexBuffers.get(this.vboIndex));
                ARBBufferObject.glBufferDataARB((int)34962, (ByteBuffer)byteBuffer, (int)35040);
            }
            if (this.hasTexture) {
                if (useVBO) {
                    GL11.glTexCoordPointer((int)4, (int)5126, (int)40, (long)12L);
                } else {
                    floatBuffer.position(3);
                    GL11.glTexCoordPointer((int)4, (int)40, (FloatBuffer)floatBuffer);
                }
                GL11.glEnableClientState((int)32888);
            }
            if (this.hasBrightness) {
                OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
                if (useVBO) {
                    GL11.glTexCoordPointer((int)2, (int)5122, (int)40, (long)36L);
                } else {
                    shortBuffer.position(18);
                    GL11.glTexCoordPointer((int)2, (int)40, (ShortBuffer)shortBuffer);
                }
                GL11.glEnableClientState((int)32888);
                OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
            }
            if (this.hasColor) {
                if (useVBO) {
                    GL11.glColorPointer((int)4, (int)5121, (int)40, (long)28L);
                } else {
                    byteBuffer.position(28);
                    GL11.glColorPointer((int)4, (boolean)true, (int)40, (ByteBuffer)byteBuffer);
                }
                GL11.glEnableClientState((int)32886);
            }
            if (this.hasNormals) {
                if (useVBO) {
                    GL11.glNormalPointer((int)5121, (int)40, (long)32L);
                } else {
                    byteBuffer.position(32);
                    GL11.glNormalPointer((int)40, (ByteBuffer)byteBuffer);
                }
                GL11.glEnableClientState((int)32885);
            }
            if (useVBO) {
                GL11.glVertexPointer((int)3, (int)5126, (int)40, (long)0L);
            } else {
                floatBuffer.position(0);
                GL11.glVertexPointer((int)3, (int)40, (FloatBuffer)floatBuffer);
            }
            GL11.glEnableClientState((int)32884);
            if (this.drawMode == 7) {
                // empty if block
            }
            GL11.glDrawArrays((int)this.drawMode, (int)0, (int)vtc);
            GL11.glDisableClientState((int)32884);
            if (this.hasTexture) {
                GL11.glDisableClientState((int)32888);
            }
            if (this.hasBrightness) {
                OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
                GL11.glDisableClientState((int)32888);
                OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
            }
            if (this.hasColor) {
                GL11.glDisableClientState((int)32886);
            }
            if (!this.hasNormals) continue;
            GL11.glDisableClientState((int)32885);
        }
        if (this.rawBufferSize > 131072 && this.rawBufferIndex < this.rawBufferSize << 3) {
            this.rawBufferSize = 0;
            this.rawBuffer = null;
        }
        this.reset();
    }

    private void reset() {
        this.vertexCount = 0;
        byteBuffer.clear();
        this.rawBufferIndex = 0;
        this.addedVertices = 0;
    }

    public void startDrawing(int par1) {
        if (this.isDrawing) {
            throw new IllegalStateException("Already tesselating!");
        }
        this.isDrawing = true;
        this.reset();
        this.drawMode = par1;
        this.hasNormals = false;
        this.hasColor = false;
        this.hasTexture = false;
        this.hasBrightness = false;
        this.isColorDisabled = false;
    }

    public void setTextureUVW(double par1, double par3, double par4) {
        this.hasTexture = true;
        this.textureU = par1;
        this.textureV = par3;
        this.textureW = par4;
    }

    public void addVertexWithUVW(double par1, double par3, double par5, double par7, double par9, double par10) {
        this.setTextureUVW(par7, par9, par10);
        this.addVertex(par1, par3, par5);
    }

    public void addVertex(double par1, double par3, double par5) {
        if (this.rawBufferIndex >= this.rawBufferSize - 40) {
            if (this.rawBufferSize == 0) {
                this.rawBufferSize = 65536;
                this.rawBuffer = new int[this.rawBufferSize];
            } else {
                this.rawBufferSize *= 2;
                this.rawBuffer = Arrays.copyOf(this.rawBuffer, this.rawBufferSize);
            }
        }
        ++this.addedVertices;
        if (this.drawMode == 7) {
            // empty if block
        }
        if (this.hasTexture) {
            this.rawBuffer[this.rawBufferIndex + 3] = Float.floatToRawIntBits((float)this.textureU);
            this.rawBuffer[this.rawBufferIndex + 4] = Float.floatToRawIntBits((float)this.textureV);
            this.rawBuffer[this.rawBufferIndex + 5] = Float.floatToRawIntBits(0.0f);
            this.rawBuffer[this.rawBufferIndex + 6] = Float.floatToRawIntBits((float)this.textureW);
        }
        if (this.hasBrightness) {
            this.rawBuffer[this.rawBufferIndex + 9] = this.brightness;
        }
        if (this.hasColor) {
            this.rawBuffer[this.rawBufferIndex + 7] = this.color;
        }
        if (this.hasNormals) {
            this.rawBuffer[this.rawBufferIndex + 8] = this.normal;
        }
        this.rawBuffer[this.rawBufferIndex] = Float.floatToRawIntBits((float)(par1 + this.xOffset));
        this.rawBuffer[this.rawBufferIndex + 1] = Float.floatToRawIntBits((float)(par3 + this.yOffset));
        this.rawBuffer[this.rawBufferIndex + 2] = Float.floatToRawIntBits((float)(par5 + this.zOffset));
        this.rawBufferIndex += 10;
        ++this.vertexCount;
    }

    public void setNormal(float par1, float par2, float par3) {
        this.hasNormals = true;
        byte b0 = (byte)(par1 * 127.0f);
        byte b1 = (byte)(par2 * 127.0f);
        byte b2 = (byte)(par3 * 127.0f);
        this.normal = b0 & 0xFF | (b1 & 0xFF) << 8 | (b2 & 0xFF) << 16;
    }

    static {
        TmtTessellator.instance.defaultTexture = true;
        useVBO = false;
    }
}

