/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.render.metal_device;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.utils.MachineUpgrade;
import pl.pabilo8.immersiveintelligence.api.utils.vehicles.IUpgradableMachine;
import pl.pabilo8.immersiveintelligence.client.animation.AMT;
import pl.pabilo8.immersiveintelligence.client.animation.IIAnimationCompiledMap;
import pl.pabilo8.immersiveintelligence.client.animation.IIAnimationLoader;
import pl.pabilo8.immersiveintelligence.client.animation.IIAnimationUtils;
import pl.pabilo8.immersiveintelligence.client.animation.IIMachineUpgradeModel;
import pl.pabilo8.immersiveintelligence.client.render.IITileRenderer;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.blocks.metal.TileEntityEffectCrate;

public abstract class EffectCrateRenderer<T extends TileEntityEffectCrate>
extends IITileRenderer<T> {
    private IIAnimationCompiledMap animationOpen = null;
    private AMT[] model = null;
    private IIMachineUpgradeModel modelUpgrade = null;
    private AMT partInserter;
    private AMT partLower;
    private AMT partUpper;

    @Override
    public void draw(T te, BufferBuilder buf, float partialTicks, Tessellator tes) {
        float progress = Math.min(1.5f, Math.max(((TileEntityEffectCrate)te).lidAngle + (((TileEntityEffectCrate)te).open ? 0.2f * partialTicks : -0.3f * partialTicks), 0.0f)) / 1.5f;
        this.animationOpen.apply(progress);
        GlStateManager.func_179094_E();
        this.applyStandardRotation(((TileEntityEffectCrate)te).getFacing());
        for (AMT mod : this.model) {
            mod.render(tes, buf);
        }
        GlStateManager.func_179121_F();
        if (this.modelUpgrade.renderConstruction((IUpgradableMachine)te, tes, buf, partialTicks)) {
            this.modelUpgrade.defaultize();
            IIAnimationUtils.setModelRotation(this.partInserter, 0.0, -((TileEntityEffectCrate)te).calculateInserterAngle(partialTicks), 0.0);
            float ins = ((TileEntityEffectCrate)te).calculateInserterAnimation(partialTicks);
            float h = ((TileEntityEffectCrate)te).calculateInserterHeight(partialTicks);
            IIAnimationUtils.setModelRotation(this.partLower, -ins * 45.0f - 15.0f, 0.0, 0.0);
            IIAnimationUtils.setModelRotation(this.partUpper, -145.0f + ins * 75.0f, 0.0, 0.0);
            IIAnimationUtils.addModelRotation(this.partLower, Utils.clampedLerp3Par(35.0f, 0.0f, -45.0f, h) * ins, 0.0, 0.0);
            IIAnimationUtils.addModelRotation(this.partUpper, Utils.clampedLerp3Par(75.0f, -10.0f, 50.0f, h) * ins, 0.0, 0.0);
            this.modelUpgrade.render(tes, buf);
        }
    }

    @Override
    public void compileModels(Tuple<IBlockState, IBakedModel> sModel) {
        this.model = IIAnimationUtils.getAMT(sModel, IIAnimationLoader.loadHeader((IBakedModel)sModel.func_76340_b()));
        this.animationOpen = IIAnimationCompiledMap.create(this.model, this.getOpenAnimationPath());
        this.modelUpgrade = new IIMachineUpgradeModel(IIContent.UPGRADE_INSERTER, this.getInserterUpgradePath(), this.getInserterUpgradeAnimationPath());
        this.partInserter = this.modelUpgrade.getPart("inserter");
        this.partUpper = this.modelUpgrade.getPart("upper");
        this.partLower = this.modelUpgrade.getPart("lower");
    }

    @Override
    protected void nullifyModels() {
        this.model = IIAnimationUtils.disposeOf(this.model);
        this.modelUpgrade = this.modelUpgrade == null ? null : this.modelUpgrade.disposeOf();
        this.animationOpen = null;
    }

    public static void renderWithUpgrade(MachineUpgrade ... upgrades) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)-0.5, (double)0.0, (double)0.5);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (MachineUpgrade upgrade : upgrades) {
            if (upgrade != IIContent.UPGRADE_INSERTER) continue;
            GlStateManager.func_179094_E();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
    }

    public abstract ResourceLocation getOpenAnimationPath();

    public abstract ResourceLocation getInserterUpgradeAnimationPath();

    public abstract ResourceLocation getInserterUpgradePath();
}

