/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.render.metal_device;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import pl.pabilo8.immersiveintelligence.client.animation.AMT;
import pl.pabilo8.immersiveintelligence.client.animation.IIAnimation;
import pl.pabilo8.immersiveintelligence.client.animation.IIAnimationCompiledMap;
import pl.pabilo8.immersiveintelligence.client.animation.IIAnimationLoader;
import pl.pabilo8.immersiveintelligence.client.animation.IIAnimationUtils;
import pl.pabilo8.immersiveintelligence.client.render.IITileRenderer;
import pl.pabilo8.immersiveintelligence.common.blocks.metal.TileEntityDataDebugger;

public class DataDebuggerRenderer
extends IITileRenderer<TileEntityDataDebugger> {
    private static IIAnimation construction;
    private static IIAnimationCompiledMap constructionMap;
    private static AMT[] models;

    @Override
    public void draw(TileEntityDataDebugger te, BufferBuilder buf, float partialTicks, Tessellator tes) {
        if (te.setupTime > 0) {
            float progress = IIAnimationUtils.getAnimationProgress(te.setupTime, 25.0f, true, partialTicks);
            constructionMap.apply(progress);
            this.applyStandardRotation(te.getFacing());
            for (AMT mod : models) {
                mod.render(tes, buf);
            }
        }
    }

    @Override
    public void compileModels(Tuple<IBlockState, IBakedModel> sModel) {
        construction = IIAnimationLoader.loadAnimation(new ResourceLocation("immersiveintelligence", "data_debugger_construction"));
        models = IIAnimationUtils.getAMT(sModel, IIAnimationLoader.loadHeader((IBakedModel)sModel.func_76340_b()));
        constructionMap = IIAnimationCompiledMap.create(models, construction);
    }

    @Override
    protected void nullifyModels() {
        models = IIAnimationUtils.disposeOf(models);
        constructionMap = null;
        construction = null;
    }

    static {
        models = null;
    }
}

