/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.render.inserter;

import java.util.function.Function;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import pl.pabilo8.immersiveintelligence.client.animation.AMT;
import pl.pabilo8.immersiveintelligence.client.animation.IIAnimationCompiledMap;
import pl.pabilo8.immersiveintelligence.client.animation.IIAnimationLoader;
import pl.pabilo8.immersiveintelligence.client.animation.IIAnimationUtils;
import pl.pabilo8.immersiveintelligence.client.animation.IIModelHeader;
import pl.pabilo8.immersiveintelligence.client.render.IITileRenderer;
import pl.pabilo8.immersiveintelligence.common.blocks.metal.inserter.TileEntityInserterBase;

public abstract class InserterBaseRenderer<T extends TileEntityInserterBase>
extends IITileRenderer<T> {
    private IIAnimationCompiledMap animationFrontBack = null;
    private IIAnimationCompiledMap animationFrontRight = null;
    private IIAnimationCompiledMap animationFrontLeft = null;
    private IIAnimationCompiledMap animationFrontFront = null;
    private AMT[] model = null;
    private AMT inBox;
    private AMT outBox;
    private AMT turntable;

    @Override
    public final void draw(T te, BufferBuilder buf, float partialTicks, Tessellator tes) {
        EnumFacing teIn = ((TileEntityInserterBase)te).getCurrentInputFacing();
        for (AMT mod : this.model) {
            mod.defaultize();
        }
        IIAnimationUtils.setModelRotation(this.inBox, 0.0, -((TileEntityInserterBase)te).defaultInputFacing.func_185119_l(), 0.0);
        IIAnimationUtils.setModelRotation(this.outBox, 0.0, -((TileEntityInserterBase)te).defaultOutputFacing.func_185119_l(), 0.0);
        if (((TileEntityInserterBase)te).current != null) {
            EnumFacing teOut = ((TileEntityInserterBase)te).getCurrentOutputFacing();
            double duration = (double)((TileEntityInserterBase)te).getPickupSpeed() * (double)(1.0f + (((TileEntityInserterBase)te).current != null ? ((TileEntityInserterBase)te).current.getTimeModifier() : 0.0f));
            float totalProgress = (float)((double)((float)((TileEntityInserterBase)te).pickProgress + (((TileEntityInserterBase)te).current != null ? partialTicks : 0.0f)) / duration);
            int diff = Math.abs(teIn.func_176736_b() - teOut.func_176736_b());
            switch (diff) {
                case 0: {
                    this.animationFrontFront.apply(totalProgress);
                    break;
                }
                case 1: {
                    (teIn.func_176746_e() == teOut ? this.animationFrontRight : this.animationFrontLeft).apply(totalProgress);
                    break;
                }
                case 2: {
                    this.animationFrontBack.apply(totalProgress);
                }
            }
        } else {
            this.animationFrontFront.apply(0.0f);
        }
        IIAnimationUtils.addModelRotation(this.turntable, 0.0, -teIn.func_185119_l(), 0.0);
        this.doAdditionalTransforms(te, buf, partialTicks, tes);
        for (AMT mod : this.model) {
            mod.render(tes, buf);
        }
    }

    protected abstract void doAdditionalTransforms(T var1, BufferBuilder var2, float var3, Tessellator var4);

    @Override
    public void compileModels(Tuple<IBlockState, IBakedModel> sModel) {
        this.model = IIAnimationUtils.getAMT(sModel, IIAnimationLoader.loadHeader((IBakedModel)sModel.func_76340_b()), this.getAdditionalParts());
        this.inBox = IIAnimationUtils.getPart(this.model, "input");
        this.outBox = IIAnimationUtils.getPart(this.model, "output");
        this.turntable = IIAnimationUtils.getPart(this.model, "turntable");
        this.animationFrontBack = IIAnimationCompiledMap.create(this.model, new ResourceLocation("immersiveintelligence", "inserter/front_back"));
        this.animationFrontRight = IIAnimationCompiledMap.create(this.model, new ResourceLocation("immersiveintelligence", "inserter/front_right"));
        this.animationFrontLeft = IIAnimationCompiledMap.create(this.model, new ResourceLocation("immersiveintelligence", "inserter/front_left"));
        this.animationFrontFront = IIAnimationCompiledMap.create(this.model, new ResourceLocation("immersiveintelligence", "inserter/front_front"));
    }

    protected abstract Function<IIModelHeader, AMT[]> getAdditionalParts();

    @Override
    protected void nullifyModels() {
        this.model = IIAnimationUtils.disposeOf(this.model);
        this.turntable = null;
        this.outBox = null;
        this.inBox = null;
    }
}

