/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.render;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.CustomSkinHandler;
import pl.pabilo8.immersiveintelligence.api.bullets.BulletRegistry;
import pl.pabilo8.immersiveintelligence.client.model.IBulletModel;
import pl.pabilo8.immersiveintelligence.client.model.weapon.ModelMachinegun;
import pl.pabilo8.immersiveintelligence.client.render.IReloadableModelContainer;
import pl.pabilo8.immersiveintelligence.client.tmt.ModelRendererTurbo;
import pl.pabilo8.immersiveintelligence.client.tmt.TmtNamedBoxGroup;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.blocks.metal.TileEntityAmmunitionCrate;
import pl.pabilo8.immersiveintelligence.common.entity.EntityMachinegun;

public class MachinegunRenderer
extends Render<EntityMachinegun>
implements IReloadableModelContainer<MachinegunRenderer> {
    public static final String texture = "machinegun.png";
    public static ModelMachinegun model;
    public static HashMap<Predicate<ItemStack>, BiConsumer<ItemStack, List<TmtNamedBoxGroup>>> upgrades;
    public static List<TmtNamedBoxGroup> defaultGunParts;
    public static List<TmtNamedBoxGroup> skinParts;

    public MachinegunRenderer(RenderManager renderManager) {
        super(renderManager);
        this.subscribeToList("machinegun");
        this.reloadModels();
    }

    public static void renderMachinegun(ItemStack stack, @Nullable EntityMachinegun entity) {
        Object s;
        GlStateManager.func_179094_E();
        ArrayList<TmtNamedBoxGroup> renderParts = new ArrayList<TmtNamedBoxGroup>(defaultGunParts);
        boolean drawText = false;
        int textColor = 0xFFFFFF;
        String skin = IIContent.itemMachinegun.getSkinnableCurrentSkin(stack);
        if (!skin.isEmpty() && (s = CustomSkinHandler.specialSkins.get(skin)) != null) {
            textColor = ((CustomSkinHandler.SpecialSkin)s).textColor;
            if (((CustomSkinHandler.SpecialSkin)s).mods.contains("skin_mg_text")) {
                drawText = true;
            }
            skinParts.forEach(arg_0 -> MachinegunRenderer.lambda$renderMachinegun$0((CustomSkinHandler.SpecialSkin)s, renderParts, arg_0));
        }
        String specialText = I18n.func_135052_a((String)("skin.immersiveintelligence." + skin + ".name"), (Object[])new Object[0]);
        skin = skin.isEmpty() ? IIContent.itemMachinegun.getSkinnableDefaultTextureLocation() : "immersiveintelligence:textures/skins/" + skin + "/";
        ClientUtils.bindTexture((String)(skin + texture));
        for (Map.Entry entry : upgrades.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null || !((Predicate)entry.getKey()).test(stack)) continue;
            ((BiConsumer)entry.getValue()).accept(stack, renderParts);
        }
        if (entity != null) {
            float yaw = entity.gunYaw;
            float f = entity.gunPitch;
            if (entity.setupTime < 1 && entity.func_184188_bt().size() > 0 && entity.func_184188_bt().get(0) instanceof EntityLivingBase) {
                EntityLivingBase psg = (EntityLivingBase)entity.func_184188_bt().get(0);
                float true_head_angle = MathHelper.func_76142_g((float)(psg.field_70758_at - entity.setYaw));
                float true_head_angle2 = MathHelper.func_76142_g((float)psg.field_70125_A);
                if (entity.gunYaw < true_head_angle) {
                    yaw += ClientUtils.mc().func_184121_ak() * 2.0f;
                } else if (entity.gunYaw > true_head_angle) {
                    yaw -= ClientUtils.mc().func_184121_ak() * 2.0f;
                }
                if (Math.ceil(entity.gunYaw) <= Math.ceil(true_head_angle) + 1.0 && Math.ceil(entity.gunYaw) >= Math.ceil(true_head_angle) - 1.0) {
                    yaw = true_head_angle;
                }
                if (entity.gunPitch < true_head_angle2) {
                    f += ClientUtils.mc().func_184121_ak();
                } else if (entity.gunPitch > true_head_angle2) {
                    f -= ClientUtils.mc().func_184121_ak();
                }
                yaw = entity.tripod ? MathHelper.func_76131_a((float)yaw, (float)-82.5f, (float)82.5f) : MathHelper.func_76131_a((float)yaw, (float)-45.0f, (float)45.0f);
                f = MathHelper.func_76131_a((float)f, (float)-20.0f, (float)20.0f);
                yaw += entity.recoilYaw;
                f += entity.recoilPitch;
                f = MathHelper.func_76131_a((float)f, (float)-20.0f, (float)20.0f);
            }
            GlStateManager.func_179137_b((double)0.0, (double)-0.34375, (double)0.0);
            float setup = Math.max((float)entity.setupTime - ClientUtils.mc().func_184121_ak(), 0.0f);
            GlStateManager.func_179114_b((float)(-25.0f * (setup / (float)entity.maxSetupTime)), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)0.0, (double)(0.25 * (double)(setup / (float)entity.maxSetupTime)), (double)0.0);
            if (drawText) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179139_a((double)0.85, (double)0.85, (double)0.85);
                GlStateManager.func_179114_b((float)(180.0f - entity.setYaw), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(-f), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179137_b((double)-0.5, (double)0.34375, (double)(1.65625 + (double)(f / 20.0f) * 0.25));
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
                GlStateManager.func_179137_b((double)-0.93, (double)-0.7, (double)0.44);
                GlStateManager.func_179114_b((float)-45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)0.010416667f, (float)0.010416667f, (float)0.010416667f);
                GlStateManager.func_179140_f();
                ClientUtils.font().func_78276_b(specialText, 0, 1, MathHelper.func_180188_d((int)textColor, (int)(0xFFFFFF * (int)entity.field_70170_p.func_175724_o(entity.func_180425_c()))));
                GlStateManager.func_179145_e();
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179121_F();
            }
            for (TmtNamedBoxGroup nmod : renderParts) {
                ClientUtils.bindTexture((String)(skin + nmod.getTexturePath()));
                if (nmod.getName().equals("bipod")) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179139_a((double)0.85, (double)0.85, (double)0.85);
                    GlStateManager.func_179114_b((float)(180.0f - entity.setYaw), (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179137_b((double)-0.5, (double)0.40625, (double)1.65625);
                    nmod.render(0.0625f, setup / (float)entity.maxSetupTime);
                    GlStateManager.func_179121_F();
                    continue;
                }
                GlStateManager.func_179094_E();
                GlStateManager.func_179139_a((double)0.85, (double)0.85, (double)0.85);
                GlStateManager.func_179114_b((float)(180.0f - entity.setYaw), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(-f), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179137_b((double)-0.5, (double)0.34375, (double)(1.65625 + (double)(f / 20.0f) * 0.25));
                switch (nmod.getName()) {
                    case "ammo": {
                        boolean should_render = false;
                        if (entity.currentlyLoaded == 1.0f) {
                            float progress = entity.magazine1.func_190926_b() ? 1.0f - Math.min(2.0f * (float)entity.clipReload / (float)Config.IIConfig.Weapons.Machinegun.clipReloadTime, 1.0f) : (float)entity.clipReload / (float)Config.IIConfig.Weapons.Machinegun.clipReloadTime;
                            GlStateManager.func_179109_b((float)0.0f, (float)(0.375f * progress), (float)0.0f);
                            should_render = true;
                        } else if (!entity.magazine1.func_190926_b()) {
                            should_render = true;
                        }
                        if (!should_render) break;
                        nmod.render(0.0625f);
                        break;
                    }
                    case "belt_fed_loader": {
                        nmod.render(0.0625f);
                        IBulletModel mm = BulletRegistry.INSTANCE.registeredModels.get("mg_2bCal");
                        GlStateManager.func_179094_E();
                        GlStateManager.func_179109_b((float)0.69f, (float)0.65f, (float)-0.15625f);
                        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
                        BlockPos cratePos = entity.func_180425_c().func_177972_a(EnumFacing.func_176733_a((double)entity.setYaw).func_176734_d()).func_177977_b();
                        if (entity.func_130014_f_().func_175625_s(cratePos) instanceof TileEntityAmmunitionCrate) {
                            TileEntityAmmunitionCrate crate = (TileEntityAmmunitionCrate)entity.func_130014_f_().func_175625_s(cratePos);
                            assert (crate != null);
                            int beltLength = (int)(24.0f + Math.max(Math.abs(entity.gunYaw) - 55.0f, 0.0f) / 2.0f - Math.max(entity.gunPitch - 20.0f, 0.0f) / 2.0f);
                            if (crate.open && crate.hasUpgrade(IIContent.UPGRADE_MG_LOADER)) {
                                int i;
                                ArrayList<ItemStack> ammoStacks = new ArrayList<ItemStack>();
                                int cc = 0;
                                for (int i2 = 38; i2 < 50 && cc < beltLength; ++i2) {
                                    ItemStack bs = (ItemStack)crate.getInventory().get(i2);
                                    if (bs.func_190926_b()) continue;
                                    ammoStacks.add(bs.func_77946_l());
                                    cc += bs.func_190916_E();
                                }
                                float ammoDir = entity.gunYaw / (entity.tripod ? 90.0f : 50.0f) * (1.0f - Math.abs(entity.gunPitch) / 40.0f);
                                float ammoTurn = entity.tripod ? Math.abs(entity.gunYaw) / 90.0f * (beltLength > 24 ? (float)((beltLength -= 4) - 24) / 24.0f : 1.0f) : 0.0f;
                                GlStateManager.func_179094_E();
                                for (i = 0; i < 4 && ammoStacks.size() > 0; ++i) {
                                    mm.renderBulletUnused((ItemStack)ammoStacks.get(0));
                                    GlStateManager.func_179114_b((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.1225f);
                                    ((ItemStack)ammoStacks.get(0)).func_190918_g(1);
                                    if (((ItemStack)ammoStacks.get(0)).func_190916_E() > 0) continue;
                                    ammoStacks.remove(0);
                                }
                                GlStateManager.func_179121_F();
                                GlStateManager.func_179137_b((double)-0.25, (double)0.0, (double)0.25);
                                GlStateManager.func_179094_E();
                                for (i = 0; i < beltLength && ammoStacks.size() > 0; ++i) {
                                    mm.renderBulletUnused((ItemStack)ammoStacks.get(0));
                                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.125f);
                                    GlStateManager.func_179114_b((float)(ammoDir * -5.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                                    GlStateManager.func_179114_b((float)(ammoTurn * -8.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                                    ((ItemStack)ammoStacks.get(0)).func_190918_g(1);
                                    if (((ItemStack)ammoStacks.get(0)).func_190916_E() > 0) continue;
                                    ammoStacks.remove(0);
                                }
                                GlStateManager.func_179121_F();
                            }
                        }
                        GlStateManager.func_179121_F();
                        break;
                    }
                    case "second_magazine_mag": {
                        boolean should_render = false;
                        if (entity.currentlyLoaded == 2.0f) {
                            float progress = entity.magazine2.func_190926_b() ? 1.0f - Math.min(2.0f * (float)entity.clipReload / (float)Config.IIConfig.Weapons.Machinegun.clipReloadTime, 1.0f) : (float)entity.clipReload / (float)Config.IIConfig.Weapons.Machinegun.clipReloadTime;
                            GlStateManager.func_179109_b((float)0.0f, (float)(0.375f * progress), (float)0.0f);
                            should_render = true;
                        } else if (!entity.magazine2.func_190926_b()) {
                            should_render = true;
                        }
                        if (!should_render) break;
                        nmod.render(0.0625f);
                        break;
                    }
                    case "slide": {
                        if ((entity.currentlyLoaded == 1.0f && entity.magazine1.func_190926_b() || entity.currentlyLoaded == 2.0f && entity.magazine2.func_190926_b()) && (double)((float)entity.clipReload / (float)Config.IIConfig.Weapons.Machinegun.clipReloadTime) > 0.5) {
                            float curr = ((float)entity.clipReload / (float)Config.IIConfig.Weapons.Machinegun.clipReloadTime - 0.5f) / 0.5f;
                            float progress = (double)curr > 0.65 ? 1.0f - (curr - 0.65f) / 0.35f : curr / 0.65f;
                            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)((double)progress * 0.375));
                        }
                        nmod.render(0.0625f);
                        break;
                    }
                    case "shield": {
                        ClientUtils.bindTexture((String)(skin + nmod.getTexturePath()));
                        nmod.render(0.0625f);
                        break;
                    }
                    default: {
                        nmod.render(0.0625f);
                    }
                }
                GlStateManager.func_179121_F();
            }
        } else {
            for (TmtNamedBoxGroup tmtNamedBoxGroup : renderParts) {
                ClientUtils.bindTexture((String)(skin + tmtNamedBoxGroup.getTexturePath()));
                if (tmtNamedBoxGroup.getName().equals("bipod")) {
                    tmtNamedBoxGroup.render(0.0625f, 1.0f);
                    continue;
                }
                if (tmtNamedBoxGroup.getName().equals("ammo") && (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"magazine1") || new ItemStack(ItemNBTHelper.getTagCompound((ItemStack)stack, (String)"magazine1")).func_190926_b()) || tmtNamedBoxGroup.getName().equals("second_magazine_mag") && (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"magazine2") || new ItemStack(ItemNBTHelper.getTagCompound((ItemStack)stack, (String)"magazine2")).func_190926_b())) continue;
                for (ModelRendererTurbo m : tmtNamedBoxGroup.getModel()) {
                    m.func_78785_a(0.0625f);
                }
            }
        }
        GlStateManager.func_179121_F();
    }

    public static void drawBulletsList(ItemStack stack) {
        RenderHelper.func_74520_c();
        GlStateManager.func_179126_j();
        RenderItem ir = ClientUtils.mc().func_175599_af();
        NBTTagList listDict = ItemNBTHelper.getTagCompound((ItemStack)stack, (String)"bullets").func_150295_c("dictionary", 10);
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"bullet0")) {
            ir.func_175042_a(new ItemStack(listDict.func_150305_b(0)), 0, 0);
        }
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"bullet1")) {
            ir.func_175042_a(new ItemStack(listDict.func_150305_b(1)), 0, 22);
        }
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"bullet2")) {
            ir.func_175042_a(new ItemStack(listDict.func_150305_b(2)), 0, 44);
        }
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"bullet3")) {
            ir.func_175042_a(new ItemStack(listDict.func_150305_b(3)), 0, 66);
        }
        GlStateManager.func_179097_i();
    }

    public void doRender(EntityMachinegun entity, double x, double y, double z, float f0, float f1) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179091_B();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderHelper.func_74519_b();
        if (entity.gun != null && !entity.gun.func_190926_b()) {
            MachinegunRenderer.renderMachinegun(entity.gun, entity);
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
    }

    protected ResourceLocation getEntityTexture(EntityMachinegun entity) {
        return new ResourceLocation(IIContent.itemMachinegun.getSkinnableDefaultTextureLocation() + texture);
    }

    @Override
    public void reloadModels() {
        model = new ModelMachinegun();
        defaultGunParts.clear();
        defaultGunParts.add(MachinegunRenderer.model.baseBox);
        defaultGunParts.add(MachinegunRenderer.model.barrelBox);
        defaultGunParts.add(MachinegunRenderer.model.sightsBox);
        defaultGunParts.add(MachinegunRenderer.model.triggerBox);
        defaultGunParts.add(MachinegunRenderer.model.ammoBox);
        defaultGunParts.add(MachinegunRenderer.model.slideBox);
        defaultGunParts.add(MachinegunRenderer.model.gripBox);
        defaultGunParts.add(MachinegunRenderer.model.bipodBox);
        skinParts.clear();
        skinParts.add(MachinegunRenderer.model.baubleBox);
    }

    private static /* synthetic */ void lambda$renderMachinegun$0(CustomSkinHandler.SpecialSkin s, List renderParts, TmtNamedBoxGroup tmtNamedBoxGroup) {
        if (s.mods.contains(tmtNamedBoxGroup.getName())) {
            renderParts.add(tmtNamedBoxGroup);
        }
    }

    static {
        upgrades = new HashMap();
        defaultGunParts = new ArrayList<TmtNamedBoxGroup>();
        skinParts = new ArrayList<TmtNamedBoxGroup>();
    }
}

