/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.manual.pages;

import blusunrize.immersiveengineering.api.ManualHelper;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonIE;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualPages;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.gui.GuiManual;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeNull;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;
import pl.pabilo8.immersiveintelligence.client.IDataMachineGui;
import pl.pabilo8.immersiveintelligence.client.gui.elements.GuiWidgetManualWrapper;

public class IIManualPageDataVariables
extends ManualPages {
    List<DisplayEntry> entries = new ArrayList<DisplayEntry>();
    boolean input;
    String title;
    int titleShift;

    public IIManualPageDataVariables(ManualInstance manual, String name, boolean input) {
        super(manual, name + (input ? ".vars_in" : ".vars_out"));
        this.input = input;
    }

    public IIManualPageDataVariables addEntry(IDataType type, char ... c) {
        if (c.length > 0) {
            this.entries.add(new DisplayEntry(type, c, this.text + "." + c[0] + ".main", this.text + "." + c[0] + ".sub"));
        }
        return this;
    }

    public void initPage(GuiManual gui, int x, int y, List<GuiButton> pageButtons) {
        this.highlighted = ItemStack.field_190927_a;
        boolean uni = this.manual.fontRenderer.func_82883_a();
        this.manual.fontRenderer.func_78264_a(true);
        this.title = I18n.func_135052_a((String)("ie.manual.entry." + (this.input ? "variables_input" : "variables_output")), (Object[])new Object[0]);
        this.titleShift = 55 - this.manual.fontRenderer.func_78256_a(this.title) / 2;
        int spacing = 15;
        for (DisplayEntry entry : this.entries) {
            entry.init(this.manual, gui, x, y + spacing, pageButtons);
            pageButtons.add((GuiButton)new GuiButtonDatatype(pageButtons.size(), x - 4, y + spacing - 3, entry));
            spacing += entry.getSpacing();
        }
        this.manual.fontRenderer.func_78264_a(uni);
    }

    public void renderPage(GuiManual gui, int x, int y, int mx, int my) {
        ManualUtils.drawSplitString((FontRenderer)this.manual.fontRenderer, (String)(String.valueOf(TextFormatting.BOLD) + TextFormatting.UNDERLINE + this.title), (int)(x + this.titleShift), (int)y, (int)120, (int)this.manual.getTextColour());
        DisplayEntry tooltip = null;
        int down = 15;
        for (DisplayEntry entry : this.entries) {
            GlStateManager.func_179147_l();
            GlStateManager.func_179131_c((float)0.9f, (float)0.9f, (float)0.85f, (float)0.85f);
            ClientUtils.bindTexture((String)entry.dataType.textureLocation());
            Gui.func_146110_a((int)(x - 4), (int)(y + down - 3), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
            if (Utils.isPointInRectangle(x - 4, y + down - 3, x + 12, y + down + 13, mx, my)) {
                tooltip = entry;
            }
            char toDraw = entry.c[(int)Math.ceil(gui.field_146297_k.field_71441_e.func_82737_E() % (long)entry.prezTimeTotal / 20L)];
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)1.25, (double)1.25, (double)1.25);
            ManualUtils.drawSplitString((FontRenderer)this.manual.fontRenderer, (String)(TextFormatting.BOLD + String.valueOf(toDraw)), (int)((int)((float)(x + 15) / 1.25f)), (int)((int)((float)(y + down - 1) / 1.25f)), (int)100, (int)entry.dataType.getTypeColour());
            GlStateManager.func_179121_F();
            GlStateManager.func_179084_k();
            ManualUtils.drawSplitString((FontRenderer)this.manual.fontRenderer, (String)entry.localizedText, (int)(x + 24), (int)(y + down), (int)100, (int)this.manual.getTextColour());
            ManualUtils.drawSplitString((FontRenderer)this.manual.fontRenderer, (String)entry.localizedSubText, (int)x, (int)(y + (down += entry.spacingMain)), (int)120, (int)this.manual.getTextColour());
            down += entry.spacingSub;
        }
        this.manual.fontRenderer.func_78264_a(false);
        if (tooltip != null) {
            ArrayList<String> toDraw = new ArrayList<String>();
            toDraw.add(I18n.func_135052_a((String)("datasystem.immersiveintelligence.datatype." + tooltip.dataType.getName()), (Object[])new Object[0]));
            ClientUtils.drawHoveringText(toDraw, (int)mx, (int)my, (FontRenderer)this.manual.fontRenderer, (int)-1, (int)-1);
        }
        this.manual.fontRenderer.func_78264_a(true);
    }

    public void buttonPressed(GuiManual gui, GuiButton button) {
        super.buttonPressed(gui, button);
        if (button instanceof GuiButtonDatatype) {
            DisplayEntry entry = ((GuiButtonDatatype)button).entry;
            if (Minecraft.func_71410_x().field_71462_r instanceof IDataMachineGui) {
                ((IDataMachineGui)Minecraft.func_71410_x().field_71462_r).editVariable(entry.c[0], (IDataType)new DataPacket().getVarInType(entry.dataType.getClass(), new DataTypeNull()));
            }
        }
    }

    public boolean listForSearch(String searchTag) {
        return false;
    }

    public static class GuiButtonDatatype
    extends GuiButtonIE {
        @Nonnull
        public final DisplayEntry entry;

        public GuiButtonDatatype(int buttonId, int x, int y, DisplayEntry entry) {
            super(100 + buttonId, x, y, 16, 16, "", String.format("immersiveintelligence:textures/gui/data_types/%s.png", entry.dataType.getName()), 0, 0);
            this.entry = entry;
            this.field_146124_l = ManualHelper.getManual().getGui() instanceof GuiWidgetManualWrapper;
        }
    }

    public static class DisplayEntry {
        IDataType dataType;
        char[] c;
        int prezTimeTotal;
        String text;
        String subtext;
        String localizedText;
        String localizedSubText;
        int spacingMain;
        int spacingSub;

        public DisplayEntry(IDataType dataType, char[] c, String text, String subtext) {
            this.dataType = dataType;
            this.c = c;
            this.text = text;
            this.subtext = subtext;
        }

        public void init(ManualInstance manual, GuiManual gui, int x, int y, List<GuiButton> pageButtons) {
            this.prezTimeTotal = this.c.length * 20;
            this.localizedText = manual.formatText(this.text);
            this.localizedSubText = TextFormatting.ITALIC + manual.formatText(this.subtext);
            this.localizedText = ManualPages.addLinks((ManualInstance)manual, (GuiManual)gui, (String)this.localizedText, (int)(x + 24), (int)y, (int)80, pageButtons);
            this.spacingMain = manual.fontRenderer.func_78267_b(this.localizedText, 120) + 4;
            if (this.localizedText == null) {
                this.localizedText = "";
            }
            this.localizedSubText = ManualPages.addLinks((ManualInstance)manual, (GuiManual)gui, (String)this.localizedSubText, (int)x, (int)(y + this.spacingMain), (int)100, pageButtons);
            this.spacingSub = manual.fontRenderer.func_78267_b(this.localizedSubText, 160);
            if (this.localizedSubText == null) {
                this.localizedSubText = "";
            }
            this.spacingSub = this.localizedSubText.equals(TextFormatting.ITALIC.toString()) ? 4 : (this.spacingSub += 10);
        }

        public int getSpacing() {
            return this.spacingMain + this.spacingSub;
        }
    }
}

