/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.gui.elements.data_editor;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonIE;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import pl.pabilo8.immersiveintelligence.ImmersiveIntelligence;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.data.DataOperations;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.operations.DataOperation;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeAccessor;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeExpression;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;
import pl.pabilo8.immersiveintelligence.client.gui.elements.buttons.GuiButtonDataLetterList;
import pl.pabilo8.immersiveintelligence.client.gui.elements.buttons.GuiButtonDropdownList;
import pl.pabilo8.immersiveintelligence.client.gui.elements.buttons.GuiButtonII;
import pl.pabilo8.immersiveintelligence.client.gui.elements.data_editor.GuiDataEditor;
import pl.pabilo8.immersiveintelligence.client.gui.elements.data_editor.GuiDataEditorAccessor;
import pl.pabilo8.immersiveintelligence.common.IIContent;

public class GuiDataEditorExpression
extends GuiDataEditor<DataTypeExpression> {
    int page = 0;
    @Nullable
    private GuiDataEditor<? extends IDataType> pageEditor;
    @Nonnull
    private final List<String> operations;
    private GuiButtonDropdownList dropdownOperationPicker;
    private GuiButtonDataLetterList dropdownLetterPicker;
    private GuiButtonIE buttonPagePrev;
    private GuiButtonIE buttonPageNext;
    private GuiButtonIE buttonPageNumber;
    private GuiButtonIE buttonUseAccessor;
    private GuiButtonIE buttonSwitchType;
    private GuiButtonIE buttonTypePrev;
    private GuiButtonIE buttonTypeNext;
    private boolean hasTypeSwitch;
    private int paramColor = 0;
    private String paramName;

    public GuiDataEditorExpression(int buttonId, DataTypeExpression dataType, ItemStack circuit) {
        super(buttonId, dataType);
        this.operations = IIContent.itemCircuit.getOperationsList(circuit);
    }

    @Override
    public void init() {
        super.init();
        this.validateExpression();
        this.pageEditor = null;
        this.buttonUseAccessor = null;
        this.buttonTypePrev = null;
        this.buttonTypeNext = null;
        this.buttonPagePrev = this.addButton(new GuiButtonIE(this.buttonList.size(), this.field_146128_h + 4, this.field_146129_i + this.field_146121_g - 5, 12, 12, "", "immersiveintelligence:textures/gui/arithmetic_logic_machine_editing.png", 96, 234).setHoverOffset(12, 0));
        this.buttonPageNumber = this.addButton(new GuiButtonIE(this.buttonList.size(), this.field_146128_h + 4 + 12, this.field_146129_i + this.field_146121_g - 5, 12, 12, String.valueOf(this.page), "immersiveintelligence:textures/gui/arithmetic_logic_machine_editing.png", 144, 234).setHoverOffset(12, 0));
        this.buttonPageNext = this.addButton(new GuiButtonIE(this.buttonList.size(), this.field_146128_h + 4 + 24, this.field_146129_i + this.field_146121_g - 5, 12, 12, "", "immersiveintelligence:textures/gui/arithmetic_logic_machine_editing.png", 120, 234).setHoverOffset(12, 0));
        if (this.page == 0) {
            this.dropdownLetterPicker = this.addButton(new GuiButtonDataLetterList(this.buttonList.size(), this.field_146128_h + 2, this.field_146129_i + 2 + 24 + 14, true, ((DataTypeExpression)this.dataType).getRequiredVariable(), GuiButtonDataLetterList.ArrowsAlignment.RIGHT));
            this.dropdownOperationPicker = this.addButton(new GuiButtonDropdownList(this.buttonList.size(), this.field_146128_h + 2, this.field_146129_i + 14, this.field_146120_f - 4, 20, 4, this.operations.toArray(new String[0]))).setTranslationFunc(s -> I18n.func_135052_a((String)("datasystem.immersiveintelligence.function." + s), (Object[])new Object[0]));
            this.dropdownOperationPicker.selectedEntry = this.operations.indexOf(((DataTypeExpression)this.dataType).getOperation().name);
            this.dropdownOperationPicker.field_146124_l = !this.operations.isEmpty();
        } else {
            this.buttonUseAccessor = this.addButton(new GuiButtonIE(this.buttonList.size(), this.field_146128_h, this.field_146129_i, 12, 12, "@", "immersiveintelligence:textures/gui/emplacement_icons.png", 144, 89).setHoverOffset(12, 0));
            Class<? extends IDataType> currentType = ((DataTypeExpression)this.dataType).getOperation().allowedTypes[this.page - 1];
            IDataType edited = ((DataTypeExpression)this.dataType).getArgument(this.page - 1);
            if (edited instanceof GuiDataEditorExpression) {
                ImmersiveIntelligence.logger.info("Stop doing what you're doing right now! Have some mercy for the bandwidth!");
            } else {
                if (currentType == DataTypeAccessor.class) {
                    this.pageEditor = this.addButton(new GuiDataEditorAccessor(this.buttonList.size(), (DataTypeAccessor)edited));
                    this.buttonUseAccessor.field_146124_l = false;
                } else {
                    for (Map.Entry<Class<? extends IDataType>, BiFunction<Integer, IDataType, GuiDataEditor<? extends IDataType>>> entry : GuiDataEditor.editors.entrySet()) {
                        if (entry.getKey() != edited.getClass()) continue;
                        this.pageEditor = (GuiDataEditor)this.addButton((GuiButton)entry.getValue().apply(this.buttonList.size(), edited));
                        break;
                    }
                    if (this.pageEditor == null) {
                        this.pageEditor = this.addButton(new GuiDataEditorAccessor(this.buttonList.size(), edited instanceof DataTypeAccessor ? (DataTypeAccessor)edited : new DataTypeAccessor('a')));
                        this.buttonUseAccessor.field_146124_l = GuiDataEditor.editors.keySet().stream().anyMatch(currentType::isAssignableFrom);
                    }
                }
                if (this.pageEditor != null) {
                    this.pageEditor.setBounds(this.field_146128_h, this.field_146129_i + 12, this.field_146120_f, this.field_146121_g - 12);
                    IDataType display = new DataPacket().getVarInType(currentType, ((DataTypeExpression)this.dataType).data[this.page - 1]);
                    this.paramColor = display.getTypeColour();
                    ResourceLocation paramIcon = new ResourceLocation("immersiveintelligence", String.format("textures/gui/data_types/%s.png", display.getName()));
                    this.hasTypeSwitch = currentType == IDataType.class || currentType.isAnnotationPresent(IDataType.IGenericDataType.class);
                    this.buttonSwitchType = this.addButton(new GuiButtonII(this.buttonList.size(), this.field_146128_h + this.field_146120_f - 12 - (this.hasTypeSwitch ? 7 : 0), this.field_146129_i, 12, 12, paramIcon.toString(), 0.0f, 0.0f, 1.0f, 1.0f));
                    if (this.hasTypeSwitch) {
                        this.buttonTypeNext = this.addButton(new GuiButtonIE(0, this.field_146128_h + this.field_146120_f - 7, this.field_146129_i + 1, 6, 4, "", "immersiveintelligence:textures/gui/emplacement_icons.png", 144, 81).setHoverOffset(6, 0));
                        this.buttonTypePrev = this.addButton(new GuiButtonIE(1, this.field_146128_h + this.field_146120_f - 7, this.field_146129_i + 6, 6, 4, "", "immersiveintelligence:textures/gui/emplacement_icons.png", 144, 85).setHoverOffset(6, 0));
                    }
                }
            }
            this.buttonUseAccessor.field_146125_m = this.pageEditor != null;
            this.paramName = ((DataTypeExpression)this.dataType).getOperation().params != null ? ((DataTypeExpression)this.dataType).getOperation().params[(this.page - 1) % ((DataTypeExpression)this.dataType).getOperation().params.length] : "value";
        }
    }

    private void validateExpression() {
        if (this.operations.isEmpty()) {
            return;
        }
        if (((DataTypeExpression)this.dataType).getOperation() == null) {
            ((DataTypeExpression)this.dataType).setDefaultValue();
        }
        DataOperation op = ((DataTypeExpression)this.dataType).getOperation() == null || !this.operations.contains(((DataTypeExpression)this.dataType).getOperation().name) ? DataOperations.getOperationInstance(this.operations.get(0)) : ((DataTypeExpression)this.dataType).getOperation();
        ((DataTypeExpression)this.dataType).setOperation(op);
        this.dataType = new DataTypeExpression(((DataTypeExpression)this.dataType).data, op, ((DataTypeExpression)this.dataType).getRequiredVariable());
    }

    @Override
    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        if (this.page == 0) {
            mc.field_71466_p.func_175065_a(I18n.func_135052_a((String)"desc.immersiveintelligence.operation", (Object[])new Object[0]), (float)(this.field_146128_h + 2), (float)(this.field_146129_i + 2), 0x1A1A1A, false);
            mc.field_71466_p.func_175065_a(I18n.func_135052_a((String)"desc.immersiveintelligence.conditional_variable", (Object[])new Object[0]), (float)(this.field_146128_h + 2), (float)(this.field_146129_i + 2 + 24), 0x1A1A1A, false);
        } else {
            ClientUtils.bindTexture((String)"immersiveintelligence:textures/gui/emplacement_icons.png");
            this.func_73729_b(this.field_146128_h + 12, this.field_146129_i, 181, 142, 12, 12);
            this.func_73729_b(this.field_146128_h + this.field_146120_f - 12, this.field_146129_i, 205, 142, 12, 12);
            for (int i = 0; i < Math.max(this.field_146120_f - 24, 0); i += 12) {
                this.func_73729_b(this.field_146128_h + 12 + i, this.field_146129_i, 192, 142, MathHelper.func_76125_a((int)(this.field_146120_f - 24 - i), (int)0, (int)12), 12);
            }
            mc.field_71466_p.func_175065_a("Parameter: ", (float)(this.field_146128_h + 2 + 12), (float)(this.field_146129_i + 2), 0x1A1A1A, false);
            mc.field_71466_p.func_175065_a(TextFormatting.ITALIC + this.paramName, (float)(this.field_146128_h + this.field_146120_f - 12 - (this.hasTypeSwitch ? 7 : 0) - mc.field_71466_p.func_78256_a(this.paramName)), (float)(this.field_146129_i + 2), this.paramColor, false);
        }
        super.func_191745_a(mc, mouseX, mouseY, partialTicks);
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) throws IOException {
        if (this.dropdownOperationPicker != null && this.dropdownLetterPicker.keyTyped(typedChar, keyCode)) {
            return;
        }
        if (this.pageEditor != null) {
            this.pageEditor.keyTyped(typedChar, keyCode);
        }
        super.keyTyped(typedChar, keyCode);
    }

    @Override
    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        if (this.page == 0) {
            if (!this.dropdownLetterPicker.dropped && this.dropdownOperationPicker.func_146116_c(mc, mouseX, mouseY)) {
                if (this.dropdownOperationPicker.selectedEntry != -1) {
                    this.outputType();
                }
                return true;
            }
            if (!this.dropdownOperationPicker.dropped && this.dropdownLetterPicker.func_146116_c(mc, mouseX, mouseY)) {
                this.outputType();
                return true;
            }
        } else {
            if (this.pageEditor != null) {
                this.pageEditor.func_146116_c(mc, mouseX, mouseY);
            }
            if (this.buttonUseAccessor != null && this.buttonUseAccessor.func_146116_c(mc, mouseX, mouseY)) {
                this.outputType();
                if (this.pageEditor.dataType instanceof DataTypeAccessor) {
                    ((DataTypeExpression)this.dataType).data[this.page - 1] = new DataPacket().getVarInType(((DataTypeExpression)this.dataType).getOperation().allowedTypes[this.page - 1], null);
                    ((DataTypeExpression)this.dataType).data[this.page - 1].setDefaultValue();
                } else {
                    ((DataTypeExpression)this.dataType).data[this.page - 1] = new DataTypeAccessor('a');
                }
                this.init();
                return true;
            }
            if (this.buttonTypeNext != null && (this.buttonTypeNext.func_146116_c(mc, mouseX, mouseY) || this.buttonTypePrev.func_146116_c(mc, mouseX, mouseY))) {
                boolean isGeneric;
                boolean forward = this.buttonSwitchType.func_146116_c(mc, mouseX, mouseY);
                boolean isAny = ((DataTypeExpression)this.dataType).getOperation().allowedTypes[this.page - 1] == IDataType.class;
                boolean bl = isGeneric = isAny || ((DataTypeExpression)this.dataType).getOperation().allowedTypes[this.page - 1].isAnnotationPresent(IDataType.IGenericDataType.class);
                if (isGeneric) {
                    List<Object> collect;
                    Class<?> dClass = ((DataTypeExpression)this.dataType).data[this.page - 1].getClass();
                    if (isAny) {
                        collect = new ArrayList(editors.keySet());
                    } else {
                        Class<?> sc = dClass.getInterfaces()[0];
                        collect = editors.keySet().stream().filter(sc::isAssignableFrom).collect(Collectors.toList());
                    }
                    if (!collect.isEmpty()) {
                        int i = Utils.cycleInt(forward, collect.indexOf(dClass), 0, collect.size() - 1);
                        ((DataTypeExpression)this.dataType).data[this.page - 1] = DataPacket.getVarInstance((Class)collect.get(i));
                        ((DataTypeExpression)this.dataType).data[this.page - 1].setDefaultValue();
                        this.pageEditor = null;
                        this.outputType();
                        this.init();
                    }
                    return true;
                }
            }
        }
        if (this.buttonPageNext.func_146116_c(mc, mouseX, mouseY) || this.buttonPagePrev.func_146116_c(mc, mouseX, mouseY)) {
            this.outputType();
            this.page = Utils.cycleInt(this.buttonPageNext.func_146115_a(), this.page, 0, ((DataTypeExpression)this.dataType).getOperation().allowedTypes.length);
            this.init();
            return true;
        }
        if (this.buttonPageNumber.func_146116_c(mc, mouseX, mouseY)) {
            this.outputType();
            this.page = 0;
            this.init();
            return true;
        }
        return super.func_146116_c(mc, mouseX, mouseY);
    }

    @Override
    public DataTypeExpression createType() {
        return new DataTypeExpression();
    }

    @Override
    public DataTypeExpression outputType() {
        if (this.page == 0) {
            if (this.dropdownOperationPicker.selectedEntry != -1) {
                ((DataTypeExpression)this.dataType).setOperation(DataOperations.getOperationInstance(this.operations.get(this.dropdownOperationPicker.selectedEntry)));
            }
            ((DataTypeExpression)this.dataType).setRequiredVariable(this.dropdownLetterPicker.selectedEntry);
        } else if (this.pageEditor != null) {
            ((DataTypeExpression)this.dataType).data[this.page - 1] = this.pageEditor.outputType();
        }
        this.validateExpression();
        return (DataTypeExpression)this.dataType;
    }

    @Override
    public boolean isFocused() {
        if (this.pageEditor != null) {
            return this.pageEditor.isFocused();
        }
        return this.dropdownLetterPicker != null && this.dropdownLetterPicker.dropped;
    }

    @Override
    public void getTooltip(ArrayList<String> tooltip, int mx, int my) {
        if (this.page != 0 && this.pageEditor != null) {
            this.pageEditor.getTooltip(tooltip, mx, my);
        }
    }
}

