/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.gui.elements;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.input.Mouse;

public class GuiMultiLineTextField
extends GuiTextField {
    private final int id;
    private final FontRenderer fontRenderer;
    public int field_146209_f;
    public int field_146210_g;
    public int field_146218_h;
    public int field_146219_i;
    private final ArrayList<String> text = new ArrayList();
    private int currentLine = 0;
    private int verticalScrollOffset = 0;
    private int maxStringLength = 32;
    private int cursorCounter;
    private boolean enableBackgroundDrawing = true;
    private boolean canLoseFocus = true;
    private boolean isFocused;
    private boolean isEnabled = true;
    private int lineScrollOffset;
    private int cursorPosition;
    private int selectionEnd;
    private int enabledColor = 0xE0E0E0;
    private int disabledColor = 0x707070;
    private boolean visible = true;
    private GuiPageButtonList.GuiResponder guiResponder;
    private Predicate<String> validator = Predicates.alwaysTrue();

    public GuiMultiLineTextField(int componentId, FontRenderer fontrendererObj, int x, int y, int par5Width, int par6Height) {
        super(componentId, fontrendererObj, x, y, par5Width, par6Height);
        this.id = componentId;
        this.fontRenderer = fontrendererObj;
        this.field_146209_f = x;
        this.field_146210_g = y;
        this.field_146218_h = par5Width;
        this.field_146219_i = Math.max(par6Height, this.fontRenderer.field_78288_b * 2);
        this.text.add("");
    }

    public void func_175207_a(GuiPageButtonList.GuiResponder guiResponderIn) {
        this.guiResponder = guiResponderIn;
    }

    public void func_146178_a() {
        ++this.cursorCounter;
    }

    public void func_146180_a(String textIn) {
        if (this.validator.apply((Object)textIn)) {
            String[] lines = textIn.split("\n");
            for (int l = 0; l < lines.length; ++l) {
                if (lines[l].length() > this.maxStringLength) {
                    this.text.set(l, lines[l].substring(0, this.maxStringLength));
                    continue;
                }
                if (this.text.size() <= l) {
                    this.text.add(lines[l]);
                    continue;
                }
                this.text.set(l, lines[l]);
            }
            this.func_146202_e();
        }
    }

    public String func_146179_b() {
        StringBuilder str = new StringBuilder();
        for (String s : this.text) {
            str.append(s).append(this.text.indexOf(s) < this.text.size() - 1 ? "\n" : "");
        }
        return str.toString();
    }

    public String func_146207_c() {
        int i = Math.min(this.cursorPosition, this.selectionEnd);
        int j = Math.max(this.cursorPosition, this.selectionEnd);
        return this.text.get(this.currentLine).substring(i, j);
    }

    public void func_175205_a(Predicate<String> theValidator) {
        this.validator = theValidator;
    }

    public void func_146191_b(String textToWrite) {
        int l;
        String s = "";
        String s1 = ChatAllowedCharacters.func_71565_a((String)textToWrite);
        int i = Math.min(this.cursorPosition, this.selectionEnd);
        int j = Math.max(this.cursorPosition, this.selectionEnd);
        int k = this.maxStringLength - this.text.get(this.currentLine).length() - (i - j);
        if (!this.text.isEmpty()) {
            s = s + this.text.get(this.currentLine).substring(0, i);
        }
        if (k < s1.length()) {
            s = s + s1.substring(0, k);
            l = k;
        } else {
            s = s + s1;
            l = s1.length();
        }
        if (!this.text.isEmpty() && j < this.text.get(this.currentLine).length()) {
            s = s + this.text.get(this.currentLine).substring(j);
        }
        if (this.validator.apply((Object)s)) {
            this.text.set(this.currentLine, s);
            this.func_146182_d(i - this.selectionEnd + l);
            this.func_190516_a(this.id, this.text.get(this.currentLine));
        }
    }

    public void func_190516_a(int idIn, String textIn) {
        if (this.guiResponder != null) {
            this.guiResponder.func_175319_a(idIn, textIn);
        }
    }

    public void func_146177_a(int num) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.func_146191_b("");
            } else {
                this.func_146175_b(this.func_146187_c(num) - this.cursorPosition);
            }
        }
    }

    public void func_146175_b(int num) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.func_146191_b("");
            } else {
                boolean flag = num < 0;
                int i = flag ? this.cursorPosition + num : this.cursorPosition;
                int j = flag ? this.cursorPosition : this.cursorPosition + num;
                String s = "";
                if (i >= 0) {
                    if (num > 0 && this.cursorPosition == this.text.get(this.currentLine).length() && this.text.size() > this.currentLine + 1) {
                        s = this.text.get(this.currentLine) + this.text.get(this.currentLine + 1);
                        this.text.remove(this.currentLine + 1);
                    } else {
                        s = this.text.get(this.currentLine).substring(0, i);
                    }
                }
                if (j < this.text.get(this.currentLine).length()) {
                    if (num < 0 && this.cursorPosition == 0 && this.currentLine > 0) {
                        String curline = this.text.get(this.currentLine);
                        this.text.remove(this.currentLine);
                        --this.currentLine;
                        this.func_146190_e(this.text.get(this.currentLine).length() + 1);
                        flag = true;
                        num = 0;
                        s = this.text.get(this.currentLine) + curline;
                    } else {
                        s = s + this.text.get(this.currentLine).substring(j);
                    }
                } else if (j == 0 && this.text.size() > 1 && this.currentLine > 0) {
                    this.text.remove(this.currentLine);
                    --this.currentLine;
                    this.func_146202_e();
                    return;
                }
                if (this.validator.apply((Object)s)) {
                    this.text.set(this.currentLine, s);
                    if (flag) {
                        this.func_146182_d(num);
                    }
                    this.func_190516_a(this.id, this.text.get(this.currentLine));
                }
            }
        }
    }

    public int func_175206_d() {
        return this.id;
    }

    public int func_146187_c(int numWords) {
        return this.func_146183_a(numWords, this.func_146198_h());
    }

    public int func_146183_a(int n, int pos) {
        return this.func_146197_a(n, pos, true);
    }

    public int func_146197_a(int n, int pos, boolean skipWs) {
        int i = pos;
        boolean flag = n < 0;
        int j = Math.abs(n);
        for (int k = 0; k < j; ++k) {
            if (!flag) {
                int l = this.text.get(this.currentLine).length();
                i = this.text.get(this.currentLine).indexOf(32, i);
                if (i == -1) {
                    i = l;
                    continue;
                }
                while (skipWs && i < l && this.text.get(this.currentLine).charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (skipWs && i > 0 && this.text.get(this.currentLine).charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && this.text.get(this.currentLine).charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public void func_146182_d(int num) {
        this.func_146190_e(this.selectionEnd + num);
    }

    public void func_146190_e(int pos) {
        this.cursorPosition = pos;
        int i = this.text.get(this.currentLine).length();
        if (this.cursorPosition > i && this.currentLine + 1 < this.text.size()) {
            ++this.currentLine;
            this.cursorPosition = 0;
            i = this.text.get(this.currentLine).length();
            if (this.lineScrollOffset > i) {
                this.lineScrollOffset = i;
            }
        }
        if (this.cursorPosition < 0 && this.currentLine > 0) {
            --this.currentLine;
            this.cursorPosition = i = this.text.get(this.currentLine).length();
            if (this.lineScrollOffset > i) {
                this.lineScrollOffset = i;
            }
        }
        this.cursorPosition = MathHelper.func_76125_a((int)this.cursorPosition, (int)0, (int)i);
        this.func_146199_i(this.cursorPosition);
    }

    public void func_146196_d() {
        this.func_146190_e(0);
    }

    public void func_146202_e() {
        this.func_146190_e(this.text.get(this.currentLine).length());
    }

    public boolean func_146201_a(char typedChar, int keyCode) {
        if (!this.isFocused) {
            return false;
        }
        if (GuiScreen.func_175278_g((int)keyCode)) {
            this.func_146202_e();
            this.func_146199_i(0);
            return true;
        }
        if (GuiScreen.func_175280_f((int)keyCode)) {
            GuiScreen.func_146275_d((String)this.func_146207_c());
            return true;
        }
        if (GuiScreen.func_175279_e((int)keyCode)) {
            if (this.isEnabled) {
                String[] lines = GuiScreen.func_146277_j().split("\n");
                this.func_146191_b(lines[0]);
                for (int l = 1; l < lines.length; ++l) {
                    ++this.currentLine;
                    this.text.add(this.currentLine, lines[l]);
                }
            }
            return true;
        }
        if (GuiScreen.func_175277_d((int)keyCode)) {
            GuiScreen.func_146275_d((String)this.func_146207_c());
            if (this.isEnabled) {
                this.func_146191_b("");
            }
            return true;
        }
        switch (keyCode) {
            case 28: {
                int lin = this.text.get(this.currentLine).length();
                if (this.cursorPosition == lin) {
                    ++this.currentLine;
                    this.text.add(this.currentLine, "");
                    this.func_146190_e(0);
                } else {
                    String rem = this.text.get(this.currentLine).substring(this.cursorPosition);
                    this.text.set(this.currentLine, this.text.get(this.currentLine).substring(0, this.cursorPosition));
                    ++this.currentLine;
                    this.text.add(this.currentLine, rem);
                    this.func_146196_d();
                }
                return true;
            }
            case 200: {
                this.currentLine = Math.max(this.currentLine - 1, 0);
                if (this.cursorPosition > this.text.get(this.currentLine).length()) {
                    this.selectionEnd = this.cursorPosition = this.text.get(this.currentLine).length();
                } else {
                    this.func_146182_d(0);
                }
                return true;
            }
            case 208: {
                this.currentLine = Math.min(this.currentLine + 1, this.text.size() - 1);
                if (this.cursorPosition > this.text.get(this.currentLine).length()) {
                    this.selectionEnd = this.cursorPosition = this.text.get(this.currentLine).length();
                } else {
                    this.func_146182_d(0);
                }
                return true;
            }
            case 14: {
                if (GuiScreen.func_146271_m()) {
                    if (this.isEnabled) {
                        this.func_146177_a(-1);
                    }
                } else if (this.isEnabled) {
                    this.func_146175_b(-1);
                }
                return true;
            }
            case 199: {
                if (GuiScreen.func_146272_n()) {
                    this.func_146199_i(0);
                } else {
                    this.func_146196_d();
                }
                return true;
            }
            case 203: {
                if (GuiScreen.func_146272_n()) {
                    if (GuiScreen.func_146271_m()) {
                        this.func_146199_i(this.func_146183_a(-1, this.func_146186_n()));
                    } else {
                        this.func_146199_i(this.func_146186_n() - 1);
                    }
                } else if (GuiScreen.func_146271_m()) {
                    this.func_146190_e(this.func_146187_c(-1));
                } else {
                    this.func_146182_d(-1);
                }
                return true;
            }
            case 205: {
                if (GuiScreen.func_146272_n()) {
                    if (GuiScreen.func_146271_m()) {
                        this.func_146199_i(this.func_146183_a(1, this.func_146186_n()));
                    } else {
                        this.func_146199_i(this.func_146186_n() + 1);
                    }
                } else if (GuiScreen.func_146271_m()) {
                    this.func_146190_e(this.func_146187_c(1));
                } else {
                    this.func_146182_d(1);
                }
                return true;
            }
            case 207: {
                if (GuiScreen.func_146272_n()) {
                    this.func_146199_i(this.text.get(this.currentLine).length());
                } else {
                    this.func_146202_e();
                }
                return true;
            }
            case 211: {
                if (GuiScreen.func_146271_m()) {
                    if (this.isEnabled) {
                        this.func_146177_a(1);
                    }
                } else if (this.isEnabled) {
                    this.func_146175_b(1);
                }
                return true;
            }
        }
        if (ChatAllowedCharacters.func_71566_a((char)typedChar)) {
            if (this.isEnabled) {
                this.func_146191_b(Character.toString(typedChar));
            }
            return true;
        }
        return false;
    }

    public boolean func_146192_a(int mouseX, int mouseY, int mouseButton) {
        boolean flag;
        boolean bl = flag = mouseX >= this.field_146209_f && mouseX < this.field_146209_f + this.field_146218_h && mouseY >= this.field_146210_g && mouseY < this.field_146210_g + this.field_146219_i;
        if (this.canLoseFocus) {
            this.func_146195_b(flag);
        }
        if (this.isFocused && flag && mouseButton == 0) {
            int i = mouseX - this.field_146209_f;
            if (this.enableBackgroundDrawing) {
                i -= 4;
            }
            int j = mouseY - this.field_146210_g;
            this.currentLine = MathHelper.func_76125_a((int)((j /= this.fontRenderer.field_78288_b) + this.verticalScrollOffset), (int)0, (int)(this.text.size() - 1));
            String s = this.fontRenderer.func_78269_a(this.text.get(this.currentLine).substring(this.lineScrollOffset), this.func_146200_o());
            this.func_146190_e(this.fontRenderer.func_78269_a(s, i).length() + this.lineScrollOffset);
            return true;
        }
        return false;
    }

    public void func_146194_f() {
        float md;
        if (this.func_146176_q()) {
            if (this.func_146181_i()) {
                GuiMultiLineTextField.func_73734_a((int)(this.field_146209_f - 1), (int)(this.field_146210_g - 1), (int)(this.field_146209_f + this.field_146218_h + 1), (int)(this.field_146210_g + this.field_146219_i + 1), (int)-6250336);
                GuiMultiLineTextField.func_73734_a((int)this.field_146209_f, (int)this.field_146210_g, (int)(this.field_146209_f + this.field_146218_h), (int)(this.field_146210_g + this.field_146219_i), (int)-16777216);
            }
            int i = this.isEnabled ? this.enabledColor : this.disabledColor;
            int j = this.cursorPosition - this.lineScrollOffset;
            int k = this.selectionEnd - this.lineScrollOffset;
            int cls = this.verticalScrollOffset;
            int maxLines = this.field_146219_i / this.fontRenderer.field_78288_b;
            while (this.currentLine >= maxLines + cls) {
                this.verticalScrollOffset = ++cls;
            }
            while (this.currentLine < cls) {
                this.verticalScrollOffset = --cls;
            }
            for (int cl = cls; cl < maxLines + cls && cl < this.text.size(); ++cl) {
                int pos = this.lineScrollOffset;
                if (pos < 0 || pos > this.text.get(cl).length()) continue;
                String s = this.fontRenderer.func_78269_a(this.text.get(cl).substring(pos), this.func_146200_o());
                boolean flag = cl == this.currentLine && j >= 0 && j <= s.length();
                boolean flag1 = this.isFocused && this.cursorCounter / 6 % 2 == 0 && flag;
                int l = this.enableBackgroundDrawing ? this.field_146209_f + 4 : this.field_146209_f;
                int i1 = this.enableBackgroundDrawing ? this.field_146210_g + (this.field_146219_i - 8) / 2 : this.field_146210_g;
                i1 -= (this.field_146219_i - this.fontRenderer.field_78288_b) / 2;
                i1 += this.fontRenderer.field_78288_b * (cl - cls);
                int j1 = l;
                if (!s.isEmpty()) {
                    String s1 = flag ? s.substring(0, j) : s;
                    j1 = this.fontRenderer.func_175063_a(s1, (float)l, (float)i1, i);
                }
                boolean flag2 = cl == this.currentLine && (this.cursorPosition < this.text.get(cl).length() || this.text.get(cl).length() >= this.func_146208_g());
                int k1 = j1;
                if (!flag) {
                    k1 = j > 0 ? l + this.field_146218_h : l;
                } else if (flag2) {
                    k1 = j1 - 1;
                    --j1;
                }
                if (cl != this.currentLine) continue;
                if (k > s.length()) {
                    k = s.length();
                }
                if (!s.isEmpty() && flag && j < s.length()) {
                    this.fontRenderer.func_175063_a(s.substring(j), (float)j1, (float)i1, i);
                }
                if (flag1) {
                    if (flag2) {
                        Gui.func_73734_a((int)k1, (int)(i1 - 1), (int)(k1 + 1), (int)(i1 + 1 + this.fontRenderer.field_78288_b), (int)-3092272);
                    } else {
                        this.fontRenderer.func_175063_a("_", (float)k1, (float)i1, i);
                    }
                }
                if (k == j) continue;
                int l1 = l + this.fontRenderer.func_78256_a(s.substring(0, k));
                this.drawSelectionBox(k1, i1 - 1, l1 - 1, i1 + 1 + this.fontRenderer.field_78288_b);
            }
        }
        if ((md = (float)Mouse.getDWheel()) != 0.0f) {
            int m = md > 0.0f ? -1 : 1;
            this.verticalScrollOffset += m;
            this.verticalScrollOffset = MathHelper.func_76125_a((int)this.verticalScrollOffset, (int)0, (int)(this.text.size() - 1));
        }
    }

    private void drawSelectionBox(int startX, int startY, int endX, int endY) {
        if (startX < endX) {
            int i = startX;
            startX = endX;
            endX = i;
        }
        if (startY < endY) {
            int j = startY;
            startY = endY;
            endY = j;
        }
        if (endX > this.field_146209_f + this.field_146218_h) {
            endX = this.field_146209_f + this.field_146218_h;
        }
        if (startX > this.field_146209_f + this.field_146218_h) {
            startX = this.field_146209_f + this.field_146218_h;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179115_u();
        GlStateManager.func_187422_a((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b((double)startX, (double)endY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)endX, (double)endY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)endX, (double)startY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)startX, (double)startY, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179134_v();
        GlStateManager.func_179098_w();
    }

    public void func_146203_f(int length) {
        this.maxStringLength = length;
        if (this.text.get(this.currentLine).length() > length) {
            this.text.set(this.currentLine, this.text.get(this.currentLine).substring(0, length));
        }
    }

    public int func_146208_g() {
        return this.maxStringLength;
    }

    public int func_146198_h() {
        return this.cursorPosition;
    }

    public char getCharAtCursor(int offset) {
        if (this.func_146198_h() == 0) {
            return ' ';
        }
        if (this.text.get(this.currentLine).length() < this.func_146198_h() + offset) {
            return ' ';
        }
        return this.text.get(this.currentLine).charAt(this.func_146198_h() - 1 + offset);
    }

    public boolean func_146181_i() {
        return this.enableBackgroundDrawing;
    }

    public void func_146185_a(boolean enableBackgroundDrawingIn) {
        this.enableBackgroundDrawing = enableBackgroundDrawingIn;
    }

    public void func_146193_g(int color) {
        this.enabledColor = color;
    }

    public void func_146204_h(int color) {
        this.disabledColor = color;
    }

    public void func_146195_b(boolean isFocusedIn) {
        if (isFocusedIn && !this.isFocused) {
            this.cursorCounter = 0;
        }
        this.isFocused = isFocusedIn;
        if (Minecraft.func_71410_x().field_71462_r != null) {
            Minecraft.func_71410_x().field_71462_r.func_193975_a(isFocusedIn);
        }
    }

    public boolean func_146206_l() {
        return this.isFocused;
    }

    public void func_146184_c(boolean enabled) {
        this.isEnabled = enabled;
    }

    public int func_146186_n() {
        return this.selectionEnd;
    }

    public int func_146200_o() {
        return this.func_146181_i() ? this.field_146218_h - 8 : this.field_146218_h;
    }

    public void func_146199_i(int position) {
        int i = this.text.get(this.currentLine).length();
        if (position > i) {
            position = i;
        }
        if (position < 0) {
            position = 0;
        }
        this.selectionEnd = position;
        if (this.fontRenderer != null) {
            if (this.lineScrollOffset > i) {
                this.lineScrollOffset = i;
            }
            int j = this.func_146200_o();
            String s = this.fontRenderer.func_78269_a(this.text.get(this.currentLine).substring(this.lineScrollOffset), j);
            int k = s.length() + this.lineScrollOffset;
            if (position == this.lineScrollOffset) {
                this.lineScrollOffset -= this.fontRenderer.func_78262_a(this.text.get(this.currentLine), j, true).length();
            }
            if (position > k) {
                this.lineScrollOffset += position - k;
            } else if (position <= this.lineScrollOffset) {
                this.lineScrollOffset -= this.lineScrollOffset - position;
            }
            this.lineScrollOffset = MathHelper.func_76125_a((int)this.lineScrollOffset, (int)0, (int)i);
        }
    }

    public void func_146205_d(boolean canLoseFocusIn) {
        this.canLoseFocus = canLoseFocusIn;
    }

    public boolean func_146176_q() {
        return this.visible;
    }

    public void func_146189_e(boolean isVisible) {
        this.visible = isVisible;
    }
}

